/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.bsp;

import java.io.Serializable;
import sbt.internal.bsp.BuildTargetIdentifier;
import sbt.internal.bsp.CompileReport$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class CompileReport
implements Serializable {
    private final BuildTargetIdentifier target;
    private final Option<String> originId;
    private final int errors;
    private final int warnings;
    private final Option<Object> time;
    private final Option<Object> noOp;

    public static CompileReport apply(BuildTargetIdentifier buildTargetIdentifier, Option<String> option, int n, int n2, Option<Object> option2, Option<Object> option3) {
        return CompileReport$.MODULE$.apply(buildTargetIdentifier, option, n, n2, option2, option3);
    }

    public static CompileReport apply(BuildTargetIdentifier buildTargetIdentifier, String string, int n, int n2, int n3, boolean bl) {
        return CompileReport$.MODULE$.apply(buildTargetIdentifier, string, n, n2, n3, bl);
    }

    public CompileReport(BuildTargetIdentifier target, Option<String> originId, int errors, int warnings, Option<Object> time, Option<Object> noOp) {
        this.target = target;
        this.originId = originId;
        this.errors = errors;
        this.warnings = warnings;
        this.time = time;
        this.noOp = noOp;
    }

    public BuildTargetIdentifier target() {
        return this.target;
    }

    public Option<String> originId() {
        return this.originId;
    }

    public int errors() {
        return this.errors;
    }

    public int warnings() {
        return this.warnings;
    }

    public Option<Object> time() {
        return this.time;
    }

    public Option<Object> noOp() {
        return this.noOp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof CompileReport)) return false;
        CompileReport x = (CompileReport)object;
        BuildTargetIdentifier buildTargetIdentifier = this.target();
        BuildTargetIdentifier buildTargetIdentifier2 = x.target();
        if (buildTargetIdentifier == null) {
            if (buildTargetIdentifier2 != null) {
                return false;
            }
        } else if (!((Object)buildTargetIdentifier).equals(buildTargetIdentifier2)) return false;
        Option<String> option = this.originId();
        Option<String> option2 = x.originId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.errors() != x.errors()) return false;
        if (this.warnings() != x.warnings()) return false;
        Option<Object> option3 = this.time();
        Option<Object> option4 = x.time();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.noOp();
        Option<Object> option6 = x.noOp();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + Statics.anyHash((Object)"sbt.internal.bsp.CompileReport")) + Statics.anyHash((Object)this.target())) + Statics.anyHash(this.originId())) + Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.errors()))) + Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.warnings()))) + Statics.anyHash(this.time())) + Statics.anyHash(this.noOp()));
    }

    public String toString() {
        return new StringBuilder(25).append("CompileReport(").append(this.target()).append(", ").append(this.originId()).append(", ").append(this.errors()).append(", ").append(this.warnings()).append(", ").append(this.time()).append(", ").append(this.noOp()).append(")").toString();
    }

    private CompileReport copy(BuildTargetIdentifier target, Option<String> originId, int errors, int warnings, Option<Object> time, Option<Object> noOp) {
        return new CompileReport(target, originId, errors, warnings, time, noOp);
    }

    private BuildTargetIdentifier copy$default$1() {
        return this.target();
    }

    private Option<String> copy$default$2() {
        return this.originId();
    }

    private int copy$default$3() {
        return this.errors();
    }

    private int copy$default$4() {
        return this.warnings();
    }

    private Option<Object> copy$default$5() {
        return this.time();
    }

    private Option<Object> copy$default$6() {
        return this.noOp();
    }

    public CompileReport withTarget(BuildTargetIdentifier target) {
        return this.copy(target, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public CompileReport withOriginId(Option<String> originId) {
        return this.copy(this.copy$default$1(), originId, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public CompileReport withOriginId(String originId) {
        Option option = Option$.MODULE$.apply((Object)originId);
        BuildTargetIdentifier buildTargetIdentifier = this.copy$default$1();
        int n = this.copy$default$3();
        int n2 = this.copy$default$4();
        Option<Object> option2 = this.copy$default$5();
        Option<Object> option3 = this.copy$default$6();
        return this.copy(buildTargetIdentifier, (Option<String>)option, n, n2, option2, option3);
    }

    public CompileReport withErrors(int errors) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), errors, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public CompileReport withWarnings(int warnings) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), warnings, this.copy$default$5(), this.copy$default$6());
    }

    public CompileReport withTime(Option<Object> time) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), time, this.copy$default$6());
    }

    public CompileReport withTime(int time) {
        Option option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)time));
        BuildTargetIdentifier buildTargetIdentifier = this.copy$default$1();
        Option<String> option2 = this.copy$default$2();
        int n = this.copy$default$3();
        int n2 = this.copy$default$4();
        Option<Object> option3 = this.copy$default$6();
        return this.copy(buildTargetIdentifier, option2, n, n2, (Option<Object>)option, option3);
    }

    public CompileReport withNoOp(Option<Object> noOp) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), noOp);
    }

    public CompileReport withNoOp(boolean noOp) {
        Option option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)noOp));
        BuildTargetIdentifier buildTargetIdentifier = this.copy$default$1();
        Option<String> option2 = this.copy$default$2();
        int n = this.copy$default$3();
        int n2 = this.copy$default$4();
        Option<Object> option3 = this.copy$default$5();
        return this.copy(buildTargetIdentifier, option2, n, n2, option3, (Option<Object>)option);
    }
}

