/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.bsp;

import java.io.Serializable;
import sbt.internal.bsp.Diagnostic$;
import sbt.internal.bsp.DiagnosticRelatedInformation;
import sbt.internal.bsp.Range;
import sbt.internal.bsp.ScalaDiagnostic;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class Diagnostic
implements Serializable {
    private final Range range;
    private final Option<Object> severity;
    private final Option<String> code;
    private final Option<String> source;
    private final String message;
    private final Vector<DiagnosticRelatedInformation> relatedInformation;
    private final Option<String> dataKind;
    private final Option<ScalaDiagnostic> data;

    public static Diagnostic apply(Range range, long l, String string, String string2, String string3) {
        return Diagnostic$.MODULE$.apply(range, l, string, string2, string3);
    }

    public static Diagnostic apply(Range range, long l, String string, String string2, String string3, Vector<DiagnosticRelatedInformation> vector) {
        return Diagnostic$.MODULE$.apply(range, l, string, string2, string3, vector);
    }

    public static Diagnostic apply(Range range, long l, String string, String string2, String string3, Vector<DiagnosticRelatedInformation> vector, String string4, ScalaDiagnostic scalaDiagnostic) {
        return Diagnostic$.MODULE$.apply(range, l, string, string2, string3, vector, string4, scalaDiagnostic);
    }

    public static Diagnostic apply(Range range, Option<Object> option, Option<String> option2, Option<String> option3, String string) {
        return Diagnostic$.MODULE$.apply(range, option, option2, option3, string);
    }

    public static Diagnostic apply(Range range, Option<Object> option, Option<String> option2, Option<String> option3, String string, Vector<DiagnosticRelatedInformation> vector) {
        return Diagnostic$.MODULE$.apply(range, option, option2, option3, string, vector);
    }

    public static Diagnostic apply(Range range, Option<Object> option, Option<String> option2, Option<String> option3, String string, Vector<DiagnosticRelatedInformation> vector, Option<String> option4, Option<ScalaDiagnostic> option5) {
        return Diagnostic$.MODULE$.apply(range, option, option2, option3, string, vector, option4, option5);
    }

    public Diagnostic(Range range, Option<Object> severity, Option<String> code, Option<String> source, String message, Vector<DiagnosticRelatedInformation> relatedInformation, Option<String> dataKind, Option<ScalaDiagnostic> data) {
        this.range = range;
        this.severity = severity;
        this.code = code;
        this.source = source;
        this.message = message;
        this.relatedInformation = relatedInformation;
        this.dataKind = dataKind;
        this.data = data;
    }

    public Range range() {
        return this.range;
    }

    public Option<Object> severity() {
        return this.severity;
    }

    public Option<String> code() {
        return this.code;
    }

    public Option<String> source() {
        return this.source;
    }

    public String message() {
        return this.message;
    }

    public Vector<DiagnosticRelatedInformation> relatedInformation() {
        return this.relatedInformation;
    }

    public Option<String> dataKind() {
        return this.dataKind;
    }

    public Option<ScalaDiagnostic> data() {
        return this.data;
    }

    public Diagnostic(Range range, Option<Object> severity, Option<String> code, Option<String> source, String message) {
        this(range, severity, code, source, message, (Vector<DiagnosticRelatedInformation>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), (Option<String>)None$.MODULE$, (Option<ScalaDiagnostic>)None$.MODULE$);
    }

    public Diagnostic(Range range, Option<Object> severity, Option<String> code, Option<String> source, String message, Vector<DiagnosticRelatedInformation> relatedInformation) {
        this(range, severity, code, source, message, relatedInformation, (Option<String>)None$.MODULE$, (Option<ScalaDiagnostic>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof Diagnostic)) return false;
        Diagnostic x = (Diagnostic)object;
        Range range = this.range();
        Range range2 = x.range();
        if (range == null) {
            if (range2 != null) {
                return false;
            }
        } else if (!((Object)range).equals(range2)) return false;
        Option<Object> option = this.severity();
        Option<Object> option2 = x.severity();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.code();
        Option<String> option4 = x.code();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.source();
        Option<String> option6 = x.source();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        String string = this.message();
        String string2 = x.message();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Vector<DiagnosticRelatedInformation> vector = this.relatedInformation();
        Vector<DiagnosticRelatedInformation> vector2 = x.relatedInformation();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        Option<String> option7 = this.dataKind();
        Option<String> option8 = x.dataKind();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<ScalaDiagnostic> option9 = this.data();
        Option<ScalaDiagnostic> option10 = x.data();
        if (option9 == null) {
            if (option10 == null) return true;
            return false;
        } else {
            if (!option9.equals(option10)) return false;
            return true;
        }
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + Statics.anyHash((Object)"sbt.internal.bsp.Diagnostic")) + Statics.anyHash((Object)this.range())) + Statics.anyHash(this.severity())) + Statics.anyHash(this.code())) + Statics.anyHash(this.source())) + Statics.anyHash((Object)this.message())) + Statics.anyHash(this.relatedInformation())) + Statics.anyHash(this.dataKind())) + Statics.anyHash(this.data()));
    }

    public String toString() {
        return new StringBuilder(26).append("Diagnostic(").append(this.range()).append(", ").append(this.severity()).append(", ").append(this.code()).append(", ").append(this.source()).append(", ").append(this.message()).append(", ").append(this.relatedInformation()).append(", ").append(this.dataKind()).append(", ").append(this.data()).append(")").toString();
    }

    private Diagnostic copy(Range range, Option<Object> severity, Option<String> code, Option<String> source, String message, Vector<DiagnosticRelatedInformation> relatedInformation, Option<String> dataKind, Option<ScalaDiagnostic> data) {
        return new Diagnostic(range, severity, code, source, message, relatedInformation, dataKind, data);
    }

    private Range copy$default$1() {
        return this.range();
    }

    private Option<Object> copy$default$2() {
        return this.severity();
    }

    private Option<String> copy$default$3() {
        return this.code();
    }

    private Option<String> copy$default$4() {
        return this.source();
    }

    private String copy$default$5() {
        return this.message();
    }

    private Vector<DiagnosticRelatedInformation> copy$default$6() {
        return this.relatedInformation();
    }

    private Option<String> copy$default$7() {
        return this.dataKind();
    }

    private Option<ScalaDiagnostic> copy$default$8() {
        return this.data();
    }

    public Diagnostic withRange(Range range) {
        return this.copy(range, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public Diagnostic withSeverity(Option<Object> severity) {
        return this.copy(this.copy$default$1(), severity, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public Diagnostic withSeverity(long severity) {
        Option option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)severity));
        Range range = this.copy$default$1();
        Option<String> option2 = this.copy$default$3();
        Option<String> option3 = this.copy$default$4();
        String string = this.copy$default$5();
        Vector<DiagnosticRelatedInformation> vector = this.copy$default$6();
        Option<String> option4 = this.copy$default$7();
        Option<ScalaDiagnostic> option5 = this.copy$default$8();
        return this.copy(range, (Option<Object>)option, option2, option3, string, vector, option4, option5);
    }

    public Diagnostic withCode(Option<String> code) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), code, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public Diagnostic withCode(String code) {
        Option option = Option$.MODULE$.apply((Object)code);
        Range range = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$4();
        String string = this.copy$default$5();
        Vector<DiagnosticRelatedInformation> vector = this.copy$default$6();
        Option<String> option4 = this.copy$default$7();
        Option<ScalaDiagnostic> option5 = this.copy$default$8();
        return this.copy(range, option2, (Option<String>)option, option3, string, vector, option4, option5);
    }

    public Diagnostic withSource(Option<String> source) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), source, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public Diagnostic withSource(String source) {
        Option option = Option$.MODULE$.apply((Object)source);
        Range range = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$3();
        String string = this.copy$default$5();
        Vector<DiagnosticRelatedInformation> vector = this.copy$default$6();
        Option<String> option4 = this.copy$default$7();
        Option<ScalaDiagnostic> option5 = this.copy$default$8();
        return this.copy(range, option2, option3, (Option<String>)option, string, vector, option4, option5);
    }

    public Diagnostic withMessage(String message) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), message, this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public Diagnostic withRelatedInformation(Vector<DiagnosticRelatedInformation> relatedInformation) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), relatedInformation, this.copy$default$7(), this.copy$default$8());
    }

    public Diagnostic withDataKind(Option<String> dataKind) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), dataKind, this.copy$default$8());
    }

    public Diagnostic withDataKind(String dataKind) {
        Option option = Option$.MODULE$.apply((Object)dataKind);
        Range range = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$3();
        Option<String> option4 = this.copy$default$4();
        String string = this.copy$default$5();
        Vector<DiagnosticRelatedInformation> vector = this.copy$default$6();
        Option<ScalaDiagnostic> option5 = this.copy$default$8();
        return this.copy(range, option2, option3, option4, string, vector, (Option<String>)option, option5);
    }

    public Diagnostic withData(Option<ScalaDiagnostic> data) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), data);
    }

    public Diagnostic withData(ScalaDiagnostic data) {
        Option option = Option$.MODULE$.apply((Object)data);
        Range range = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$3();
        Option<String> option4 = this.copy$default$4();
        String string = this.copy$default$5();
        Vector<DiagnosticRelatedInformation> vector = this.copy$default$6();
        Option<String> option5 = this.copy$default$7();
        return this.copy(range, option2, option3, option4, string, vector, option5, (Option<ScalaDiagnostic>)option);
    }
}

