/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.bsp;

import java.io.Serializable;
import sbt.internal.bsp.BuildTargetIdentifier;
import sbt.internal.bsp.Diagnostic;
import sbt.internal.bsp.PublishDiagnosticsParams$;
import sbt.internal.bsp.TextDocumentIdentifier;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class PublishDiagnosticsParams
implements Serializable {
    private final TextDocumentIdentifier textDocument;
    private final BuildTargetIdentifier buildTarget;
    private final Option<String> originId;
    private final Vector<Diagnostic> diagnostics;
    private final boolean reset;

    public static PublishDiagnosticsParams apply(TextDocumentIdentifier textDocumentIdentifier, BuildTargetIdentifier buildTargetIdentifier, Option<String> option, Vector<Diagnostic> vector, boolean bl) {
        return PublishDiagnosticsParams$.MODULE$.apply(textDocumentIdentifier, buildTargetIdentifier, option, vector, bl);
    }

    public static PublishDiagnosticsParams apply(TextDocumentIdentifier textDocumentIdentifier, BuildTargetIdentifier buildTargetIdentifier, String string, Vector<Diagnostic> vector, boolean bl) {
        return PublishDiagnosticsParams$.MODULE$.apply(textDocumentIdentifier, buildTargetIdentifier, string, vector, bl);
    }

    public PublishDiagnosticsParams(TextDocumentIdentifier textDocument, BuildTargetIdentifier buildTarget, Option<String> originId, Vector<Diagnostic> diagnostics, boolean reset) {
        this.textDocument = textDocument;
        this.buildTarget = buildTarget;
        this.originId = originId;
        this.diagnostics = diagnostics;
        this.reset = reset;
    }

    public TextDocumentIdentifier textDocument() {
        return this.textDocument;
    }

    public BuildTargetIdentifier buildTarget() {
        return this.buildTarget;
    }

    public Option<String> originId() {
        return this.originId;
    }

    public Vector<Diagnostic> diagnostics() {
        return this.diagnostics;
    }

    public boolean reset() {
        return this.reset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof PublishDiagnosticsParams)) return false;
        PublishDiagnosticsParams x = (PublishDiagnosticsParams)object;
        TextDocumentIdentifier textDocumentIdentifier = this.textDocument();
        TextDocumentIdentifier textDocumentIdentifier2 = x.textDocument();
        if (textDocumentIdentifier == null) {
            if (textDocumentIdentifier2 != null) {
                return false;
            }
        } else if (!((Object)textDocumentIdentifier).equals(textDocumentIdentifier2)) return false;
        BuildTargetIdentifier buildTargetIdentifier = this.buildTarget();
        BuildTargetIdentifier buildTargetIdentifier2 = x.buildTarget();
        if (buildTargetIdentifier == null) {
            if (buildTargetIdentifier2 != null) {
                return false;
            }
        } else if (!((Object)buildTargetIdentifier).equals(buildTargetIdentifier2)) return false;
        Option<String> option = this.originId();
        Option<String> option2 = x.originId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Vector<Diagnostic> vector = this.diagnostics();
        Vector<Diagnostic> vector2 = x.diagnostics();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        if (this.reset() != x.reset()) return false;
        return true;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (17 + Statics.anyHash((Object)"sbt.internal.bsp.PublishDiagnosticsParams")) + Statics.anyHash((Object)this.textDocument())) + Statics.anyHash((Object)this.buildTarget())) + Statics.anyHash(this.originId())) + Statics.anyHash(this.diagnostics())) + Statics.anyHash((Object)BoxesRunTime.boxToBoolean((boolean)this.reset())));
    }

    public String toString() {
        return new StringBuilder(34).append("PublishDiagnosticsParams(").append(this.textDocument()).append(", ").append(this.buildTarget()).append(", ").append(this.originId()).append(", ").append(this.diagnostics()).append(", ").append(this.reset()).append(")").toString();
    }

    private PublishDiagnosticsParams copy(TextDocumentIdentifier textDocument, BuildTargetIdentifier buildTarget, Option<String> originId, Vector<Diagnostic> diagnostics, boolean reset) {
        return new PublishDiagnosticsParams(textDocument, buildTarget, originId, diagnostics, reset);
    }

    private TextDocumentIdentifier copy$default$1() {
        return this.textDocument();
    }

    private BuildTargetIdentifier copy$default$2() {
        return this.buildTarget();
    }

    private Option<String> copy$default$3() {
        return this.originId();
    }

    private Vector<Diagnostic> copy$default$4() {
        return this.diagnostics();
    }

    private boolean copy$default$5() {
        return this.reset();
    }

    public PublishDiagnosticsParams withTextDocument(TextDocumentIdentifier textDocument) {
        return this.copy(textDocument, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public PublishDiagnosticsParams withBuildTarget(BuildTargetIdentifier buildTarget) {
        return this.copy(this.copy$default$1(), buildTarget, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public PublishDiagnosticsParams withOriginId(Option<String> originId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), originId, this.copy$default$4(), this.copy$default$5());
    }

    public PublishDiagnosticsParams withOriginId(String originId) {
        Option option = Option$.MODULE$.apply((Object)originId);
        TextDocumentIdentifier textDocumentIdentifier = this.copy$default$1();
        BuildTargetIdentifier buildTargetIdentifier = this.copy$default$2();
        Vector<Diagnostic> vector = this.copy$default$4();
        boolean bl = this.copy$default$5();
        return this.copy(textDocumentIdentifier, buildTargetIdentifier, (Option<String>)option, vector, bl);
    }

    public PublishDiagnosticsParams withDiagnostics(Vector<Diagnostic> diagnostics) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), diagnostics, this.copy$default$5());
    }

    public PublishDiagnosticsParams withReset(boolean reset) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), reset);
    }
}

