/*
 * Decompiled with CFR 0.152.
 */
package sbt.protocol;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import sbt.internal.protocol.InitializeOption;
import sbt.internal.protocol.JsonRpcMessage;
import sbt.internal.protocol.JsonRpcNotificationMessage;
import sbt.internal.protocol.JsonRpcRequestMessage;
import sbt.internal.protocol.JsonRpcResponseMessage;
import sbt.internal.protocol.codec.JsonRPCProtocol$;
import sbt.internal.util.StringEvent;
import sbt.protocol.Attach;
import sbt.protocol.CommandMessage;
import sbt.protocol.EventMessage;
import sbt.protocol.ExecCommand;
import sbt.protocol.InitCommand;
import sbt.protocol.SettingQuery;
import sbt.protocol.codec.JsonProtocol$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sjsonnew.BasicJsonProtocol$;
import sjsonnew.JsonFormat;
import sjsonnew.JsonReader;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JObject;
import sjsonnew.shaded.scalajson.ast.unsafe.JObject$;
import sjsonnew.shaded.scalajson.ast.unsafe.JString;
import sjsonnew.shaded.scalajson.ast.unsafe.JString$;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;
import sjsonnew.support.scalajson.unsafe.Parser$;

public final class Serialization$
implements Serializable {
    private static final String VsCode;
    private static final String readSystemIn;
    private static final String cancelReadSystemIn;
    private static final String clientJob;
    private static final String systemIn;
    private static final String systemOut;
    private static final String systemErr;
    private static final String systemOutFlush;
    private static final String systemErrFlush;
    private static final String terminalPropertiesQuery;
    private static final String terminalPropertiesResponse;
    private static final String terminalCapabilities;
    private static final String terminalCapabilitiesResponse;
    private static final String attach;
    private static final String attachResponse;
    private static final String cancelRequest;
    private static final String promptChannel;
    private static final String setTerminalAttributes;
    private static final String getTerminalAttributes;
    private static final String terminalGetSize;
    private static final String terminalSetSize;
    private static final String terminalSetEcho;
    private static final String terminalSetRawMode;
    private static final String CancelAll;
    public static final Serialization$ MODULE$;

    private Serialization$() {
    }

    static {
        MODULE$ = new Serialization$();
        VsCode = "application/vscode-jsonrpc; charset=utf-8";
        readSystemIn = "sbt/readSystemIn";
        cancelReadSystemIn = "sbt/cancelReadSystemIn";
        clientJob = "sbt/clientJob";
        systemIn = "sbt/systemIn";
        systemOut = "sbt/systemOut";
        systemErr = "sbt/systemErr";
        systemOutFlush = "sbt/systemOutFlush";
        systemErrFlush = "sbt/systemErrFlush";
        terminalPropertiesQuery = "sbt/terminalPropertiesQuery";
        terminalPropertiesResponse = "sbt/terminalPropertiesResponse";
        terminalCapabilities = "sbt/terminalCapabilities";
        terminalCapabilitiesResponse = "sbt/terminalCapabilitiesResponse";
        attach = "sbt/attach";
        attachResponse = "sbt/attachResponse";
        cancelRequest = "sbt/cancelRequest";
        promptChannel = "sbt/promptChannel";
        setTerminalAttributes = "sbt/setTerminalAttributes";
        getTerminalAttributes = "sbt/getTerminalAttributes";
        terminalGetSize = "sbt/terminalGetSize";
        terminalSetSize = "sbt/terminalSetSize";
        terminalSetEcho = "sbt/terminalSetEcho";
        terminalSetRawMode = "sbt/terminalSetRawMode";
        CancelAll = "__CancelAll";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Serialization$.class);
    }

    public String VsCode() {
        return VsCode;
    }

    public String readSystemIn() {
        return readSystemIn;
    }

    public String cancelReadSystemIn() {
        return cancelReadSystemIn;
    }

    public String clientJob() {
        return clientJob;
    }

    public String systemIn() {
        return systemIn;
    }

    public String systemOut() {
        return systemOut;
    }

    public String systemErr() {
        return systemErr;
    }

    public String systemOutFlush() {
        return systemOutFlush;
    }

    public String systemErrFlush() {
        return systemErrFlush;
    }

    public String terminalPropertiesQuery() {
        return terminalPropertiesQuery;
    }

    public String terminalPropertiesResponse() {
        return terminalPropertiesResponse;
    }

    public String terminalCapabilities() {
        return terminalCapabilities;
    }

    public String terminalCapabilitiesResponse() {
        return terminalCapabilitiesResponse;
    }

    public String attach() {
        return attach;
    }

    public String attachResponse() {
        return attachResponse;
    }

    public String cancelRequest() {
        return cancelRequest;
    }

    public String promptChannel() {
        return promptChannel;
    }

    public String setTerminalAttributes() {
        return setTerminalAttributes;
    }

    public String getTerminalAttributes() {
        return getTerminalAttributes;
    }

    public String terminalGetSize() {
        return terminalGetSize;
    }

    public String terminalSetSize() {
        return terminalSetSize;
    }

    public String terminalSetEcho() {
        return terminalSetEcho;
    }

    public String terminalSetRawMode() {
        return terminalSetRawMode;
    }

    public String CancelAll() {
        return CancelAll;
    }

    public <A> byte[] serializeEvent(A event, JsonFormat<A> evidence$1) {
        JValue json = (JValue)Converter$.MODULE$.toJson(event, evidence$1).get();
        return CompactPrinter$.MODULE$.apply(json).getBytes("UTF-8");
    }

    public byte[] serializeCommand(CommandMessage command) {
        JValue json = (JValue)Converter$.MODULE$.toJson((Object)command, (JsonWriter)JsonProtocol$.MODULE$.CommandMessageFormat()).get();
        return CompactPrinter$.MODULE$.apply(json).getBytes("UTF-8");
    }

    public String serializeCommandAsJsonMessage(CommandMessage command) {
        CommandMessage commandMessage = command;
        if (commandMessage instanceof InitCommand) {
            InitCommand x = (InitCommand)commandMessage;
            String execId = (String)x.execId().getOrElse(Serialization$::$anonfun$1);
            InitializeOption opts = (InitializeOption)x.initializationOptions().getOrElse(Serialization$::$anonfun$2);
            String optsJson = CompactPrinter$.MODULE$.apply((JValue)Converter$.MODULE$.toJson((Object)opts, (JsonWriter)JsonProtocol$.MODULE$.InitializeOptionFormat()).get());
            return new StringBuilder(95).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"initialize\", \"params\": { \"initializationOptions\": ").append(optsJson).append(" } }").toString();
        }
        if (commandMessage instanceof ExecCommand) {
            ExecCommand x = (ExecCommand)commandMessage;
            String execId = (String)x.execId().getOrElse(Serialization$::$anonfun$3);
            JValue json = (JValue)Converter$.MODULE$.toJson((Object)x.commandLine(), (JsonWriter)BasicJsonProtocol$.MODULE$.StringJsonFormat()).get();
            String v = CompactPrinter$.MODULE$.apply(json);
            return new StringBuilder(83).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"sbt/exec\", \"params\": { \"commandLine\": ").append(v).append(" } }").toString();
        }
        if (commandMessage instanceof SettingQuery) {
            SettingQuery x = (SettingQuery)commandMessage;
            String execId = UUID.randomUUID().toString();
            JValue json = (JValue)Converter$.MODULE$.toJson((Object)x.setting(), (JsonWriter)BasicJsonProtocol$.MODULE$.StringJsonFormat()).get();
            String v = CompactPrinter$.MODULE$.apply(json);
            return new StringBuilder(82).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"sbt/setting\", \"params\": { \"setting\": ").append(v).append(" } }").toString();
        }
        if (commandMessage instanceof Attach) {
            Attach x = (Attach)commandMessage;
            String execId = UUID.randomUUID().toString();
            JValue json = (JValue)Converter$.MODULE$.toJson((Object)BoxesRunTime.boxToBoolean((boolean)x.interactive()), (JsonWriter)BasicJsonProtocol$.MODULE$.BooleanJsonFormat()).get();
            String v = CompactPrinter$.MODULE$.apply(json);
            return new StringBuilder(75).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"").append(this.attach()).append("\", \"params\": { \"interactive\": ").append(v).append(" } }").toString();
        }
        throw new MatchError((Object)commandMessage);
    }

    public byte[] serializeEventMessage(EventMessage event) {
        JValue json = (JValue)Converter$.MODULE$.toJson((Object)event, (JsonWriter)JsonProtocol$.MODULE$.EventMessageFormat()).get();
        return CompactPrinter$.MODULE$.apply(json).getBytes("UTF-8");
    }

    public byte[] serializeResponseMessage(JsonRpcResponseMessage message) {
        return this.serializeResponse((Object)message, (JsonWriter)JsonRPCProtocol$.MODULE$.JsonRpcResponseMessageFormat());
    }

    public byte[] serializeRequestMessage(JsonRpcRequestMessage message) {
        return this.serializeResponse((Object)message, (JsonWriter)JsonRPCProtocol$.MODULE$.JsonRpcRequestMessageFormat());
    }

    public byte[] serializeNotificationMessage(JsonRpcNotificationMessage message) {
        return this.serializeResponse((Object)message, (JsonWriter)JsonRPCProtocol$.MODULE$.JsonRpcNotificationMessageFormat());
    }

    public <A> byte[] serializeResponse(A message, JsonWriter<A> evidence$1) {
        JValue json = (JValue)Converter$.MODULE$.toJson(message, evidence$1).get();
        String body = CompactPrinter$.MODULE$.apply(json);
        int bodyLength = body.getBytes("UTF-8").length;
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("Content-Length: ").append(bodyLength).toString(), new StringBuilder(14).append("Content-Type: ").append(this.VsCode()).toString(), "", body})).mkString("\r\n").getBytes("UTF-8");
    }

    public Either<String, CommandMessage> deserializeCommand(Seq<Object> bytes) {
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            JValue json = (JValue)((Success)try_).value();
            Try try_2 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)JsonProtocol$.MODULE$.CommandMessageFormat());
            if (try_2 instanceof Success) {
                CommandMessage command = (CommandMessage)((Success)try_2).value();
                return package$.MODULE$.Right().apply((Object)command);
            }
            if (try_2 instanceof Failure) {
                Throwable e = ((Failure)try_2).exception();
                return package$.MODULE$.Left().apply((Object)e.getMessage());
            }
            throw new MatchError((Object)try_2);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("Parse error: ").append(e.getMessage()).toString());
        }
        throw new MatchError((Object)try_);
    }

    public Either<String, Object> deserializeEvent(Seq<Object> bytes) {
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            JValue json = (JValue)((Success)try_).value();
            Option<String> option = this.detectType(json);
            if (option instanceof Some && "StringEvent".equals(((Some)option).value())) {
                Try try_2 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)sbt.internal.util.codec.JsonProtocol$.MODULE$.StringEventFormat());
                if (try_2 instanceof Success) {
                    StringEvent event = (StringEvent)((Success)try_2).value();
                    return package$.MODULE$.Right().apply((Object)event);
                }
                if (try_2 instanceof Failure) {
                    Throwable e = ((Failure)try_2).exception();
                    return package$.MODULE$.Left().apply((Object)e.getMessage());
                }
                throw new MatchError((Object)try_2);
            }
            Try try_3 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)JsonProtocol$.MODULE$.EventMessageFormat());
            if (try_3 instanceof Success) {
                EventMessage event = (EventMessage)((Success)try_3).value();
                return package$.MODULE$.Right().apply((Object)event);
            }
            if (try_3 instanceof Failure) {
                Throwable e = ((Failure)try_3).exception();
                return package$.MODULE$.Left().apply((Object)e.getMessage());
            }
            throw new MatchError((Object)try_3);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("Parse error: ").append(e.getMessage()).toString());
        }
        throw new MatchError((Object)try_);
    }

    public Option<String> detectType(JValue json) {
        JValue jValue = json;
        if (jValue instanceof JObject) {
            JValue jValue2;
            JObject jObject = JObject$.MODULE$.unapply((JObject)jValue);
            Object[] objectArray = jObject._1();
            Object[] fields = objectArray;
            Object object = Predef$.MODULE$.refArrayOps(fields);
            Option option = ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$1 -> {
                String string = _$1.field();
                String string2 = "type";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).map((Function1 & Serializable)_$2 -> _$2.value());
            if (option instanceof Some && (jValue2 = (JValue)((Some)option).value()) instanceof JString) {
                String string;
                JString jString = JString$.MODULE$.unapply((JString)jValue2);
                String value = string = jString._1();
                return Some$.MODULE$.apply((Object)value);
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Either<String, EventMessage> deserializeEventMessage(Seq<Object> bytes) {
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            JValue json = (JValue)((Success)try_).value();
            Try try_2 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)JsonProtocol$.MODULE$.EventMessageFormat());
            if (try_2 instanceof Success) {
                EventMessage event = (EventMessage)((Success)try_2).value();
                return package$.MODULE$.Right().apply((Object)event);
            }
            if (try_2 instanceof Failure) {
                Throwable e = ((Failure)try_2).exception();
                return package$.MODULE$.Left().apply((Object)e.getMessage());
            }
            throw new MatchError((Object)try_2);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("Parse error: ").append(e.getMessage()).toString());
        }
        throw new MatchError((Object)try_);
    }

    public Either<String, JsonRpcMessage> deserializeJsonMessage(Seq<Object> bytes) {
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            JValue jValue = (JValue)((Success)try_).value();
            if (jValue instanceof JObject) {
                Object[] objectArray;
                JObject jObject = (JObject)jValue;
                JObject jObject2 = JObject$.MODULE$.unapply(jObject);
                Object[] fields = objectArray = jObject2._1();
                JObject json = jObject;
                Object object = Predef$.MODULE$.refArrayOps(fields);
                if (ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$3 -> {
                    String string = _$3.field();
                    String string2 = "method";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).isDefined()) {
                    Object object2 = Predef$.MODULE$.refArrayOps(fields);
                    if (ArrayOps$.MODULE$.find$extension(object2, (Function1 & Serializable)_$4 -> {
                        String string = _$4.field();
                        String string2 = "id";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }).isDefined()) {
                        Try try_2 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)JsonRPCProtocol$.MODULE$.JsonRpcRequestMessageFormat());
                        if (try_2 instanceof Success) {
                            JsonRpcRequestMessage request = (JsonRpcRequestMessage)((Success)try_2).value();
                            return package$.MODULE$.Right().apply((Object)request);
                        }
                        if (try_2 instanceof Failure) {
                            Throwable e = ((Failure)try_2).exception();
                            return package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("conversion error: ").append(e.getMessage()).toString());
                        }
                        throw new MatchError((Object)try_2);
                    }
                    Try try_3 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)JsonRPCProtocol$.MODULE$.JsonRpcNotificationMessageFormat());
                    if (try_3 instanceof Success) {
                        JsonRpcNotificationMessage notification = (JsonRpcNotificationMessage)((Success)try_3).value();
                        return package$.MODULE$.Right().apply((Object)notification);
                    }
                    if (try_3 instanceof Failure) {
                        Throwable e = ((Failure)try_3).exception();
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("conversion error: ").append(e.getMessage()).toString());
                    }
                    throw new MatchError((Object)try_3);
                }
                Object object3 = Predef$.MODULE$.refArrayOps(fields);
                if (ArrayOps$.MODULE$.find$extension(object3, (Function1 & Serializable)_$5 -> {
                    String string = _$5.field();
                    String string2 = "id";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).isDefined()) {
                    Try try_4 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)JsonRPCProtocol$.MODULE$.JsonRpcResponseMessageFormat());
                    if (try_4 instanceof Success) {
                        JsonRpcResponseMessage res = (JsonRpcResponseMessage)((Success)try_4).value();
                        return package$.MODULE$.Right().apply((Object)res);
                    }
                    if (try_4 instanceof Failure) {
                        Throwable e = ((Failure)try_4).exception();
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("conversion error: ").append(e.getMessage()).toString());
                    }
                    throw new MatchError((Object)try_4);
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(35).append("expected JSON-RPC object but found ").append(new String((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), "UTF-8")).toString());
            }
            JValue json = jValue;
            return package$.MODULE$.Left().apply((Object)new StringBuilder(31).append("expected JSON object but found ").append(new String((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), "UTF-8")).toString());
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("parse error: ").append(e.getMessage()).toString());
        }
        throw new MatchError((Object)try_);
    }

    public String compactPrintJsonOpt(Option<JValue> jsonOpt) {
        Option<JValue> option = jsonOpt;
        if (option instanceof Some) {
            JValue x = (JValue)((Some)option).value();
            return CompactPrinter$.MODULE$.apply(x);
        }
        return "";
    }

    private static final String $anonfun$1() {
        return UUID.randomUUID().toString();
    }

    private static final InitializeOption $anonfun$2() {
        throw scala.sys.package$.MODULE$.error("expected initializationOptions");
    }

    private static final String $anonfun$3() {
        return UUID.randomUUID().toString();
    }
}

