/*
 * Decompiled with CFR 0.152.
 */
package sbt.scriptedtest;

import java.io.Serializable;
import sbt.internal.scripted.ScriptRunner;
import sbt.internal.scripted.Statement;
import sbt.internal.scripted.StatementHandler;
import sbt.internal.scripted.TestException;
import sbt.internal.scripted.TestFailed;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.function.JProcedure1;
import scala.util.Left;
import scala.util.Right;

public class BatchScriptRunner
extends ScriptRunner
implements AutoCloseable {
    public void apply(List<Tuple2<StatementHandler, Statement>> statements, HashMap<StatementHandler, Object> states) {
        if (states.isEmpty()) {
            super.apply(statements);
            return;
        }
        statements.foreach((Function1)(JProcedure1 & Serializable)st -> this.processStatement((StatementHandler)st._1(), (Statement)st._2(), states));
    }

    public void initStates(HashMap<StatementHandler, Object> states, Seq<StatementHandler> handlers) {
        handlers.foreach((Function1)(JProcedure1 & Serializable)handler -> states.update(handler, handler.initialState()));
    }

    public void cleanUpHandlers(Seq<StatementHandler> handlers, HashMap<StatementHandler, Object> states) {
        handlers.foreach((Function1)(JProcedure1 & Serializable)handler -> states.get(handler).foreach((Function1)(JProcedure1 & Serializable)state -> {
            try {
                handler.finish(state);
            }
            catch (Exception exception) {}
        }));
    }

    public void processStatement(StatementHandler handler, Statement statement, HashMap<StatementHandler, Object> states) {
        Left nextState;
        Left left;
        Object state = states.apply((Object)handler);
        try {
            left = package$.MODULE$.Right().apply(handler.apply(statement.command(), statement.arguments(), state));
        }
        catch (Exception e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        Left left2 = nextState = left;
        if (left2 instanceof Left) {
            Exception err = (Exception)left2.value();
            if (statement.successExpected()) {
                Exception exception = err;
                if (exception instanceof TestFailed) {
                    TestFailed t = (TestFailed)exception;
                    throw new TestException(statement, new StringBuilder(16).append("Command failed: ").append(t.getMessage()).toString(), null);
                }
                throw new TestException(statement, "Command failed", (Throwable)err);
            }
            return;
        }
        if (left2 instanceof Right) {
            Object s = ((Right)left2).value();
            if (statement.successExpected()) {
                states.update((Object)handler, s);
                return;
            }
            throw new TestException(statement, "Command succeeded but failure was expected", null);
        }
        throw new MatchError((Object)left2);
    }

    @Override
    public void close() {
    }
}

