/*
 * Decompiled with CFR 0.152.
 */
package sbt.scriptedtest;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ForkJoinPool;
import sbt.internal.librarymanagement.cross.CrossVersionUtil$;
import sbt.package$;
import sbt.scriptedtest.ListTests;
import sbt.scriptedtest.RemoteSbtCreatorProp;
import sbt.scriptedtest.RemoteSbtCreatorProp$LauncherBased$;
import sbt.scriptedtest.RemoteSbtCreatorProp$RunFromSourceBased$;
import sbt.scriptedtest.ScriptedTest;
import sbt.scriptedtest.ScriptedTest$;
import sbt.scriptedtest.ScriptedTests;
import sbt.scriptedtest.TestConsoleLogger;
import sbt.scriptedtest.TestConsoleLogger$;
import sbt.util.Logger;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.ParSeq;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.mutable.ParArray;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.function.JProcedure1;

public class ScriptedRunner {
    public void run(File resourceBaseDirectory, boolean bufferLog, String[] tests, File launcherJar, String[] launchOpts) {
        TestConsoleLogger logger = TestConsoleLogger$.MODULE$.apply();
        this.run(resourceBaseDirectory, bufferLog, tests, (Logger)logger, "java", launchOpts, new ArrayList<File>(), RemoteSbtCreatorProp$LauncherBased$.MODULE$.apply(launcherJar), 1, false);
    }

    public void run(File resourceBaseDirectory, boolean bufferLog, String[] tests, File launcherJar, String[] launchOpts, List<File> prescripted) {
        TestConsoleLogger logger = TestConsoleLogger$.MODULE$.apply();
        this.run(resourceBaseDirectory, bufferLog, tests, (Logger)logger, "java", launchOpts, prescripted, RemoteSbtCreatorProp$LauncherBased$.MODULE$.apply(launcherJar), Integer.MAX_VALUE, false);
    }

    public void run(File resourceBaseDirectory, boolean bufferLog, String[] tests, File launcherJar, String javaCommand, String[] launchOpts, List<File> prescripted) {
        TestConsoleLogger logger = TestConsoleLogger$.MODULE$.apply();
        this.run(resourceBaseDirectory, bufferLog, tests, (Logger)logger, javaCommand, launchOpts, prescripted, RemoteSbtCreatorProp$LauncherBased$.MODULE$.apply(launcherJar), Integer.MAX_VALUE, false);
    }

    public void runInParallel(File resourceBaseDirectory, boolean bufferLog, String[] tests, File launcherJar, String[] launchOpts, List<File> prescripted, int instance) {
        TestConsoleLogger logger = TestConsoleLogger$.MODULE$.apply();
        this.runInParallel(resourceBaseDirectory, bufferLog, tests, (Logger)logger, "java", launchOpts, prescripted, RemoteSbtCreatorProp$LauncherBased$.MODULE$.apply(launcherJar), instance);
    }

    public void runInParallel(File resourceBaseDirectory, boolean bufferLog, String[] tests, File launcherJar, String javaCommand, String[] launchOpts, List<File> prescripted, int instance) {
        TestConsoleLogger logger = TestConsoleLogger$.MODULE$.apply();
        this.runInParallel(resourceBaseDirectory, bufferLog, tests, (Logger)logger, javaCommand, launchOpts, prescripted, RemoteSbtCreatorProp$LauncherBased$.MODULE$.apply(launcherJar), instance);
    }

    public void runInParallel(File baseDir, boolean bufferLog, String[] tests, Logger logger, String[] launchOpts, List<File> prescripted, String scalaVersion, String sbtVersion, File[] classpath, int instances) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])classpath);
        this.runInParallel(baseDir, bufferLog, tests, logger, "java", launchOpts, prescripted, RemoteSbtCreatorProp$RunFromSourceBased$.MODULE$.apply(scalaVersion, sbtVersion, (Seq<File>)ArrayOps$.MODULE$.toSeq$extension(object)), instances);
    }

    public void runInParallel(File baseDir, boolean bufferLog, String[] tests, Logger logger, String javaCommand, String[] launchOpts, List<File> prescripted, RemoteSbtCreatorProp prop, int instances) {
        this.run(baseDir, bufferLog, tests, logger, javaCommand, launchOpts, prescripted, prop, instances, true);
    }

    private void run(File baseDir, boolean bufferLog, String[] tests, Logger logger, String javaCommand, String[] launchOpts, List<File> prescripted, RemoteSbtCreatorProp prop, int instances, boolean parallelExecution) {
        String string;
        JProcedure1 & Serializable addTestFile = (JProcedure1 & Serializable)f -> prescripted.add((File)f);
        ScriptedTests runner = new ScriptedTests(baseDir, bufferLog, javaCommand, (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)launchOpts));
        RemoteSbtCreatorProp remoteSbtCreatorProp = prop;
        if (remoteSbtCreatorProp instanceof RemoteSbtCreatorProp.LauncherBased) {
            File file;
            RemoteSbtCreatorProp.LauncherBased launcherBased = RemoteSbtCreatorProp$LauncherBased$.MODULE$.unapply((RemoteSbtCreatorProp.LauncherBased)remoteSbtCreatorProp);
            File launcherJar = file = launcherBased._1();
            string = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(launcherJar.getName()), (Function1 & Serializable)_$7 -> ScriptedRunner.$anonfun$13(BoxesRunTime.unboxToChar((Object)_$7)))), ".jar".length());
        } else if (remoteSbtCreatorProp instanceof RemoteSbtCreatorProp.RunFromSourceBased) {
            String sbtVersion;
            RemoteSbtCreatorProp.RunFromSourceBased runFromSourceBased = RemoteSbtCreatorProp$RunFromSourceBased$.MODULE$.unapply((RemoteSbtCreatorProp.RunFromSourceBased)remoteSbtCreatorProp);
            String string2 = runFromSourceBased._1();
            String string3 = runFromSourceBased._2();
            Seq<File> seq = runFromSourceBased._3();
            string = sbtVersion = string3;
        } else {
            throw new MatchError((Object)remoteSbtCreatorProp);
        }
        String sbtVersion = string;
        Function1 & Serializable accept = (Function1 & Serializable)test -> this.isTestCompatible(baseDir, sbtVersion, (ScriptedTest)test);
        Seq scriptedTests = (Seq)this.get((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)tests), baseDir, (Function1<ScriptedTest, Object>)accept, logger).map((Function1 & Serializable)st -> Tuple2$.MODULE$.apply((Object)st.group(), (Object)st.name()));
        int groupCount = parallelExecution ? instances : Integer.MAX_VALUE;
        Seq<Function0<Seq<Option<String>>>> scriptedRunners = runner.batchScriptedRunner((Seq<Tuple2<String, String>>)scriptedTests, (Function1<File, BoxedUnit>)addTestFile, groupCount, prop, logger);
        if (parallelExecution && instances > 1) {
            Object object = CollectionConverters$.MODULE$.ArrayIsParallelizable(scriptedRunners.toArray(ClassTag$.MODULE$.apply(Function0.class)));
            ParArray parallelRunners = CollectionConverters.ArrayIsParallelizable$.MODULE$.par$extension(object);
            parallelRunners.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(new ForkJoinPool(instances)));
            this.runAll((ParSeq<Function0<Seq<Option<String>>>>)parallelRunners);
            return;
        }
        this.runAll(scriptedRunners);
    }

    public void runInParallel(File baseDir, boolean bufferLog, String[] tests, String[] launchOpts, List<File> prescripted, String sbtVersion, String scalaVersion, File[] classpath, int instances) {
        this.runInParallel(baseDir, bufferLog, tests, (Logger)TestConsoleLogger$.MODULE$.apply(), launchOpts, prescripted, sbtVersion, scalaVersion, classpath, instances);
    }

    private void reportErrors(Seq<String> errors) {
        if (errors.nonEmpty()) {
            throw scala.sys.package$.MODULE$.error(errors.mkString("Failed tests:\n\t", "\n\t", "\n"));
        }
    }

    public void runAll(Seq<Function0<Seq<Option<String>>>> toRun) {
        this.reportErrors((Seq<String>)((Seq)toRun.flatMap((Function1 & Serializable)test -> (IterableOnce)((IterableOps)test.apply()).flatten(Predef$.MODULE$.$conforms()))));
    }

    public void runAll(ParSeq<Function0<Seq<Option<String>>>> toRun) {
        this.reportErrors((Seq<String>)toRun.flatMap((Function1 & Serializable)test -> (IterableOnce)((IterableOps)test.apply()).flatten(Predef$.MODULE$.$conforms())).toList());
    }

    public Seq<ScriptedTest> get(Seq<String> tests, File baseDirectory, Logger log) {
        return this.get(tests, baseDirectory, (Function1<ScriptedTest, Object>)(Function1 & Serializable)_$8 -> true, log);
    }

    public Seq<ScriptedTest> get(Seq<String> tests, File baseDirectory, Function1<ScriptedTest, Object> accept, Logger log) {
        Seq<ScriptedTest> unsorted = tests.isEmpty() ? this.listTests(baseDirectory, accept, log) : this.parseTests(tests);
        return (Seq)unsorted.sortBy((Function1 & Serializable)t -> Tuple2$.MODULE$.apply((Object)t.group(), (Object)t.name()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
    }

    public Seq<ScriptedTest> listTests(File baseDirectory, Logger log) {
        return this.listTests(baseDirectory, (Function1<ScriptedTest, Object>)(Function1 & Serializable)_$9 -> true, log);
    }

    public Seq<ScriptedTest> listTests(File baseDirectory, Function1<ScriptedTest, Object> accept, Logger log) {
        return new ListTests(baseDirectory, accept, log).listTests();
    }

    public Seq<ScriptedTest> parseTests(Seq<String> in) {
        return (Seq)in.map((Function1 & Serializable)testString -> {
            Object object;
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])testString.split("/"));
            String[] stringArray = (String[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$10 -> _$10.trim(), ClassTag$.MODULE$.apply(String.class));
            if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String group = string;
            String name = string2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)group, (Object)name);
            String group2 = (String)tuple2._1();
            String name2 = (String)tuple2._2();
            return ScriptedTest$.MODULE$.apply(group2, name2);
        });
    }

    private boolean isTestCompatible(File resourceBaseDirectory, String sbtVersion, ScriptedTest test) {
        Properties buildProperties = new Properties();
        File testDir = new File(new File(resourceBaseDirectory, test.group()), test.name());
        File buildPropertiesFile = new File(new File(testDir, "project"), "build.properties");
        package$.MODULE$.IO().load(buildProperties, buildPropertiesFile);
        Option option = Option$.MODULE$.apply((Object)buildProperties.getProperty("sbt.version"));
        if (option instanceof Some) {
            String version = (String)((Some)option).value();
            String string = CrossVersionUtil$.MODULE$.binarySbtVersion(version);
            String string2 = CrossVersionUtil$.MODULE$.binarySbtVersion(sbtVersion);
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    private static final /* synthetic */ boolean $anonfun$13(char _$7) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$7));
    }
}

