/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import sbt.SuiteResult;
import sbt.TestDefinition;
import sbt.TestFramework;
import sbt.TestFunction;
import sbt.TestReportListener;
import sbt.TestRunner;
import sbt.TestsListener;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.classpath.ClasspathUtilities$;
import sbt.internal.inc.classpath.DualLoader;
import sbt.internal.util.ManagedLogger;
import sbt.io.IO$;
import sbt.protocol.testing.TestResult;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import sbt.testing.SubclassFingerprint;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class TestFramework$
implements Serializable {
    public static final TestFramework$ MODULE$ = new TestFramework$();

    private TestFramework$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TestFramework$.class);
    }

    public TestFramework apply(Seq<String> implClassNames) {
        return new TestFramework(implClassNames);
    }

    public Seq<Fingerprint> getFingerprints(Framework framework) {
        Object object = framework.getClass().getMethod("fingerprints", new Class[0]).invoke((Object)framework, new Object[0]);
        if (object instanceof Fingerprint[]) {
            Object[] fingerprints = (Fingerprint[])object;
            return Predef$.MODULE$.wrapRefArray(fingerprints).toList();
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(43).append("Could not call 'fingerprints' on framework ").append(framework).toString());
    }

    public <T> void safeForeach(Iterable<T> it, ManagedLogger log, Function1<T, BoxedUnit> f) {
        it.foreach((Function1)(JProcedure1 & Serializable)i -> {
            try {
                f.apply(i);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    log.trace(() -> TestFramework$.safeForeach$$anonfun$1$$anonfun$1(e));
                    log.error(() -> TestFramework$.safeForeach$$anonfun$1$$anonfun$2(e));
                }
                throw throwable;
            }
        });
    }

    public int hashCode(Fingerprint f) {
        Fingerprint fingerprint = f;
        if (fingerprint instanceof SubclassFingerprint) {
            SubclassFingerprint s = (SubclassFingerprint)fingerprint;
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)s.isModule()), (Object)s.superclassName()).hashCode();
        }
        if (fingerprint instanceof AnnotatedFingerprint) {
            AnnotatedFingerprint a = (AnnotatedFingerprint)fingerprint;
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)a.isModule()), (Object)a.annotationName()).hashCode();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(Fingerprint a, Fingerprint b) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)a, (Object)b);
        if (tuple2 == null) return false;
        Fingerprint fingerprint = (Fingerprint)tuple2._1();
        Fingerprint fingerprint2 = (Fingerprint)tuple2._2();
        if (fingerprint instanceof SubclassFingerprint) {
            SubclassFingerprint a2 = (SubclassFingerprint)fingerprint;
            if (fingerprint2 instanceof SubclassFingerprint) {
                SubclassFingerprint b2 = (SubclassFingerprint)fingerprint2;
                if (a2.isModule() != b2.isModule()) return false;
                String string = a2.superclassName();
                String string2 = b2.superclassName();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
        }
        if (!(fingerprint instanceof AnnotatedFingerprint)) return false;
        AnnotatedFingerprint a3 = (AnnotatedFingerprint)fingerprint;
        if (!(fingerprint2 instanceof AnnotatedFingerprint)) return false;
        AnnotatedFingerprint b3 = (AnnotatedFingerprint)fingerprint2;
        if (a3.isModule() != b3.isModule()) return false;
        String string = a3.annotationName();
        String string3 = b3.annotationName();
        if (string != null) {
            if (!string.equals(string3)) return false;
            return true;
        }
        if (string3 == null) return true;
        return false;
    }

    public String toString(Fingerprint f) {
        Fingerprint fingerprint = f;
        if (fingerprint instanceof SubclassFingerprint) {
            SubclassFingerprint sf = (SubclassFingerprint)fingerprint;
            return new StringBuilder(12).append("subclass(").append(sf.isModule()).append(", ").append(sf.superclassName()).append(")").toString();
        }
        if (fingerprint instanceof AnnotatedFingerprint) {
            AnnotatedFingerprint af = (AnnotatedFingerprint)fingerprint;
            return new StringBuilder(14).append("annotation(").append(af.isModule()).append(", ").append(af.annotationName()).append(")").toString();
        }
        return f.toString();
    }

    public Tuple3<Function0<BoxedUnit>, Vector<Tuple2<String, TestFunction>>, Function1<TestResult, Function0<BoxedUnit>>> testTasks(Map<TestFramework, Framework> frameworks, Map<TestFramework, Runner> runners, ClassLoader testLoader, Vector<TestDefinition> tests, ManagedLogger log, Vector<TestReportListener> listeners) {
        Map<Framework, scala.collection.immutable.Set<TestDefinition>> mappedTests = this.testMap((Seq<Framework>)frameworks.values().toSeq(), (Seq<TestDefinition>)tests);
        if (mappedTests.isEmpty()) {
            return Tuple3$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> {}, package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function1 & Serializable)_$8 -> (JFunction0.mcV.sp & Serializable)() -> {});
        }
        return this.createTestTasks(testLoader, (Map<Framework, TestRunner>)((Map)runners.map((Function1 & Serializable)x$1 -> {
            TestFramework testFramework = (TestFramework)x$1._1();
            Runner runner = (Runner)x$1._2();
            return Tuple2$.MODULE$.apply(frameworks.apply((Object)testFramework), (Object)new TestRunner(runner, listeners, log));
        })), mappedTests, tests, log, listeners);
    }

    private Vector<Tuple2<String, TestFunction>> order(Map<String, TestFunction> mapped, Vector<TestDefinition> inputs) {
        return (Vector)inputs.flatMap((Function1 & Serializable)d -> mapped.get((Object)d.name()).map((Function1 & Serializable)act -> Tuple2$.MODULE$.apply((Object)d.name(), act)));
    }

    public Map<Framework, scala.collection.immutable.Set<TestDefinition>> testMap(Seq<Framework> frameworks, Seq<TestDefinition> tests) {
        HashMap map = new HashMap();
        if (frameworks.nonEmpty()) {
            tests.foreach((Function1)(JProcedure1 & Serializable)test -> this.assignTest$1((Seq)frameworks, map, (TestDefinition)test));
        }
        return map.view().mapValues((Function1 & Serializable)_$9 -> _$9.toSet()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Tuple3<Function0<BoxedUnit>, Vector<Tuple2<String, TestFunction>>, Function1<TestResult, Function0<BoxedUnit>>> createTestTasks(ClassLoader loader, Map<Framework, TestRunner> runners, Map<Framework, scala.collection.immutable.Set<TestDefinition>> tests, Vector<TestDefinition> ordered, ManagedLogger log, Vector<TestReportListener> listeners) {
        Vector testsListeners = (Vector)listeners.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(TestReportListener x) {
                TestReportListener testReportListener = x;
                if (testReportListener instanceof TestsListener) {
                    TestsListener tl = (TestsListener)testReportListener;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(TestReportListener x, Function1 function1) {
                TestReportListener testReportListener = x;
                if (testReportListener instanceof TestsListener) {
                    TestsListener tl = (TestsListener)testReportListener;
                    return tl;
                }
                return function1.apply((Object)x);
            }
        });
        Function0 startTask = this.foreachListenerSafe$1(testsListeners, log, (Function1)(JProcedure1 & Serializable)_$10 -> _$10.doInit());
        Map testTasks = (Map)Predef$.MODULE$.Map().apply((Seq)tests.toSeq().flatMap((Function1 & Serializable)x$1 -> {
            Framework framework = (Framework)x$1._1();
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)x$1._2();
            TestRunner runner = (TestRunner)runners.apply((Object)framework);
            Object[] testTasks = (Task[])MODULE$.withContextLoader(loader, () -> TestFramework$.$anonfun$6(runner, set));
            Object object = Predef$.MODULE$.refArrayOps(testTasks);
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)testTask -> {
                TaskDef taskDef = testTask.taskDef();
                return Tuple2$.MODULE$.apply((Object)taskDef.fullyQualifiedName(), (Object)MODULE$.createTestFunction(loader, taskDef, runner, (Task)testTask));
            }, ClassTag$.MODULE$.apply(Tuple2.class)));
        }));
        Function1 & Serializable endTask = (Function1 & Serializable)result -> this.foreachListenerSafe$1(testsListeners, log, (Function1)(JProcedure1 & Serializable)_$11 -> _$11.doComplete((TestResult)result));
        return Tuple3$.MODULE$.apply((Object)startTask, this.order((Map<String, TestFunction>)testTasks, ordered), (Object)endTask);
    }

    private <T> T withContextLoader(ClassLoader loader, Function0<T> eval) {
        Object object;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            object = eval.apply();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        return (T)object;
    }

    public ClassLoader createTestLoader(Seq<File> classpath, ScalaInstance scalaInstance, File tempDir) {
        Seq seq;
        File interfaceJar = IO$.MODULE$.classLocationPath(Framework.class).toFile();
        Function1 & Serializable interfaceFilter = (Function1 & Serializable)name -> name.startsWith("org.scalatools.testing.") || name.startsWith("sbt.testing.");
        Function1 & Serializable notInterfaceFilter = (Function1 & Serializable)name -> !BoxesRunTime.unboxToBoolean((Object)interfaceFilter.apply(name));
        DualLoader dual = new DualLoader(scalaInstance.loader(), (Function1)notInterfaceFilter, (Function1 & Serializable)x -> true, this.getClass().getClassLoader(), (Function1)interfaceFilter, (Function1 & Serializable)x -> false);
        ClassLoader main = ClasspathUtilities$.MODULE$.makeLoader(classpath, (ClassLoader)dual, (xsbti.compile.ScalaInstance)scalaInstance, tempDir);
        if (scalaInstance.isManagedVersion()) {
            seq = (Seq)classpath.$plus$colon((Object)interfaceJar);
        } else {
            Object object = Predef$.MODULE$.refArrayOps((Object[])scalaInstance.allJars());
            seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.$plus$plus$extension(object, (IterableOnce)classpath.$plus$colon((Object)interfaceJar), ClassTag$.MODULE$.apply(File.class)));
        }
        Seq cp = seq;
        return ClasspathUtilities$.MODULE$.filterByClasspath(cp, main);
    }

    public TestFunction createTestFunction(ClassLoader loader, TaskDef taskDef, TestRunner runner, Task testTask) {
        return new TestFunction(taskDef, runner, testTask, loader){
            private final Task testTask$4;
            {
                this.testTask$4 = testTask$3;
                super(taskDef$3, runner$3, (Function1<TestRunner, Tuple2<SuiteResult, Seq<Task>>>)TestFramework$.MODULE$.sbt$TestFramework$$$_$$anon$superArg$1$1(loader$3, taskDef$3, testTask$3));
            }

            public Seq tags() {
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.testTask$4.tags());
                return ArrayOps$.MODULE$.toSeq$extension(object);
            }
        };
    }

    private static final Throwable safeForeach$$anonfun$1$$anonfun$1(Throwable e$4) {
        return e$4;
    }

    private static final String safeForeach$$anonfun$1$$anonfun$2(Throwable e$5) {
        return e$5.toString();
    }

    private final boolean isTestForFramework$1(TestDefinition test$1, Framework framework) {
        return this.getFingerprints(framework).exists((Function1 & Serializable)t -> MODULE$.matches((Fingerprint)t, test$1.fingerprint()));
    }

    private static final Set assignTest$1$$anonfun$2$$anonfun$1() {
        return new HashSet();
    }

    private final void assignTest$1(Seq frameworks$2, HashMap map$1, TestDefinition test) {
        frameworks$2.find((Function1 & Serializable)framework -> this.isTestForFramework$1(test, (Framework)framework)).foreach((Function1 & Serializable)framework -> (Set)((Growable)map$1.getOrElseUpdate(framework, TestFramework$::assignTest$1$$anonfun$2$$anonfun$1)).$plus$eq((Object)test));
    }

    private final Function0 foreachListenerSafe$1(Vector testsListeners$1, ManagedLogger log$4, Function1 f) {
        return (JFunction0.mcV.sp & Serializable)() -> MODULE$.safeForeach((Iterable)testsListeners$1, log$4, (Function1)f);
    }

    private static final Task[] $anonfun$6(TestRunner runner$1, scala.collection.immutable.Set testDefinitions$1) {
        return runner$1.tasks((scala.collection.immutable.Set<TestDefinition>)testDefinitions$1);
    }

    private static final Tuple2 $anon$superArg$1$1$$anonfun$1$$anonfun$1(TestRunner r$1, TaskDef taskDef$6, Task testTask$7) {
        return r$1.run(taskDef$6, testTask$7);
    }

    public final Function1 sbt$TestFramework$$$_$$anon$superArg$1$1(ClassLoader loader$4, TaskDef taskDef$4, Task testTask$5) {
        return (Function1 & Serializable)r -> (Tuple2)MODULE$.withContextLoader(loader$4, () -> TestFramework$.$anon$superArg$1$1$$anonfun$1$$anonfun$1(r, taskDef$4, testTask$5));
    }
}

