/*
 * Decompiled with CFR 0.152.
 */
package sbt.util;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import sbt.internal.util.ActionCacheEvent$;
import sbt.internal.util.ActionCacheEvent$Found$;
import sbt.internal.util.StringVirtualFile1;
import sbt.internal.util.StringVirtualFile1$;
import sbt.internal.util.codec.ManifestCodec$;
import sbt.io.IO$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.RelativeGlob;
import sbt.nio.file.package$;
import sbt.util.ActionCache;
import sbt.util.ActionCache$InternalActionResult$;
import sbt.util.ActionResult;
import sbt.util.BuildWideCacheConfiguration;
import sbt.util.CacheLevelTag;
import sbt.util.Digest$package$Digest$;
import sbt.util.GetActionResultRequest;
import sbt.util.GetActionResultRequest$;
import sbt.util.Manifest;
import sbt.util.Manifest$;
import sbt.util.UpdateActionResultRequest$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sjsonnew.HashWriter;
import sjsonnew.JsonFormat;
import sjsonnew.JsonReader;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.murmurhash.Hasher$;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;
import sjsonnew.support.scalajson.unsafe.Parser$;
import xsbti.FileConverter;
import xsbti.HashedVirtualFileRef;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;

public final class ActionCache$
implements Serializable {
    private static final String dirZipExt;
    private static final String manifestFileName;
    private static final long default2010Timestamp;
    public static final ActionCache$InternalActionResult$ InternalActionResult;
    public static final ActionCache$ MODULE$;

    private ActionCache$() {
    }

    static {
        MODULE$ = new ActionCache$();
        dirZipExt = ".sbtdir.zip";
        manifestFileName = "sbtdir_manifest.json";
        default2010Timestamp = 1262304000000L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ActionCache$.class);
    }

    public String dirZipExt() {
        return dirZipExt;
    }

    public String manifestFileName() {
        return manifestFileName;
    }

    public <I, O> O cache(I key, String codeContentHash, String extraHash, List<CacheLevelTag> tags, BuildWideCacheConfiguration config, Function1<I, ActionCache.InternalActionResult<O>> action, HashWriter<I> evidence$1, JsonFormat<O> evidence$2, ClassTag<O> evidence$3) {
        Option<O> option = this.get(key, codeContentHash, extraHash, tags, config, evidence$1, evidence$2, evidence$3);
        if (option instanceof Some) {
            Object value = ((Some)option).value();
            return (O)value;
        }
        if (None$.MODULE$.equals(option)) {
            return (O)this.organicTask$1(action, key, config, evidence$2, codeContentHash, extraHash, evidence$1);
        }
        throw new MatchError(option);
    }

    public <I, O> Option<O> get(I key, String codeContentHash, String extraHash, List<CacheLevelTag> tags, BuildWideCacheConfiguration config, HashWriter<I> evidence$1, JsonFormat<O> evidence$2, ClassTag<O> evidence$3) {
        String input = Digest$package$Digest$.MODULE$.sha256Hash((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{codeContentHash, extraHash, Digest$package$Digest$.MODULE$.dummy(Int$.MODULE$.int2long(BoxesRunTime.unboxToInt((Object)Hasher$.MODULE$.hashUnsafe(key, evidence$1))))}));
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)input, (Object)new StringBuilder(12).append(config.outputDirectory()).append("/value/").append(input).append(".json").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String input2 = (String)tuple2._1();
        String valuePath = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)input2, (Object)valuePath);
        String input3 = (String)tuple22._1();
        String valuePath2 = (String)tuple22._2();
        GetActionResultRequest getRequest = GetActionResultRequest$.MODULE$.apply(input3, false, false, (Vector<String>)((Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{valuePath2}))));
        Either<Throwable, ActionResult> either = config.store().get(getRequest);
        if (either instanceof Right) {
            ActionResult result = (ActionResult)((Right)either).value();
            Option option = result.contents().headOption();
            if (option instanceof Some) {
                ByteBuffer head = (ByteBuffer)((Some)option).value();
                config.store().syncBlobs((Seq<HashedVirtualFileRef>)result.outputFiles(), config.outputDirectory());
                String str = new String(head.array(), StandardCharsets.UTF_8);
                return Some$.MODULE$.apply(this.valueFromStr$1(config, evidence$2, str, result.origin()));
            }
            Seq<Path> paths = config.store().syncBlobs((Seq<HashedVirtualFileRef>)result.outputFiles(), config.outputDirectory());
            if (paths.isEmpty()) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(this.valueFromStr$1(config, evidence$2, IO$.MODULE$.read(((Path)paths.head()).toFile(), IO$.MODULE$.read$default$2()), result.origin()));
        }
        if (either instanceof Left) {
            return None$.MODULE$;
        }
        throw new MatchError(either);
    }

    public <I> boolean exists(I key, String codeContentHash, String extraHash, BuildWideCacheConfiguration config, HashWriter<I> evidence$1) {
        String input = Digest$package$Digest$.MODULE$.sha256Hash((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{codeContentHash, extraHash, Digest$package$Digest$.MODULE$.dummy(Int$.MODULE$.int2long(BoxesRunTime.unboxToInt((Object)Hasher$.MODULE$.hashUnsafe(key, evidence$1))))}));
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)input, (Object)new StringBuilder(12).append(config.outputDirectory()).append("/value/").append(input).append(".json").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String input2 = (String)tuple2._1();
        String valuePath = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)input2, (Object)valuePath);
        String input3 = (String)tuple22._1();
        String valuePath2 = (String)tuple22._2();
        GetActionResultRequest getRequest = GetActionResultRequest$.MODULE$.apply(input3, false, false, (Vector<String>)((Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{valuePath2}))));
        Either<Throwable, ActionResult> either = config.store().get(getRequest);
        if (either instanceof Right) {
            return true;
        }
        if (either instanceof Left) {
            return false;
        }
        throw new MatchError(either);
    }

    public Manifest manifestFromFile(Path manifest) {
        JValue json = (JValue)Parser$.MODULE$.parseFromFile(manifest.toFile()).get();
        return (Manifest)Converter$.MODULE$.fromJsonUnsafe((Object)json, (JsonReader)ManifestCodec$.MODULE$.ManifestFormat());
    }

    public VirtualFile packageDirectory(VirtualFileRef dir, FileConverter conv, Path outputDirectory) {
        Path dirPath = conv.toPath(dir);
        Seq allPaths = (Seq)((SeqOps)FileTreeView.Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(FileTreeView$.MODULE$.default()), Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(Glob.PathOps$.MODULE$.toGlob$extension(sbt.nio.file.syntax.package$.MODULE$.pathToPathOps(dirPath))), (RelativeGlob)package$.MODULE$.$times$times())), "*")).withFilter((Function1 & Serializable)_$1 -> !((FileAttributes)_$1._2()).isDirectory()).map((Function1 & Serializable)_$2 -> (Path)_$2._1())).sortBy((Function1 & Serializable)_$3 -> _$3.toString(), (Ordering)Ordering.String$.MODULE$);
        return (VirtualFile)IO$.MODULE$.withTemporaryDirectory((Function1 & Serializable)tempDir -> {
            Path mPath = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(tempDir), this.manifestFileName()).toPath();
            this.makeManifest$1(allPaths, conv, mPath);
            Path zipPath = Paths.get(new StringBuilder(0).append(dirPath.toString()).append(this.dirZipExt()).toString(), new String[0]);
            Function1 & Serializable rebase = (Function1 & Serializable)p -> {
                Path p2;
                Path path;
                Path p3;
                Path path2 = p3 = (path = p);
                Path path3 = dirPath;
                if (!(path2 != null ? !((Object)path2).equals(path3) : path3 != null)) {
                    return scala.package$.MODULE$.Nil();
                }
                Path path4 = p2 = path;
                Path path5 = mPath;
                if (!(path4 != null ? !((Object)path4).equals(path5) : path5 != null)) {
                    File file = (File)Predef$.MODULE$.ArrowAssoc((Object)mPath.toFile());
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, (Object)MODULE$.manifestFileName());
                    return scala.package$.MODULE$.Nil().$colon$colon((Object)tuple2);
                }
                Path f = path;
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)f.toFile());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, (Object)outputDirectory.relativize(f).toString());
                return scala.package$.MODULE$.Nil().$colon$colon((Object)tuple2);
            };
            IO$.MODULE$.zip((Iterable)((IterableOps)allPaths.$plus$plus((IterableOnce)((SeqOps)new .colon.colon((Object)mPath, (List)Nil$.MODULE$)))).flatMap((Function1)rebase), zipPath.toFile(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)default2010Timestamp)));
            return conv.toVirtualFile(zipPath);
        });
    }

    private static final String organicTask$1$$anonfun$1(Seq uncacheableOutputs$1) {
        return new StringBuilder(78).append("Cannot cache task because its output files are outside the output directory: \n").append(uncacheableOutputs$1.mkString("  - ", "\n  - ", "")).toString();
    }

    private final Object organicTask$1(Function1 action$1, Object key$1, BuildWideCacheConfiguration config$1, JsonFormat evidence$2$1, String codeContentHash$1, String extraHash$1, HashWriter evidence$1$1) {
        Option option;
        ActionCache.InternalActionResult internalActionResult;
        try {
            internalActionResult = (ActionCache.InternalActionResult)action$1.apply(key$1);
        }
        catch (Exception e) {
            config$1.cacheEventLog().append(ActionCacheEvent$.Error);
            throw e;
        }
        ActionCache.InternalActionResult internalActionResult2 = internalActionResult;
        if (internalActionResult2 == null || (option = ActionCache$InternalActionResult$.MODULE$.unapply(internalActionResult2)).isEmpty()) {
            throw new MatchError((Object)internalActionResult2);
        }
        Tuple2 tuple2 = (Tuple2)option.get();
        Object result = tuple2._1();
        Seq outputs = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(result, (Object)outputs);
        Object result2 = tuple22._1();
        Seq outputs2 = (Seq)tuple22._2();
        JValue json = (JValue)Converter$.MODULE$.toJsonUnsafe(result2, (JsonWriter)evidence$2$1);
        Seq uncacheableOutputs = (Seq)outputs2.filter((Function1 & Serializable)f -> !config$1.fileConverter().toPath((VirtualFileRef)f).toAbsolutePath().startsWith(config$1.outputDirectory()));
        if (uncacheableOutputs.nonEmpty()) {
            config$1.cacheEventLog().append(ActionCacheEvent$.Error);
            config$1.logger().error(() -> ActionCache$.organicTask$1$$anonfun$1(uncacheableOutputs));
            return result2;
        }
        config$1.cacheEventLog().append(ActionCacheEvent$.OnsiteTask);
        String input = Digest$package$Digest$.MODULE$.sha256Hash((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{codeContentHash$1, extraHash$1, Digest$package$Digest$.MODULE$.dummy(Int$.MODULE$.int2long(BoxesRunTime.unboxToInt((Object)Hasher$.MODULE$.hashUnsafe(key$1, evidence$1$1))))}));
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)input, (Object)new StringBuilder(12).append(config$1.outputDirectory()).append("/value/").append(input).append(".json").toString());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        String input2 = (String)tuple23._1();
        String valuePath = (String)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)input2, (Object)valuePath);
        String input3 = (String)tuple24._1();
        String valuePath2 = (String)tuple24._2();
        StringVirtualFile1 valueFile = StringVirtualFile1$.MODULE$.apply(valuePath2, CompactPrinter$.MODULE$.apply(json));
        Vector newOutputs = (Vector)((IterableOps)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringVirtualFile1[]{valueFile}))).$plus$plus((IterableOnce)outputs2.toVector());
        Either<Throwable, ActionResult> either = config$1.store().put(UpdateActionResultRequest$.MODULE$.apply(input3, (Vector<VirtualFile>)newOutputs, 0));
        if (either instanceof Right) {
            ActionResult cachedResult = (ActionResult)((Right)either).value();
            config$1.store().syncBlobs((Seq<HashedVirtualFileRef>)cachedResult.outputFiles(), config$1.outputDirectory());
            return result2;
        }
        if (either instanceof Left) {
            Throwable e = (Throwable)((Left)either).value();
            throw e;
        }
        throw new MatchError(either);
    }

    private static final String valueFromStr$1$$anonfun$1() {
        return "unknown";
    }

    private final Object valueFromStr$1(BuildWideCacheConfiguration config$3, JsonFormat evidence$2$2, String str, Option origin) {
        config$3.cacheEventLog().append(ActionCacheEvent$Found$.MODULE$.apply((String)origin.getOrElse(ActionCache$::valueFromStr$1$$anonfun$1)));
        JValue json = (JValue)Parser$.MODULE$.parseUnsafe(str);
        return Converter$.MODULE$.fromJsonUnsafe((Object)json, (JsonReader)evidence$2$2);
    }

    private final void makeManifest$1(Seq allPaths$1, FileConverter conv$1, Path manifestFile) {
        Vector vfs = ((IterableOnceOps)allPaths$1.map((Function1 & Serializable)p -> conv$1.toVirtualFile(p))).toVector();
        Manifest manifest = Manifest$.MODULE$.apply("0.1.0", (Vector<HashedVirtualFileRef>)vfs);
        String str = CompactPrinter$.MODULE$.apply((JValue)Converter$.MODULE$.toJsonUnsafe((Object)manifest, (JsonWriter)ManifestCodec$.MODULE$.ManifestFormat()));
        IO$.MODULE$.write(manifestFile.toFile(), str, IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
    }
}

