/*
 * Decompiled with CFR 0.152.
 */
package sbt.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import sbt.internal.util.codec.ActionResultCodec$;
import sbt.io.IO$;
import sbt.util.AbstractActionCacheStore;
import sbt.util.ActionResult;
import sbt.util.ActionResult$;
import sbt.util.GetActionResultRequest;
import sbt.util.UpdateActionResultRequest;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.util.Either;
import scala.util.control.NonFatal$;
import sjsonnew.JsonReader;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.Converter$;
import xsbti.HashedVirtualFileRef;
import xsbti.VirtualFile;

public class InMemoryActionCacheStore
implements AbstractActionCacheStore {
    private final Map<String, JValue> underlying = (Map)Map$.MODULE$.empty();
    private final Map<String, VirtualFile> blobCache = (Map)Map$.MODULE$.empty();

    @Override
    public String storeName() {
        return "in-memory";
    }

    @Override
    public Either<Throwable, ActionResult> get(GetActionResultRequest request) {
        Option optResult = this.underlying.get((Object)request.actionDigest()).flatMap((Function1 & Serializable)j -> {
            Some some;
            try {
                ActionResult value = (ActionResult)Converter$.MODULE$.fromJsonUnsafe(j, (JsonReader)ActionResultCodec$.MODULE$.ActionResultFormat());
                if (request.inlineOutputFiles().isEmpty()) {
                    some = Some$.MODULE$.apply((Object)value);
                } else {
                    Vector inlineRefs = (Vector)request.inlineOutputFiles().map((Function1 & Serializable)path -> (HashedVirtualFileRef)value.outputFiles().find((Function1 & Serializable)_$3 -> {
                        String string = _$3.id();
                        String string2 = path;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }).get());
                    Vector contents = (Vector)this.getBlobs((Seq<HashedVirtualFileRef>)inlineRefs).toVector().map((Function1 & Serializable)b -> ByteBuffer.wrap(IO$.MODULE$.readBytes(b.input())));
                    some = Some$.MODULE$.apply((Object)value.withContents((Vector<ByteBuffer>)contents));
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        });
        Option option = optResult;
        if (option instanceof Some) {
            ActionResult r = (ActionResult)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)r);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)this.notFound());
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Either<Throwable, ActionResult> put(UpdateActionResultRequest request) {
        Vector refs = this.putBlobsIfNeeded((Seq)request.outputFiles()).toVector();
        ActionResult v = ActionResult$.MODULE$.apply((Vector<HashedVirtualFileRef>)refs, this.storeName());
        JValue json = (JValue)Converter$.MODULE$.toJsonUnsafe((Object)v, (JsonWriter)ActionResultCodec$.MODULE$.ActionResultFormat());
        this.underlying.update((Object)request.actionDigest(), (Object)json);
        return package$.MODULE$.Right().apply((Object)v);
    }

    @Override
    public Seq<HashedVirtualFileRef> putBlobs(Seq<VirtualFile> blobs) {
        return (Seq)blobs.map((Function1 & Serializable)b -> {
            this.blobCache.update((Object)b.contentHashStr(), b);
            return b;
        });
    }

    private Seq<VirtualFile> getBlobs(Seq<HashedVirtualFileRef> refs) {
        return (Seq)refs.map((Function1 & Serializable)ref -> (VirtualFile)this.blobCache.apply((Object)ref.contentHashStr()));
    }

    @Override
    public Seq<Path> syncBlobs(Seq<HashedVirtualFileRef> refs, Path outputDirectory) {
        return package$.MODULE$.Nil();
    }

    @Override
    public Seq<HashedVirtualFileRef> findBlobs(Seq<HashedVirtualFileRef> refs) {
        return (Seq)refs.flatMap((Function1 & Serializable)r -> {
            if (this.blobCache.contains((Object)r.contentHashStr())) {
                return Some$.MODULE$.apply(r);
            }
            return None$.MODULE$;
        });
    }

    public String toString() {
        return this.underlying.toString();
    }
}

