/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class EscHelpers$ {
    public static EscHelpers$ MODULE$;
    private final int esc;
    private final int csi;

    static {
        new EscHelpers$();
    }

    public final char ESC() {
        return '\u001b';
    }

    public boolean isEscapeTerminator(char c) {
        return c >= '@' && c <= '~';
    }

    private boolean isCSI(char c) {
        return c == '[';
    }

    private boolean isAnsiTwoCharacterTerminator(char c) {
        return c >= '@' && c <= '_';
    }

    public boolean hasEscapeSequence(String s) {
        return s.indexOf(27) >= 0;
    }

    public String removeEscapeSequences(String s) {
        String string;
        if (s.isEmpty() || !this.hasEscapeSequence(s)) {
            string = s;
        } else {
            StringBuilder sb = new StringBuilder();
            this.nextESC(s, 0, sb);
            string = sb.toString();
        }
        return string;
    }

    private void nextESC(String s, int start, StringBuilder sb) {
        while (true) {
            int next;
            int escIndex;
            if ((escIndex = s.indexOf(27, start)) < 0) break;
            sb.append(s, start, escIndex);
            start = next = escIndex + 1 >= s.length() ? this.skipESC(s, escIndex + 1) : (this.isCSI(s.charAt(escIndex + 1)) ? this.skipESC(s, escIndex + 2) : (this.isAnsiTwoCharacterTerminator(s.charAt(escIndex + 1)) ? escIndex + 2 : this.skipESC(s, escIndex + 1)));
        }
        sb.append(s, start, s.length());
    }

    public int cursorPosition(String s) {
        byte[] bytes = s.getBytes();
        int index = 0;
        int state = 0;
        ArrayBuffer digit = new ArrayBuffer();
        int leftDigit = -1;
        for (int i = 0; i < bytes.length; ++i) {
            BoxedUnit boxedUnit;
            byte by = bytes[i];
            if (27 == by) {
                state = this.esc;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ((state == this.esc || state == this.csi) && by >= 48 && by < 58) {
                state = this.csi;
                boxedUnit = digit.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
                continue;
            }
            if (91 == by && state == this.esc) {
                state = this.csi;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (8 == by) {
                state = 0;
                --index;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (state == this.csi) {
                leftDigit = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new String((byte[])digit.toArray(ClassTag$.MODULE$.Byte())))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
                state = 0;
                char c = (char)by;
                switch (c) {
                    case 'D': {
                        index = package$.MODULE$.max(index - leftDigit, 0);
                        break;
                    }
                    case 'C': {
                        index += leftDigit;
                        break;
                    }
                    case 'K': {
                        break;
                    }
                    case 'J': {
                        if (leftDigit != 2) break;
                        index = 0;
                        break;
                    }
                    case 'm': {
                        break;
                    }
                    case ';': {
                        state = this.csi;
                        break;
                    }
                }
                digit.clear();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            ++index;
            boxedUnit = BoxedUnit.UNIT;
        }
        return index;
    }

    public String stripMoves(String s) {
        byte[] bytes = s.getBytes();
        byte[] res = (byte[])Array$.MODULE$.fill(bytes.length, (Function0)(JFunction0.mcB.sp & java.io.Serializable & Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        IntRef index = IntRef.create((int)0);
        IntRef lastEscapeIndex = IntRef.create((int)-1);
        IntRef state = IntRef.create((int)0);
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).foreach((Function1 & java.io.Serializable & Serializable)b -> {
            EscHelpers$.$anonfun$stripMoves$2(state, lastEscapeIndex, index, res, BoxesRunTime.unboxToByte((Object)b));
            return BoxedUnit.UNIT;
        });
        return new String(res, 0, index.elem);
    }

    public String stripColorsAndMoves(String s) {
        byte[] bytes = s.getBytes();
        byte[] res = (byte[])Array$.MODULE$.fill(bytes.length, (Function0)(JFunction0.mcB.sp & java.io.Serializable & Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        boolean i = false;
        IntRef index = IntRef.create((int)0);
        IntRef state = IntRef.create((int)0);
        IntRef limit = IntRef.create((int)0);
        ArrayBuffer digit = new ArrayBuffer();
        IntRef leftDigit = IntRef.create((int)-1);
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> EscHelpers$.$anonfun$stripColorsAndMoves$2(state, digit, index, leftDigit, limit, res, BoxesRunTime.unboxToByte((Object)x0$1)));
        return new String(res, 0, limit.elem);
    }

    private int skipESC(String s, int i) {
        int n;
        while (true) {
            if (i >= s.length()) {
                n = i;
                break;
            }
            if (this.isEscapeTerminator(s.charAt(i))) {
                n = i + 1;
                break;
            }
            ++i;
        }
        return n;
    }

    private static final void set$1(byte b, byte[] res$1, IntRef index$1) {
        res$1[index$1.elem] = b;
        ++index$1.elem;
    }

    public static final /* synthetic */ void $anonfun$stripMoves$2(IntRef state$1, IntRef lastEscapeIndex$1, IntRef index$1, byte[] res$1, byte b) {
        EscHelpers$.set$1(b, res$1, index$1);
        byte by = b;
        if (27 == by) {
            state$1.elem = EscHelpers$.MODULE$.esc;
            lastEscapeIndex$1.elem = package$.MODULE$.max(0, index$1.elem);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (by == 91 && state$1.elem == EscHelpers$.MODULE$.esc) {
            state$1.elem = EscHelpers$.MODULE$.csi;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (109 == by) {
            state$1.elem = 0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (state$1.elem == EscHelpers$.MODULE$.csi && (by < 48 || by >= 58) && by != 59) {
            state$1.elem = 0;
            index$1.elem = package$.MODULE$.max(0, lastEscapeIndex$1.elem - 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Object $anonfun$stripColorsAndMoves$2(IntRef state$2, ArrayBuffer digit$2, IntRef index$2, IntRef leftDigit$1, IntRef limit$1, byte[] res$2, byte x0$1) {
        BoxedUnit boxedUnit;
        byte by = x0$1;
        if (27 == by) {
            state$2.elem = EscHelpers$.MODULE$.esc;
            boxedUnit = BoxedUnit.UNIT;
        } else if ((state$2.elem == EscHelpers$.MODULE$.esc || state$2.elem == EscHelpers$.MODULE$.csi) && by >= 48 && by < 58) {
            state$2.elem = EscHelpers$.MODULE$.csi;
            boxedUnit = digit$2.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
        } else if (91 == by && state$2.elem == EscHelpers$.MODULE$.esc) {
            state$2.elem = EscHelpers$.MODULE$.csi;
            boxedUnit = BoxedUnit.UNIT;
        } else if (8 == by) {
            state$2.elem = 0;
            index$2.elem = package$.MODULE$.max(index$2.elem - 1, 0);
            boxedUnit = BoxedUnit.UNIT;
        } else if (state$2.elem == EscHelpers$.MODULE$.csi) {
            leftDigit$1.elem = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new String((byte[])digit$2.toArray(ClassTag$.MODULE$.Byte())))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
            state$2.elem = 0;
            char c = (char)by;
            switch (c) {
                case 'D': {
                    index$2.elem = package$.MODULE$.max(index$2.elem - leftDigit$1.elem, 0);
                    break;
                }
                case 'C': {
                    index$2.elem = package$.MODULE$.min(limit$1.elem, package$.MODULE$.min(index$2.elem + leftDigit$1.elem, res$2.length - 1));
                    break;
                }
                case 'J': 
                case 'K': {
                    if (leftDigit$1.elem > 0) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index$2.elem).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)x$1 -> {
                            res$2[x$1] = 32;
                        });
                        break;
                    }
                    res$2[index$2.elem] = 32;
                    break;
                }
                case 'm': {
                    break;
                }
                case ';': {
                    state$2.elem = EscHelpers$.MODULE$.csi;
                    break;
                }
                default: {
                    state$2.elem = EscHelpers$.MODULE$.csi;
                    break;
                }
            }
            digit$2.clear();
            boxedUnit = BoxedUnit.UNIT;
        } else if (state$2.elem == EscHelpers$.MODULE$.esc) {
            state$2.elem = 0;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            res$2[index$2.elem] = by;
            ++index$2.elem;
            limit$1.elem = package$.MODULE$.max(limit$1.elem, index$2.elem);
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private EscHelpers$() {
        MODULE$ = this;
        this.esc = 1;
        this.csi = 2;
    }
}

