/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.PrimitiveIterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.terminal.impl.jansi.JansiTerminalProvider;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.ClosedException;
import org.jline.utils.InfoCmp;
import org.jline.utils.NonBlockingReader;
import org.jline.utils.OSUtils;
import sbt.internal.util.JLine3$;
import sbt.internal.util.JLine3$$anon$1$;
import sbt.internal.util.Prompt;
import sbt.internal.util.Terminal;
import sbt.internal.util.Util$;
import sbt.internal.util.WindowsSupport$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Try$;

public final class JLine3$ {
    public static JLine3$ MODULE$;
    private final AtomicReference<Attributes> initialAttributes;
    private final AtomicBoolean forceWindowsJansiHolder;
    private final boolean jansi;
    private final int ENABLE_PROCESS_INPUT;
    private final Map<String, Attributes.InputFlag> iflagMap;
    private final Map<String, Attributes.OutputFlag> oflagMap;
    private final Map<String, Attributes.ControlFlag> cflagMap;
    private final Map<String, Attributes.LocalFlag> lflagMap;
    private final Map<String, Attributes.ControlChar> charMap;

    static {
        new JLine3$();
    }

    public AtomicReference<Attributes> initialAttributes() {
        return this.initialAttributes;
    }

    public void forceWindowsJansi() {
        this.forceWindowsJansiHolder.set(true);
    }

    private org.jline.terminal.Terminal windowsJansi() {
        JansiTerminalProvider provider = new JansiTerminalProvider();
        String termType = (String)package$.MODULE$.props().get("org.jline.terminal.type").orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"TERM")).orNull(Predef$.MODULE$.$conforms());
        return provider.winSysTerminal("console", termType, OSUtils.IS_CONEMU, Charset.forName("UTF-8"), false, Terminal.SignalHandler.SIG_DFL, true, SystemStream.Output);
    }

    private boolean jansi() {
        return this.jansi;
    }

    public org.jline.terminal.Terminal system() {
        org.jline.terminal.Terminal term;
        block0: {
            term = this.forceWindowsJansiHolder.get() ? this.windowsJansi() : TerminalBuilder.builder().system(System.console() != null).jna(Util$.MODULE$.isWindows() && !this.jansi()).jansi(this.jansi()).paused(true).build();
            Attributes attributes = this.initialAttributes().get();
            if (attributes != null) break block0;
            this.initialAttributes().set(term.getAttributes());
        }
        return term;
    }

    public org.jline.terminal.Terminal apply(Terminal term) {
        String string = System.getProperty("jline.terminal", "");
        String string2 = "none";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new DumbTerminal(term.inputStream(), term.outputStream());
        }
        return this.wrapTerminal(term);
    }

    public int decodeInput(CharsetDecoder decoder, InputStream inputStream) {
        byte[] bytes = new byte[4];
        int i = 0;
        int res = -2;
        block5: do {
            int n = inputStream.read();
            switch (n) {
                case -1: {
                    res = -1;
                    break;
                }
                default: {
                    bytes[i] = (byte)n;
                    ByteBuffer bb = ByteBuffer.wrap(bytes, 0, ++i);
                    try {
                        CharBuffer cb = decoder.decode(bb);
                        PrimitiveIterator.OfInt it = cb.codePoints().iterator();
                        if (!it.hasNext()) continue block5;
                        res = Predef$.MODULE$.Integer2int(it.next());
                    }
                    catch (CharacterCodingException characterCodingException) {}
                }
            }
        } while (i < 4 && res == -2);
        return res;
    }

    private org.jline.terminal.Terminal wrapTerminal(Terminal term) {
        return new AbstractTerminal(term){
            private final AtomicBoolean sbt$internal$util$JLine3$$anon$$closed;
            private final InputStream input;
            private final OutputStream output;
            private final NonBlockingReader reader;
            private final PrintWriter writer;
            public final Terminal term$1;

            public /* synthetic */ void protected$doClose(anon.1 x$1) {
                x$1.doClose();
            }

            public /* synthetic */ Charset protected$encoding(anon.1 x$1) {
                return x$1.encoding;
            }

            public AtomicBoolean sbt$internal$util$JLine3$$anon$$closed() {
                return this.sbt$internal$util$JLine3$$anon$$closed;
            }

            public TerminalProvider getProvider() {
                return null;
            }

            public SystemStream getSystemStream() {
                return null;
            }

            public InputStream input() {
                return this.input;
            }

            public OutputStream output() {
                return this.output;
            }

            public NonBlockingReader reader() {
                return this.reader;
            }

            public PrintWriter writer() {
                return this.writer;
            }

            public String getStringCapability(InfoCmp.Capability cap) {
                boolean bl = false;
                String string = null;
                String string2 = this.term$1.getStringCapability(cap.toString());
                if (string2 == null) {
                    bl = true;
                    string = string2;
                    InfoCmp.Capability capability = cap;
                    InfoCmp.Capability capability2 = InfoCmp.Capability.key_dc;
                    if (!(capability != null ? !capability.equals(capability2) : capability2 != null) && Util$.MODULE$.isWindows()) {
                        return "\\E[3~";
                    }
                }
                if (bl) {
                    InfoCmp.Capability capability = cap;
                    InfoCmp.Capability capability3 = InfoCmp.Capability.key_end;
                    if (!(capability != null ? !capability.equals(capability3) : capability3 != null) && Util$.MODULE$.isWindows()) {
                        return "\\E[4~";
                    }
                }
                if (bl) {
                    InfoCmp.Capability capability = cap;
                    InfoCmp.Capability capability4 = InfoCmp.Capability.key_ic;
                    if (!(capability != null ? !capability.equals(capability4) : capability4 != null) && Util$.MODULE$.isWindows()) {
                        return "\\E[2~";
                    }
                }
                return string2;
            }

            public Integer getNumericCapability(InfoCmp.Capability cap) {
                InfoCmp.Capability capability = cap;
                InfoCmp.Capability capability2 = InfoCmp.Capability.max_colors;
                if (!(capability != null ? !capability.equals(capability2) : capability2 != null) && !this.term$1.isColorEnabled()) {
                    return Predef$.MODULE$.int2Integer(1);
                }
                return this.term$1.getNumericCapability(cap.toString());
            }

            public boolean getBooleanCapability(InfoCmp.Capability cap) {
                return this.term$1.getBooleanCapability(cap.toString());
            }

            public Attributes getAttributes() {
                return JLine3$.MODULE$.attributesFromMap(this.term$1.getAttributes());
            }

            public Size getSize() {
                return new Size(this.term$1.getWidth(), this.term$1.getHeight());
            }

            public void setAttributes(Attributes a) {
            }

            public void setSize(Size size) {
                this.term$1.setSize(size.getColumns(), size.getRows());
            }

            public Attributes enterRawMode() {
                return JLine3$.MODULE$.attributesFromMap(this.term$1.getAttributes());
            }
            {
                this.term$1 = term$1;
                super(term$1.name(), "nocapabilities", Charset.forName("UTF-8"), Terminal.SignalHandler.SIG_DFL);
                this.sbt$internal$util$JLine3$$anon$$closed = new AtomicBoolean(false);
                this.setOnClose(() -> {
                    this.protected$doClose(this);
                    this.reader().close();
                    if (this.sbt$internal$util$JLine3$$anon$$closed().compareAndSet(false, true)) {
                        InputStream inputStream = term$1.inputStream();
                        if (inputStream instanceof Terminal.WriteableInputStream) {
                            Terminal.WriteableInputStream writeableInputStream = (Terminal.WriteableInputStream)inputStream;
                            writeableInputStream.cancel();
                            return;
                        }
                        return;
                    }
                });
                this.input = new InputStream(this){
                    private final /* synthetic */ anon.1 $outer;

                    public int read() {
                        int res;
                        int n;
                        InputStream inputStream = this.$outer.term$1.inputStream();
                        if (inputStream instanceof Terminal.WriteableInputStream) {
                            Terminal.WriteableInputStream writeableInputStream = (Terminal.WriteableInputStream)inputStream;
                            LinkedBlockingQueue<Integer> result = new LinkedBlockingQueue<Integer>();
                            try {
                                writeableInputStream.read(result);
                                Integer n2 = result.poll();
                                if (n2 == null) {
                                    throw new ClosedException();
                                }
                                n = Predef$.MODULE$.Integer2int(n2);
                            }
                            catch (InterruptedException interruptedException) {
                                writeableInputStream.cancel();
                                throw new ClosedException();
                            }
                        } else {
                            throw new ClosedException();
                        }
                        int n3 = res = n;
                        switch (n3) {
                            case 3: {
                                throw new ClosedException();
                            }
                        }
                        return n3;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                this.output = new OutputStream(this){
                    private final /* synthetic */ anon.1 $outer;

                    public void write(int b) {
                        this.write((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)b}), ClassTag$.MODULE$.Byte()));
                    }

                    public void write(byte[] b) {
                        if (!this.$outer.sbt$internal$util$JLine3$$anon$$closed().get()) {
                            this.$outer.term$1.withPrintStream((Function1 & Serializable & scala.Serializable)ps -> {
                                anon$1$$anon$3.$anonfun$write$1(this, b, ps);
                                return BoxedUnit.UNIT;
                            });
                            return;
                        }
                    }

                    public void write(byte[] b, int offset, int len) {
                        this.write(Arrays.copyOfRange(b, offset, offset + len));
                    }

                    public void flush() {
                        this.$outer.term$1.withPrintStream((Function1 & Serializable & scala.Serializable)x$2 -> {
                            anon$1$$anon$3.$anonfun$flush$1(x$2);
                            return BoxedUnit.UNIT;
                        });
                    }

                    public static final /* synthetic */ void $anonfun$write$1(anon$1$$anon$3 $this, byte[] b$1, PrintStream ps) {
                        ps.write(b$1);
                        Prompt prompt = $this.$outer.term$1.prompt();
                        if (prompt instanceof Prompt.AskUser) {
                            Prompt.AskUser askUser = (Prompt.AskUser)prompt;
                            askUser.write(b$1);
                            return;
                        }
                    }

                    public static final /* synthetic */ void $anonfun$flush$1(PrintStream x$2) {
                        x$2.flush();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$write$1$adapted(sbt.internal.util.JLine3$$anon$1$$anon$3 byte[] java.io.PrintStream ), $anonfun$flush$1$adapted(java.io.PrintStream )}, serializedLambda);
                    }
                };
                this.reader = new NonBlockingReader(this){
                    private final LinkedBlockingQueue<Integer> buffer;
                    private final AtomicReference<Thread> thread;
                    private final /* synthetic */ anon.1 $outer;

                    public LinkedBlockingQueue<Integer> buffer() {
                        return this.buffer;
                    }

                    public AtomicReference<Thread> thread() {
                        return this.thread;
                    }

                    private void fillBuffer() {
                        AtomicReference<Thread> atomicReference = this.thread();
                        synchronized (atomicReference) {
                            this.thread().set(Thread.currentThread());
                            this.liftedTree1$1();
                        }
                    }

                    public void close() {
                        Thread thread = this.thread().get();
                        if (thread == null) {
                            return;
                        }
                        thread.interrupt();
                    }

                    public int read(long timeout, boolean peek) {
                        Integer n;
                        if (this.buffer().isEmpty() && !peek) {
                            this.fillBuffer();
                        }
                        Integer n2 = n = peek ? this.buffer().peek() : this.buffer().take();
                        if (n == null) {
                            return -2;
                        }
                        if (BoxesRunTime.equalsNumObject((Number)n, (Object)BoxesRunTime.boxToInteger((int)-3))) {
                            throw new InterruptedException();
                        }
                        return Predef$.MODULE$.Integer2int(n);
                    }

                    public int peek(long timeout) {
                        Integer n = this.buffer().peek();
                        if (n == null) {
                            return -1;
                        }
                        return Predef$.MODULE$.Integer2int(n);
                    }

                    public int readBuffered(char[] buf, int off, int len, long timeout) {
                        Integer n;
                        if (this.buffer().isEmpty()) {
                            this.fillBuffer();
                        }
                        if (BoxesRunTime.equalsNumObject((Number)(n = this.buffer().take()), (Object)BoxesRunTime.boxToInteger((int)-1))) {
                            return -1;
                        }
                        buf[0] = (char)Predef$.MODULE$.Integer2int(n);
                        return 1;
                    }

                    private final /* synthetic */ void liftedTree1$1() {
                        try {
                            this.buffer().put(Predef$.MODULE$.int2Integer(JLine3$.MODULE$.decodeInput(this.$outer.protected$encoding(this.$outer).newDecoder(), this.$outer.term$1.inputStream())));
                        }
                        catch (InterruptedException interruptedException) {
                            this.buffer().put(Predef$.MODULE$.int2Integer(-3));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.buffer = new LinkedBlockingQueue<E>();
                        this.thread = new AtomicReference<V>();
                    }
                };
                this.writer = new PrintWriter(this.output(), true);
            }
        };
    }

    private Attributes enterRawModeImpl(org.jline.terminal.Terminal term) {
        Attributes prvAttr = term.getAttributes();
        Attributes newAttr = new Attributes(prvAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        term.setAttributes(newAttr);
        return prvAttr;
    }

    public void setEnableProcessInput() {
        if (Util$.MODULE$.isWindows()) {
            WindowsSupport$.MODULE$.setConsoleMode(WindowsSupport$.MODULE$.getConsoleMode() | this.ENABLE_PROCESS_INPUT);
            return;
        }
    }

    public void enterRawMode(org.jline.terminal.Terminal term) {
        Attributes prevAttr = this.initialAttributes().get();
        Attributes newAttr = new Attributes(prevAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.IEXTEN, Attributes.LocalFlag.ECHO), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        term.setAttributes(newAttr);
        this.setEnableProcessInput();
    }

    public void exitRawMode(org.jline.terminal.Terminal term) {
        Attributes initAttr = this.initialAttributes().get();
        Attributes newAttr = new Attributes(initAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO), true);
        term.setAttributes(newAttr);
        this.setEnableProcessInput();
    }

    public Map<String, String> toMap(Attributes jattributes) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("iflag", ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jattributes.getInputFlags().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name().toLowerCase()).mkString(" "));
        result.put("oflag", ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jattributes.getOutputFlags().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name().toLowerCase()).mkString(" "));
        result.put("cflag", ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jattributes.getControlFlags().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name().toLowerCase()).mkString(" "));
        result.put("lflag", ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jattributes.getLocalFlags().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name().toLowerCase()).mkString(" "));
        result.put("cchars", ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jattributes.getControlChars().entrySet().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(1).append(((Enum)e.getKey()).name().toLowerCase()).append(",").append(e.getValue()).toString()).mkString(" "));
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public void setMode(Terminal term, boolean canonical, boolean echo) {
        Attributes prev = this.attributesFromMap(term.getAttributes());
        Attributes newAttrs = new Attributes(prev);
        newAttrs.setLocalFlag(Attributes.LocalFlag.ICANON, canonical);
        newAttrs.setLocalFlag(Attributes.LocalFlag.ECHO, echo);
        term.setAttributes(this.toMap(newAttrs));
    }

    public Attributes attributesFromMap(Map<String, String> map) {
        Attributes attributes = new Attributes();
        map.get((Object)"iflag").foreach((Function1 & Serializable & scala.Serializable)flags -> {
            JLine3$.$anonfun$attributesFromMap$1(attributes, flags);
            return BoxedUnit.UNIT;
        });
        map.get((Object)"oflag").foreach((Function1 & Serializable & scala.Serializable)flags -> {
            JLine3$.$anonfun$attributesFromMap$4(attributes, flags);
            return BoxedUnit.UNIT;
        });
        map.get((Object)"cflag").foreach((Function1 & Serializable & scala.Serializable)flags -> {
            JLine3$.$anonfun$attributesFromMap$7(attributes, flags);
            return BoxedUnit.UNIT;
        });
        map.get((Object)"lflag").foreach((Function1 & Serializable & scala.Serializable)flags -> {
            JLine3$.$anonfun$attributesFromMap$10(attributes, flags);
            return BoxedUnit.UNIT;
        });
        map.get((Object)"cchars").foreach((Function1 & Serializable & scala.Serializable)chars -> {
            JLine3$.$anonfun$attributesFromMap$13(attributes, chars);
            return BoxedUnit.UNIT;
        });
        return attributes;
    }

    public boolean isEchoEnabled(Map<String, String> map) {
        return this.attributesFromMap(map).getLocalFlag(Attributes.LocalFlag.ECHO);
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$2(Attributes attributes$1, String f) {
        JLine3$.MODULE$.iflagMap.get((Object)f).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            attributes$1.setInputFlag(x$7, true);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$1(Attributes attributes$1, String flags) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flags.split(" "))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            JLine3$.$anonfun$attributesFromMap$2(attributes$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$5(Attributes attributes$1, String f) {
        JLine3$.MODULE$.oflagMap.get((Object)f).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            attributes$1.setOutputFlag(x$8, true);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$4(Attributes attributes$1, String flags) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flags.split(" "))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            JLine3$.$anonfun$attributesFromMap$5(attributes$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$8(Attributes attributes$1, String f) {
        JLine3$.MODULE$.cflagMap.get((Object)f).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            attributes$1.setControlFlag(x$9, true);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$7(Attributes attributes$1, String flags) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flags.split(" "))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            JLine3$.$anonfun$attributesFromMap$8(attributes$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$11(Attributes attributes$1, String f) {
        JLine3$.MODULE$.lflagMap.get((Object)f).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            attributes$1.setLocalFlag(x$10, true);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$10(Attributes attributes$1, String flags) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flags.split(" "))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            JLine3$.$anonfun$attributesFromMap$11(attributes$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$14(Attributes attributes$1, String keyValue) {
        String[] stringArray = keyValue.split(",");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            String k = (String)((SeqLike)option.get()).apply(0);
            String v = (String)((SeqLike)option.get()).apply(1);
            Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(v)).toInt()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> JLine3$.MODULE$.charMap.get((Object)k).foreach((Function1 & Serializable & scala.Serializable)c -> {
                attributes$1.setControlChar(c, i);
                return BoxedUnit.UNIT;
            }));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$attributesFromMap$13(Attributes attributes$1, String chars) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chars.split(" "))).foreach((Function1 & Serializable & scala.Serializable)keyValue -> {
            JLine3$.$anonfun$attributesFromMap$14(attributes$1, keyValue);
            return BoxedUnit.UNIT;
        });
    }

    private JLine3$() {
        MODULE$ = this;
        this.initialAttributes = new AtomicReference();
        this.forceWindowsJansiHolder = new AtomicBoolean(false);
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(JansiTerminalProvider.getJansiMajorVersion(), JansiTerminalProvider.getJansiMinorVersion());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int major = sp2._1$mcI$sp();
        int minor = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(major, minor);
        int major2 = sp3._1$mcI$sp();
        int minor2 = sp3._2$mcI$sp();
        this.jansi = (major2 > 1 || minor2 >= 18) && Util$.MODULE$.isWindows();
        this.ENABLE_PROCESS_INPUT = 1;
        this.iflagMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Attributes.InputFlag.values())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name().toLowerCase()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.oflagMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Attributes.OutputFlag.values())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name().toLowerCase()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.cflagMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Attributes.ControlFlag.values())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name().toLowerCase()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.lflagMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Attributes.LocalFlag.values())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name().toLowerCase()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.charMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Attributes.ControlChar.values())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name().toLowerCase()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }
}

