/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.scripted;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.scripted.BasicStatementHandler;
import sbt.io.IO$;
import sbt.io.Path$;
import sbt.io.PathFinder;
import sbt.io.syntax$;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.PathFilter;
import sbt.nio.file.PathFilter$;
import sbt.nio.file.RecursiveGlob$;
import sbt.nio.file.RelativeGlob;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.sys.process.Process$;

public class FileCommands
implements BasicStatementHandler {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(FileCommands.class.getDeclaredField("commands$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileCommands.class.getDeclaredField("view$lzy1"));
    private final File baseDirectory;
    private volatile Object view$lzy1;
    private final Glob baseGlob;
    private volatile Object commands$lzy1;

    public FileCommands(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.baseGlob = Glob$.MODULE$.apply(baseDirectory);
    }

    public final String OR() {
        return "||";
    }

    public FileTreeView view() {
        Object object = this.view$lzy1;
        if (object instanceof FileTreeView) {
            return (FileTreeView)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FileTreeView)this.view$lzyINIT1();
    }

    private Object view$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.view$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FileTreeView fileTreeView = null;
                    try {
                        fileTreeView = FileTreeView$.MODULE$.Ops(FileTreeView$.MODULE$.default());
                        object2 = fileTreeView == null ? LazyVals.NullValue$.MODULE$ : fileTreeView;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.view$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fileTreeView;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Glob baseGlob() {
        return this.baseGlob;
    }

    public Map<String, Function1<List<String>, BoxedUnit>> commands() {
        Object object = this.commands$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.commands$lzyINIT1();
    }

    private Object commands$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.commands$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Map<String, Function1<List<String>, BoxedUnit>> map = null;
                    Map<String, Function1<List<String>, BoxedUnit>> map2 = null;
                    try {
                        map2 = this.commandMap();
                        map = map2 == null ? LazyVals.NullValue$.MODULE$ : map2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, map)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.commands$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, map);
                            waiting.countDown();
                        }
                    }
                    return map2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Map<String, Function1<List<String>, BoxedUnit>> commandMap() {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.nonEmpty("touch", (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)paths -> this.touch((List<String>)paths)), this.nonEmpty("delete", (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)paths -> this.delete((List<String>)paths)), this.nonEmpty("exists", (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)paths -> this.exists((List<String>)paths)), this.nonEmpty("mkdir", (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)paths -> this.makeDirectories((List<String>)paths)), this.nonEmpty("absent", (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)paths -> this.absent((List<String>)paths)), this.twoArg("newer", "Two paths", (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(a, b) -> this.newer((String)a, (String)b)), this.noArg("pause", (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.commandMap$$anonfun$7();
            return BoxedUnit.UNIT;
        }), this.oneArg("sleep", "Time in milliseconds", (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)time -> Thread.sleep(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(time)))), this.nonEmpty("exec", (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)command -> this.execute((List<String>)command)), this.copy("copy", (Function1<File, Function1<File, Option<File>>>)(Function1 & Serializable)to -> Path$.MODULE$.rebase(this.baseDirectory, to)), this.twoArg("copy-file", "Two paths", (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(from, to) -> this.copyFile((String)from, (String)to)), this.twoArg("must-mirror", "Two paths", (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(file1, file2) -> this.diffFiles((String)file1, (String)file2)), this.copy("copy-flat", (Function1<File, Function1<File, Option<File>>>)(Function1 & Serializable)newDirectory -> Path$.MODULE$.flat(newDirectory))}));
    }

    @Override
    public void apply(String command, List<String> arguments) {
        Option option = this.commands().get((Object)command).map((Function1)(JProcedure1 & Serializable)_$1 -> _$1.apply((Object)arguments));
        if (option instanceof Some) {
            return;
        }
        this.scriptError(new StringBuilder(16).append("Unknown command ").append(command).toString());
    }

    public void scriptError(String message) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(19).append("Test script error: ").append(message).toString());
    }

    public <T> String spaced(scala.collection.immutable.Seq<T> l) {
        return l.mkString(" ");
    }

    public List<File> fromStrings(List<String> paths) {
        return paths.map((Function1 & Serializable)path -> this.fromString((String)path));
    }

    public File fromString(String path) {
        return new File(this.baseDirectory, path);
    }

    public List<PathFilter> filterFromStrings(List<String> exprs) {
        if (exprs.contains((Object)"||")) {
            return this.orGlobs$1(exprs);
        }
        return this.globs$1(exprs);
    }

    public void touch(List<String> paths) {
        IO$.MODULE$.touch(this.fromStrings(paths));
    }

    public void delete(List<String> paths) {
        IO$.MODULE$.delete((Iterable)this.filterFromStrings(paths).flatMap((Function1 & Serializable)filter -> FileTreeView.Ops$.MODULE$.list$extension(this.view(), Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(this.baseGlob()), (RelativeGlob)RecursiveGlob$.MODULE$), filter)).map((Function1 & Serializable)_$4 -> ((Path)_$4._1()).toFile()));
    }

    public void copyFile(String from, String to) {
        IO$.MODULE$.copyFile(this.fromString(from), this.fromString(to));
    }

    public void makeDirectories(List<String> paths) {
        IO$.MODULE$.createDirectories(this.fromStrings(paths));
    }

    public void diffFiles(String file1, String file2) {
        List lines1 = IO$.MODULE$.readLines(this.fromString(file1), IO$.MODULE$.readLines$default$2());
        List lines2 = IO$.MODULE$.readLines(this.fromString(file2), IO$.MODULE$.readLines$default$2());
        List list = lines1;
        List list2 = lines2;
        if (list == null ? list2 != null : !list.equals(list2)) {
            this.scriptError(new StringBuilder(35).append("File contents are different:\n").append(lines1.mkString("\n")).append("\nAnd:\n").append(lines2.mkString("\n")).toString());
            return;
        }
    }

    public void newer(String a, String b) {
        boolean isNewer;
        File pathA = this.fromString(a);
        File pathB = this.fromString(b);
        boolean bl = isNewer = pathA.exists() && (!pathB.exists() || IO$.MODULE$.getModifiedTimeOrZero(pathA) > IO$.MODULE$.getModifiedTimeOrZero(pathB));
        if (!isNewer) {
            this.scriptError(new StringBuilder(19).append(pathA).append(" is not newer than ").append(pathB).toString());
            return;
        }
    }

    public boolean exists0(PathFilter filter) {
        return FileTreeView.Ops$.MODULE$.list$extension(this.view(), Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(this.baseGlob()), (RelativeGlob)RecursiveGlob$.MODULE$), filter).nonEmpty();
    }

    public void exists(List<String> paths) {
        List notPresent = this.filterFromStrings(paths).filter((Function1 & Serializable)_$5 -> !this.exists0((PathFilter)_$5));
        if (notPresent.nonEmpty()) {
            this.scriptError(new StringBuilder(23).append("File(s) did not exist: ").append(notPresent.mkString("[ ", " , ", " ]")).toString());
            return;
        }
    }

    public void absent(List<String> paths) {
        List present = this.filterFromStrings(paths).filter((Function1 & Serializable)filter -> this.exists0((PathFilter)filter));
        if (present.nonEmpty()) {
            this.scriptError(new StringBuilder(17).append("File(s) existed: ").append(present.mkString("[ ", " , ", " ]")).toString());
            return;
        }
    }

    public void execute(List<String> command) {
        this.execute0((String)command.head(), (List<String>)((List)command.tail()));
    }

    public void execute0(String command, List<String> args) {
        if (command.trim().isEmpty()) {
            this.scriptError("Command was empty.");
            return;
        }
        int exitValue = Process$.MODULE$.apply((Seq)args.$colon$colon((Object)command), this.baseDirectory, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        if (exitValue != 0) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(21).append("Nonzero exit value (").append(exitValue).append(")").toString());
        }
    }

    public Tuple2<String, Function1<List<String>, BoxedUnit>> nonEmpty(String commandName, Function1<List<String>, BoxedUnit> action) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)commandName);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)paths -> {
            if (paths.isEmpty()) {
                this.scriptError(new StringBuilder(36).append("No arguments specified for ").append(commandName).append(" command.").toString());
                return;
            }
            action.apply(paths);
        });
    }

    public Tuple2<String, Function1<List<String>, BoxedUnit>> twoArg(String commandName, String requiredArgs, Function2<String, String, BoxedUnit> action) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)commandName);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)x$1 -> {
            SeqOps seqOps;
            List list = x$1;
            if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 2) == 0) {
                String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                String string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                String from = string;
                String to = string2;
                action.apply((Object)from, (Object)to);
                return;
            }
            List other = list;
            this.wrongArguments(commandName, requiredArgs, (List<String>)other);
        });
    }

    public Tuple2<String, Function1<List<String>, BoxedUnit>> noArg(String commandName, Function0<BoxedUnit> action) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)commandName);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)x$1 -> {
            List list = x$1;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                action.apply$mcV$sp();
                return;
            }
            List other = list;
            this.wrongArguments(commandName, (List<String>)other);
        });
    }

    public Tuple2<String, Function1<List<String>, BoxedUnit>> oneArg(String commandName, String requiredArgs, Function1<String, BoxedUnit> action) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)commandName);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)x$1 -> {
            SeqOps seqOps;
            List list = x$1;
            if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
                String string;
                String single = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                action.apply((Object)single);
                return;
            }
            List other = list;
            this.wrongArguments(commandName, requiredArgs, (List<String>)other);
        });
    }

    public Tuple2<String, Function1<List<String>, BoxedUnit>> copy(String commandName, Function1<File, Function1<File, Option<File>>> mapper) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)commandName);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)x$1 -> {
            List list = x$1;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                this.scriptError(new StringBuilder(32).append("No paths specified for ").append(commandName).append(" command.").toString());
                return;
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next();
                String path = (String)colon2.head();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                    this.scriptError(new StringBuilder(38).append("No destination specified for ").append(commandName).append(" command.").toString());
                    return;
                }
            }
            List paths = list;
            List<File> mapped = this.fromStrings((List<String>)paths);
            Function1 map = (Function1)mapper.apply(mapped.last());
            PathFinder pathFinder = syntax$.MODULE$.filesToFinder((Iterable)mapped.init());
            IO$.MODULE$.copy((Iterable)pathFinder.pair(map, pathFinder.pair$default$2()));
        });
    }

    public void wrongArguments(String commandName, List<String> args) {
        this.scriptError(new StringBuilder(48).append("Command '").append(commandName).append("' does not accept arguments (found '").append(this.spaced((scala.collection.immutable.Seq)args)).append("').").toString());
    }

    public void wrongArguments(String commandName, String requiredArgs, List<String> args) {
        this.scriptError(new StringBuilder(61).append("Wrong number of arguments to ").append(commandName).append(" command.  ").append(requiredArgs).append(" required, found: '").append(this.spaced((scala.collection.immutable.Seq)args)).append("'.").toString());
    }

    private final void commandMap$$anonfun$7() {
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("Pausing in ").append(this.baseDirectory).toString());
        Predef$.MODULE$.print((Object)"Press enter to continue. ");
        System.console().readLine();
        Predef$.MODULE$.println();
    }

    private final List globs$1(List exprs) {
        return exprs.map((Function1 & Serializable)g -> {
            if (g.startsWith("/")) {
                return PathFilter$.MODULE$.globToPathFilter(Glob$.MODULE$.apply(g));
            }
            return PathFilter$.MODULE$.globToPathFilter(Glob$.MODULE$.apply(this.baseDirectory, g));
        });
    }

    private final List orGlobs$1(List exprs$1) {
        PathFilter pathFilter;
        Object object = Predef$.MODULE$.refArrayOps((Object[])exprs$1.mkString("").split("||"));
        List exprs1 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$2 -> {
            String string = _$2;
            String string2 = "||";
            return string == null ? string2 != null : !string.equals(string2);
        })).toList().map((Function1 & Serializable)_$3 -> _$3.trim());
        List list = this.globs$1(exprs1);
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            throw scala.sys.package$.MODULE$.error("unexpected Nil");
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            PathFilter pathFilter2 = (PathFilter)colon2.head();
            List list3 = colon2.next();
            PathFilter g2 = pathFilter2;
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                pathFilter = g2;
            } else {
                PathFilter g3 = pathFilter2;
                List gs = list3;
                pathFilter = (PathFilter)gs.foldLeft((Object)g3, (Function2 & Serializable)(acc, g) -> PathFilter.Ops$.MODULE$.$bar$bar$extension(PathFilter$.MODULE$.Ops(acc), g));
            }
        } else {
            throw new MatchError((Object)list);
        }
        PathFilter combined = pathFilter;
        return (List)new .colon.colon((Object)combined, (List)Nil$.MODULE$);
    }
}

