/*
 * Decompiled with CFR 0.152.
 */
package sbt.util;

import java.io.File;
import sbt.internal.util.EmptyCacheError;
import sbt.util.CacheImplicits$;
import sbt.util.CacheStore;
import sbt.util.Difference;
import sbt.util.FileInfo;
import sbt.util.SingletonCache;
import sbt.util.Timestamp;
import sbt.util.Tracked$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sjsonnew.JsonFormat;
import sjsonnew.JsonWriter;
import sjsonnew.support.murmurhash.Hasher$;

public interface Tracked {
    public static Difference diffInputs(CacheStore cacheStore, FileInfo.Style style) {
        return Tracked$.MODULE$.diffInputs(cacheStore, style);
    }

    public static Difference diffInputs(File file, FileInfo.Style style) {
        return Tracked$.MODULE$.diffInputs(file, style);
    }

    public static Difference diffOutputs(CacheStore cacheStore, FileInfo.Style style) {
        return Tracked$.MODULE$.diffOutputs(cacheStore, style);
    }

    public static Difference diffOutputs(File file, FileInfo.Style style) {
        return Tracked$.MODULE$.diffOutputs(file, style);
    }

    public static <I, O> Function1<I, O> inputChanged(CacheStore cacheStore, Function2<Object, I, O> function2, JsonFormat<I> jsonFormat, SingletonCache<I> singletonCache) {
        return Tracked$.MODULE$.inputChanged(cacheStore, function2, jsonFormat, singletonCache);
    }

    public static <I, O> Function1<I, O> inputChanged(File file, Function2<Object, I, O> function2, JsonFormat<I> jsonFormat, SingletonCache<I> singletonCache) {
        return Tracked$.MODULE$.inputChanged(file, function2, jsonFormat, singletonCache);
    }

    public static <I, O> Function1<I, O> inputChangedW(CacheStore cacheStore, Function2<Object, I, O> function2, JsonWriter<I> jsonWriter) {
        return Tracked$.MODULE$.inputChangedW(cacheStore, function2, jsonWriter);
    }

    public static <I, O> Function1<I, O> inputChangedW(File file, Function2<Object, I, O> function2, JsonWriter<I> jsonWriter) {
        return Tracked$.MODULE$.inputChangedW(file, function2, jsonWriter);
    }

    public static boolean isStrictMode() {
        return Tracked$.MODULE$.isStrictMode();
    }

    public static <I, O> Function1<I, O> lastOutput(CacheStore cacheStore, Function2<I, Option<O>, O> function2, JsonFormat<O> jsonFormat) {
        return Tracked$.MODULE$.lastOutput(cacheStore, function2, jsonFormat);
    }

    public static <I, O> Function1<I, O> lastOutput(File file, Function2<I, Option<O>, O> function2, JsonFormat<O> jsonFormat) {
        return Tracked$.MODULE$.lastOutput(file, function2, jsonFormat);
    }

    public static <A1, A2> Function1<Function0<A1>, A2> outputChanged(CacheStore cacheStore, Function2<Object, A1, A2> function2, JsonFormat<A1> jsonFormat) {
        return Tracked$.MODULE$.outputChanged(cacheStore, function2, jsonFormat);
    }

    public static <A1, A2> Function1<Function0<A1>, A2> outputChanged(File file, Function2<Object, A1, A2> function2, JsonFormat<A1> jsonFormat) {
        return Tracked$.MODULE$.outputChanged(file, function2, jsonFormat);
    }

    public static <A1, A2> Function1<Function0<A1>, A2> outputChangedW(CacheStore cacheStore, Function2<Object, A1, A2> function2, JsonWriter<A1> jsonWriter) {
        return Tracked$.MODULE$.outputChangedW(cacheStore, function2, jsonWriter);
    }

    public static <A1, A2> Function1<Function0<A1>, A2> outputChangedW(File file, Function2<Object, A1, A2> function2, JsonWriter<A1> jsonWriter) {
        return Tracked$.MODULE$.outputChangedW(file, function2, jsonWriter);
    }

    public static Timestamp tstamp(CacheStore cacheStore) {
        return Tracked$.MODULE$.tstamp(cacheStore);
    }

    public static Timestamp tstamp(CacheStore cacheStore, boolean bl) {
        return Tracked$.MODULE$.tstamp(cacheStore, bl);
    }

    public static Timestamp tstamp(File file) {
        return Tracked$.MODULE$.tstamp(file);
    }

    public static Timestamp tstamp(File file, boolean bl) {
        return Tracked$.MODULE$.tstamp(file, bl);
    }

    public void clean();

    public static final class CacheHelp<I> {
        private final SingletonCache<Object> sc;
        private final JsonWriter<I> evidence$1;

        public CacheHelp(SingletonCache<Object> sc, JsonWriter<I> evidence$1) {
            this.sc = sc;
            this.evidence$1 = evidence$1;
        }

        public SingletonCache<Object> sc() {
            return this.sc;
        }

        public void save(CacheStore store, I value) {
            Try try_ = Hasher$.MODULE$.hash(value, CacheImplicits$.MODULE$.implicitHashWriter(this.evidence$1));
            if (try_ instanceof Success) {
                int keyHash = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
                store.write((Object)BoxesRunTime.boxToLong((long)keyHash), (JsonWriter)CacheImplicits$.MODULE$.LongJsonFormat());
                return;
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                if (Tracked$.MODULE$.isStrictMode()) {
                    throw e;
                }
                return;
            }
            throw new MatchError((Object)try_);
        }

        public boolean changed(CacheStore store, I value) {
            Try try_ = Try$.MODULE$.apply(() -> Tracked$.sbt$util$Tracked$CacheHelp$$_$changed$$anonfun$1(store));
            if (try_ instanceof Success) {
                long l = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                if (true) {
                    long prev = l;
                    Try try_2 = Hasher$.MODULE$.hash(value, CacheImplicits$.MODULE$.implicitHashWriter(this.evidence$1));
                    if (try_2 instanceof Success) {
                        int n = BoxesRunTime.unboxToInt((Object)((Success)try_2).value());
                        if (true) {
                            int keyHash = n;
                            return (long)keyHash != prev;
                        }
                    }
                    if (try_2 instanceof Failure) {
                        Throwable e = ((Failure)try_2).exception();
                        if (Tracked$.MODULE$.isStrictMode()) {
                            throw e;
                        }
                        return true;
                    }
                    throw new MatchError((Object)try_2);
                }
            }
            if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (throwable instanceof EmptyCacheError) {
                    return true;
                }
                Throwable e = throwable;
                if (Tracked$.MODULE$.isStrictMode()) {
                    throw e;
                }
                return true;
            }
            throw new MatchError((Object)try_);
        }
    }
}

