/*
 * Decompiled with CFR 0.152.
 */
package xsbt.api;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.MurmurHash3$;
import xsbt.api.HashAPI;
import xsbt.api.HashAPI$;
import xsbt.api.SameAPI$;
import xsbti.api.Access;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.AnnotationArgument;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.Definition;
import xsbti.api.DefinitionType;
import xsbti.api.EmptyType;
import xsbti.api.Existential;
import xsbti.api.FieldLike;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.MethodParameter;
import xsbti.api.Modifiers;
import xsbti.api.Package;
import xsbti.api.ParameterList;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.ParameterizedDefinition;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualified;
import xsbti.api.Qualifier;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.This;
import xsbti.api.ThisQualifier;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Unqualified;
import xsbti.api.Val;
import xsbti.api.Var;

public final class HashAPI {
    private final boolean includePrivate;
    private final boolean includeDefinitions;
    private final boolean includeSealedChildren;
    private final boolean includeTraitBreakers;
    private final HashMap<Structure, List<Object>> visitedStructures;
    private final HashMap<ClassLike, List<Object>> visitedClassLike;
    private final int ClassHash;
    public int xsbt$api$HashAPI$$hash;
    private final Function1<Structure, BoxedUnit> hashStructure0WithDefsTrait;
    private final Function1<Structure, BoxedUnit> hashStructure0WithDefs;
    private final Function1<Structure, BoxedUnit> hashStructure0NoDefs;

    public static int apply(ClassLike classLike) {
        return HashAPI$.MODULE$.apply(classLike);
    }

    public static int apply(Def def) {
        return HashAPI$.MODULE$.apply(def);
    }

    public static int apply(Function1<HashAPI, BoxedUnit> function1, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return HashAPI$.MODULE$.apply(function1, bl, bl2, bl3, bl4, bl5);
    }

    public static boolean apply$default$2() {
        return HashAPI$.MODULE$.apply$default$2();
    }

    public static boolean apply$default$3() {
        return HashAPI$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$4() {
        return HashAPI$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$5() {
        return HashAPI$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$6() {
        return HashAPI$.MODULE$.apply$default$6();
    }

    public HashAPI(boolean includePrivate, boolean includeParamNames, boolean includeDefinitions, boolean includeSealedChildren, boolean includeTraitBreakers) {
        this.includePrivate = includePrivate;
        this.includeDefinitions = includeDefinitions;
        this.includeSealedChildren = includeSealedChildren;
        this.includeTraitBreakers = includeTraitBreakers;
        this.visitedStructures = this.visitedMap();
        this.visitedClassLike = this.visitedMap();
        boolean ValHash = true;
        int VarHash = 2;
        int DefHash = 3;
        int ClassDefHash = 4;
        int TypeDeclHash = 5;
        int TypeAliasHash = 6;
        int PublicHash = 30;
        int ProtectedHash = 31;
        int PrivateHash = 32;
        int UnqualifiedHash = 33;
        int ThisQualifierHash = 34;
        int IdQualifierHash = 35;
        int IdPathHash = 20;
        int SuperHash = 21;
        int ThisPathHash = 22;
        int ValueParamsHash = 40;
        int ClassPendingHash = 41;
        int StructurePendingHash = 42;
        int EmptyTypeHash = 51;
        int ParameterRefHash = 52;
        int SingletonHash = 53;
        int ProjectionHash = 54;
        int ParameterizedHash = 55;
        int AnnotatedHash = 56;
        int PolymorphicHash = 57;
        int ConstantHash = 58;
        int ExistentialHash = 59;
        int StructureHash = 60;
        this.ClassHash = 70;
        int TrueHash = 97;
        int FalseHash = 98;
        this.xsbt$api$HashAPI$$hash = 0;
        this.hashStructure0WithDefsTrait = (JProcedure1 & Serializable)s -> this.hashStructure0((Structure)s, true, true);
        this.hashStructure0WithDefs = (JProcedure1 & Serializable)s -> this.hashStructure0((Structure)s, true, false);
        this.hashStructure0NoDefs = (JProcedure1 & Serializable)s -> this.hashStructure0((Structure)s, false, false);
    }

    public HashAPI(boolean includePrivate, boolean includeParamNames) {
        this(includePrivate, includeParamNames, true, true, false);
    }

    private <T> HashMap<T, List<Object>> visitedMap() {
        return new HashMap();
    }

    private <T> void visit(Map<T, List<Object>> map, T t, Function1<T, BoxedUnit> hashF) {
        List list;
        int n = this.xsbt$api$HashAPI$$hash;
        Option option = map.put(t, (Object)((List)map.getOrElse(t, HashAPI::visit$$anonfun$1)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)));
        if (option instanceof Some && (list = (List)((Some)option).value()) instanceof .colon.colon) {
            List list2 = ((.colon.colon)list).next();
            int x = BoxesRunTime.unboxToInt((Object)((.colon.colon)list).head());
            this.extend(x);
            return;
        }
        hashF.apply(t);
        ((List)map.apply(t)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)hs -> this.extend(hs));
        int n2 = this.xsbt$api$HashAPI$$hash;
        map.put(t, (Object)package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)n2)));
    }

    public final void hashString(String s) {
        this.extend(MurmurHash3$.MODULE$.stringHash(s));
    }

    public final void hashBoolean(boolean b) {
        this.extend(b ? 97 : 98);
    }

    public final <T> void hashArray(T[] s, Function1<T, BoxedUnit> hashF) {
        this.extend(s.length);
        for (int i = 0; i < s.length; ++i) {
            hashF.apply(s[i]);
        }
    }

    public final <T> void hashSymmetric(IterableOnce<T> ts, Function1<T, BoxedUnit> hashF) {
        int n;
        int current = this.xsbt$api$HashAPI$$hash;
        IterableOnce<T> iterableOnce = ts;
        if (iterableOnce instanceof Iterable) {
            Iterable ts2 = (Iterable)iterableOnce;
            public class Xsbt_api_HashAPI$HashIterator$1
            implements Iterator<Object> {
                private final Function1 hashF$1;
                private final Iterator delegate;
                private final /* synthetic */ HashAPI $outer;

                public Xsbt_api_HashAPI$HashIterator$1(Function1 hashF$3, HashAPI $outer, Iterator delegate) {
                    this.hashF$1 = hashF$3;
                    this.delegate = delegate;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                }

                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                public Object next() {
                    this.$outer.xsbt$api$HashAPI$$hash = 1;
                    this.hashF$1.apply(this.delegate.next());
                    return this;
                }

                public int hashCode() {
                    return this.$outer.finalizeHash();
                }

                public final /* synthetic */ HashAPI xsbt$api$HashAPI$_$_$HashIterator$$$outer() {
                    return this.$outer;
                }
            }
            n = MurmurHash3$.MODULE$.unorderedHash((IterableOnce)new Xsbt_api_HashAPI$HashIterator$1(hashF, this, ts2.iterator()));
        } else {
            IterableOnce iterableOnce2 = IterableOnce$.MODULE$.iterableOnceExtensionMethods(ts);
            n = MurmurHash3$.MODULE$.unorderedHash((IterableOnce)IterableOnceExtensionMethods$.MODULE$.toList$extension(iterableOnce2).map((Function1 & Serializable)t -> {
                this.xsbt$api$HashAPI$$hash = 1;
                hashF.apply(t);
                return this.finalizeHash();
            }));
        }
        int tsHash = n;
        this.xsbt$api$HashAPI$$hash = current;
        this.extend(tsHash);
    }

    public final void extend(int a) {
        this.xsbt$api$HashAPI$$hash = MurmurHash3$.MODULE$.mix(this.xsbt$api$HashAPI$$hash, a);
    }

    public int finalizeHash() {
        return MurmurHash3$.MODULE$.finalizeHash(this.xsbt$api$HashAPI$$hash, 1);
    }

    public void hashModifiers(Modifiers m) {
        this.extend(m.raw());
    }

    public void hashAPI(ClassLike c) {
        this.xsbt$api$HashAPI$$hash = 1;
        this.hashClass(c);
    }

    public void hashPackage(Package p) {
        this.hashString(p.name());
    }

    public void hashDefinitions(Seq<Definition> ds, boolean topLevel, boolean isTrait) {
        boolean requiresPrivateDefinitions = isTrait && this.includeTraitBreakers && !topLevel;
        Nil$ extraPrivateDefinitions = !requiresPrivateDefinitions ? package$.MODULE$.Nil() : (Seq)ds.filter((Function1 & Serializable)x -> HashAPI.isTraitBreaker$1(x) && HashAPI.isPrivate$1(x));
        Seq<Definition> defs = SameAPI$.MODULE$.filterDefinitions(ds, topLevel, this.includePrivate);
        this.hashSymmetric((IterableOnce)((IterableOnce)defs.$plus$plus((IterableOnce)extraPrivateDefinitions)), (Function1)(JProcedure1 & Serializable)d -> this.hashDefinition((Definition)d));
    }

    public void hashDefinitionsWithExtraHash(IterableOnce<Definition> ds, int extraHash) {
        this.hashSymmetric((IterableOnce)ds, (Function1)(JProcedure1 & Serializable)d -> this.hashDefinitionCombined$1(extraHash, (Definition)d));
    }

    public void hashDefinition(Definition d) {
        this.hashString(d.name());
        this.hashAnnotations(d.annotations());
        this.hashModifiers(d.modifiers());
        this.hashAccess(d.access());
        Definition definition = d;
        if (definition instanceof ClassLikeDef) {
            ClassLikeDef c = (ClassLikeDef)definition;
            this.hashClassDef(c);
            return;
        }
        if (definition instanceof ClassLike) {
            ClassLike c = (ClassLike)definition;
            this.hashClass(c);
            return;
        }
        if (definition instanceof FieldLike) {
            FieldLike f = (FieldLike)definition;
            this.hashField(f);
            return;
        }
        if (definition instanceof Def) {
            Def d2 = (Def)definition;
            this.hashDef(d2);
            return;
        }
        if (definition instanceof TypeDeclaration) {
            TypeDeclaration t = (TypeDeclaration)definition;
            this.hashTypeDeclaration(t);
            return;
        }
        if (definition instanceof TypeAlias) {
            TypeAlias t = (TypeAlias)definition;
            this.hashTypeAlias(t);
            return;
        }
        throw new MatchError((Object)definition);
    }

    public final void hashClassDef(ClassLikeDef c) {
        this.extend(4);
        this.hashParameterizedDefinition(c);
    }

    public final void hashClass(ClassLike c2) {
        this.visit((Map)this.visitedClassLike, (Object)c2, (Function1)(JProcedure1 & Serializable)c -> this.hashClass0((ClassLike)c));
    }

    public void hashClass0(ClassLike c) {
        this.extend(this.ClassHash);
        this.hashTypeParameters(c.typeParameters());
        this.hashType(c.selfType(), this.hashType$default$2());
        if (this.includeSealedChildren) {
            this.hashTypesSymmetric(c.childrenOfSealedClass(), this.includeDefinitions);
        }
        DefinitionType definitionType = c.definitionType();
        DefinitionType definitionType2 = DefinitionType.Trait;
        boolean isTrait = !(definitionType != null ? !definitionType.equals(definitionType2) : definitionType2 != null);
        this.hashStructure(c.structure(), this.includeDefinitions, isTrait);
    }

    public void hashField(FieldLike f) {
        FieldLike fieldLike = f;
        if (fieldLike instanceof Var) {
            this.extend(2);
        } else if (fieldLike instanceof Val) {
            this.extend(1);
        } else {
            throw new MatchError((Object)fieldLike);
        }
        this.hashType(f.tpe(), this.hashType$default$2());
    }

    public void hashDef(Def d) {
        this.extend(3);
        this.hashParameterizedDefinition(d);
        this.hashValueParameters(d.valueParameters());
        this.hashType(d.returnType(), this.hashType$default$2());
    }

    public void hashAccess(Access a) {
        Access access = a;
        if (access instanceof Public) {
            this.extend(30);
            return;
        }
        if (access instanceof Qualified) {
            Qualified qual = (Qualified)access;
            this.hashQualified(qual);
            return;
        }
        throw new MatchError((Object)access);
    }

    public void hashQualified(Qualified qual) {
        Qualified qualified = qual;
        if (qualified instanceof Protected) {
            this.extend(31);
        } else if (qualified instanceof Private) {
            this.extend(32);
        } else {
            throw new MatchError((Object)qualified);
        }
        this.hashQualifier(qual.qualifier());
    }

    public void hashQualifier(Qualifier qual) {
        Qualifier qualifier = qual;
        if (qualifier instanceof Unqualified) {
            this.extend(33);
            return;
        }
        if (qualifier instanceof ThisQualifier) {
            this.extend(34);
            return;
        }
        if (qualifier instanceof IdQualifier) {
            IdQualifier id = (IdQualifier)qualifier;
            this.extend(35);
            this.hashString(id.value());
            return;
        }
        throw new MatchError((Object)qualifier);
    }

    public void hashValueParameters(ParameterList[] valueParameters) {
        this.hashArray((T[])valueParameters, (Function1)(JProcedure1 & Serializable)list -> this.hashValueParameterList((ParameterList)list));
    }

    public void hashValueParameterList(ParameterList list) {
        this.extend(40);
        this.hashBoolean(list.isImplicit());
        this.hashArray((T[])list.parameters(), (Function1)(JProcedure1 & Serializable)parameter -> this.hashValueParameter((MethodParameter)parameter));
    }

    public void hashValueParameter(MethodParameter parameter) {
        this.hashString(parameter.name());
        this.hashType(parameter.tpe(), this.hashType$default$2());
        this.extend(parameter.modifier().ordinal());
        this.hashBoolean(parameter.hasDefault());
    }

    public <T extends ParameterizedDefinition> void hashParameterizedDefinition(T d) {
        this.hashTypeParameters(d.typeParameters());
    }

    public void hashTypeDeclaration(TypeDeclaration d) {
        this.extend(5);
        this.hashParameterizedDefinition(d);
        this.hashType(d.lowerBound(), this.hashType$default$2());
        this.hashType(d.upperBound(), this.hashType$default$2());
    }

    public void hashTypeAlias(TypeAlias d) {
        this.extend(6);
        this.hashParameterizedDefinition(d);
        this.hashType(d.tpe(), this.hashType$default$2());
    }

    public void hashTypeParameters(TypeParameter[] parameters) {
        this.hashArray((T[])parameters, (Function1)(JProcedure1 & Serializable)parameter -> this.hashTypeParameter((TypeParameter)parameter));
    }

    public void hashTypeParameter(TypeParameter parameter) {
        this.hashString(parameter.id());
        this.extend(parameter.variance().ordinal());
        this.hashTypeParameters(parameter.typeParameters());
        this.hashType(parameter.lowerBound(), this.hashType$default$2());
        this.hashType(parameter.upperBound(), this.hashType$default$2());
        this.hashAnnotations(parameter.annotations());
    }

    public void hashAnnotations(Annotation[] annotations) {
        this.hashArray((T[])annotations, (Function1)(JProcedure1 & Serializable)annotation -> this.hashAnnotation((Annotation)annotation));
    }

    public void hashAnnotation(Annotation annotation) {
        this.hashType(annotation.base(), this.hashType$default$2());
        this.hashAnnotationArguments(annotation.arguments());
    }

    public void hashAnnotationArguments(AnnotationArgument[] args) {
        this.hashArray((T[])args, (Function1)(JProcedure1 & Serializable)arg -> this.hashAnnotationArgument((AnnotationArgument)arg));
    }

    public void hashAnnotationArgument(AnnotationArgument arg) {
        this.hashString(arg.name());
        this.hashString(arg.value());
    }

    public void hashTypes(Type[] ts, boolean includeDefinitions) {
        this.hashArray((T[])ts, (Function1)(JProcedure1 & Serializable)t -> this.hashType((Type)t, includeDefinitions));
    }

    public boolean hashTypes$default$2() {
        return true;
    }

    public void hashTypesSymmetric(Type[] ts, boolean includeDefinitions) {
        this.hashSymmetric((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ts), (Function1)(JProcedure1 & Serializable)_$3 -> this.hashType((Type)_$3, includeDefinitions));
    }

    public boolean hashTypesSymmetric$default$2() {
        return true;
    }

    public void hashType(Type t, boolean includeDefinitions) {
        Type type = t;
        if (type instanceof Structure) {
            Structure s = (Structure)type;
            this.hashStructure(s, includeDefinitions, false);
            return;
        }
        if (type instanceof Existential) {
            Existential e = (Existential)type;
            this.hashExistential(e);
            return;
        }
        if (type instanceof Constant) {
            Constant c = (Constant)type;
            this.hashConstant(c);
            return;
        }
        if (type instanceof Polymorphic) {
            Polymorphic p = (Polymorphic)type;
            this.hashPolymorphic(p);
            return;
        }
        if (type instanceof Annotated) {
            Annotated a = (Annotated)type;
            this.hashAnnotated(a);
            return;
        }
        if (type instanceof Parameterized) {
            Parameterized p = (Parameterized)type;
            this.hashParameterized(p);
            return;
        }
        if (type instanceof Projection) {
            Projection p = (Projection)type;
            this.hashProjection(p);
            return;
        }
        if (type instanceof EmptyType) {
            this.extend(51);
            return;
        }
        if (type instanceof Singleton) {
            Singleton s = (Singleton)type;
            this.hashSingleton(s);
            return;
        }
        if (type instanceof ParameterRef) {
            ParameterRef pr = (ParameterRef)type;
            this.hashParameterRef(pr);
            return;
        }
        throw new MatchError((Object)type);
    }

    public boolean hashType$default$2() {
        return true;
    }

    public void hashParameterRef(ParameterRef p) {
        this.extend(52);
        this.hashString(p.id());
    }

    public void hashSingleton(Singleton s) {
        this.extend(53);
        this.hashPath(s.path());
    }

    public void hashPath(Path path) {
        this.hashArray((T[])path.components(), (Function1)(JProcedure1 & Serializable)pc -> this.hashPathComponent((PathComponent)pc));
    }

    public void hashPathComponent(PathComponent pc) {
        PathComponent pathComponent = pc;
        if (pathComponent instanceof This) {
            this.extend(22);
            return;
        }
        if (pathComponent instanceof Super) {
            Super s = (Super)pathComponent;
            this.hashSuperPath(s);
            return;
        }
        if (pathComponent instanceof Id) {
            Id id = (Id)pathComponent;
            this.hashIdPath(id);
            return;
        }
        throw new MatchError((Object)pathComponent);
    }

    public void hashSuperPath(Super s) {
        this.extend(21);
        this.hashPath(s.qualifier());
    }

    public void hashIdPath(Id id) {
        this.extend(20);
        this.hashString(id.id());
    }

    public void hashConstant(Constant c) {
        this.extend(58);
        this.hashString(c.value());
        this.hashType(c.baseType(), this.hashType$default$2());
    }

    public void hashExistential(Existential e) {
        this.extend(59);
        this.hashParameters(e.clause(), e.baseType());
    }

    public void hashPolymorphic(Polymorphic p) {
        this.extend(57);
        this.hashParameters(p.parameters(), p.baseType());
    }

    public void hashProjection(Projection p) {
        this.extend(54);
        this.hashString(p.id());
        this.hashType(p.prefix(), this.hashType$default$2());
    }

    public void hashParameterized(Parameterized p) {
        this.extend(55);
        this.hashType(p.baseType(), this.hashType$default$2());
        this.hashTypes(p.typeArguments(), this.hashTypes$default$2());
    }

    public void hashAnnotated(Annotated a) {
        this.extend(56);
        this.hashType(a.baseType(), this.hashType$default$2());
        this.hashAnnotations(a.annotations());
    }

    public void hashStructure(Structure structure, boolean includeDefinitions, boolean isTrait) {
        this.visit((Map)this.visitedStructures, (Object)structure, (Function1)this.hashStructure0(includeDefinitions, isTrait));
    }

    private Function1<Structure, BoxedUnit> hashStructure0(boolean includeDefinitions, boolean isTrait) {
        if (isTrait && this.includeTraitBreakers) {
            return this.hashStructure0WithDefsTrait;
        }
        if (includeDefinitions) {
            return this.hashStructure0WithDefs;
        }
        return this.hashStructure0NoDefs;
    }

    public void hashStructure0(Structure structure, boolean includeDefinitions, boolean isTrait) {
        this.extend(60);
        this.hashTypes(structure.parents(), includeDefinitions);
        if (includeDefinitions) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])structure.declared());
            this.hashDefinitions((Seq<Definition>)ArrayOps$.MODULE$.toIndexedSeq$extension(object), false, isTrait);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])structure.inherited());
            this.hashDefinitions((Seq<Definition>)ArrayOps$.MODULE$.toIndexedSeq$extension(object2), false, isTrait);
            return;
        }
    }

    public void hashParameters(TypeParameter[] parameters, Type base) {
        this.hashTypeParameters(parameters);
        this.hashType(base, this.hashType$default$2());
    }

    private static final List visit$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final boolean isPrivate$1(Definition d) {
        Access access = d.access();
        return access instanceof Private;
    }

    private static final boolean isTraitBreaker$1(Definition d) {
        Definition definition = d;
        if (definition instanceof FieldLike) {
            return true;
        }
        if (definition instanceof ClassLikeDef) {
            ClassLikeDef cl = (ClassLikeDef)definition;
            DefinitionType definitionType = cl.definitionType();
            DefinitionType definitionType2 = DefinitionType.Module;
            return !(definitionType != null ? !definitionType.equals(definitionType2) : definitionType2 != null);
        }
        if (definition instanceof Def) {
            Def d2 = (Def)definition;
            return d2.modifiers().isSuperAccessor();
        }
        return false;
    }

    private final void hashDefinitionCombined$1(int extraHash$1, Definition d) {
        this.hashDefinition(d);
        this.extend(extraHash$1);
    }
}

