/*
 * Decompiled with CFR 0.152.
 */
package xsbt.api;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import xsbti.api.Access;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.AnnotationArgument;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.Definition;
import xsbti.api.EmptyType;
import xsbti.api.Existential;
import xsbti.api.FieldLike;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.MethodParameter;
import xsbti.api.Modifiers;
import xsbti.api.Package;
import xsbti.api.ParameterList;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.ParameterizedDefinition;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualified;
import xsbti.api.Qualifier;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.This;
import xsbti.api.ThisQualifier;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Unqualified;
import xsbti.api.Val;
import xsbti.api.Var;

public class Visit {
    private final HashSet<Structure> visitedStructures = new HashSet();
    private final HashSet<ClassLike> visitedClassLike = new HashSet();

    public void visitAPI(ClassLike c) {
        this.visitDefinition((Definition)c);
    }

    public void visitPackage(Package p) {
        this.visitString(p.name());
    }

    public void visitDefinitions(Definition[] ds) {
        this.visitArray((T[])ds, (Function1)(JProcedure1 & Serializable)d -> this.visitDefinition((Definition)d));
    }

    public void visitDefinition(Definition d) {
        this.visitString(d.name());
        this.visitAnnotations(d.annotations());
        this.visitModifiers(d.modifiers());
        this.visitAccess(d.access());
        Definition definition = d;
        if (definition instanceof ClassLikeDef) {
            ClassLikeDef c = (ClassLikeDef)definition;
            this.visitClassDef(c);
            return;
        }
        if (definition instanceof ClassLike) {
            ClassLike c = (ClassLike)definition;
            this.visitClass(c);
            return;
        }
        if (definition instanceof FieldLike) {
            FieldLike f = (FieldLike)definition;
            this.visitField(f);
            return;
        }
        if (definition instanceof Def) {
            Def d2 = (Def)definition;
            this.visitDef(d2);
            return;
        }
        if (definition instanceof TypeDeclaration) {
            TypeDeclaration t = (TypeDeclaration)definition;
            this.visitTypeDeclaration(t);
            return;
        }
        if (definition instanceof TypeAlias) {
            TypeAlias t = (TypeAlias)definition;
            this.visitTypeAlias(t);
            return;
        }
        throw new MatchError((Object)definition);
    }

    public final void visitClassDef(ClassLikeDef c) {
        this.visitTypeParameters(c.typeParameters());
    }

    public final void visitClass(ClassLike c) {
        if (this.visitedClassLike.add((Object)c)) {
            this.visitClass0(c);
            return;
        }
    }

    public void visitClass0(ClassLike c) {
        this.visitTypeParameters(c.typeParameters());
        this.visitType(c.selfType());
        this.visitStructure(c.structure());
    }

    public void visitField(FieldLike f) {
        this.visitType(f.tpe());
        FieldLike fieldLike = f;
        if (fieldLike instanceof Var) {
            Var v = (Var)fieldLike;
            this.visitVar(v);
            return;
        }
        if (fieldLike instanceof Val) {
            Val v = (Val)fieldLike;
            this.visitVal(v);
            return;
        }
        throw new MatchError((Object)fieldLike);
    }

    public void visitVar(Var v) {
    }

    public void visitVal(Val v) {
    }

    public void visitDef(Def d) {
        this.visitParameterizedDefinition(d);
        this.visitValueParameters(d.valueParameters());
        this.visitType(d.returnType());
    }

    public void visitAccess(Access a) {
        Access access = a;
        if (access instanceof Public) {
            Public pub = (Public)access;
            this.visitPublic(pub);
            return;
        }
        if (access instanceof Qualified) {
            Qualified qual = (Qualified)access;
            this.visitQualified(qual);
            return;
        }
        throw new MatchError((Object)access);
    }

    public void visitQualified(Qualified qual) {
        Qualified qualified = qual;
        if (qualified instanceof Protected) {
            Protected p = (Protected)qualified;
            this.visitProtected(p);
            return;
        }
        if (qualified instanceof Private) {
            Private p = (Private)qualified;
            this.visitPrivate(p);
            return;
        }
        throw new MatchError((Object)qualified);
    }

    public void visitQualifier(Qualifier qual) {
        Qualifier qualifier = qual;
        if (qualifier instanceof Unqualified) {
            Unqualified unq = (Unqualified)qualifier;
            this.visitUnqualified(unq);
            return;
        }
        if (qualifier instanceof ThisQualifier) {
            ThisQualifier thisq = (ThisQualifier)qualifier;
            this.visitThisQualifier(thisq);
            return;
        }
        if (qualifier instanceof IdQualifier) {
            IdQualifier id = (IdQualifier)qualifier;
            this.visitIdQualifier(id);
            return;
        }
        throw new MatchError((Object)qualifier);
    }

    public void visitIdQualifier(IdQualifier id) {
        this.visitString(id.value());
    }

    public void visitUnqualified(Unqualified unq) {
    }

    public void visitThisQualifier(ThisQualifier thisq) {
    }

    public void visitPublic(Public pub) {
    }

    public void visitPrivate(Private p) {
        this.visitQualifier(p.qualifier());
    }

    public void visitProtected(Protected p) {
        this.visitQualifier(p.qualifier());
    }

    public void visitModifiers(Modifiers m) {
    }

    public void visitValueParameters(ParameterList[] valueParameters) {
        this.visitArray((T[])valueParameters, (Function1)(JProcedure1 & Serializable)list -> this.visitValueParameterList((ParameterList)list));
    }

    public void visitValueParameterList(ParameterList list) {
        this.visitArray((T[])list.parameters(), (Function1)(JProcedure1 & Serializable)parameter -> this.visitValueParameter((MethodParameter)parameter));
    }

    public void visitValueParameter(MethodParameter parameter) {
        this.visitString(parameter.name());
        this.visitType(parameter.tpe());
    }

    public <T extends ParameterizedDefinition> void visitParameterizedDefinition(T d) {
        this.visitTypeParameters(d.typeParameters());
    }

    public void visitTypeDeclaration(TypeDeclaration d) {
        this.visitParameterizedDefinition(d);
        this.visitType(d.lowerBound());
        this.visitType(d.upperBound());
    }

    public void visitTypeAlias(TypeAlias d) {
        this.visitParameterizedDefinition(d);
        this.visitType(d.tpe());
    }

    public void visitTypeParameters(TypeParameter[] parameters) {
        this.visitArray((T[])parameters, (Function1)(JProcedure1 & Serializable)parameter -> this.visitTypeParameter((TypeParameter)parameter));
    }

    public void visitTypeParameter(TypeParameter parameter) {
        this.visitTypeParameters(parameter.typeParameters());
        this.visitType(parameter.lowerBound());
        this.visitType(parameter.upperBound());
        this.visitAnnotations(parameter.annotations());
    }

    public void visitAnnotations(Annotation[] annotations) {
        this.visitArray((T[])annotations, (Function1)(JProcedure1 & Serializable)annotation -> this.visitAnnotation((Annotation)annotation));
    }

    public void visitAnnotation(Annotation annotation) {
        this.visitType(annotation.base());
        this.visitAnnotationArguments(annotation.arguments());
    }

    public void visitAnnotationArguments(AnnotationArgument[] args) {
        this.visitArray((T[])args, (Function1)(JProcedure1 & Serializable)arg -> this.visitAnnotationArgument((AnnotationArgument)arg));
    }

    public void visitAnnotationArgument(AnnotationArgument arg) {
        this.visitString(arg.name());
        this.visitString(arg.value());
    }

    public void visitTypes(Type[] ts) {
        this.visitArray((T[])ts, (Function1)(JProcedure1 & Serializable)t -> this.visitType((Type)t));
    }

    public void visitType(Type t) {
        Type type = t;
        if (type instanceof Structure) {
            Structure s = (Structure)type;
            this.visitStructure(s);
            return;
        }
        if (type instanceof Existential) {
            Existential e = (Existential)type;
            this.visitExistential(e);
            return;
        }
        if (type instanceof Constant) {
            Constant c = (Constant)type;
            this.visitConstant(c);
            return;
        }
        if (type instanceof Polymorphic) {
            Polymorphic p = (Polymorphic)type;
            this.visitPolymorphic(p);
            return;
        }
        if (type instanceof Annotated) {
            Annotated a = (Annotated)type;
            this.visitAnnotated(a);
            return;
        }
        if (type instanceof Parameterized) {
            Parameterized p = (Parameterized)type;
            this.visitParameterized(p);
            return;
        }
        if (type instanceof Projection) {
            Projection p = (Projection)type;
            this.visitProjection(p);
            return;
        }
        if (type instanceof EmptyType) {
            this.visitEmptyType();
            return;
        }
        if (type instanceof Singleton) {
            Singleton s = (Singleton)type;
            this.visitSingleton(s);
            return;
        }
        if (type instanceof ParameterRef) {
            ParameterRef pr = (ParameterRef)type;
            this.visitParameterRef(pr);
            return;
        }
        throw new MatchError((Object)type);
    }

    public void visitEmptyType() {
    }

    public void visitParameterRef(ParameterRef p) {
    }

    public void visitSingleton(Singleton s) {
        this.visitPath(s.path());
    }

    public void visitPath(Path path) {
        this.visitArray((T[])path.components(), (Function1)(JProcedure1 & Serializable)pc -> this.visitPathComponent((PathComponent)pc));
    }

    public void visitPathComponent(PathComponent pc) {
        PathComponent pathComponent = pc;
        if (pathComponent instanceof This) {
            This t = (This)pathComponent;
            this.visitThisPath(t);
            return;
        }
        if (pathComponent instanceof Super) {
            Super s = (Super)pathComponent;
            this.visitSuperPath(s);
            return;
        }
        if (pathComponent instanceof Id) {
            Id id = (Id)pathComponent;
            this.visitIdPath(id);
            return;
        }
        throw new MatchError((Object)pathComponent);
    }

    public void visitThisPath(This t) {
    }

    public void visitSuperPath(Super s) {
        this.visitPath(s.qualifier());
    }

    public void visitIdPath(Id id) {
        this.visitString(id.id());
    }

    public void visitConstant(Constant c) {
        this.visitString(c.value());
        this.visitType(c.baseType());
    }

    public void visitExistential(Existential e) {
        this.visitParameters(e.clause(), e.baseType());
    }

    public void visitPolymorphic(Polymorphic p) {
        this.visitParameters(p.parameters(), p.baseType());
    }

    public void visitProjection(Projection p) {
        this.visitString(p.id());
        this.visitType(p.prefix());
    }

    public void visitParameterized(Parameterized p) {
        this.visitType(p.baseType());
        this.visitTypes(p.typeArguments());
    }

    public void visitAnnotated(Annotated a) {
        this.visitType(a.baseType());
        this.visitAnnotations(a.annotations());
    }

    public final void visitStructure(Structure structure) {
        if (this.visitedStructures.add((Object)structure)) {
            this.visitStructure0(structure);
            return;
        }
    }

    public void visitStructure0(Structure structure) {
        this.visitTypes(structure.parents());
        this.visitDefinitions((Definition[])structure.declared());
        this.visitDefinitions((Definition[])structure.inherited());
    }

    public void visitParameters(TypeParameter[] parameters, Type base) {
        this.visitTypeParameters(parameters);
        this.visitType(base);
    }

    public void visitString(String s) {
    }

    public final <T> void visitArray(T[] ts, Function1<T, BoxedUnit> f) {
        for (int i = 0; i < ts.length; ++i) {
            f.apply(ts[i]);
        }
    }
}

