/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classfile;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import sbt.internal.inc.JarUtils$ClassInJar$;
import sbt.internal.inc.classfile.ClassFile;
import sbt.internal.inc.classfile.Parser$;
import sbt.io.IO$;
import sbt.util.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.api.DependencyContext;
import xsbti.compile.Output;

public final class JavaAnalyze$ {
    public static final JavaAnalyze$ MODULE$ = new JavaAnalyze$();

    public <T> void apply(Seq<Path> newClasses, Seq<VirtualFile> sources, Logger log, Output output, Option<Path> finalJarOutput, AnalysisCallback analysis, ClassLoader loader, Function2<VirtualFileRef, Seq<Class<?>>, scala.collection.immutable.Set<Tuple2<String, String>>> readAPI) {
        Map sourceMap = sources.toSet().groupBy((Function1 & Serializable)x$1 -> x$1.name());
        Path outputJarOrNull = (Path)finalJarOutput.getOrElse((Function0 & Serializable)() -> null);
        Path singleOutputOrNull = output.getSingleOutputAsPath().orElse(null);
        Set classNames = (Set)Set$.MODULE$.empty();
        HashMap sourceToClassFiles = (HashMap)HashMap$.MODULE$.apply((Seq)sources.map((Function1 & Serializable)vf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(vf), (Object)new ArrayBuffer())));
        HashMap binaryClassNameToLoadedClass = new HashMap();
        scala.collection.mutable.Map classfilesCache = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        ((IterableOnceOps)newClasses.map((Function1 & Serializable)newClass -> {
            ClassFile classFile = Parser$.MODULE$.apply((Path)newClass);
            return new Tuple2(newClass, (Object)classFile);
        })).foreach((Function1 & Serializable)x$4 -> {
            JavaAnalyze$.$anonfun$apply$7(this, sourceMap, log, binaryClassNameToLoadedClass, singleOutputOrNull, outputJarOrNull, analysis, classNames, sourceToClassFiles, loader, x$4);
            return BoxedUnit.UNIT;
        });
        sourceToClassFiles.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$apply$14(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
            JavaAnalyze$.$anonfun$apply$15(analysis, binaryClassNameToLoadedClass, loader, log, finalJarOutput, classfilesCache, classNames, singleOutputOrNull, outputJarOrNull, readAPI, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private Path resolveFinalClassFile(Path realClassFile, Path outputDir, Path outputJar, Logger log) {
        Path path;
        Option option = IO$.MODULE$.relativize(JavaAnalyze$.toFile$1(outputDir), JavaAnalyze$.toFile$1(realClassFile));
        if (option instanceof Some) {
            Some some = (Some)option;
            String relativeClass = (String)some.value();
            path = JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.apply(outputJar, relativeClass));
        } else if (None$.MODULE$.equals(option)) {
            path = realClassFile;
        } else {
            throw new MatchError((Object)option);
        }
        return path;
    }

    private Option<Path> urlAsFile(URL url, Logger log, Option<Path> finalJarOutput) {
        None$ none$;
        try {
            none$ = this.urlAsFile(url, finalJarOutput);
        }
        catch (Exception e) {
            log.warn((Function0 & Serializable)() -> new StringBuilder(34).append("Could not convert URL '").append(url.toExternalForm()).append("' to File: ").append(e.toString()).toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<Path> urlAsFile(URL url, Option<Path> finalJarOutput) {
        return IO$.MODULE$.urlAsFile(url).map((Function1 & Serializable)file -> {
            void var3_3;
            Path p = file.toPath();
            return finalJarOutput.exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$urlAsFile$3(p, x$10))) ? JarUtils$ClassInJar$.MODULE$.toPath$extension(JarUtils$ClassInJar$.MODULE$.fromURL(url, p)) : var3_3;
        });
    }

    private void trapAndLog(Logger log, Function0<BoxedUnit> execute) {
        try {
            execute.apply$mcV$sp();
        }
        catch (Throwable e) {
            log.trace((Function0 & Serializable)() -> e);
            log.error((Function0 & Serializable)() -> e.toString());
        }
    }

    private Some<String> guessSourceName(String name) {
        return new Some((Object)this.takeToDollar(this.trimClassExt(name)));
    }

    private String takeToDollar(String name) {
        int dollar = name.indexOf(36);
        return dollar < 0 ? name : name.substring(0, dollar);
    }

    private final String ClassExt() {
        return ".class";
    }

    private String trimClassExt(String name) {
        return name.endsWith(".class") ? name.substring(0, name.length() - ".class".length()) : name;
    }

    private String classNameToClassFile(String name) {
        return new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
    }

    private Option<String> binaryToSourceName(Class<?> loadedClass) {
        return Option$.MODULE$.apply((Object)loadedClass.getCanonicalName());
    }

    private List<VirtualFile> guessSourcePath(Map<String, scala.collection.immutable.Set<VirtualFile>> sourceNameMap, ClassFile classFile, Logger log) {
        .colon.colon colon2;
        List list;
        String[] classNameParts = classFile.className().split("\\.");
        String[] pkg = (String[])ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps((Object[])classNameParts));
        String simpleClassName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])classNameParts));
        String sourceFileName = (String)classFile.sourceFile().getOrElse((Function0 & Serializable)() -> StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(simpleClassName), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$guessSourcePath$2(BoxesRunTime.unboxToChar((Object)x$11))))), "", "", ".java"));
        List<VirtualFile> candidates = this.findSource(sourceNameMap, (List<String>)Predef$.MODULE$.wrapRefArray((Object[])pkg).toList(), sourceFileName);
        List<VirtualFile> list2 = candidates;
        if (Nil$.MODULE$.equals(list2)) {
            log.warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not determine source for class ").append(classFile.className()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).next$access$1())) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            log.warn((Function0 & Serializable)() -> new StringBuilder(37).append("Multiple sources matched for class ").append(classFile.className()).append(": ").append(candidates.mkString(", ")).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return candidates;
    }

    private List<VirtualFile> findSource(Map<String, Iterable<VirtualFile>> sourceNameMap, List<String> pkg, String sourceFileName) {
        return this.refine$1(((List)sourceNameMap.get((Object)sourceFileName).toList().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x -> new Tuple2(x, (Object)Predef$.MODULE$.wrapRefArray((Object[])x.names()).toList().reverse().drop(1))), pkg.reverse());
    }

    private static final Option load$1(String tpe, Function0 errMsg, ClassLoader loader$1, Logger log$1) {
        None$ none$;
        if (tpe.endsWith("module-info")) {
            none$ = None$.MODULE$;
        } else {
            try {
                none$ = new Some(Class.forName(tpe, false, loader$1));
            }
            catch (Throwable e) {
                ((Option)errMsg.apply()).foreach((Function1 & Serializable)msg -> {
                    log$1.warn((Function0 & Serializable)() -> new StringBuilder(3).append(msg).append(" : ").append(e$1.toString()).toString());
                    return BoxedUnit.UNIT;
                });
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private final Option loadEnclosingClass$1(Class clazz) {
        Option<String> option;
        while (None$.MODULE$.equals(option = this.binaryToSourceName(clazz)) && clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
        }
        Option<String> option2 = option;
        return option2;
    }

    public static final /* synthetic */ void $anonfun$apply$11(JavaAnalyze$ $this, HashMap binaryClassNameToLoadedClass$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, Path newClass$1, Logger log$1, AnalysisCallback analysis$1, Set classNames$1, HashMap sourceToClassFiles$1, ClassFile classFile$1, ClassLoader loader$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        VirtualFile source = (VirtualFile)tuple2._1();
        String binaryClassName = (String)tuple2._2();
        JavaAnalyze$.load$1(binaryClassName, (Function0 & Serializable)() -> new Some((Object)new StringBuilder(35).append("Error reading API from class file: ").append(binaryClassName).toString()), loader$1, log$1).foreach((Function1 & Serializable)loadedClass -> {
            BoxedUnit boxedUnit;
            binaryClassNameToLoadedClass$1.update((Object)binaryClassName, loadedClass);
            Option srcClassName = $this.loadEnclosingClass$1((Class)loadedClass);
            Path finalClassFile = singleOutputOrNull$1 == null || outputJarOrNull$1 == null ? newClass$1 : MODULE$.resolveFinalClassFile(newClass$1, singleOutputOrNull$1, outputJarOrNull$1, log$1);
            Option option = srcClassName;
            if (option instanceof Some) {
                Some some = (Some)option;
                String className = (String)some.value();
                analysis$1.generatedNonLocalClass((VirtualFileRef)source, finalClassFile, binaryClassName, className);
                boxedUnit = classNames$1.$plus$eq((Object)className);
            } else if (None$.MODULE$.equals(option)) {
                analysis$1.generatedLocalClass((VirtualFileRef)source, finalClassFile);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return (Buffer)((Growable)sourceToClassFiles$1.apply((Object)source)).$plus$eq((Object)classFile$1);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$9(JavaAnalyze$ $this, Map sourceMap$1, ClassFile classFile$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, Path newClass$1, AnalysisCallback analysis$1, Set classNames$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, String x$3) {
        String string = x$3;
        MODULE$.guessSourcePath((Map<String, scala.collection.immutable.Set<VirtualFile>>)sourceMap$1, classFile$1, log$1).map((Function1 & Serializable)source -> {
            String binaryClassName = classFile$1.className();
            return new Tuple2(source, (Object)binaryClassName);
        }).foreach((Function1 & Serializable)x$2 -> {
            JavaAnalyze$.$anonfun$apply$11($this, binaryClassNameToLoadedClass$1, singleOutputOrNull$1, outputJarOrNull$1, newClass$1, log$1, analysis$1, classNames$1, sourceToClassFiles$1, classFile$1, loader$1, x$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$7(JavaAnalyze$ $this, Map sourceMap$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, AnalysisCallback analysis$1, Set classNames$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path newClass = (Path)tuple2._1();
        ClassFile classFile = (ClassFile)tuple2._2();
        classFile.sourceFile().orElse((Function0 & Serializable)() -> MODULE$.guessSourceName(((Object)newClass.getFileName()).toString())).foreach((Function1 & Serializable)x$3 -> {
            JavaAnalyze$.$anonfun$apply$9($this, sourceMap$1, classFile, log$1, binaryClassNameToLoadedClass$1, singleOutputOrNull$1, outputJarOrNull$1, newClass, analysis$1, classNames$1, sourceToClassFiles$1, loader$1, x$3);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$apply$14(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(Class x$5) {
        return x$5.getCanonicalName() != null;
    }

    private static final Option getMappedSource$1(String className, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        Option nonLocalSourceName = binaryClassNameToLoadedClass$1.get((Object)className).flatMap((Function1 & Serializable)loadedClass -> MODULE$.binaryToSourceName((Class<?>)loadedClass).map((Function1 & Serializable)sourceName -> sourceName));
        return nonLocalSourceName.orElse((Function0 & Serializable)() -> localClassesToSources$1.get((Object)className));
    }

    private static final Option loadFromClassloader$1(ClassLoader loader$1, String onBinaryName$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1) {
        return Option$.MODULE$.apply((Object)loader$1.getResource(MODULE$.classNameToClassFile(onBinaryName$1))).flatMap((Function1 & Serializable)url -> MODULE$.urlAsFile((URL)url, log$1, (Option<Path>)finalJarOutput$1).map((Function1 & Serializable)file -> {
            classfilesCache$1.update((Object)onBinaryName$1, file);
            return file;
        }));
    }

    public static final /* synthetic */ void $anonfun$apply$28(Path singleOutputOrNull$1, Path outputJarOrNull$1, Logger log$1, AnalysisCallback analysis$1, String onBinaryName$1, String fromClassName$1, VirtualFile source$2, DependencyContext context$1, Path file) {
        Path binaryFile = singleOutputOrNull$1 == null || outputJarOrNull$1 == null ? file : MODULE$.resolveFinalClassFile(file, singleOutputOrNull$1, outputJarOrNull$1, log$1);
        analysis$1.binaryDependency(binaryFile, onBinaryName$1, fromClassName$1, (VirtualFileRef)source$2, context$1);
    }

    private static final void processDependency$1(String onBinaryName, DependencyContext context, String fromBinaryName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        Option option = JavaAnalyze$.getMappedSource$1(fromBinaryName, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            String fromClassName = (String)some.value();
            MODULE$.trapAndLog(log$1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String scalaLikeTypeName = onBinaryName.replace('$', '.');
                if (classNames$1.contains((Object)scalaLikeTypeName)) {
                    analysis$1.classDependency(scalaLikeTypeName, fromClassName, context);
                } else {
                    Option cachedOrigin = classfilesCache$1.get((Object)onBinaryName);
                    cachedOrigin.orElse((Function0 & Serializable)() -> JavaAnalyze$.loadFromClassloader$1(loader$1, onBinaryName, log$1, finalJarOutput$1, classfilesCache$1)).foreach((Function1 & Serializable)file -> {
                        JavaAnalyze$.$anonfun$apply$28(singleOutputOrNull$1, outputJarOrNull$1, log$1, analysis$1, onBinaryName, fromClassName, source$2, context, file);
                        return BoxedUnit.UNIT;
                    });
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private static final void processDependencies$1(Iterable binaryClassNames, DependencyContext context, String fromBinaryClassName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        binaryClassNames.foreach((Function1 & Serializable)binaryClassName -> {
            JavaAnalyze$.processDependency$1(binaryClassName, context, fromBinaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, singleOutputOrNull$1, outputJarOrNull$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$31(ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String binaryClassName = (String)tuple2._1();
        scala.collection.immutable.Set binaryClassNameDeps = (scala.collection.immutable.Set)tuple2._2();
        JavaAnalyze$.processDependencies$1((Iterable)binaryClassNameDeps, DependencyContext.DependencyByMemberRef, binaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, singleOutputOrNull$1, outputJarOrNull$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Iterator readInheritanceDependencies$1(Seq classes, Function2 readAPI$1, VirtualFile source$2) {
        scala.collection.immutable.Set api = (scala.collection.immutable.Set)readAPI$1.apply((Object)source$2, (Object)classes);
        return api.groupBy((Function1 & Serializable)x$7 -> (String)x$7._1()).iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            scala.collection.immutable.Set v = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.map((Function1 & Serializable)x$8 -> (String)x$8._2()));
            return tuple22;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$35(ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String className = (String)tuple2._1();
        scala.collection.immutable.Set inheritanceDeps = (scala.collection.immutable.Set)tuple2._2();
        JavaAnalyze$.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.DependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, singleOutputOrNull$1, outputJarOrNull$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$37(ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, VirtualFile source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String className = (String)tuple2._1();
        scala.collection.immutable.Set inheritanceDeps = (scala.collection.immutable.Set)tuple2._2();
        JavaAnalyze$.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.LocalDependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, singleOutputOrNull$1, outputJarOrNull$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$15(AnalysisCallback analysis$1, HashMap binaryClassNameToLoadedClass$1, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, Path singleOutputOrNull$1, Path outputJarOrNull$1, Function2 readAPI$1, Tuple2 x$9) {
        Tuple2 tuple2;
        Buffer classFiles;
        VirtualFile source;
        Tuple2 tuple22 = x$9;
        if (tuple22 != null) {
            source = (VirtualFile)tuple22._1();
            classFiles = (Buffer)tuple22._2();
            analysis$1.startSource(source);
            Buffer loadedClasses = (Buffer)classFiles.map((Function1 & Serializable)c -> (Class)binaryClassNameToLoadedClass$1.apply((Object)c.className()));
            Tuple2 tuple23 = loadedClasses.partition((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JavaAnalyze$.$anonfun$apply$17(x$5)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Buffer nonLocalClasses = (Buffer)tuple23._1();
            Buffer localClassesOrStale = (Buffer)tuple23._2();
            tuple2 = new Tuple2((Object)nonLocalClasses, (Object)localClassesOrStale);
        } else {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple24 = tuple2;
        Buffer nonLocalClasses = (Buffer)tuple24._1();
        Buffer localClassesOrStale = (Buffer)tuple24._2();
        Buffer localToSourcesSeq = (Buffer)localClassesOrStale.flatMap((Function1 & Serializable)cls -> Option$.MODULE$.apply(cls.getEnclosingClass()).flatMap((Function1 & Serializable)enclosingCls -> MODULE$.binaryToSourceName((Class<?>)enclosingCls).map((Function1 & Serializable)sourceOfEnclosing -> new Tuple2((Object)cls.getName(), sourceOfEnclosing))));
        Map localClassesToSources = localToSourcesSeq.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map typesInSource = ((IterableOnceOps)classFiles.map((Function1 & Serializable)cf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cf.className()), cf.types()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        typesInSource.foreach((Function1 & Serializable)x0$1 -> {
            JavaAnalyze$.$anonfun$apply$31(loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, singleOutputOrNull$1, outputJarOrNull$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, x0$1);
            return BoxedUnit.UNIT;
        });
        Map nonLocalInherited = JavaAnalyze$.readInheritanceDependencies$1(nonLocalClasses.toSeq(), readAPI$1, source).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        nonLocalInherited.foreach((Function1 & Serializable)x0$2 -> {
            JavaAnalyze$.$anonfun$apply$35(loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, singleOutputOrNull$1, outputJarOrNull$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, x0$2);
            return BoxedUnit.UNIT;
        });
        Buffer localClasses = (Buffer)localClassesOrStale.filter((Function1 & Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)localClassesToSources.contains((Object)cls.getName())));
        Map localInherited = JavaAnalyze$.readInheritanceDependencies$1(localClasses.toSeq(), readAPI$1, source).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        localInherited.foreach((Function1 & Serializable)x0$3 -> {
            JavaAnalyze$.$anonfun$apply$37(loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, singleOutputOrNull$1, outputJarOrNull$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, x0$3);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final File toFile$1(Path p) {
        return p == null ? null : p.toFile();
    }

    public static final /* synthetic */ boolean $anonfun$urlAsFile$3(Path p$1, Path x$10) {
        Path path = x$10;
        Path path2 = p$1;
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$guessSourcePath$2(char x$11) {
        return x$11 != '$';
    }

    private static final List make$1(List sources$1) {
        return sources$1.map((Function1 & Serializable)x$12 -> (VirtualFile)x$12._1());
    }

    private final List refine$1(List sources, List pkgRev) {
        List list;
        block2: {
            block3: {
                List list2;
                while (true) {
                    if (sources.isEmpty() || ((List)sources.tail()).isEmpty()) {
                        list = JavaAnalyze$.make$1(sources);
                        break block2;
                    }
                    list2 = pkgRev;
                    if (Nil$.MODULE$.equals(list2)) break block3;
                    if (!(list2 instanceof .colon.colon)) break;
                    .colon.colon colon2 = (.colon.colon)list2;
                    String x = (String)colon2.head();
                    List xs = colon2.next$access$1();
                    List retain = sources.flatMap((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) return Nil$.MODULE$;
                        VirtualFile src = (VirtualFile)tuple2._1();
                        List list = (List)tuple2._2();
                        if (!(list instanceof .colon.colon)) return Nil$.MODULE$;
                        .colon.colon colon2 = (.colon.colon)list;
                        String string = (String)colon2.head();
                        List presRev = colon2.next$access$1();
                        String string2 = x;
                        String string3 = string;
                        if (string2 == null) {
                            if (string3 != null) {
                                return Nil$.MODULE$;
                            }
                        } else if (!string2.equals(string3)) return Nil$.MODULE$;
                        Tuple2 tuple22 = new Tuple2((Object)src, (Object)presRev);
                        return Nil$.MODULE$.$colon$colon((Object)tuple22);
                    });
                    pkgRev = xs;
                    sources = retain;
                }
                throw new MatchError((Object)list2);
            }
            List list3 = JavaAnalyze$.shortest$1(JavaAnalyze$.make$1(sources));
            list = list3;
        }
        return list;
    }

    private static final List shortest$1(List files) {
        List list;
        if (files.isEmpty()) {
            list = files;
        } else {
            Map fs = files.groupBy((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])x.names()))));
            list = (List)fs.apply(fs.keys().min((Ordering)Ordering.Int$.MODULE$));
        }
        return list;
    }

    private JavaAnalyze$() {
    }
}

