/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import sbt.internal.inc.classfile.AttributeInfo;
import sbt.internal.inc.classfile.ClassFile;
import sbt.internal.inc.classfile.Constant;
import sbt.internal.inc.classfile.FieldOrMethodInfo;
import sbt.internal.inc.classfile.Parser$;
import sbt.internal.io.ErrorHandling$;
import sbt.io.Using;
import sbt.io.Using$;
import sbt.util.Logger;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class Parser$ {
    public static final Parser$ MODULE$ = new Parser$();
    private static final Using<URL, BufferedInputStream> usingUrlInputStreamWithoutCaching = Using$.MODULE$.resource((Function1 & Serializable)u -> (BufferedInputStream)ErrorHandling$.MODULE$.translate((Function0 & Serializable)() -> new StringBuilder(16).append("Error opening ").append(u).append(": ").toString(), (Function0 & Serializable)() -> {
        URLConnection urlConnection = u.openConnection();
        urlConnection.setUseCaches(false);
        return new BufferedInputStream(urlConnection.getInputStream());
    }));

    public ClassFile apply(Path file, Logger log) {
        String string = ((Object)file).toString();
        return (ClassFile)((Either)Using$.MODULE$.bufferedInputStream().apply((Object)Files.newInputStream(file, new OpenOption[0]), (Function1 & Serializable)is -> MODULE$.parse(string, log, (InputStream)is))).right().get();
    }

    public ClassFile apply(File file, Logger log) {
        String string = file.toString();
        return (ClassFile)((Either)((Using)Using$.MODULE$.fileInputStream()).apply((Object)file, (Function1 & Serializable)is -> MODULE$.parse(string, log, (InputStream)is))).right().get();
    }

    public ClassFile apply(URL url, Logger log) {
        String string = url.toString();
        return (ClassFile)((Either)this.usingUrlInputStreamWithoutCaching().apply((Object)url, (Function1 & Serializable)is -> MODULE$.parse(string, log, (InputStream)is))).right().get();
    }

    private Using<URL, BufferedInputStream> usingUrlInputStreamWithoutCaching() {
        return usingUrlInputStreamWithoutCaching;
    }

    private Either<String, ClassFile> parse(String readableName, Logger log, InputStream is) {
        return package$.MODULE$.Right().apply((Object)this.parseImpl(readableName, log, is));
    }

    private ClassFile parseImpl(String readableName, Logger log, InputStream is) {
        DataInputStream in = new DataInputStream(is);
        Predef$.MODULE$.assume(in.readInt() == -889275714, (Function0 & Serializable)() -> new StringBuilder(20).append("Invalid class file: ").append(readableName).toString());
        return new ClassFile(log, in){
            private Option<String> sourceFile;
            private final int minorVersion;
            private final int majorVersion;
            private final Constant[] constantPool;
            private final int accessFlags;
            private final String className;
            private final String superClassName;
            private final String[] interfaceNames;
            private final FieldOrMethodInfo[] fields;
            private final FieldOrMethodInfo[] methods;
            private final AttributeInfo[] attributes;
            private volatile boolean bitmap$0;
            private final DataInputStream in$1;

            public Option<Object> constantValue(String fieldName) {
                return ClassFile.constantValue$(this, fieldName);
            }

            public int minorVersion() {
                return this.minorVersion;
            }

            public int majorVersion() {
                return this.majorVersion;
            }

            public Constant[] constantPool() {
                return this.constantPool;
            }

            public int accessFlags() {
                return this.accessFlags;
            }

            public String className() {
                return this.className;
            }

            public String superClassName() {
                return this.superClassName;
            }

            public String[] interfaceNames() {
                return this.interfaceNames;
            }

            public FieldOrMethodInfo[] fields() {
                return this.fields;
            }

            public FieldOrMethodInfo[] methods() {
                return this.methods;
            }

            public AttributeInfo[] attributes() {
                return this.attributes;
            }

            private Option<String> sourceFile$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.sourceFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.attributes()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$sourceFile$1(x$1))).map((Function1 & Serializable)sourceFileAttribute -> this.toUTF8(Parser$.MODULE$.entryIndex((AttributeInfo)sourceFileAttribute)));
                        this.bitmap$0 = true;
                    }
                }
                return this.sourceFile;
            }

            public Option<String> sourceFile() {
                return !this.bitmap$0 ? this.sourceFile$lzycompute() : this.sourceFile;
            }

            public String stringValue(AttributeInfo a) {
                return this.toUTF8(Parser$.MODULE$.entryIndex(a));
            }

            private FieldOrMethodInfo[] readFieldsOrMethods() {
                return (FieldOrMethodInfo[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(this.in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.parseFieldOrMethodInfo(), ManifestFactory$.MODULE$.classType(FieldOrMethodInfo.class));
            }

            private String toUTF8(int entryIndex) {
                Constant entry = this.constantPool()[entryIndex];
                Predef$.MODULE$.assume(entry.tag() == 1, (Function0 & Serializable)() -> new StringBuilder(40).append("Constant pool entry is not a UTF8 type: ").append(entryIndex).toString());
                return (String)entry.value().get();
            }

            private String getClassConstantName(int entryIndex) {
                Constant entry = this.constantPool()[entryIndex];
                return entry == null ? "" : Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(entry.nameIndex()));
            }

            private Option<String> toString(int index) {
                return index <= 0 ? None$.MODULE$ : new Some((Object)this.toUTF8(index));
            }

            private FieldOrMethodInfo parseFieldOrMethodInfo() {
                return new FieldOrMethodInfo(this.in$1.readUnsignedShort(), this.toString(this.in$1.readUnsignedShort()), this.toString(this.in$1.readUnsignedShort()), (IndexedSeq<AttributeInfo>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(this.in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.parseAttribute(), ManifestFactory$.MODULE$.classType(AttributeInfo.class))));
            }

            private AttributeInfo parseAttribute() {
                int nameIndex = this.in$1.readUnsignedShort();
                None$ name = nameIndex == -1 ? None$.MODULE$ : new Some((Object)this.toUTF8(nameIndex));
                byte[] value = (byte[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(this.in$1.readInt(), (JFunction0.mcB.sp & Serializable)() -> $this.in$1.readByte(), ManifestFactory$.MODULE$.Byte());
                return new AttributeInfo((Option<String>)name, value);
            }

            public Set<String> types() {
                return ((IterableOnceOps)((IterableOps)((IterableOps)this.classConstantReferences().$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.fieldTypes()))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.methodTypes()))).$plus$plus(this.annotationsReferences())).toSet();
            }

            private String[] getTypes(FieldOrMethodInfo[] fieldsOrMethods) {
                return (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])fieldsOrMethods), (Function1 & Serializable)fieldOrMethod -> Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$descriptorToTypes(fieldOrMethod.descriptor()), ClassTag$.MODULE$.apply(String.class));
            }

            private String[] fieldTypes() {
                return this.getTypes(this.fields());
            }

            private String[] methodTypes() {
                return this.getTypes(this.methods());
            }

            private List<String> annotationsReferences() {
                AttributeInfo[] allAttributes = (AttributeInfo[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.attributes()), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.fields()), (Function1 & Serializable)x$2 -> x$2.attributes(), ClassTag$.MODULE$.apply(AttributeInfo.class)), ClassTag$.MODULE$.apply(AttributeInfo.class))), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.methods()), (Function1 & Serializable)x$3 -> x$3.attributes(), ClassTag$.MODULE$.apply(AttributeInfo.class)), ClassTag$.MODULE$.apply(AttributeInfo.class));
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allAttributes), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$annotationsReferences$3(x)))), (Function1 & Serializable)attr -> {
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(attr.value()));
                    int numAnnotations = in.readUnsignedShort();
                    ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numAnnotations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
                        int n = x$7;
                        this.parseAnnotation$1(result, in);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                    return (ListBuffer)result.map((Function1 & Serializable)name -> StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 1, name.length() - 1));
                }, ClassTag$.MODULE$.apply(String.class))).toList();
            }

            private List<String> classConstantReferences() {
                return this.constants().flatMap((Function1 & Serializable)constant -> {
                    List list;
                    byte by = constant.tag();
                    switch (by) {
                        case 7: {
                            String name = this.toUTF8(constant.nameIndex());
                            if (name.startsWith("[")) {
                                list = Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$descriptorToTypes((Option<String>)new Some((Object)name));
                                break;
                            }
                            String string = Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(name);
                            list = package$.MODULE$.Nil().$colon$colon((Object)string);
                            break;
                        }
                        default: {
                            list = package$.MODULE$.Nil();
                            break;
                        }
                    }
                    return list;
                });
            }

            private List<Constant> constants() {
                return this.next$1(1, (List)package$.MODULE$.Nil());
            }

            public static final /* synthetic */ boolean $anonfun$sourceFile$1(AttributeInfo x$1) {
                return x$1.isSourceFile();
            }

            public static final /* synthetic */ boolean $anonfun$annotationsReferences$3(AttributeInfo x) {
                return x.isRuntimeVisibleAnnotations() || x.isRuntimeInvisibleAnnotations();
            }

            private final void parseElementValue$1(DataInputStream in$2, ListBuffer result$1) {
                char c;
                char c2 = c = (char)in$2.readUnsignedByte();
                switch (c2) {
                    case 'e': {
                        result$1.$plus$eq((Object)Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(in$2.readUnsignedShort())));
                        int n = in$2.readUnsignedShort();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        break;
                    }
                    case 'c': {
                        result$1.$plus$eq((Object)Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(in$2.readUnsignedShort())));
                        break;
                    }
                    case '@': {
                        this.parseAnnotation$1(result$1, in$2);
                        break;
                    }
                    case '[': {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), in$2.readUnsignedShort()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
                            int n = x$5;
                            this.parseElementValue$1(in$2, result$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                        break;
                    }
                }
            }

            private final void parseAnnotation$1(ListBuffer result$1, DataInputStream in$2) {
                result$1.$plus$eq((Object)Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$slashesToDots(this.toUTF8(in$2.readUnsignedShort())));
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), in$2.readUnsignedShort()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
                    int n = x$6;
                    in$2.readUnsignedShort();
                    this.parseElementValue$1(in$2, result$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            }

            private final List next$1(int i, List list) {
                while (i < this.constantPool().length) {
                    Constant constant;
                    Constant constant2 = constant;
                    list = list.$colon$colon((Object)constant2);
                    constant = this.constantPool()[i];
                    i = constant.wide() ? i + 2 : i + 1;
                }
                return list;
            }
            {
                this.in$1 = in$1;
                ClassFile.$init$(this);
                this.minorVersion = in$1.readUnsignedShort();
                this.majorVersion = in$1.readUnsignedShort();
                this.constantPool = Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$parseConstantPool(in$1);
                this.accessFlags = in$1.readUnsignedShort();
                this.className = this.getClassConstantName(in$1.readUnsignedShort());
                log$4.debug((Function0 & Serializable)() -> new StringBuilder(32).append("[zinc] classfile.Parser parsing ").append(this.className()).toString());
                this.superClassName = this.getClassConstantName(in$1.readUnsignedShort());
                this.interfaceNames = (String[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.getClassConstantName($this.in$1.readUnsignedShort()), ManifestFactory$.MODULE$.classType(String.class));
                this.fields = this.readFieldsOrMethods();
                this.methods = this.readFieldsOrMethods();
                this.attributes = (AttributeInfo[])Parser$.MODULE$.sbt$internal$inc$classfile$Parser$$array(in$1.readUnsignedShort(), (Function0 & Serializable)() -> this.parseAttribute(), ManifestFactory$.MODULE$.classType(AttributeInfo.class));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$annotationsReferences$1(sbt.internal.inc.classfile.FieldOrMethodInfo ), $anonfun$annotationsReferences$2(sbt.internal.inc.classfile.FieldOrMethodInfo ), $anonfun$annotationsReferences$3$adapted(sbt.internal.inc.classfile.AttributeInfo ), $anonfun$annotationsReferences$4(sbt.internal.inc.classfile.Parser$$anon$1 sbt.internal.inc.classfile.AttributeInfo ), $anonfun$annotationsReferences$5(sbt.internal.inc.classfile.Parser$$anon$1 java.io.DataInputStream scala.collection.mutable.ListBuffer int ), $anonfun$annotationsReferences$6(sbt.internal.inc.classfile.Parser$$anon$1 java.io.DataInputStream scala.collection.mutable.ListBuffer int ), $anonfun$annotationsReferences$7(sbt.internal.inc.classfile.Parser$$anon$1 scala.collection.mutable.ListBuffer java.io.DataInputStream int ), $anonfun$annotationsReferences$8(java.lang.String ), $anonfun$attributes$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$classConstantReferences$1(sbt.internal.inc.classfile.Parser$$anon$1 sbt.internal.inc.classfile.Constant ), $anonfun$getTypes$1(sbt.internal.inc.classfile.FieldOrMethodInfo ), $anonfun$interfaceNames$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$new$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$parseAttribute$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$parseFieldOrMethodInfo$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$readFieldsOrMethods$1(sbt.internal.inc.classfile.Parser$$anon$1 ), $anonfun$sourceFile$1$adapted(sbt.internal.inc.classfile.AttributeInfo ), $anonfun$sourceFile$2(sbt.internal.inc.classfile.Parser$$anon$1 sbt.internal.inc.classfile.AttributeInfo ), $anonfun$toUTF8$1(int )}, serializedLambda);
            }
        };
    }

    public <T> Object sbt$internal$inc$classfile$Parser$$array(int size, Function0<T> f, Manifest<T> evidence$1) {
        return Array$.MODULE$.tabulate(size, (Function1 & Serializable)x$8 -> f.apply(), evidence$1);
    }

    /*
     * WARNING - void declaration
     */
    public Constant[] sbt$internal$inc$classfile$Parser$$parseConstantPool(DataInputStream in) {
        void var3_3;
        int constantPoolSize = in.readUnsignedShort();
        Constant[] pool = new Constant[constantPoolSize];
        this.parse$1(1, constantPoolSize, in, pool);
        return var3_3;
    }

    private Constant getConstant(DataInputStream in) {
        Constant constant;
        byte tag;
        byte by = tag = in.readByte();
        switch (by) {
            case 7: 
            case 8: {
                constant = new Constant(tag, in.readUnsignedShort());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                constant = new Constant(tag, in.readUnsignedShort(), in.readUnsignedShort());
                break;
            }
            case 3: {
                constant = new Constant(tag, (Object)in.readInt());
                break;
            }
            case 4: {
                constant = new Constant(tag, Float.valueOf(in.readFloat()));
                break;
            }
            case 5: {
                constant = new Constant(tag, in.readLong());
                break;
            }
            case 6: {
                constant = new Constant(tag, in.readDouble());
                break;
            }
            case 1: {
                constant = new Constant(tag, in.readUTF());
                break;
            }
            case 15: {
                in.readByte();
                in.readUnsignedShort();
                constant = new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
                break;
            }
            case 16: {
                in.readUnsignedShort();
                constant = new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
                break;
            }
            case 18: {
                in.readUnsignedShort();
                in.readUnsignedShort();
                constant = new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
                break;
            }
            case 19: {
                in.readUnsignedShort();
                constant = new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
                break;
            }
            case 20: {
                in.readUnsignedShort();
                constant = new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
                break;
            }
            case 17: {
                in.readUnsignedShort();
                in.readUnsignedShort();
                constant = new Constant(tag, -1, -1, (Option<Object>)None$.MODULE$);
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(18).append("Unknown constant: ").append(tag).toString());
            }
        }
        return constant;
    }

    private int toInt(byte v) {
        return v < 0 ? v + 256 : v;
    }

    private int u2(byte highByte, byte lowByte) {
        return this.toInt(highByte) * 256 + this.toInt(lowByte);
    }

    public int entryIndex(AttributeInfo a) {
        Object object;
        byte[] byArray = a.value();
        if (byArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)byArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(44).append("Expected two bytes for unsigned value; got: ").append(a.value().length).toString());
        }
        byte v0 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
        byte v1 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
        int n = this.u2(v0, v1);
        return n;
    }

    public String sbt$internal$inc$classfile$Parser$$slashesToDots(String s) {
        return s.replace('/', '.');
    }

    public List<String> sbt$internal$inc$classfile$Parser$$descriptorToTypes(Option<String> descriptor) {
        return this.toTypes$1((String)descriptor.getOrElse((Function0 & Serializable)() -> ""), (List)package$.MODULE$.Nil());
    }

    private final void parse$1(int i, int constantPoolSize$1, DataInputStream in$3, Constant[] pool$1) {
        while (i < constantPoolSize$1) {
            Constant constant;
            pool$1[i] = constant = this.getConstant(in$3);
            i = constant.wide() ? i + 2 : i + 1;
        }
    }

    private final List toTypes$1(String descriptor, List types) {
        int startIndex;
        while ((startIndex = descriptor.indexOf(76)) >= 0) {
            String tpe;
            int endIndex = descriptor.indexOf(59, startIndex + 1);
            String string = tpe = this.sbt$internal$inc$classfile$Parser$$slashesToDots(descriptor.substring(startIndex + 1, endIndex));
            types = types.$colon$colon((Object)string);
            descriptor = descriptor.substring(endIndex);
        }
        return types;
    }

    private Parser$() {
    }
}

