/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.binary.converters;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import sbt.internal.inc.APIs;
import sbt.internal.inc.APIs$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.Compilation;
import sbt.internal.inc.Compilations;
import sbt.internal.inc.Compilations$;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.ExternalDependencies;
import sbt.internal.inc.FarmHash$;
import sbt.internal.inc.Hash$;
import sbt.internal.inc.InternalDependencies;
import sbt.internal.inc.LastModified;
import sbt.internal.inc.RelationBuilder;
import sbt.internal.inc.Relations;
import sbt.internal.inc.Relations$;
import sbt.internal.inc.Schema;
import sbt.internal.inc.SourceInfos;
import sbt.internal.inc.SourceInfos$;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.UsedName;
import sbt.internal.inc.UsedName$;
import sbt.internal.inc.binary.converters.InternalApiProxy$Modifiers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$EmptyLazyCompanions$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$Readers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$ReadersConstants$;
import sbt.internal.util.Relation;
import sbt.util.InterfaceUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import xsbti.Position;
import xsbti.Problem;
import xsbti.Severity;
import xsbti.T2;
import xsbti.UseScope;
import xsbti.VirtualFileRef;
import xsbti.api.Access;
import xsbti.api.AnalyzedClass;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.AnnotationArgument;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Companions;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.DefinitionType;
import xsbti.api.DependencyContext;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Lazy;
import xsbti.api.MethodParameter;
import xsbti.api.Modifiers;
import xsbti.api.NameHash;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualifier;
import xsbti.api.SafeLazyProxy$;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;
import xsbti.compile.CompileOrder;
import xsbti.compile.FileHash;
import xsbti.compile.MiniOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.OutputGroup;
import xsbti.compile.analysis.ReadMapper;
import xsbti.compile.analysis.SourceInfo;
import xsbti.compile.analysis.Stamp;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015e\u0001\u0002\u001e<\u0005\u0019C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t1\u0002\u0011\t\u0011)A\u00053\")\u0011\r\u0001C\u0001E\")q\r\u0001C\u0001Q\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002f\u0001!\t!a\u001a\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003Dq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002f\u0002!\t!a:\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0001b\u0002B\u000e\u0001\u0011\u0005!Q\u0004\u0005\b\u0005[\u0001A\u0011\u0001B\u0018\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007BqA!\u0016\u0001\t\u0003\u00119\u0006C\u0004\u0003d\u0001!\tA!\u001a\u0007\r\t5\u0004!\u0001B8\u0011)\u0011\u0019(\u0007B\u0001B\u0003%!Q\u000f\u0005\u0007Cf!\tAa&\t\u000f\t}\u0015\u0004\"\u0001\u0003\"\"I!Q\u001a\u0001\u0002\u0002\u0013\r!q\u001a\u0004\u0007\u0005;\u0004\u0011Aa8\t\u0015\t\rhD!A!\u0002\u0013\u0011)\u000f\u0003\u0004b=\u0011\u0005!1\u001e\u0005\b\u0005ctB\u0011\u0001Bz\u0011%\u0019Y\u0001AA\u0001\n\u0007\u0019i\u0001C\u0004\u0004\u001c\u0001!\ta!\b\t\u000f\r=\u0002\u0001\"\u0001\u00042!91\u0011\t\u0001\u0005\u0002\r\r\u0003bBB.\u0001\u0011\u00051Q\f\u0005\b\u0007[\u0002A\u0011AB8\u0011\u001d\u0019y\b\u0001C\u0001\u0007\u0003Cqa!%\u0001\t\u0003\u0019\u0019\nC\u0004\u0004$\u0002!\ta!*\t\u000f\rU\u0006\u0001\"\u0001\u00048\"91q\u0019\u0001\u0005\u0002\r%\u0007bBBm\u0001\u0011\u000511\u001c\u0005\b\u0007[\u0004A\u0011ABx\u0011%!Y\u0001\u0001b\u0001\n\u001b!i\u0001\u0003\u0005\u0005\u0012\u0001\u0001\u000bQ\u0002C\b\u0011%!\u0019\u0002\u0001b\u0001\n\u001b!)\u0002\u0003\u0005\u0005\u001a\u0001\u0001\u000bQ\u0002C\f\u0011%!Y\u0002\u0001b\u0001\n\u001b!i\u0002\u0003\u0005\u0005\"\u0001\u0001\u000bQ\u0002C\u0010\u0011\u001d!\u0019\u0003\u0001C\u0001\tKAq\u0001\"\u000e\u0001\t\u0003!9\u0004C\u0004\u0005L\u0001!\t\u0001\"\u0014\t\u000f\u0011\u0005\u0004\u0001\"\u0001\u0005d!9A\u0011\u000f\u0001\u0005\u0002\u0011M$a\u0004)s_R|'-\u001e4SK\u0006$WM]:\u000b\u0005qj\u0014AC2p]Z,'\u000f^3sg*\u0011ahP\u0001\u0007E&t\u0017M]=\u000b\u0005\u0001\u000b\u0015aA5oG*\u0011!iQ\u0001\tS:$XM\u001d8bY*\tA)A\u0002tER\u001c\u0001a\u0005\u0002\u0001\u000fB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\fa!\\1qa\u0016\u0014\bCA(W\u001b\u0005\u0001&BA)S\u0003!\tg.\u00197zg&\u001c(BA*U\u0003\u001d\u0019w.\u001c9jY\u0016T\u0011!V\u0001\u0006qN\u0014G/[\u0005\u0003/B\u0013!BU3bI6\u000b\u0007\u000f]3s\u00039\u0019WO\u001d:f]R4VM]:j_:\u0004\"A\u00170\u000f\u0005mcV\"A \n\u0005u{\u0014AB*dQ\u0016l\u0017-\u0003\u0002`A\n9a+\u001a:tS>t'BA/@\u0003\u0019a\u0014N\\5u}Q\u00191-\u001a4\u0011\u0005\u0011\u0004Q\"A\u001e\t\u000b5\u001b\u0001\u0019\u0001(\t\u000ba\u001b\u0001\u0019A-\u0002\u001d\u0019\u0014x.\u001c)bi\"\u001cFO]5oOR\u0011\u0011n\u001d\t\u0003UFl\u0011a\u001b\u0006\u0003Y6\fAAZ5mK*\u0011an\\\u0001\u0004]&|'\"\u00019\u0002\t)\fg/Y\u0005\u0003e.\u0014A\u0001U1uQ\")A\u000f\u0002a\u0001k\u0006!\u0001/\u0019;i!\t1XP\u0004\u0002xwB\u0011\u00010S\u0007\u0002s*\u0011!0R\u0001\u0007yI|w\u000e\u001e \n\u0005qL\u0015A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001`%\u0002\u001f\u0019\u0014x.\u001c)bi\"\u001cFO]5oOZ#B!!\u0002\u0002\u000eA!\u0011qAA\u0005\u001b\u0005!\u0016bAA\u0006)\nqa+\u001b:uk\u0006dg)\u001b7f%\u00164\u0007\"\u0002;\u0006\u0001\u0004)\u0018!\u00044s_6\u001cF/Y7q)f\u0004X\r\u0006\u0003\u0002\u0014\u0005e\u0001cA(\u0002\u0016%\u0019\u0011q\u0003)\u0003\u000bM#\u0018-\u001c9\t\u000f\u0005ma\u00011\u0001\u0002\u001e\u0005I1\u000f^1naRK\b/\u001a\t\u0005\u0003?\t)CD\u0002[\u0003CI1!a\ta\u0003\u0019\u0019F/Y7qg&!\u0011qEA\u0015\u0005%\u0019F/Y7q)f\u0004XMC\u0002\u0002$\u0001\f!B\u001a:p[N#\u0018-\u001c9t)\u0011\ty#!\u000e\u0011\u0007m\u000b\t$C\u0002\u00024}\u0012aa\u0015;b[B\u001c\bbBA\u001c\u000f\u0001\u0007\u0011\u0011H\u0001\u0007gR\fW\u000e]:\u0011\u0007i\u000bY$C\u0002\u00024\u0001\fqB\u001a:p[>+H\u000f];u\u000fJ|W\u000f\u001d\u000b\u0005\u0003\u0003\nI\u0005\u0005\u0003\u0002D\u0005\u0015S\"\u0001*\n\u0007\u0005\u001d#KA\u0006PkR\u0004X\u000f^$s_V\u0004\bbBA&\u0011\u0001\u0007\u0011QJ\u0001\f_V$\b/\u001e;He>,\b\u000fE\u0002[\u0003\u001fJ1!a\u0012a\u0003U1'o\\7D_6\u0004\u0018\u000e\\1uS>tw*\u001e;qkR$B!!\u0016\u0002\\A!\u00111IA,\u0013\r\tIF\u0015\u0002\u0007\u001fV$\b/\u001e;\t\u000f\u0005u\u0013\u00021\u0001\u0002`\u0005\t1\rE\u0002[\u0003CJ1!a\u0019a\u0005-\u0019u.\u001c9jY\u0006$\u0018n\u001c8\u0002\u001f\u0019\u0014x.\\\"p[BLG.\u0019;j_:$B!!\u001b\u0002nA\u0019q*a\u001b\n\u0007\u0005\r\u0004\u000bC\u0004\u0002p)\u0001\r!a\u0018\u0002\u0017\r|W\u000e]5mCRLwN\\\u0001\u0011MJ|WnQ8na&d\u0017\r^5p]N$B!!\u001e\u0002|A\u00191,a\u001e\n\u0007\u0005etH\u0001\u0007D_6\u0004\u0018\u000e\\1uS>t7\u000fC\u0004\u0002~-\u0001\r!a \u0002\u001b\r|W\u000e]5mCRLwN\\:1!\rQ\u0016\u0011Q\u0005\u0004\u0003s\u0002\u0017\u0001\u00044s_6\u0004vn]5uS>tG\u0003BAD\u0003\u001b\u0003B!a\u0002\u0002\n&\u0019\u00111\u0012+\u0003\u0011A{7/\u001b;j_:Dq!a$\r\u0001\u0004\t\t*\u0001\u0005q_NLG/[8o!\rQ\u00161S\u0005\u0004\u0003\u0017\u0003\u0017\u0001\u00044s_6\u001cVM^3sSRLHCBAM\u0003?\u000b9\u000b\u0005\u0003\u0002\b\u0005m\u0015bAAO)\nA1+\u001a<fe&$\u0018\u0010C\u0004\u0002\"6\u0001\r!a)\u0002\u0011M,g/\u001a:jif\u00042AWAS\u0013\r\ti\n\u0019\u0005\b\u0003Sk\u0001\u0019AAV\u0003\tIG\rE\u0002I\u0003[K1!a,J\u0005\rIe\u000e^\u0001\u000bMJ|Wn\u0015;sS:<G\u0003BA[\u0003w\u0003B\u0001SA\\k&\u0019\u0011\u0011X%\u0003\r=\u0003H/[8o\u0011\u0019\tiL\u0004a\u0001k\u0006)a/\u00197vK\u00069aM]8n\u0013:$H\u0003BAb\u0003#\u0004R\u0001SA\\\u0003\u000b\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017|\u0017\u0001\u00027b]\u001eLA!a4\u0002J\n9\u0011J\u001c;fO\u0016\u0014\bbBA_\u001f\u0001\u0007\u00111V\u0001\fMJ|W\u000e\u0015:pE2,W\u000e\u0006\u0003\u0002X\u0006u\u0007\u0003BA\u0004\u00033L1!a7U\u0005\u001d\u0001&o\u001c2mK6Dq!a8\u0011\u0001\u0004\t\t/A\u0004qe>\u0014G.Z7\u0011\u0007i\u000b\u0019/C\u0002\u0002\\\u0002\faB\u001a:p[N{WO]2f\u0013:4w\u000e\u0006\u0003\u0002j\u0006=\bcA(\u0002l&\u0019\u0011Q\u001e)\u0003\u0015M{WO]2f\u0013:4w\u000eC\u0004\u0002rF\u0001\r!a=\u0002\u0015M|WO]2f\u0013:4w\u000eE\u0002[\u0003kL1!!<a\u0003=1'o\\7T_V\u00148-Z%oM>\u001cH\u0003BA~\u0005\u0003\u00012aWA\u007f\u0013\r\typ\u0010\u0002\f'>,(oY3J]\u001a|7\u000fC\u0004\u0003\u0004I\u0001\rA!\u0002\u0002\u0019M|WO]2f\u0013:4wn\u001d\u0019\u0011\u0007i\u00139!C\u0002\u0002\u0000\u0002\fQC\u001a:p[\u000ec\u0017m]:qCRDg)\u001b7f\u0011\u0006\u001c\b\u000e\u0006\u0003\u0003\u000e\tM\u0001\u0003BA\"\u0005\u001fI1A!\u0005S\u0005!1\u0015\u000e\\3ICND\u0007b\u0002B\u000b'\u0001\u0007!qC\u0001\tM&dW\rS1tQB\u0019!L!\u0007\n\u0007\tE\u0001-A\bge>lW*\u001b8j\u001fB$\u0018n\u001c8t)\u0011\u0011yB!\n\u0011\t\u0005\r#\u0011E\u0005\u0004\u0005G\u0011&aC'j]&|\u0005\u000f^5p]NDqAa\n\u0015\u0001\u0004\u0011I#A\u0006nS:Lw\n\u001d;j_:\u001c\bc\u0001.\u0003,%\u0019!1\u00051\u0002!\u0019\u0014x.\\\"p[BLG.Z(sI\u0016\u0014HC\u0002B\u0019\u0005o\u0011y\u0004\u0005\u0003\u0002D\tM\u0012b\u0001B\u001b%\na1i\\7qS2,wJ\u001d3fe\"9!\u0011H\u000bA\u0002\tm\u0012\u0001D2p[BLG.Z(sI\u0016\u0014\bc\u0001.\u0003>%\u0019!Q\u00071\t\u000f\u0005%V\u00031\u0001\u0002,\u0006yaM]8n'R\u0014\u0018N\\4UkBdW\r\u0006\u0003\u0003F\t-\u0003CBA\u0004\u0005\u000f*X/C\u0002\u0003JQ\u0013!\u0001\u0016\u001a\t\u000f\t5c\u00031\u0001\u0003P\u0005)A/\u001e9mKB\u0019!L!\u0015\n\u0007\tM\u0003MA\u0003UkBdW-A\nge>lW*\u001b8j'\u0016$X\u000f](viB,H\u000f\u0006\u0003\u0002V\te\u0003b\u0002B./\u0001\u0007!QL\u0001\n[&t\u0017nU3ukB\u00042A\u0017B0\u0013\r\u0011\t\u0007\u0019\u0002\n\u001b&t\u0017nU3ukB\fQB\u001a:p[6Kg.[*fiV\u0004H\u0003\u0002B4\u0005W\u0002B!a\u0011\u0003j%\u0019!\u0011\r*\t\u000f\tm\u0003\u00041\u0001\u0003^\t\tRI\u001a4jG&,g\u000e\u001e+sCZ,'o]3\u0016\t\tE$QQ\n\u00033\u001d\u000b1a]3r!\u0019\u00119H! \u0003\u00026\u0011!\u0011\u0010\u0006\u0004\u0005wz\u0017\u0001B;uS2LAAa \u0003z\t!A*[:u!\u0011\u0011\u0019I!\"\r\u0001\u00119!qQ\rC\u0002\t%%!\u0001+\u0012\t\t-%\u0011\u0013\t\u0004\u0011\n5\u0015b\u0001BH\u0013\n9aj\u001c;iS:<\u0007c\u0001%\u0003\u0014&\u0019!QS%\u0003\u0007\u0005s\u0017\u0010\u0006\u0003\u0003\u001a\nu\u0005#\u0002BN3\t\u0005U\"\u0001\u0001\t\u000f\tM4\u00041\u0001\u0003v\u0005YAo\u001c.j]\u000e\f%O]1z+\u0011\u0011\u0019Ka,\u0015\t\t\u0015&1\u0019\u000b\u0005\u0005O\u0013\u0019\fE\u0003I\u0005S\u0013i+C\u0002\u0003,&\u0013Q!\u0011:sCf\u0004BAa!\u00030\u00129!\u0011\u0017\u000fC\u0002\t%%!\u0001*\t\u0013\tUF$!AA\u0004\t]\u0016AC3wS\u0012,gnY3%cA1!\u0011\u0018B`\u0005[k!Aa/\u000b\u0007\tu\u0016*A\u0004sK\u001adWm\u0019;\n\t\t\u0005'1\u0018\u0002\t\u00072\f7o\u001d+bO\"9!Q\u0019\u000fA\u0002\t\u001d\u0017!\u00014\u0011\u000f!\u0013IM!!\u0003.&\u0019!1Z%\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!E#gM&\u001c\u0017.\u001a8u)J\fg/\u001a:tKV!!\u0011\u001bBl)\u0011\u0011\u0019N!7\u0011\u000b\tm\u0015D!6\u0011\t\t\r%q\u001b\u0003\b\u0005\u000fk\"\u0019\u0001BE\u0011\u001d\u0011\u0019(\ba\u0001\u00057\u0004bAa\u001e\u0003~\tU'\u0001D(qi&|gNU3bI\u0016\u0014X\u0003\u0002Bq\u0005S\u001c\"AH$\u0002\r=\u0004H/[8o!\u0015A\u0015q\u0017Bt!\u0011\u0011\u0019I!;\u0005\u000f\t\u001deD1\u0001\u0003\nR!!Q\u001eBx!\u0015\u0011YJ\bBt\u0011\u001d\u0011\u0019\u000f\ta\u0001\u0005K\fAA]3bIV!!Q\u001fB})\u0019\u00119Pa?\u0004\u0002A!!1\u0011B}\t\u001d\u0011\t,\tb\u0001\u0005\u0013CqA!@\"\u0001\u0004\u0011y0\u0001\u0003ge>l\u0007c\u0002%\u0003J\n\u001d(q\u001f\u0005\t\u0007\u0007\tC\u00111\u0001\u0004\u0006\u0005aQM\u001d:pe6+7o]1hKB!\u0001ja\u0002v\u0013\r\u0019I!\u0013\u0002\ty\tLh.Y7f}\u0005aq\n\u001d;j_:\u0014V-\u00193feV!1qBB\u000b)\u0011\u0019\tba\u0006\u0011\u000b\tmeda\u0005\u0011\t\t\r5Q\u0003\u0003\b\u0005\u000f\u0013#\u0019\u0001BE\u0011\u001d\u0011\u0019O\ta\u0001\u00073\u0001R\u0001SA\\\u0007'\t\u0001B\u001a:p[B\u000bG\u000f\u001b\u000b\u0005\u0007?\u0019I\u0003\u0005\u0003\u0004\"\r\u001dRBAB\u0012\u0015\r\u0019)\u0003V\u0001\u0004CBL\u0017b\u0001:\u0004$!1Ao\ta\u0001\u0007W\u00012AWB\u0017\u0013\t\u0011\b-\u0001\bge>l\u0017I\u001c8pi\u0006$\u0018n\u001c8\u0015\t\rM2\u0011\b\t\u0005\u0007C\u0019)$\u0003\u0003\u00048\r\r\"AC!o]>$\u0018\r^5p]\"911\b\u0013A\u0002\ru\u0012AC1o]>$\u0018\r^5p]B\u0019!la\u0010\n\u0007\r]\u0002-A\u0007ge>l7\u000b\u001e:vGR,(/\u001a\u000b\u0005\u0007\u000b\u001aY\u0005\u0005\u0003\u0004\"\r\u001d\u0013\u0002BB%\u0007G\u0011\u0011b\u0015;sk\u000e$XO]3\t\u000f\r5S\u00051\u0001\u0004P\u0005\u0019A\u000f]3\u0011\t\rE3q\u000b\b\u00045\u000eM\u0013bAB+A\u0006!A+\u001f9f\u0013\u0011\u0019Ie!\u0017\u000b\u0007\rU\u0003-\u0001\u0005ge>lG+\u001f9f)\u0011\u0019yf!\u001a\u0011\t\r\u00052\u0011M\u0005\u0005\u0007G\u001a\u0019C\u0001\u0003UsB,\u0007bBB4M\u0001\u00071\u0011N\u0001\u0005if\u0004X\rE\u0002[\u0007WJ1aa\u0019a\u000351'o\\7N_\u0012Lg-[3sgR!1\u0011OB<!\u0011\u0019\tca\u001d\n\t\rU41\u0005\u0002\n\u001b>$\u0017NZ5feNDqa!\u001f(\u0001\u0004\u0019Y(A\u0005n_\u0012Lg-[3sgB\u0019!l! \n\u0007\rU\u0004-\u0001\u0006ge>l\u0017iY2fgN$Baa!\u0004\nB!1\u0011EBC\u0013\u0011\u00199ia\t\u0003\r\u0005\u001b7-Z:t\u0011\u001d\u0019Y\t\u000ba\u0001\u0007\u001b\u000ba!Y2dKN\u001c\bc\u0001.\u0004\u0010&\u00191q\u00111\u0002%\u0019\u0014x.\u001c#fM&t\u0017\u000e^5p]RK\b/\u001a\u000b\u0005\u0007+\u001bY\n\u0005\u0003\u0004\"\r]\u0015\u0002BBM\u0007G\u0011a\u0002R3gS:LG/[8o)f\u0004X\rC\u0004\u0004\u001e&\u0002\raa(\u0002\u001d\u0011,g-\u001b8ji&|g\u000eV=qKB\u0019!l!)\n\u0007\re\u0005-A\nge>l7\t\\1tg\u0012+g-\u001b8ji&|g\u000e\u0006\u0003\u0004(\u000e5\u0006\u0003BB\u0011\u0007SKAaa+\u0004$\ty1\t\\1tg\u0012+g-\u001b8ji&|g\u000eC\u0004\u00040*\u0002\ra!-\u0002\u001f\rd\u0017m]:EK\u001aLg.\u001b;j_:\u00042AWBZ\u0013\r\u0019Y\u000bY\u0001\u0012MJ|W\u000eV=qKB\u000b'/Y7fi\u0016\u0014H\u0003BB]\u0007\u007f\u0003Ba!\t\u0004<&!1QXB\u0012\u00055!\u0016\u0010]3QCJ\fW.\u001a;fe\"91\u0011Y\u0016A\u0002\r\r\u0017!\u0004;za\u0016\u0004\u0016M]1nKR,'\u000fE\u0002[\u0007\u000bL1a!0a\u000351'o\\7DY\u0006\u001c8\u000fT5lKR!11ZBi!\u0011\u0019\tc!4\n\t\r=71\u0005\u0002\n\u00072\f7o\u001d'jW\u0016Dqaa5-\u0001\u0004\u0019).A\u0005dY\u0006\u001c8\u000fT5lKB\u0019!la6\n\u0007\r=\u0007-\u0001\u0007ge>lWk]3TG>\u0004X\r\u0006\u0004\u0004^\u000e\r81\u001e\t\u0005\u0003\u000f\u0019y.C\u0002\u0004bR\u0013\u0001\"V:f'\u000e|\u0007/\u001a\u0005\b\u0007Kl\u0003\u0019ABt\u0003!)8/Z*d_B,\u0007c\u0001.\u0004j&\u00191\u0011\u001d1\t\u000f\u0005%V\u00061\u0001\u0002,\u0006\tbM]8n\u0003:\fG.\u001f>fI\u000ec\u0017m]:\u0015\t\rEH\u0011\u0001\u000b\u0005\u0007g\u001cI\u0010\u0005\u0003\u0004\"\rU\u0018\u0002BB|\u0007G\u0011Q\"\u00118bYfTX\rZ\"mCN\u001c\bbBB~]\u0001\u00071Q`\u0001\u000eC:\fG.\u001f>fI\u000ec\u0017m]:\u0011\u0007i\u001by0C\u0002\u0004x\u0002Dq\u0001b\u0001/\u0001\u0004!)!A\btQ>,H\u000eZ*u_J,\u0017\t]5t!\rAEqA\u0005\u0004\t\u0013I%a\u0002\"p_2,\u0017M\\\u0001\tgR\u0014\u0018N\\4JIV\u0011Aq\u0002\t\u0006\u0011\n%W/^\u0001\ngR\u0014\u0018N\\4JI\u0002\nAb\u001d;sS:<Gk\u001c$jY\u0016,\"\u0001b\u0006\u0011\u000b!\u0013I-^5\u0002\u001bM$(/\u001b8h)>4\u0015\u000e\\3!\u00035\u0019HO]5oOR{gKR5mKV\u0011Aq\u0004\t\u0007\u0011\n%W/!\u0002\u0002\u001dM$(/\u001b8h)>4f)\u001b7fA\u0005iaM]8n%\u0016d\u0017\r^5p]N$B\u0001b\n\u0005.A\u00191\f\"\u000b\n\u0007\u0011-rHA\u0005SK2\fG/[8og\"9AqF\u001bA\u0002\u0011E\u0012!\u0003:fY\u0006$\u0018n\u001c8t!\rQF1G\u0005\u0004\tW\u0001\u0017\u0001\u00034s_6\f\u0005/[:\u0015\t\u0011eB\u0011\n\u000b\u0005\tw!\t\u0005E\u0002\\\t{I1\u0001b\u0010@\u0005\u0011\t\u0005+S:\t\u000f\u0011\rc\u00071\u0001\u0005F\u0005!\u0011\r]5t!\rQFqI\u0005\u0004\t\u007f\u0001\u0007b\u0002C\u0002m\u0001\u0007AQA\u0001\rMJ|W.\u00119jg\u001aKG.\u001a\u000b\u0007\t\u001f\")\u0006b\u0018\u0011\r!#\t\u0006b\u000fZ\u0013\r!\u0019&\u0013\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0011]s\u00071\u0001\u0005Z\u0005A\u0011\r]5t\r&dW\rE\u0002[\t7J1\u0001\"\u0018a\u0005!\t\u0005+S:GS2,\u0007b\u0002C\u0002o\u0001\u0007AQA\u0001\rMJ|W.\u00118bYf\u001c\u0018n\u001d\u000b\u0005\tK\"Y\u0007E\u0002\\\tOJ1\u0001\"\u001b@\u0005!\te.\u00197zg&\u001c\bBB)9\u0001\u0004!i\u0007E\u0002[\t_J1\u0001\"\u001ba\u0003A1'o\\7B]\u0006d\u0017p]5t\r&dW\r\u0006\u0003\u0005v\u0011m\u0004\u0003\u0003%\u0005x\u0011\u0015$qM-\n\u0007\u0011e\u0014J\u0001\u0004UkBdWm\r\u0005\b\t{J\u0004\u0019\u0001C@\u00031\tg.\u00197zg&\u001ch)\u001b7f!\rQF\u0011Q\u0005\u0004\t\u0007\u0003'\u0001D!oC2L8/[:GS2,\u0007")
public final class ProtobufReaders {
    private final ReadMapper mapper;
    private final Schema.Version currentVersion;
    private final Function1<String, String> stringId;
    private final Function1<String, java.nio.file.Path> stringToFile;
    private final Function1<String, VirtualFileRef> stringToVFile;

    public java.nio.file.Path fromPathString(String path) {
        return Paths.get(path, new String[0]);
    }

    public VirtualFileRef fromPathStringV(String path) {
        return VirtualFileRef.of((String)path);
    }

    public Stamp fromStampType(Schema.Stamps.StampType stampType) {
        EmptyStamp$ emptyStamp$;
        Schema.Stamps.StampType.TypeCase typeCase = stampType.getTypeCase();
        if (Schema.Stamps.StampType.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            emptyStamp$ = EmptyStamp$.MODULE$;
        } else if (Schema.Stamps.StampType.TypeCase.FARMHASH.equals(typeCase)) {
            emptyStamp$ = FarmHash$.MODULE$.fromLong(stampType.getFarmHash().getHash());
        } else if (Schema.Stamps.StampType.TypeCase.HASH.equals(typeCase)) {
            emptyStamp$ = Hash$.MODULE$.unsafeFromString(stampType.getHash().getHash());
        } else if (Schema.Stamps.StampType.TypeCase.LASTMODIFIED.equals(typeCase)) {
            emptyStamp$ = new LastModified(stampType.getLastModified().getMillis());
        } else {
            throw new MatchError((Object)typeCase);
        }
        return emptyStamp$;
    }

    public Stamps fromStamps(Schema.Stamps stamps) {
        scala.collection.immutable.Map libraries = this.fromBinarySchemaMap$1(stamps.getBinaryStampsMap());
        scala.collection.immutable.Map sources = this.fromSourceSchemaMap$1(stamps.getSourceStampsMap());
        scala.collection.immutable.Map products = this.fromProductSchemaMap$1(stamps.getProductStampsMap());
        return Stamps$.MODULE$.apply(products, sources, libraries);
    }

    public OutputGroup fromOutputGroup(Schema.OutputGroup outputGroup) {
        java.nio.file.Path sourcePath = this.fromPathString(outputGroup.getSourcePath());
        java.nio.file.Path sourceDir = this.mapper.mapSourceDir(sourcePath);
        java.nio.file.Path targetPath = this.fromPathString(outputGroup.getTargetPath());
        java.nio.file.Path targetDir = this.mapper.mapOutputDir(targetPath);
        return CompileOutput$.MODULE$.outputGroup(sourceDir, targetDir);
    }

    public Output fromCompilationOutput(Schema.Compilation c) {
        Output output;
        Schema.Compilation.OutputCase outputCase = c.getOutputCase();
        if (Schema.Compilation.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            Schema.SingleOutput single = c.getSingleOutput();
            java.nio.file.Path target = this.fromPathString(single.getTarget());
            java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
            output = CompileOutput$.MODULE$.apply(outputDir);
        } else if (Schema.Compilation.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = c.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            output = CompileOutput$.MODULE$.apply(groups);
        } else {
            if (Schema.Compilation.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
            }
            throw new MatchError((Object)outputCase);
        }
        return output;
    }

    public xsbti.compile.analysis.Compilation fromCompilation(Schema.Compilation compilation) {
        Output output = this.fromCompilationOutput(compilation);
        return new Compilation(compilation.getStartTimeMillis(), output);
    }

    public Compilations fromCompilations(Schema.Compilations compilations0) {
        Iterator compilations = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(compilations0.getCompilationsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)compilation -> this.fromCompilation((Schema.Compilation)compilation));
        Seq castedCompilations = compilations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Compilation compilation;
            xsbti.compile.analysis.Compilation compilation2 = x0$1;
            if (!(compilation2 instanceof Compilation)) {
                throw new MatchError((Object)compilation2);
            }
            Compilation compilation3 = compilation = (Compilation)compilation2;
            return compilation3;
        }).toSeq();
        return Compilations$.MODULE$.of(castedCompilations);
    }

    public Position fromPosition(Schema.Position position) {
        return InterfaceUtil$.MODULE$.position(this.fromInt(position.getLine()), position.getLineContent(), this.fromInt(position.getOffset()), this.fromInt(position.getPointer()), this.fromString(position.getPointerSpace()), this.fromString(position.getSourcePath()), this.fromString(position.getSourceFilepath()).map((Function1 & Serializable & scala.Serializable)path -> this.fromPathString((String)path)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toFile()), this.fromInt(position.getStartOffset()), this.fromInt(position.getEndOffset()), this.fromInt(position.getStartLine()), this.fromInt(position.getStartColumn()), this.fromInt(position.getEndLine()), this.fromInt(position.getEndColumn()));
    }

    public Severity fromSeverity(Schema.Severity severity, int id) {
        Severity severity2;
        Schema.Severity severity3 = severity;
        if (Schema.Severity.INFO.equals(severity3)) {
            severity2 = Severity.Info;
        } else if (Schema.Severity.WARN.equals(severity3)) {
            severity2 = Severity.Warn;
        } else if (Schema.Severity.ERROR.equals(severity3)) {
            severity2 = Severity.Error;
        } else {
            if (Schema.Severity.UNRECOGNIZED.equals(severity3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedSeverity(id)).$bang$bang();
            }
            throw new MatchError((Object)severity3);
        }
        return severity2;
    }

    private Option<String> fromString(String value) {
        String string = value;
        String string2 = ProtobufDefaults$.MODULE$.MissingString();
        return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)value);
    }

    private Option<Integer> fromInt(int value) {
        return value == ProtobufDefaults$.MODULE$.MissingInt() ? None$.MODULE$ : new Some((Object)Predef$.MODULE$.int2Integer(value));
    }

    public Problem fromProblem(Schema.Problem problem) {
        String category = problem.getCategory();
        String message = problem.getMessage();
        Severity severity = this.fromSeverity(problem.getSeverity(), problem.getSeverityValue());
        if (!problem.hasPosition()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPositionInProblem()).$bang$bang();
        }
        Position position = this.fromPosition(problem.getPosition());
        Option<String> rendered = this.fromString(problem.getRendered());
        return InterfaceUtil$.MODULE$.problem(category, position, message, severity, rendered);
    }

    public SourceInfo fromSourceInfo(Schema.SourceInfo sourceInfo) {
        Seq mainClasses = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)sourceInfo.getMainClassesList()).asScala()).toSeq();
        Seq reportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getReportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        Seq unreportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getUnreportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        return SourceInfos$.MODULE$.makeInfo(reportedProblems, unreportedProblems, mainClasses);
    }

    public SourceInfos fromSourceInfos(Schema.SourceInfos sourceInfos0) {
        Iterator sourceInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sourceInfos0.getSourceInfosMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.SourceInfo value = (Schema.SourceInfo)tuple2._2();
            VirtualFileRef file = $this.mapper.mapSourceFile(this.fromPathStringV(path));
            SourceInfo sourceInfo = this.fromSourceInfo(value);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)sourceInfo);
            return tuple22;
        });
        return SourceInfos$.MODULE$.of(sourceInfos.toMap(Predef$.MODULE$.$conforms()));
    }

    public FileHash fromClasspathFileHash(Schema.FileHash fileHash) {
        int hash = fileHash.getHash();
        java.nio.file.Path classpathEntry = this.fromPathString(fileHash.getPath());
        java.nio.file.Path newClasspathEntry = this.mapper.mapClasspathEntry(classpathEntry);
        return FileHash.of((java.nio.file.Path)newClasspathEntry, (int)hash);
    }

    public MiniOptions fromMiniOptions(Schema.MiniOptions miniOptions) {
        FileHash[] classpathHash = (FileHash[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniOptions.getClasspathHashList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)fileHash -> this.fromClasspathFileHash((Schema.FileHash)fileHash)).toArray(ClassTag$.MODULE$.apply(FileHash.class));
        String[] javacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)miniOptions.getJavacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)javacOption -> $this.mapper.mapJavacOption((String)javacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] scalacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)miniOptions.getScalacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)scalacOption -> $this.mapper.mapScalacOption((String)scalacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        return MiniOptions.of((FileHash[])classpathHash, (String[])scalacOptions, (String[])javacOptions);
    }

    public CompileOrder fromCompileOrder(Schema.CompileOrder compileOrder, int id) {
        CompileOrder compileOrder2;
        Schema.CompileOrder compileOrder3 = compileOrder;
        if (Schema.CompileOrder.MIXED.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.Mixed;
        } else if (Schema.CompileOrder.JAVATHENSCALA.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.JavaThenScala;
        } else if (Schema.CompileOrder.SCALATHENJAVA.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.ScalaThenJava;
        } else {
            if (Schema.CompileOrder.UNRECOGNIZED.equals(compileOrder3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedOrder(id)).$bang$bang();
            }
            throw new MatchError((Object)compileOrder3);
        }
        return compileOrder2;
    }

    public T2<String, String> fromStringTuple(Schema.Tuple tuple) {
        return InterfaceUtil$.MODULE$.t2(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tuple.getFirst()), (Object)tuple.getSecond()));
    }

    public Output fromMiniSetupOutput(Schema.MiniSetup miniSetup) {
        Output output;
        Schema.MiniSetup.OutputCase outputCase = miniSetup.getOutputCase();
        if (Schema.MiniSetup.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            Schema.SingleOutput single = miniSetup.getSingleOutput();
            java.nio.file.Path targetDir = this.fromPathString(single.getTarget());
            java.nio.file.Path outputDir = this.mapper.mapOutputDir(targetDir);
            output = CompileOutput$.MODULE$.apply(outputDir);
        } else if (Schema.MiniSetup.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = miniSetup.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            output = CompileOutput$.MODULE$.apply(groups);
        } else {
            if (Schema.MiniSetup.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
            }
            throw new MatchError((Object)outputCase);
        }
        return output;
    }

    public MiniSetup fromMiniSetup(Schema.MiniSetup miniSetup) {
        Output output = this.fromMiniSetupOutput(miniSetup);
        if (!miniSetup.hasMiniOptions()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedMiniOptionsInSetup()).$bang$bang();
        }
        MiniOptions miniOptions = this.fromMiniOptions(miniSetup.getMiniOptions());
        String compilerVersion = miniSetup.getCompilerVersion();
        CompileOrder compileOrder = this.fromCompileOrder(miniSetup.getCompileOrder(), miniSetup.getCompileOrderValue());
        boolean storeApis = miniSetup.getStoreApis();
        T2[] extra = (T2[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniSetup.getExtraList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)tuple -> this.fromStringTuple((Schema.Tuple)tuple)).toArray(ClassTag$.MODULE$.apply(T2.class));
        MiniSetup original = MiniSetup.of((Output)output, (MiniOptions)miniOptions, (String)compilerVersion, (CompileOrder)compileOrder, (boolean)storeApis, (T2[])extra);
        return this.mapper.mapMiniSetup(original);
    }

    public <T> EfficientTraverse<T> EfficientTraverse(List<T> seq) {
        return new EfficientTraverse<T>(this, seq);
    }

    public <T> OptionReader<T> OptionReader(Option<T> option) {
        return new OptionReader<T>(this, option);
    }

    public Path fromPath(Schema.Path path) {
        PathComponent[] components = (PathComponent[])this.EfficientTraverse(path.getComponentsList()).toZincArray((Function1 & Serializable & scala.Serializable)pathComponent -> this.fromPathComponent$1((Schema.Path.PathComponent)pathComponent), ClassTag$.MODULE$.apply(PathComponent.class));
        return Path.of((PathComponent[])components);
    }

    public Annotation fromAnnotation(Schema.Annotation annotation) {
        AnnotationArgument[] arguments = (AnnotationArgument[])this.EfficientTraverse(annotation.getArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)argument -> ProtobufReaders.fromAnnotationArgument$1(argument), ClassTag$.MODULE$.apply(AnnotationArgument.class));
        None$ b = annotation.hasBase() ? new Some((Object)annotation.getBase()) : None$.MODULE$;
        Type base = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Annotation.class));
        return Annotation.of((Type)base, (AnnotationArgument[])arguments);
    }

    public Structure fromStructure(Schema.Type.Structure tpe) {
        Lazy parents = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getParentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class)));
        Lazy declared = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getDeclaredList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        Lazy inherited = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getInheritedList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        return Structure.of((Lazy)parents, (Lazy)declared, (Lazy)inherited);
    }

    public Type fromType(Schema.Type type) {
        ParameterRef parameterRef;
        Schema.Type.ValueCase valueCase = type.getValueCase();
        if (Schema.Type.ValueCase.PARAMETERREF.equals(valueCase)) {
            parameterRef = ProtobufReaders.fromParameterRef$1(type.getParameterRef());
        } else if (Schema.Type.ValueCase.PARAMETERIZED.equals(valueCase)) {
            parameterRef = this.fromParameterized$1(type.getParameterized());
        } else if (Schema.Type.ValueCase.STRUCTURE.equals(valueCase)) {
            parameterRef = this.fromStructure(type.getStructure());
        } else if (Schema.Type.ValueCase.POLYMORPHIC.equals(valueCase)) {
            parameterRef = this.fromPolymorphic$1(type.getPolymorphic());
        } else if (Schema.Type.ValueCase.CONSTANT.equals(valueCase)) {
            parameterRef = this.fromConstant$1(type.getConstant());
        } else if (Schema.Type.ValueCase.EXISTENTIAL.equals(valueCase)) {
            parameterRef = this.fromExistential$1(type.getExistential());
        } else if (Schema.Type.ValueCase.SINGLETON.equals(valueCase)) {
            parameterRef = this.fromSingleton$1(type.getSingleton());
        } else if (Schema.Type.ValueCase.PROJECTION.equals(valueCase)) {
            parameterRef = this.fromProjection$1(type.getProjection());
        } else if (Schema.Type.ValueCase.ANNOTATED.equals(valueCase)) {
            parameterRef = this.fromAnnotated$1(type.getAnnotated());
        } else if (Schema.Type.ValueCase.EMPTYTYPE.equals(valueCase)) {
            parameterRef = ProtobufDefaults$ReadersConstants$.MODULE$.EmptyType();
        } else {
            if (Schema.Type.ValueCase.VALUE_NOT_SET.equals(valueCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyType()).$bang$bang();
            }
            throw new MatchError((Object)valueCase);
        }
        return parameterRef;
    }

    public Modifiers fromModifiers(Schema.Modifiers modifiers) {
        return InternalApiProxy$Modifiers$.MODULE$.apply(modifiers.getFlags());
    }

    public Access fromAccess(Schema.Access access) {
        Public public_;
        Schema.Access.TypeCase typeCase = access.getTypeCase();
        if (Schema.Access.TypeCase.PUBLIC.equals(typeCase)) {
            public_ = ProtobufDefaults$ReadersConstants$.MODULE$.Public();
        } else if (Schema.Access.TypeCase.PROTECTED.equals(typeCase)) {
            Schema.Protected a = access.getProtected();
            public_ = Protected.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        } else if (Schema.Access.TypeCase.PRIVATE.equals(typeCase)) {
            Schema.Private a = access.getPrivate();
            public_ = Private.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        } else {
            if (Schema.Access.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedValidAccessType()).$bang$bang();
            }
            throw new MatchError((Object)typeCase);
        }
        return public_;
    }

    public DefinitionType fromDefinitionType(Schema.DefinitionType definitionType) {
        DefinitionType definitionType2;
        Schema.DefinitionType definitionType3 = definitionType;
        if (Schema.DefinitionType.CLASSDEF.equals(definitionType3)) {
            definitionType2 = DefinitionType.ClassDef;
        } else if (Schema.DefinitionType.MODULE.equals(definitionType3)) {
            definitionType2 = DefinitionType.Module;
        } else if (Schema.DefinitionType.TRAIT.equals(definitionType3)) {
            definitionType2 = DefinitionType.Trait;
        } else if (Schema.DefinitionType.PACKAGEMODULE.equals(definitionType3)) {
            definitionType2 = DefinitionType.PackageModule;
        } else {
            if (Schema.DefinitionType.UNRECOGNIZED.equals(definitionType3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedDefinitionType()).$bang$bang();
            }
            throw new MatchError((Object)definitionType3);
        }
        return definitionType2;
    }

    public ClassDefinition fromClassDefinition(Schema.ClassDefinition classDefinition) {
        ClassLikeDef classLikeDef;
        String name = classDefinition.getName().intern();
        if (!classDefinition.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingAccessInDef()).$bang$bang();
        }
        Access access = this.fromAccess(classDefinition.getAccess());
        if (!classDefinition.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingModifiersInDef()).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classDefinition.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classDefinition.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        Schema.ClassDefinition.ExtraCase extraCase = classDefinition.getExtraCase();
        if (Schema.ClassDefinition.ExtraCase.CLASSLIKEDEF.equals(extraCase)) {
            classLikeDef = this.fromClassLikeDef$1(classDefinition.getClassLikeDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.DEFDEF.equals(extraCase)) {
            classLikeDef = this.fromDefDef$1(classDefinition.getDefDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.VALDEF.equals(extraCase)) {
            classLikeDef = this.fromValDef$1(classDefinition.getValDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.VARDEF.equals(extraCase)) {
            classLikeDef = this.fromVarDef$1(classDefinition.getVarDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.TYPEALIAS.equals(extraCase)) {
            classLikeDef = this.fromTypeAlias$1(classDefinition.getTypeAlias(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.TYPEDECLARATION.equals(extraCase)) {
            classLikeDef = this.fromTypeDeclaration$1(classDefinition.getTypeDeclaration(), name, access, modifiers, annotations);
        } else {
            if (Schema.ClassDefinition.ExtraCase.EXTRA_NOT_SET.equals(extraCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyDefType()).$bang$bang();
            }
            throw new MatchError((Object)extraCase);
        }
        return classLikeDef;
    }

    public TypeParameter fromTypeParameter(Schema.TypeParameter typeParameter2) {
        String id = typeParameter2.getId();
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(typeParameter2.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeParameter2.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        Variance variance = ProtobufReaders.fromVariance$1(typeParameter2.getVariance());
        if (!typeParameter2.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeParameter()).$bang$bang();
        }
        Type lowerBound = this.fromType(typeParameter2.getLowerBound());
        if (!typeParameter2.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeParameter()).$bang$bang();
        }
        Type upperBound = this.fromType(typeParameter2.getUpperBound());
        return TypeParameter.of((String)id, (Annotation[])annotations, (TypeParameter[])typeParameters, (Variance)variance, (Type)lowerBound, (Type)upperBound);
    }

    public ClassLike fromClassLike(Schema.ClassLike classLike) {
        String name = classLike.getName().intern();
        if (!classLike.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Access.class)).$bang$bang();
        }
        Access access = this.fromAccess(classLike.getAccess());
        if (!classLike.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Modifiers.class)).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classLike.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classLike.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        DefinitionType definitionType = this.fromDefinitionType(classLike.getDefinitionType());
        if (!classLike.hasSelfType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expectedMsg$1("self type")).$bang$bang();
        }
        Lazy selfType = SafeLazyProxy$.MODULE$.strict((Object)this.fromType(classLike.getSelfType()));
        if (!classLike.hasStructure()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Type.Structure.class)).$bang$bang();
        }
        Lazy structure = SafeLazyProxy$.MODULE$.strict((Object)this.fromStructure(classLike.getStructure()));
        String[] savedAnnotations = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)classLike.getSavedAnnotationsList()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        Type[] childrenOfSealedClass = (Type[])this.EfficientTraverse(classLike.getChildrenOfSealedClassList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        boolean topLevel = classLike.getTopLevel();
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(classLike.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLike.of((String)name, (Access)access, (Modifiers)modifiers, (Annotation[])annotations, (DefinitionType)definitionType, (Lazy)selfType, (Lazy)structure, (String[])savedAnnotations, (Type[])childrenOfSealedClass, (boolean)topLevel, (TypeParameter[])typeParameters);
    }

    public UseScope fromUseScope(Schema.UseScope useScope, int id) {
        UseScope useScope2;
        Schema.UseScope useScope3 = useScope;
        if (Schema.UseScope.DEFAULT.equals(useScope3)) {
            useScope2 = UseScope.Default;
        } else if (Schema.UseScope.IMPLICIT.equals(useScope3)) {
            useScope2 = UseScope.Implicit;
        } else if (Schema.UseScope.PATMAT.equals(useScope3)) {
            useScope2 = UseScope.PatMatTarget;
        } else {
            if (Schema.UseScope.UNRECOGNIZED.equals(useScope3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedUseScope(id)).$bang$bang();
            }
            throw new MatchError((Object)useScope3);
        }
        return useScope2;
    }

    public AnalyzedClass fromAnalyzedClass(boolean shouldStoreApis, Schema.AnalyzedClass analyzedClass) {
        ProtobufDefaults$EmptyLazyCompanions$ protobufDefaults$EmptyLazyCompanions$;
        long compilationTs = analyzedClass.getCompilationTimestamp();
        String name = analyzedClass.getName().intern();
        if (!shouldStoreApis) {
            protobufDefaults$EmptyLazyCompanions$ = ProtobufDefaults$EmptyLazyCompanions$.MODULE$;
        } else {
            if (!analyzedClass.hasApi()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedCompanionsInAnalyzedClass()).$bang$bang();
            }
            protobufDefaults$EmptyLazyCompanions$ = SafeLazyProxy$.MODULE$.strict((Object)this.fromCompanions$1(analyzedClass.getApi()));
        }
        ProtobufDefaults$EmptyLazyCompanions$ api = protobufDefaults$EmptyLazyCompanions$;
        int apiHash = analyzedClass.getApiHash();
        Schema.Version version = this.currentVersion;
        Schema.Version version2 = Schema.Version.V1;
        int extraHash = !(version != null ? !version.equals(version2) : version2 != null) ? 0 : analyzedClass.getExtraHash();
        NameHash[] nameHashes = (NameHash[])this.EfficientTraverse(analyzedClass.getNameHashesList()).toZincArray((Function1 & Serializable & scala.Serializable)nameHash -> this.fromNameHash$1((Schema.NameHash)nameHash), ClassTag$.MODULE$.apply(NameHash.class));
        boolean hasMacro = analyzedClass.getHasMacro();
        String provenance = analyzedClass.getProvenance().intern();
        return AnalyzedClass.of((long)compilationTs, (String)name, (Lazy)api, (int)apiHash, (NameHash[])nameHashes, (boolean)hasMacro, (int)extraHash, (String)provenance);
    }

    private final Function1<String, String> stringId() {
        return this.stringId;
    }

    private final Function1<String, java.nio.file.Path> stringToFile() {
        return this.stringToFile;
    }

    private final Function1<String, VirtualFileRef> stringToVFile() {
        return this.stringToVFile;
    }

    public Relations fromRelations(Schema.Relations relations) {
        Relation srcProd = ProtobufReaders.fromMap$1(relations.getSrcProdMap(), this.stringToVFile(), this.stringToVFile());
        Relation libraryDep = ProtobufReaders.fromMap$1(relations.getLibraryDepMap(), this.stringToVFile(), this.stringToVFile());
        Relation libraryClassName = ProtobufReaders.fromMap$1(relations.getLibraryClassNameMap(), this.stringToVFile(), this.stringId());
        if (!relations.hasMemberRef()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("member refs")).$bang$bang();
        }
        Relations.ClassDependencies memberRef = this.fromClassDependencies$1(relations.getMemberRef());
        if (!relations.hasInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("inheritance")).$bang$bang();
        }
        Relations.ClassDependencies inheritance = this.fromClassDependencies$1(relations.getInheritance());
        if (!relations.hasLocalInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("local inheritance")).$bang$bang();
        }
        Relations.ClassDependencies localInheritance = this.fromClassDependencies$1(relations.getLocalInheritance());
        Relation classes = ProtobufReaders.fromMap$1(relations.getClassesMap(), this.stringToVFile(), this.stringId());
        Relation productClassName = ProtobufReaders.fromMap$1(relations.getProductClassNameMap(), this.stringId(), this.stringId());
        Relation names = this.fromUsedNamesMap$1(relations.getNamesMap());
        InternalDependencies internal = new InternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.internal())})));
        ExternalDependencies external = new ExternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.external())})));
        return Relations$.MODULE$.make(srcProd, libraryDep, libraryClassName, internal, external, classes, names, productClassName);
    }

    public APIs fromApis(boolean shouldStoreApis, Schema.APIs apis) {
        scala.collection.immutable.Map internal = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getInternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, v));
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map external = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getExternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, v));
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
        return APIs$.MODULE$.apply(internal, external);
    }

    public Tuple2<APIs, Schema.Version> fromApisFile(Schema.APIsFile apisFile, boolean shouldStoreApis) {
        if (!apisFile.hasApis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedApisInApisFile()).$bang$bang();
        }
        APIs apis = this.fromApis(shouldStoreApis, apisFile.getApis());
        Schema.Version version = apisFile.getVersion();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)apis), (Object)version);
    }

    public Analysis fromAnalysis(Schema.Analysis analysis) {
        if (!analysis.hasStamps()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Stamps.class)).$bang$bang();
        }
        Stamps stamps = this.fromStamps(analysis.getStamps());
        if (!analysis.hasRelations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Relations.class)).$bang$bang();
        }
        Relations relations = this.fromRelations(analysis.getRelations());
        if (!analysis.hasSourceInfos()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.SourceInfos.class)).$bang$bang();
        }
        SourceInfos sourceInfos = this.fromSourceInfos(analysis.getSourceInfos());
        if (!analysis.hasCompilations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Compilations.class)).$bang$bang();
        }
        Compilations compilations = this.fromCompilations(analysis.getCompilations());
        Stamps x$1 = stamps;
        Relations x$2 = relations;
        SourceInfos x$3 = sourceInfos;
        Compilations x$4 = compilations;
        APIs x$5 = Analysis$.MODULE$.Empty().copy$default$2();
        return Analysis$.MODULE$.Empty().copy(x$1, x$5, x$2, x$3, x$4);
    }

    public Tuple3<Analysis, MiniSetup, Schema.Version> fromAnalysisFile(Schema.AnalysisFile analysisFile) {
        Schema.Version version = analysisFile.getVersion();
        if (!analysisFile.hasAnalysis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(49).append("The analysis file from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        Analysis analysis = this.fromAnalysis(analysisFile.getAnalysis());
        if (!analysisFile.hasMiniSetup()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(46).append("The mini setup from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        MiniSetup miniSetup = this.fromMiniSetup(analysisFile.getMiniSetup());
        return new Tuple3((Object)analysis, (Object)miniSetup, (Object)version);
    }

    private final scala.collection.immutable.Map fromBinarySchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapBinaryFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapBinaryStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromSourceSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapSourceFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapSourceStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromProductSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapProductFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapProductStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final PathComponent fromPathComponent$1(Schema.Path.PathComponent pathComponent) {
        Id id;
        Schema.Path.PathComponent.ComponentCase componentCase = pathComponent.getComponentCase();
        if (Schema.Path.PathComponent.ComponentCase.ID.equals(componentCase)) {
            Schema.Id c = pathComponent.getId();
            id = Id.of((String)c.getId());
        } else if (Schema.Path.PathComponent.ComponentCase.SUPER.equals(componentCase)) {
            Schema.Super c = pathComponent.getSuper();
            if (!c.hasQualifier()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSuper()).$bang$bang();
            }
            Path q = this.fromPath(c.getQualifier());
            id = Super.of((Path)q);
        } else if (Schema.Path.PathComponent.ComponentCase.THIS.equals(componentCase)) {
            id = ProtobufDefaults$ReadersConstants$.MODULE$.This();
        } else {
            if (Schema.Path.PathComponent.ComponentCase.COMPONENT_NOT_SET.equals(componentCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expected(Schema.Path.PathComponent.ComponentCase.class, Schema.Path.PathComponent.class)).$bang$bang();
            }
            throw new MatchError((Object)componentCase);
        }
        return id;
    }

    private static final AnnotationArgument fromAnnotationArgument$1(Schema.AnnotationArgument argument) {
        String name = argument.getName().intern();
        String value = argument.getValue();
        return AnnotationArgument.of((String)name, (String)value);
    }

    private static final Lazy lazy$1(Object value) {
        return SafeLazyProxy$.MODULE$.strict(value);
    }

    private static final ParameterRef fromParameterRef$1(Schema.Type.ParameterRef tpe) {
        return ParameterRef.of((String)tpe.getId());
    }

    private final Parameterized fromParameterized$1(Schema.Type.Parameterized tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Parameterized.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Type[] typeArguments = (Type[])this.EfficientTraverse(tpe.getTypeArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        return Parameterized.of((Type)baseType, (Type[])typeArguments);
    }

    private final Polymorphic fromPolymorphic$1(Schema.Type.Polymorphic tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Polymorphic.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(tpe.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Polymorphic.of((Type)baseType, (TypeParameter[])typeParameters);
    }

    private final Constant fromConstant$1(Schema.Type.Constant tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Constant.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        String value = tpe.getValue();
        return Constant.of((Type)baseType, (String)value);
    }

    private final Existential fromExistential$1(Schema.Type.Existential tpe) {
        None$ b = tpe.hasBaseType() ? new Some((Object)tpe.getBaseType()) : None$.MODULE$;
        Type baseType = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Existential.class));
        TypeParameter[] clause = (TypeParameter[])this.EfficientTraverse(tpe.getClauseList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Existential.of((Type)baseType, (TypeParameter[])clause);
    }

    private final Singleton fromSingleton$1(Schema.Type.Singleton tpe) {
        if (!tpe.hasPath()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSingleton()).$bang$bang();
        }
        Path path = this.fromPath(tpe.getPath());
        return Singleton.of((Path)path);
    }

    private final Projection fromProjection$1(Schema.Type.Projection tpe) {
        String id = tpe.getId();
        if (!tpe.hasPrefix()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPrefixInProjection()).$bang$bang();
        }
        Type prefix = this.fromType(tpe.getPrefix());
        return Projection.of((Type)prefix, (String)id);
    }

    private final Annotated fromAnnotated$1(Schema.Type.Annotated tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Annotated.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(tpe.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        return Annotated.of((Type)baseType, (Annotation[])annotations);
    }

    private static final Qualifier fromQualifier$1(Schema.Qualifier qualifier) {
        IdQualifier idQualifier;
        Schema.Qualifier.TypeCase typeCase = qualifier.getTypeCase();
        if (Schema.Qualifier.TypeCase.IDQUALIFIER.equals(typeCase)) {
            Schema.IdQualifier q = qualifier.getIdQualifier();
            idQualifier = IdQualifier.of((String)q.getValue());
        } else if (Schema.Qualifier.TypeCase.THISQUALIFIER.equals(typeCase)) {
            idQualifier = ProtobufDefaults$ReadersConstants$.MODULE$.ThisQualifier();
        } else if (Schema.Qualifier.TypeCase.UNQUALIFIED.equals(typeCase)) {
            idQualifier = ProtobufDefaults$ReadersConstants$.MODULE$.Unqualified();
        } else {
            if (Schema.Qualifier.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyQualifier()).$bang$bang();
            }
            throw new MatchError((Object)typeCase);
        }
        return idQualifier;
    }

    private final Qualifier readQualifier$1(Option qualifier2) {
        return (Qualifier)this.OptionReader(qualifier2).read((Function1 & Serializable & scala.Serializable)qualifier -> ProtobufReaders.fromQualifier$1(qualifier), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedQualifierInAccess());
    }

    private static final ParameterModifier fromParameterModifier$1(Schema.ParameterModifier modifier) {
        ParameterModifier parameterModifier;
        Schema.ParameterModifier parameterModifier2 = modifier;
        if (Schema.ParameterModifier.PLAIN.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.Plain;
        } else if (Schema.ParameterModifier.BYNAME.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.ByName;
        } else if (Schema.ParameterModifier.REPEATED.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.Repeated;
        } else {
            if (Schema.ParameterModifier.UNRECOGNIZED.equals(parameterModifier2)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedParamModifier()).$bang$bang();
            }
            throw new MatchError((Object)parameterModifier2);
        }
        return parameterModifier;
    }

    private final MethodParameter fromMethodParameter$1(Schema.MethodParameter methodParameter) {
        String name = methodParameter.getName().intern();
        boolean hasDefault = methodParameter.getHasDefault();
        if (!methodParameter.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.MethodParameter.class)).$bang$bang();
        }
        Type type = this.fromType(methodParameter.getType());
        ParameterModifier modifier = ProtobufReaders.fromParameterModifier$1(methodParameter.getModifier());
        return MethodParameter.of((String)name, (Type)type, (boolean)hasDefault, (ParameterModifier)modifier);
    }

    private final ParameterList fromParameterList$1(Schema.ParameterList parameterList) {
        boolean isImplicit = parameterList.getIsImplicit();
        MethodParameter[] parameters = (MethodParameter[])this.EfficientTraverse(parameterList.getParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)methodParameter -> this.fromMethodParameter$1((Schema.MethodParameter)methodParameter), ClassTag$.MODULE$.apply(MethodParameter.class));
        return ParameterList.of((MethodParameter[])parameters, (boolean)isImplicit);
    }

    private final ClassLikeDef fromClassLikeDef$1(Schema.ClassDefinition.ClassLikeDef defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        DefinitionType definitionType = this.fromDefinitionType(defDef.getDefinitionType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLikeDef.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (DefinitionType)definitionType);
    }

    private final Def fromDefDef$1(Schema.ClassDefinition.Def defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!defDef.hasReturnType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedReturnTypeInDef()).$bang$bang();
        }
        Type returnType = this.fromType(defDef.getReturnType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        ParameterList[] valueParameters = (ParameterList[])this.EfficientTraverse(defDef.getValueParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)parameterList -> this.fromParameterList$1((Schema.ParameterList)parameterList), ClassTag$.MODULE$.apply(ParameterList.class));
        return Def.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (ParameterList[])valueParameters, (Type)returnType);
    }

    private final Val fromValDef$1(Schema.ClassDefinition.Val valDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!valDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Val.class)).$bang$bang();
        }
        Type tpe = this.fromType(valDef.getType());
        return Val.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final Var fromVarDef$1(Schema.ClassDefinition.Var varDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!varDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Var.class)).$bang$bang();
        }
        Type tpe = this.fromType(varDef.getType());
        return Var.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final TypeAlias fromTypeAlias$1(Schema.ClassDefinition.TypeAlias typeAlias, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!typeAlias.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.TypeAlias.class)).$bang$bang();
        }
        Type tpe = this.fromType(typeAlias.getType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeAlias.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeAlias.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (Type)tpe);
    }

    private final TypeDeclaration fromTypeDeclaration$1(Schema.ClassDefinition.TypeDeclaration decl, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!decl.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeDeclaration()).$bang$bang();
        }
        Type lowerBound = this.fromType(decl.getLowerBound());
        if (!decl.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeDeclaration()).$bang$bang();
        }
        Type upperBound = this.fromType(decl.getUpperBound());
        TypeParameter[] typeParams = (TypeParameter[])this.EfficientTraverse(decl.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeDeclaration.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParams, (Type)lowerBound, (Type)upperBound);
    }

    private static final Variance fromVariance$1(Schema.Variance variance) {
        Variance variance2;
        Schema.Variance variance3 = variance;
        if (Schema.Variance.INVARIANT.equals(variance3)) {
            variance2 = Variance.Invariant;
        } else if (Schema.Variance.COVARIANT.equals(variance3)) {
            variance2 = Variance.Covariant;
        } else if (Schema.Variance.CONTRAVARIANT.equals(variance3)) {
            variance2 = Variance.Contravariant;
        } else {
            if (Schema.Variance.UNRECOGNIZED.equals(variance3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedVariance()).$bang$bang();
            }
            throw new MatchError((Object)variance3);
        }
        return variance2;
    }

    private static final String expectedMsg$1(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.ClassLike.class);
    }

    private static final String expected$1(Class clazz) {
        return ProtobufReaders.expectedMsg$1(clazz.getName());
    }

    private static final String expected$2(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Companions.class);
    }

    private final Companions fromCompanions$1(Schema.Companions companions) {
        if (!companions.hasClassApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("class api")).$bang$bang();
        }
        ClassLike classApi = this.fromClassLike(companions.getClassApi());
        if (!companions.hasObjectApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("object api")).$bang$bang();
        }
        ClassLike objectApi = this.fromClassLike(companions.getObjectApi());
        return Companions.of((ClassLike)classApi, (ClassLike)objectApi);
    }

    private final NameHash fromNameHash$1(Schema.NameHash nameHash) {
        String name = nameHash.getName().intern();
        int hash = nameHash.getHash();
        UseScope scope = this.fromUseScope(nameHash.getScope(), nameHash.getScopeValue());
        return NameHash.of((String)name, (UseScope)scope, (int)hash);
    }

    public static final /* synthetic */ boolean $anonfun$fromRelations$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$fromRelations$2(Function1 fk$1, RelationBuilder builder$1, Function1 fv$1, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            String kString = (String)tuple2._1();
            Schema.Values vs = (Schema.Values)tuple2._2();
            if (!vs.getValuesList().isEmpty()) {
                Object k = fk$1.apply((Object)kString);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)vs.getValuesList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)vString -> {
                    builder$1.update(k, fv$1.apply((Object)vString));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final Relation fromMap$1(Map map, Function1 fk, Function1 fv) {
        RelationBuilder builder = new RelationBuilder();
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProtobufReaders.$anonfun$fromRelations$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            ProtobufReaders.$anonfun$fromRelations$2(fk, builder, fv, x$2);
            return BoxedUnit.UNIT;
        });
        return builder.result();
    }

    private final Relations.ClassDependencies fromClassDependencies$1(Schema.ClassDependencies classDependencies) {
        Relation internal = ProtobufReaders.fromMap$1(classDependencies.getInternalMap(), this.stringId(), this.stringId());
        Relation external = ProtobufReaders.fromMap$1(classDependencies.getExternalMap(), this.stringId(), this.stringId());
        return new Relations.ClassDependencies(internal, external);
    }

    private final UsedName fromUsedName$1(Schema.UsedName usedName) {
        String name = usedName.getName().intern();
        EnumSet<UseScope> useScopes = EnumSet.noneOf(UseScope.class);
        int len = usedName.getScopesCount();
        IndexedSeq scopes = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), len - 1).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> useScopes.add(this.fromUseScope(usedName.getScopes(i), usedName.getScopesValue(i))), IndexedSeq$.MODULE$.canBuildFrom());
        return UsedName$.MODULE$.make(name, useScopes);
    }

    public static final /* synthetic */ boolean $anonfun$fromRelations$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$fromRelations$6(ProtobufReaders $this, RelationBuilder builder$2, Tuple2 x$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            Schema.UsedNames used = (Schema.UsedNames)tuple2._2();
            Buffer usedNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(used.getUsedNamesList()).asScala();
            if (!usedNames.isEmpty()) {
                usedNames.foreach((Function1 & Serializable & scala.Serializable)schemaUsedName -> {
                    builder$2.update((Object)k, (Object)$this.fromUsedName$1(schemaUsedName));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final Relation fromUsedNamesMap$1(Map map) {
        RelationBuilder builder = new RelationBuilder();
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ProtobufReaders.$anonfun$fromRelations$5(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ProtobufReaders.$anonfun$fromRelations$6(this, builder, x$3);
            return BoxedUnit.UNIT;
        });
        return builder.result();
    }

    private static final String expected$3(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Relations.class);
    }

    private static final String expected$4(Class clazz) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(clazz, Schema.Analysis.class);
    }

    public ProtobufReaders(ReadMapper mapper, Schema.Version currentVersion) {
        this.mapper = mapper;
        this.currentVersion = currentVersion;
        this.stringId = (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x);
        this.stringToFile = (Function1 & Serializable & scala.Serializable)path -> this.fromPathString((String)path);
        this.stringToVFile = (Function1 & Serializable & scala.Serializable)path -> this.fromPathStringV((String)path);
    }

    public class EfficientTraverse<T> {
        private final List<T> seq;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> Object toZincArray(Function1<T, R> f, ClassTag<R> evidence$1) {
            return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.seq).asScala()).iterator().map(f).toArray(evidence$1);
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$EfficientTraverse$$$outer() {
            return this.$outer;
        }

        public EfficientTraverse(ProtobufReaders $outer, List<T> seq) {
            this.seq = seq;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class OptionReader<T> {
        private final Option<T> option;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R read(Function1<T, R> from, Function0<String> errorMessage) {
            return (R)this.option.fold((Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$.MODULE$.StringToException((String)errorMessage.apply()).$bang$bang(), from);
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$OptionReader$$$outer() {
            return this.$outer;
        }

        public OptionReader(ProtobufReaders $outer, Option<T> option) {
            this.option = option;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

