/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.binary.converters;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import sbt.internal.inc.APIs;
import sbt.internal.inc.APIs$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.Compilation;
import sbt.internal.inc.Compilations;
import sbt.internal.inc.Compilations$;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.ExternalDependencies;
import sbt.internal.inc.FarmHash$;
import sbt.internal.inc.Hash$;
import sbt.internal.inc.InternalDependencies;
import sbt.internal.inc.LastModified;
import sbt.internal.inc.RelationBuilder;
import sbt.internal.inc.Relations;
import sbt.internal.inc.Relations$;
import sbt.internal.inc.Schema;
import sbt.internal.inc.SourceInfos;
import sbt.internal.inc.SourceInfos$;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.UsedName;
import sbt.internal.inc.UsedName$;
import sbt.internal.inc.binary.converters.InternalApiProxy$Modifiers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$EmptyLazyCompanions$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$Readers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$ReadersConstants$;
import sbt.internal.util.Relation;
import sbt.util.InterfaceUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import xsbti.Position;
import xsbti.Problem;
import xsbti.Severity;
import xsbti.T2;
import xsbti.UseScope;
import xsbti.VirtualFileRef;
import xsbti.api.Access;
import xsbti.api.AnalyzedClass;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.AnnotationArgument;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Companions;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.DefinitionType;
import xsbti.api.DependencyContext;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Lazy;
import xsbti.api.MethodParameter;
import xsbti.api.Modifiers;
import xsbti.api.NameHash;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualifier;
import xsbti.api.SafeLazyProxy$;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;
import xsbti.compile.CompileOrder;
import xsbti.compile.FileHash;
import xsbti.compile.MiniOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.OutputGroup;
import xsbti.compile.analysis.ReadMapper;
import xsbti.compile.analysis.SourceInfo;
import xsbti.compile.analysis.Stamp;

@ScalaSignature(bytes="\u0006\u0001\u0011-e\u0001\u0002\u001f>\u0005!C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t5\u0002\u0011\t\u0011)A\u00057\")1\r\u0001C\u0001I\")\u0011\u000e\u0001C\u0001U\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!Q\u0002\u0001\u0005\u0002\t=\u0001b\u0002B\u0010\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqA!\u0017\u0001\t\u0003\u0011Y\u0006C\u0004\u0003h\u0001!\tA!\u001b\u0007\r\tE\u0004!\u0001B:\u0011)\u00119(\u0007B\u0001B\u0003%!\u0011\u0010\u0005\u0007Gf!\tAa'\t\u000f\t\r\u0016\u0004\"\u0001\u0003&\"I!1\u001b\u0001\u0002\u0002\u0013\r!Q\u001b\u0004\u0007\u0005G\u0004\u0011A!:\t\u0015\t%hD!A!\u0002\u0013\u0011Y\u000f\u0003\u0004d=\u0011\u0005!\u0011\u001f\u0005\b\u0005otB\u0011\u0001B}\u0011%\u0019\t\u0002AA\u0001\n\u0007\u0019\u0019\u0002C\u0004\u0004\"\u0001!\taa\t\t\u000f\rU\u0002\u0001\"\u0001\u00048!91q\t\u0001\u0005\u0002\r%\u0003bBB1\u0001\u0011\u000511\r\u0005\b\u0007g\u0002A\u0011AB;\u0011\u001d\u0019)\t\u0001C\u0001\u0007\u000fCqaa&\u0001\t\u0003\u0019I\nC\u0004\u0004*\u0002!\taa+\t\u000f\rm\u0006\u0001\"\u0001\u0004>\"91Q\u001a\u0001\u0005\u0002\r=\u0007bBBp\u0001\u0011\u00051\u0011\u001d\u0005\b\u0007g\u0004A\u0011AB{\u0011%!\t\u0002\u0001b\u0001\n\u001b!\u0019\u0002\u0003\u0005\u0005\u0018\u0001\u0001\u000bQ\u0002C\u000b\u0011%!I\u0002\u0001b\u0001\n\u001b!Y\u0002\u0003\u0005\u0005 \u0001\u0001\u000bQ\u0002C\u000f\u0011%!\t\u0003\u0001b\u0001\n\u001b!Y\u0002\u0003\u0005\u0005$\u0001\u0001\u000bQ\u0002C\u000f\u0011%!)\u0003\u0001b\u0001\n\u001b!Y\u0002\u0003\u0005\u0005(\u0001\u0001\u000bQ\u0002C\u000f\u0011\u001d!I\u0003\u0001C\u0001\tWAq\u0001b\u000f\u0001\t\u0003!i\u0004C\u0004\u0005R\u0001!\t\u0001b\u0015\t\u000f\u0011\u001d\u0004\u0001\"\u0001\u0005j!9Aq\u000f\u0001\u0005\u0002\u0011e$a\u0004)s_R|'-\u001e4SK\u0006$WM]:\u000b\u0005yz\u0014AC2p]Z,'\u000f^3sg*\u0011\u0001)Q\u0001\u0007E&t\u0017M]=\u000b\u0005\t\u001b\u0015aA5oG*\u0011A)R\u0001\tS:$XM\u001d8bY*\ta)A\u0002tER\u001c\u0001a\u0005\u0002\u0001\u0013B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\fa!\\1qa\u0016\u0014\bCA)Y\u001b\u0005\u0011&BA*U\u0003!\tg.\u00197zg&\u001c(BA+W\u0003\u001d\u0019w.\u001c9jY\u0016T\u0011aV\u0001\u0006qN\u0014G/[\u0005\u00033J\u0013!BU3bI6\u000b\u0007\u000f]3s\u00039\u0019WO\u001d:f]R4VM]:j_:\u0004\"\u0001\u00181\u000f\u0005usV\"A!\n\u0005}\u000b\u0015AB*dQ\u0016l\u0017-\u0003\u0002bE\n9a+\u001a:tS>t'BA0B\u0003\u0019a\u0014N\\5u}Q\u0019Qm\u001a5\u0011\u0005\u0019\u0004Q\"A\u001f\t\u000b=\u001b\u0001\u0019\u0001)\t\u000bi\u001b\u0001\u0019A.\u0002\u001d\u0019\u0014x.\u001c)bi\"\u001cFO]5oOR\u00111.\u001e\t\u0003YNl\u0011!\u001c\u0006\u0003]>\fAAZ5mK*\u0011\u0001/]\u0001\u0004]&|'\"\u0001:\u0002\t)\fg/Y\u0005\u0003i6\u0014A\u0001U1uQ\")a\u000f\u0002a\u0001o\u0006!\u0001/\u0019;i!\tAxP\u0004\u0002z{B\u0011!pS\u0007\u0002w*\u0011ApR\u0001\u0007yI|w\u000e\u001e \n\u0005y\\\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0002\u0005\r!AB*ue&twM\u0003\u0002\u007f\u0017\u0006yaM]8n!\u0006$\bn\u0015;sS:<g\u000b\u0006\u0003\u0002\n\u0005E\u0001\u0003BA\u0006\u0003\u001bi\u0011AV\u0005\u0004\u0003\u001f1&A\u0004,jeR,\u0018\r\u001c$jY\u0016\u0014VM\u001a\u0005\u0006m\u0016\u0001\ra^\u0001\u000eMJ|Wn\u0015;b[B$\u0016\u0010]3\u0015\t\u0005]\u0011Q\u0004\t\u0004#\u0006e\u0011bAA\u000e%\n)1\u000b^1na\"9\u0011q\u0004\u0004A\u0002\u0005\u0005\u0012!C:uC6\u0004H+\u001f9f!\u0011\t\u0019#!\u000b\u000f\u0007q\u000b)#C\u0002\u0002(\t\faa\u0015;b[B\u001c\u0018\u0002BA\u0016\u0003[\u0011\u0011b\u0015;b[B$\u0016\u0010]3\u000b\u0007\u0005\u001d\"-\u0001\u0006ge>l7\u000b^1naN$B!a\r\u0002:A\u0019Q,!\u000e\n\u0007\u0005]\u0012I\u0001\u0004Ti\u0006l\u0007o\u001d\u0005\b\u0003w9\u0001\u0019AA\u001f\u0003\u0019\u0019H/Y7qgB\u0019A,a\u0010\n\u0007\u0005]\"-A\bge>lw*\u001e;qkR<%o\\;q)\u0011\t)%!\u0014\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0002)&\u0019\u00111\n+\u0003\u0017=+H\u000f];u\u000fJ|W\u000f\u001d\u0005\b\u0003\u001fB\u0001\u0019AA)\u0003-yW\u000f\u001e9vi\u001e\u0013x.\u001e9\u0011\u0007q\u000b\u0019&C\u0002\u0002L\t\fQC\u001a:p[\u000e{W\u000e]5mCRLwN\\(viB,H\u000f\u0006\u0003\u0002Z\u0005}\u0003\u0003BA$\u00037J1!!\u0018U\u0005\u0019yU\u000f\u001e9vi\"9\u0011\u0011M\u0005A\u0002\u0005\r\u0014!A2\u0011\u0007q\u000b)'C\u0002\u0002h\t\u00141bQ8na&d\u0017\r^5p]\u0006yaM]8n\u0007>l\u0007/\u001b7bi&|g\u000e\u0006\u0003\u0002n\u0005E\u0004cA)\u0002p%\u0019\u0011q\r*\t\u000f\u0005M$\u00021\u0001\u0002d\u0005Y1m\\7qS2\fG/[8o\u0003A1'o\\7D_6\u0004\u0018\u000e\\1uS>t7\u000f\u0006\u0003\u0002z\u0005}\u0004cA/\u0002|%\u0019\u0011QP!\u0003\u0019\r{W\u000e]5mCRLwN\\:\t\u000f\u0005\u00055\u00021\u0001\u0002\u0004\u0006i1m\\7qS2\fG/[8ogB\u00022\u0001XAC\u0013\r\tiHY\u0001\rMJ|W\u000eU8tSRLwN\u001c\u000b\u0005\u0003\u0017\u000b\t\n\u0005\u0003\u0002\f\u00055\u0015bAAH-\nA\u0001k\\:ji&|g\u000eC\u0004\u0002\u00142\u0001\r!!&\u0002\u0011A|7/\u001b;j_:\u00042\u0001XAL\u0013\r\tyIY\u0001\rMJ|WnU3wKJLG/\u001f\u000b\u0007\u0003;\u000b\u0019+a+\u0011\t\u0005-\u0011qT\u0005\u0004\u0003C3&\u0001C*fm\u0016\u0014\u0018\u000e^=\t\u000f\u0005\u0015V\u00021\u0001\u0002(\u0006A1/\u001a<fe&$\u0018\u0010E\u0002]\u0003SK1!!)c\u0011\u001d\ti+\u0004a\u0001\u0003_\u000b!!\u001b3\u0011\u0007)\u000b\t,C\u0002\u00024.\u00131!\u00138u\u0003)1'o\\7TiJLgn\u001a\u000b\u0005\u0003s\u000by\f\u0005\u0003K\u0003w;\u0018bAA_\u0017\n1q\n\u001d;j_:Da!!1\u000f\u0001\u00049\u0018!\u0002<bYV,\u0017a\u00024s_6Le\u000e\u001e\u000b\u0005\u0003\u000f\f)\u000eE\u0003K\u0003w\u000bI\r\u0005\u0003\u0002L\u0006EWBAAg\u0015\r\ty-]\u0001\u0005Y\u0006tw-\u0003\u0003\u0002T\u00065'aB%oi\u0016<WM\u001d\u0005\b\u0003\u0003|\u0001\u0019AAX\u0003-1'o\\7Qe>\u0014G.Z7\u0015\t\u0005m\u0017\u0011\u001d\t\u0005\u0003\u0017\ti.C\u0002\u0002`Z\u0013q\u0001\u0015:pE2,W\u000eC\u0004\u0002dB\u0001\r!!:\u0002\u000fA\u0014xN\u00197f[B\u0019A,a:\n\u0007\u0005}'-\u0001\bge>l7k\\;sG\u0016LeNZ8\u0015\t\u00055\u00181\u001f\t\u0004#\u0006=\u0018bAAy%\nQ1k\\;sG\u0016LeNZ8\t\u000f\u0005U\u0018\u00031\u0001\u0002x\u0006Q1o\\;sG\u0016LeNZ8\u0011\u0007q\u000bI0C\u0002\u0002r\n\fqB\u001a:p[N{WO]2f\u0013:4wn\u001d\u000b\u0005\u0003\u007f\u0014)\u0001E\u0002^\u0005\u0003I1Aa\u0001B\u0005-\u0019v.\u001e:dK&sgm\\:\t\u000f\t\u001d!\u00031\u0001\u0003\n\u0005a1o\\;sG\u0016LeNZ8taA\u0019ALa\u0003\n\u0007\t\r!-A\u000bge>l7\t\\1tgB\fG\u000f\u001b$jY\u0016D\u0015m\u001d5\u0015\t\tE!q\u0003\t\u0005\u0003\u000f\u0012\u0019\"C\u0002\u0003\u0016Q\u0013\u0001BR5mK\"\u000b7\u000f\u001b\u0005\b\u00053\u0019\u0002\u0019\u0001B\u000e\u0003!1\u0017\u000e\\3ICND\u0007c\u0001/\u0003\u001e%\u0019!Q\u00032\u0002\u001f\u0019\u0014x.\\'j]&|\u0005\u000f^5p]N$BAa\t\u0003*A!\u0011q\tB\u0013\u0013\r\u00119\u0003\u0016\u0002\f\u001b&t\u0017n\u00149uS>t7\u000fC\u0004\u0003,Q\u0001\rA!\f\u0002\u00175Lg.[(qi&|gn\u001d\t\u00049\n=\u0012b\u0001B\u0014E\u0006\u0001bM]8n\u0007>l\u0007/\u001b7f\u001fJ$WM\u001d\u000b\u0007\u0005k\u0011YDa\u0011\u0011\t\u0005\u001d#qG\u0005\u0004\u0005s!&\u0001D\"p[BLG.Z(sI\u0016\u0014\bb\u0002B\u001f+\u0001\u0007!qH\u0001\rG>l\u0007/\u001b7f\u001fJ$WM\u001d\t\u00049\n\u0005\u0013b\u0001B\u001dE\"9\u0011QV\u000bA\u0002\u0005=\u0016a\u00044s_6\u001cFO]5oOR+\b\u000f\\3\u0015\t\t%#q\n\t\u0007\u0003\u0017\u0011Ye^<\n\u0007\t5cK\u0001\u0002Ue!9!\u0011\u000b\fA\u0002\tM\u0013!\u0002;va2,\u0007c\u0001/\u0003V%\u0019!q\u000b2\u0003\u000bQ+\b\u000f\\3\u0002'\u0019\u0014x.\\'j]&\u001cV\r^;q\u001fV$\b/\u001e;\u0015\t\u0005e#Q\f\u0005\b\u0005?:\u0002\u0019\u0001B1\u0003%i\u0017N\\5TKR,\b\u000fE\u0002]\u0005GJ1A!\u001ac\u0005%i\u0015N\\5TKR,\b/A\u0007ge>lW*\u001b8j'\u0016$X\u000f\u001d\u000b\u0005\u0005W\u0012y\u0007\u0005\u0003\u0002H\t5\u0014b\u0001B3)\"9!q\f\rA\u0002\t\u0005$!E#gM&\u001c\u0017.\u001a8u)J\fg/\u001a:tKV!!Q\u000fBE'\tI\u0012*A\u0002tKF\u0004bAa\u001f\u0003\u0002\n\u0015UB\u0001B?\u0015\r\u0011y(]\u0001\u0005kRLG.\u0003\u0003\u0003\u0004\nu$\u0001\u0002'jgR\u0004BAa\"\u0003\n2\u0001Aa\u0002BF3\t\u0007!Q\u0012\u0002\u0002)F!!q\u0012BK!\rQ%\u0011S\u0005\u0004\u0005'[%a\u0002(pi\"Lgn\u001a\t\u0004\u0015\n]\u0015b\u0001BM\u0017\n\u0019\u0011I\\=\u0015\t\tu%\u0011\u0015\t\u0006\u0005?K\"QQ\u0007\u0002\u0001!9!qO\u000eA\u0002\te\u0014a\u0003;p5&t7-\u0011:sCf,BAa*\u00034R!!\u0011\u0016Be)\u0011\u0011YK!/\u0011\u000b)\u0013iK!-\n\u0007\t=6JA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0003\b\nMFa\u0002B[9\t\u0007!q\u0017\u0002\u0002%F\u0019!qR%\t\u0013\tmF$!AA\u0004\tu\u0016AC3wS\u0012,gnY3%cA1!q\u0018Bc\u0005ck!A!1\u000b\u0007\t\r7*A\u0004sK\u001adWm\u0019;\n\t\t\u001d'\u0011\u0019\u0002\t\u00072\f7o\u001d+bO\"9!1\u001a\u000fA\u0002\t5\u0017!\u00014\u0011\u000f)\u0013yM!\"\u00032&\u0019!\u0011[&\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!E#gM&\u001c\u0017.\u001a8u)J\fg/\u001a:tKV!!q\u001bBo)\u0011\u0011INa8\u0011\u000b\t}\u0015Da7\u0011\t\t\u001d%Q\u001c\u0003\b\u0005\u0017k\"\u0019\u0001BG\u0011\u001d\u00119(\ba\u0001\u0005C\u0004bAa\u001f\u0003\u0002\nm'\u0001D(qi&|gNU3bI\u0016\u0014X\u0003\u0002Bt\u0005_\u001c\"AH%\u0002\r=\u0004H/[8o!\u0015Q\u00151\u0018Bw!\u0011\u00119Ia<\u0005\u000f\t-eD1\u0001\u0003\u000eR!!1\u001fB{!\u0015\u0011yJ\bBw\u0011\u001d\u0011I\u000f\ta\u0001\u0005W\fAA]3bIV!!1 B\u0000)\u0019\u0011ip!\u0001\u0004\bA!!q\u0011B\u0000\t\u001d\u0011),\tb\u0001\u0005\u001bCqaa\u0001\"\u0001\u0004\u0019)!\u0001\u0003ge>l\u0007c\u0002&\u0003P\n5(Q \u0005\t\u0007\u0013\tC\u00111\u0001\u0004\f\u0005aQM\u001d:pe6+7o]1hKB!!j!\u0004x\u0013\r\u0019ya\u0013\u0002\ty\tLh.Y7f}\u0005aq\n\u001d;j_:\u0014V-\u00193feV!1QCB\u000e)\u0011\u00199b!\b\u0011\u000b\t}ed!\u0007\u0011\t\t\u001d51\u0004\u0003\b\u0005\u0017\u0013#\u0019\u0001BG\u0011\u001d\u0011IO\ta\u0001\u0007?\u0001RASA^\u00073\t\u0001B\u001a:p[B\u000bG\u000f\u001b\u000b\u0005\u0007K\u0019y\u0003\u0005\u0003\u0004(\r5RBAB\u0015\u0015\r\u0019YCV\u0001\u0004CBL\u0017b\u0001;\u0004*!1ao\ta\u0001\u0007c\u00012\u0001XB\u001a\u0013\t!(-\u0001\bge>l\u0017I\u001c8pi\u0006$\u0018n\u001c8\u0015\t\re2q\b\t\u0005\u0007O\u0019Y$\u0003\u0003\u0004>\r%\"AC!o]>$\u0018\r^5p]\"91\u0011\t\u0013A\u0002\r\r\u0013AC1o]>$\u0018\r^5p]B\u0019Al!\u0012\n\u0007\ru\"-A\u0007ge>l7\u000b\u001e:vGR,(/\u001a\u000b\u0005\u0007\u0017\u001a\t\u0006\u0005\u0003\u0004(\r5\u0013\u0002BB(\u0007S\u0011\u0011b\u0015;sk\u000e$XO]3\t\u000f\rMS\u00051\u0001\u0004V\u0005\u0019A\u000f]3\u0011\t\r]3Q\f\b\u00049\u000ee\u0013bAB.E\u0006!A+\u001f9f\u0013\u0011\u0019yea\u0018\u000b\u0007\rm#-\u0001\u0005ge>lG+\u001f9f)\u0011\u0019)ga\u001b\u0011\t\r\u001d2qM\u0005\u0005\u0007S\u001aIC\u0001\u0003UsB,\u0007bBB7M\u0001\u00071qN\u0001\u0005if\u0004X\rE\u0002]\u0007cJ1a!\u001bc\u000351'o\\7N_\u0012Lg-[3sgR!1qOB?!\u0011\u00199c!\u001f\n\t\rm4\u0011\u0006\u0002\n\u001b>$\u0017NZ5feNDqaa (\u0001\u0004\u0019\t)A\u0005n_\u0012Lg-[3sgB\u0019Ala!\n\u0007\rm$-\u0001\u0006ge>l\u0017iY2fgN$Ba!#\u0004\u0010B!1qEBF\u0013\u0011\u0019ii!\u000b\u0003\r\u0005\u001b7-Z:t\u0011\u001d\u0019\t\n\u000ba\u0001\u0007'\u000ba!Y2dKN\u001c\bc\u0001/\u0004\u0016&\u00191Q\u00122\u0002%\u0019\u0014x.\u001c#fM&t\u0017\u000e^5p]RK\b/\u001a\u000b\u0005\u00077\u001b\t\u000b\u0005\u0003\u0004(\ru\u0015\u0002BBP\u0007S\u0011a\u0002R3gS:LG/[8o)f\u0004X\rC\u0004\u0004$&\u0002\ra!*\u0002\u001d\u0011,g-\u001b8ji&|g\u000eV=qKB\u0019Ala*\n\u0007\r}%-A\nge>l7\t\\1tg\u0012+g-\u001b8ji&|g\u000e\u0006\u0003\u0004.\u000eM\u0006\u0003BB\u0014\u0007_KAa!-\u0004*\ty1\t\\1tg\u0012+g-\u001b8ji&|g\u000eC\u0004\u00046*\u0002\raa.\u0002\u001f\rd\u0017m]:EK\u001aLg.\u001b;j_:\u00042\u0001XB]\u0013\r\u0019\tLY\u0001\u0012MJ|W\u000eV=qKB\u000b'/Y7fi\u0016\u0014H\u0003BB`\u0007\u000b\u0004Baa\n\u0004B&!11YB\u0015\u00055!\u0016\u0010]3QCJ\fW.\u001a;fe\"91qY\u0016A\u0002\r%\u0017!\u0004;za\u0016\u0004\u0016M]1nKR,'\u000fE\u0002]\u0007\u0017L1aa1c\u000351'o\\7DY\u0006\u001c8\u000fT5lKR!1\u0011[Bl!\u0011\u00199ca5\n\t\rU7\u0011\u0006\u0002\n\u00072\f7o\u001d'jW\u0016Dqa!7-\u0001\u0004\u0019Y.A\u0005dY\u0006\u001c8\u000fT5lKB\u0019Al!8\n\u0007\rU'-\u0001\u0007ge>lWk]3TG>\u0004X\r\u0006\u0004\u0004d\u000e%8\u0011\u001f\t\u0005\u0003\u0017\u0019)/C\u0002\u0004hZ\u0013\u0001\"V:f'\u000e|\u0007/\u001a\u0005\b\u0007Wl\u0003\u0019ABw\u0003!)8/Z*d_B,\u0007c\u0001/\u0004p&\u00191q\u001d2\t\u000f\u00055V\u00061\u0001\u00020\u0006\tbM]8n\u0003:\fG.\u001f>fI\u000ec\u0017m]:\u0015\t\r]Hq\u0001\u000b\u0005\u0007s\u001cy\u0010\u0005\u0003\u0004(\rm\u0018\u0002BB\u007f\u0007S\u0011Q\"\u00118bYfTX\rZ\"mCN\u001c\bb\u0002C\u0001]\u0001\u0007A1A\u0001\u000eC:\fG.\u001f>fI\u000ec\u0017m]:\u0011\u0007q#)!C\u0002\u0004~\nDq\u0001\"\u0003/\u0001\u0004!Y!A\btQ>,H\u000eZ*u_J,\u0017\t]5t!\rQEQB\u0005\u0004\t\u001fY%a\u0002\"p_2,\u0017M\\\u0001\tgR\u0014\u0018N\\4JIV\u0011AQ\u0003\t\u0006\u0015\n=wo^\u0001\ngR\u0014\u0018N\\4JI\u0002\nab\u001d;sS:<Gk\\*pkJ\u001cW-\u0006\u0002\u0005\u001eA1!Ja4x\u0003\u0013\tqb\u001d;sS:<Gk\\*pkJ\u001cW\rI\u0001\u0010gR\u0014\u0018N\\4U_2K'M]1ss\u0006\u00012\u000f\u001e:j]\u001e$v\u000eT5ce\u0006\u0014\u0018\u0010I\u0001\rgR\u0014\u0018N\\4U_B\u0013x\u000eZ\u0001\u000egR\u0014\u0018N\\4U_B\u0013x\u000e\u001a\u0011\u0002\u001b\u0019\u0014x.\u001c*fY\u0006$\u0018n\u001c8t)\u0011!i\u0003b\r\u0011\u0007u#y#C\u0002\u00052\u0005\u0013\u0011BU3mCRLwN\\:\t\u000f\u0011Ur\u00071\u0001\u00058\u0005I!/\u001a7bi&|gn\u001d\t\u00049\u0012e\u0012b\u0001C\u0019E\u0006AaM]8n\u0003BL7\u000f\u0006\u0003\u0005@\u0011=C\u0003\u0002C!\t\u000f\u00022!\u0018C\"\u0013\r!)%\u0011\u0002\u0005\u0003BK5\u000fC\u0004\u0005Ja\u0002\r\u0001b\u0013\u0002\t\u0005\u0004\u0018n\u001d\t\u00049\u00125\u0013b\u0001C#E\"9A\u0011\u0002\u001dA\u0002\u0011-\u0011\u0001\u00044s_6\f\u0005/[:GS2,GC\u0002C+\t7\")\u0007\u0005\u0004K\t/\"\teW\u0005\u0004\t3Z%A\u0002+va2,'\u0007C\u0004\u0005^e\u0002\r\u0001b\u0018\u0002\u0011\u0005\u0004\u0018n\u001d$jY\u0016\u00042\u0001\u0018C1\u0013\r!\u0019G\u0019\u0002\t\u0003BK5OR5mK\"9A\u0011B\u001dA\u0002\u0011-\u0011\u0001\u00044s_6\fe.\u00197zg&\u001cH\u0003\u0002C6\tc\u00022!\u0018C7\u0013\r!y'\u0011\u0002\t\u0003:\fG._:jg\"11K\u000fa\u0001\tg\u00022\u0001\u0018C;\u0013\r!yGY\u0001\u0011MJ|W.\u00118bYf\u001c\u0018n\u001d$jY\u0016$B\u0001b\u001f\u0005\u0002BA!\n\" \u0005l\t-4,C\u0002\u0005\u0000-\u0013a\u0001V;qY\u0016\u001c\u0004b\u0002CBw\u0001\u0007AQQ\u0001\rC:\fG._:jg\u001aKG.\u001a\t\u00049\u0012\u001d\u0015b\u0001CEE\na\u0011I\\1msNL7OR5mK\u0002")
public final class ProtobufReaders {
    private final ReadMapper mapper;
    private final Schema.Version currentVersion;
    private final Function1<String, String> stringId;
    private final Function1<String, VirtualFileRef> stringToSource;
    private final Function1<String, VirtualFileRef> stringToLibrary;
    private final Function1<String, VirtualFileRef> stringToProd;

    public java.nio.file.Path fromPathString(String path) {
        return Paths.get(path, new String[0]);
    }

    public VirtualFileRef fromPathStringV(String path) {
        return VirtualFileRef.of((String)path);
    }

    public Stamp fromStampType(Schema.Stamps.StampType stampType) {
        EmptyStamp$ emptyStamp$;
        Schema.Stamps.StampType.TypeCase typeCase = stampType.getTypeCase();
        if (Schema.Stamps.StampType.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            emptyStamp$ = EmptyStamp$.MODULE$;
        } else if (Schema.Stamps.StampType.TypeCase.FARMHASH.equals(typeCase)) {
            emptyStamp$ = FarmHash$.MODULE$.fromLong(stampType.getFarmHash().getHash());
        } else if (Schema.Stamps.StampType.TypeCase.HASH.equals(typeCase)) {
            emptyStamp$ = Hash$.MODULE$.unsafeFromString(stampType.getHash().getHash());
        } else if (Schema.Stamps.StampType.TypeCase.LASTMODIFIED.equals(typeCase)) {
            emptyStamp$ = new LastModified(stampType.getLastModified().getMillis());
        } else {
            throw new MatchError((Object)typeCase);
        }
        return emptyStamp$;
    }

    public Stamps fromStamps(Schema.Stamps stamps) {
        scala.collection.immutable.Map libraries = this.fromBinarySchemaMap$1(stamps.getBinaryStampsMap());
        scala.collection.immutable.Map sources = this.fromSourceSchemaMap$1(stamps.getSourceStampsMap());
        scala.collection.immutable.Map products = this.fromProductSchemaMap$1(stamps.getProductStampsMap());
        return Stamps$.MODULE$.apply(products, sources, libraries);
    }

    public OutputGroup fromOutputGroup(Schema.OutputGroup outputGroup) {
        java.nio.file.Path sourcePath = this.fromPathString(outputGroup.getSourcePath());
        java.nio.file.Path sourceDir = this.mapper.mapSourceDir(sourcePath);
        java.nio.file.Path targetPath = this.fromPathString(outputGroup.getTargetPath());
        java.nio.file.Path targetDir = this.mapper.mapOutputDir(targetPath);
        return CompileOutput$.MODULE$.outputGroup(sourceDir, targetDir);
    }

    public Output fromCompilationOutput(Schema.Compilation c) {
        Output output;
        Schema.Compilation.OutputCase outputCase = c.getOutputCase();
        if (Schema.Compilation.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            Output output2;
            java.nio.file.Path target;
            Schema.SingleOutput single = c.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                output2 = CompileOutput$.MODULE$.empty();
            } else {
                java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
                output2 = CompileOutput$.MODULE$.apply(outputDir);
            }
            output = output2;
        } else if (Schema.Compilation.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = c.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            output = CompileOutput$.MODULE$.apply(groups);
        } else {
            if (Schema.Compilation.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
            }
            throw new MatchError((Object)outputCase);
        }
        return output;
    }

    public xsbti.compile.analysis.Compilation fromCompilation(Schema.Compilation compilation) {
        Output output = this.fromCompilationOutput(compilation);
        return new Compilation(compilation.getStartTimeMillis(), output);
    }

    public Compilations fromCompilations(Schema.Compilations compilations0) {
        Iterator compilations = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(compilations0.getCompilationsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)compilation -> this.fromCompilation((Schema.Compilation)compilation));
        Seq castedCompilations = compilations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Compilation compilation;
            xsbti.compile.analysis.Compilation compilation2 = x0$1;
            if (!(compilation2 instanceof Compilation)) {
                throw new MatchError((Object)compilation2);
            }
            Compilation compilation3 = compilation = (Compilation)compilation2;
            return compilation3;
        }).toSeq();
        return Compilations$.MODULE$.of(castedCompilations);
    }

    public Position fromPosition(Schema.Position position) {
        return InterfaceUtil$.MODULE$.position(this.fromInt(position.getLine()), position.getLineContent(), this.fromInt(position.getOffset()), this.fromInt(position.getPointer()), this.fromString(position.getPointerSpace()), this.fromString(position.getSourcePath()), this.fromString(position.getSourceFilepath()).map((Function1 & Serializable & scala.Serializable)path -> this.fromPathString((String)path)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toFile()), this.fromInt(position.getStartOffset()), this.fromInt(position.getEndOffset()), this.fromInt(position.getStartLine()), this.fromInt(position.getStartColumn()), this.fromInt(position.getEndLine()), this.fromInt(position.getEndColumn()));
    }

    public Severity fromSeverity(Schema.Severity severity, int id) {
        Severity severity2;
        Schema.Severity severity3 = severity;
        if (Schema.Severity.INFO.equals(severity3)) {
            severity2 = Severity.Info;
        } else if (Schema.Severity.WARN.equals(severity3)) {
            severity2 = Severity.Warn;
        } else if (Schema.Severity.ERROR.equals(severity3)) {
            severity2 = Severity.Error;
        } else {
            if (Schema.Severity.UNRECOGNIZED.equals(severity3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedSeverity(id)).$bang$bang();
            }
            throw new MatchError((Object)severity3);
        }
        return severity2;
    }

    private Option<String> fromString(String value) {
        String string = value;
        String string2 = ProtobufDefaults$.MODULE$.MissingString();
        return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)value);
    }

    private Option<Integer> fromInt(int value) {
        return value == ProtobufDefaults$.MODULE$.MissingInt() ? None$.MODULE$ : new Some((Object)Predef$.MODULE$.int2Integer(value));
    }

    public Problem fromProblem(Schema.Problem problem) {
        String category = problem.getCategory();
        String message = problem.getMessage();
        Severity severity = this.fromSeverity(problem.getSeverity(), problem.getSeverityValue());
        if (!problem.hasPosition()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPositionInProblem()).$bang$bang();
        }
        Position position = this.fromPosition(problem.getPosition());
        Option<String> rendered = this.fromString(problem.getRendered());
        return InterfaceUtil$.MODULE$.problem(category, position, message, severity, rendered);
    }

    public SourceInfo fromSourceInfo(Schema.SourceInfo sourceInfo) {
        Seq mainClasses = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)sourceInfo.getMainClassesList()).asScala()).toSeq();
        Seq reportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getReportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        Seq unreportedProblems = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getUnreportedProblemsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        return SourceInfos$.MODULE$.makeInfo(reportedProblems, unreportedProblems, mainClasses);
    }

    public SourceInfos fromSourceInfos(Schema.SourceInfos sourceInfos0) {
        Iterator sourceInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sourceInfos0.getSourceInfosMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.SourceInfo value = (Schema.SourceInfo)tuple2._2();
            VirtualFileRef file = $this.mapper.mapSourceFile(this.fromPathStringV(path));
            SourceInfo sourceInfo = this.fromSourceInfo(value);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)sourceInfo);
            return tuple22;
        });
        return SourceInfos$.MODULE$.of(sourceInfos.toMap(Predef$.MODULE$.$conforms()));
    }

    public FileHash fromClasspathFileHash(Schema.FileHash fileHash) {
        int hash = fileHash.getHash();
        java.nio.file.Path classpathEntry = this.fromPathString(fileHash.getPath());
        java.nio.file.Path newClasspathEntry = this.mapper.mapClasspathEntry(classpathEntry);
        return FileHash.of((java.nio.file.Path)newClasspathEntry, (int)hash);
    }

    public MiniOptions fromMiniOptions(Schema.MiniOptions miniOptions) {
        FileHash[] classpathHash = (FileHash[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniOptions.getClasspathHashList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)fileHash -> this.fromClasspathFileHash((Schema.FileHash)fileHash)).toArray(ClassTag$.MODULE$.apply(FileHash.class));
        String[] javacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)miniOptions.getJavacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)javacOption -> $this.mapper.mapJavacOption((String)javacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] scalacOptions = (String[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)miniOptions.getScalacOptionsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)scalacOption -> $this.mapper.mapScalacOption((String)scalacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        return MiniOptions.of((FileHash[])classpathHash, (String[])scalacOptions, (String[])javacOptions);
    }

    public CompileOrder fromCompileOrder(Schema.CompileOrder compileOrder, int id) {
        CompileOrder compileOrder2;
        Schema.CompileOrder compileOrder3 = compileOrder;
        if (Schema.CompileOrder.MIXED.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.Mixed;
        } else if (Schema.CompileOrder.JAVATHENSCALA.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.JavaThenScala;
        } else if (Schema.CompileOrder.SCALATHENJAVA.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.ScalaThenJava;
        } else {
            if (Schema.CompileOrder.UNRECOGNIZED.equals(compileOrder3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedOrder(id)).$bang$bang();
            }
            throw new MatchError((Object)compileOrder3);
        }
        return compileOrder2;
    }

    public T2<String, String> fromStringTuple(Schema.Tuple tuple) {
        return InterfaceUtil$.MODULE$.t2(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tuple.getFirst()), (Object)tuple.getSecond()));
    }

    public Output fromMiniSetupOutput(Schema.MiniSetup miniSetup) {
        Output output;
        Schema.MiniSetup.OutputCase outputCase = miniSetup.getOutputCase();
        if (Schema.MiniSetup.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            Output output2;
            java.nio.file.Path target;
            Schema.SingleOutput single = miniSetup.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                output2 = CompileOutput$.MODULE$.empty();
            } else {
                java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
                output2 = CompileOutput$.MODULE$.apply(outputDir);
            }
            output = output2;
        } else if (Schema.MiniSetup.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = miniSetup.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            output = CompileOutput$.MODULE$.apply(groups);
        } else {
            if (Schema.MiniSetup.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
            }
            throw new MatchError((Object)outputCase);
        }
        return output;
    }

    public MiniSetup fromMiniSetup(Schema.MiniSetup miniSetup) {
        Output output = this.fromMiniSetupOutput(miniSetup);
        if (!miniSetup.hasMiniOptions()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedMiniOptionsInSetup()).$bang$bang();
        }
        MiniOptions miniOptions = this.fromMiniOptions(miniSetup.getMiniOptions());
        String compilerVersion = miniSetup.getCompilerVersion();
        CompileOrder compileOrder = this.fromCompileOrder(miniSetup.getCompileOrder(), miniSetup.getCompileOrderValue());
        boolean storeApis = miniSetup.getStoreApis();
        T2[] extra = (T2[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(miniSetup.getExtraList()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)tuple -> this.fromStringTuple((Schema.Tuple)tuple)).toArray(ClassTag$.MODULE$.apply(T2.class));
        MiniSetup original = MiniSetup.of((Output)output, (MiniOptions)miniOptions, (String)compilerVersion, (CompileOrder)compileOrder, (boolean)storeApis, (T2[])extra);
        return this.mapper.mapMiniSetup(original);
    }

    public <T> EfficientTraverse<T> EfficientTraverse(List<T> seq) {
        return new EfficientTraverse<T>(this, seq);
    }

    public <T> OptionReader<T> OptionReader(Option<T> option) {
        return new OptionReader<T>(this, option);
    }

    public Path fromPath(Schema.Path path) {
        PathComponent[] components = (PathComponent[])this.EfficientTraverse(path.getComponentsList()).toZincArray((Function1 & Serializable & scala.Serializable)pathComponent -> this.fromPathComponent$1((Schema.Path.PathComponent)pathComponent), ClassTag$.MODULE$.apply(PathComponent.class));
        return Path.of((PathComponent[])components);
    }

    public Annotation fromAnnotation(Schema.Annotation annotation) {
        AnnotationArgument[] arguments = (AnnotationArgument[])this.EfficientTraverse(annotation.getArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)argument -> ProtobufReaders.fromAnnotationArgument$1(argument), ClassTag$.MODULE$.apply(AnnotationArgument.class));
        None$ b = annotation.hasBase() ? new Some((Object)annotation.getBase()) : None$.MODULE$;
        Type base = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Annotation.class));
        return Annotation.of((Type)base, (AnnotationArgument[])arguments);
    }

    public Structure fromStructure(Schema.Type.Structure tpe) {
        Lazy parents = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getParentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class)));
        Lazy declared = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getDeclaredList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        Lazy inherited = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getInheritedList()).toZincArray((Function1 & Serializable & scala.Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        return Structure.of((Lazy)parents, (Lazy)declared, (Lazy)inherited);
    }

    public Type fromType(Schema.Type type) {
        ParameterRef parameterRef;
        Schema.Type.ValueCase valueCase = type.getValueCase();
        if (Schema.Type.ValueCase.PARAMETERREF.equals(valueCase)) {
            parameterRef = ProtobufReaders.fromParameterRef$1(type.getParameterRef());
        } else if (Schema.Type.ValueCase.PARAMETERIZED.equals(valueCase)) {
            parameterRef = this.fromParameterized$1(type.getParameterized());
        } else if (Schema.Type.ValueCase.STRUCTURE.equals(valueCase)) {
            parameterRef = this.fromStructure(type.getStructure());
        } else if (Schema.Type.ValueCase.POLYMORPHIC.equals(valueCase)) {
            parameterRef = this.fromPolymorphic$1(type.getPolymorphic());
        } else if (Schema.Type.ValueCase.CONSTANT.equals(valueCase)) {
            parameterRef = this.fromConstant$1(type.getConstant());
        } else if (Schema.Type.ValueCase.EXISTENTIAL.equals(valueCase)) {
            parameterRef = this.fromExistential$1(type.getExistential());
        } else if (Schema.Type.ValueCase.SINGLETON.equals(valueCase)) {
            parameterRef = this.fromSingleton$1(type.getSingleton());
        } else if (Schema.Type.ValueCase.PROJECTION.equals(valueCase)) {
            parameterRef = this.fromProjection$1(type.getProjection());
        } else if (Schema.Type.ValueCase.ANNOTATED.equals(valueCase)) {
            parameterRef = this.fromAnnotated$1(type.getAnnotated());
        } else if (Schema.Type.ValueCase.EMPTYTYPE.equals(valueCase)) {
            parameterRef = ProtobufDefaults$ReadersConstants$.MODULE$.EmptyType();
        } else {
            if (Schema.Type.ValueCase.VALUE_NOT_SET.equals(valueCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyType()).$bang$bang();
            }
            throw new MatchError((Object)valueCase);
        }
        return parameterRef;
    }

    public Modifiers fromModifiers(Schema.Modifiers modifiers) {
        return InternalApiProxy$Modifiers$.MODULE$.apply(modifiers.getFlags());
    }

    public Access fromAccess(Schema.Access access) {
        Public public_;
        Schema.Access.TypeCase typeCase = access.getTypeCase();
        if (Schema.Access.TypeCase.PUBLIC.equals(typeCase)) {
            public_ = ProtobufDefaults$ReadersConstants$.MODULE$.Public();
        } else if (Schema.Access.TypeCase.PROTECTED.equals(typeCase)) {
            Schema.Protected a = access.getProtected();
            public_ = Protected.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        } else if (Schema.Access.TypeCase.PRIVATE.equals(typeCase)) {
            Schema.Private a = access.getPrivate();
            public_ = Private.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        } else {
            if (Schema.Access.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedValidAccessType()).$bang$bang();
            }
            throw new MatchError((Object)typeCase);
        }
        return public_;
    }

    public DefinitionType fromDefinitionType(Schema.DefinitionType definitionType) {
        DefinitionType definitionType2;
        Schema.DefinitionType definitionType3 = definitionType;
        if (Schema.DefinitionType.CLASSDEF.equals(definitionType3)) {
            definitionType2 = DefinitionType.ClassDef;
        } else if (Schema.DefinitionType.MODULE.equals(definitionType3)) {
            definitionType2 = DefinitionType.Module;
        } else if (Schema.DefinitionType.TRAIT.equals(definitionType3)) {
            definitionType2 = DefinitionType.Trait;
        } else if (Schema.DefinitionType.PACKAGEMODULE.equals(definitionType3)) {
            definitionType2 = DefinitionType.PackageModule;
        } else {
            if (Schema.DefinitionType.UNRECOGNIZED.equals(definitionType3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedDefinitionType()).$bang$bang();
            }
            throw new MatchError((Object)definitionType3);
        }
        return definitionType2;
    }

    public ClassDefinition fromClassDefinition(Schema.ClassDefinition classDefinition) {
        ClassLikeDef classLikeDef;
        String name = classDefinition.getName().intern();
        if (!classDefinition.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingAccessInDef()).$bang$bang();
        }
        Access access = this.fromAccess(classDefinition.getAccess());
        if (!classDefinition.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingModifiersInDef()).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classDefinition.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classDefinition.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        Schema.ClassDefinition.ExtraCase extraCase = classDefinition.getExtraCase();
        if (Schema.ClassDefinition.ExtraCase.CLASSLIKEDEF.equals(extraCase)) {
            classLikeDef = this.fromClassLikeDef$1(classDefinition.getClassLikeDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.DEFDEF.equals(extraCase)) {
            classLikeDef = this.fromDefDef$1(classDefinition.getDefDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.VALDEF.equals(extraCase)) {
            classLikeDef = this.fromValDef$1(classDefinition.getValDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.VARDEF.equals(extraCase)) {
            classLikeDef = this.fromVarDef$1(classDefinition.getVarDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.TYPEALIAS.equals(extraCase)) {
            classLikeDef = this.fromTypeAlias$1(classDefinition.getTypeAlias(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.TYPEDECLARATION.equals(extraCase)) {
            classLikeDef = this.fromTypeDeclaration$1(classDefinition.getTypeDeclaration(), name, access, modifiers, annotations);
        } else {
            if (Schema.ClassDefinition.ExtraCase.EXTRA_NOT_SET.equals(extraCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyDefType()).$bang$bang();
            }
            throw new MatchError((Object)extraCase);
        }
        return classLikeDef;
    }

    public TypeParameter fromTypeParameter(Schema.TypeParameter typeParameter2) {
        String id = typeParameter2.getId();
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(typeParameter2.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeParameter2.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        Variance variance = ProtobufReaders.fromVariance$1(typeParameter2.getVariance());
        if (!typeParameter2.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeParameter()).$bang$bang();
        }
        Type lowerBound = this.fromType(typeParameter2.getLowerBound());
        if (!typeParameter2.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeParameter()).$bang$bang();
        }
        Type upperBound = this.fromType(typeParameter2.getUpperBound());
        return TypeParameter.of((String)id, (Annotation[])annotations, (TypeParameter[])typeParameters, (Variance)variance, (Type)lowerBound, (Type)upperBound);
    }

    public ClassLike fromClassLike(Schema.ClassLike classLike) {
        String name = classLike.getName().intern();
        if (!classLike.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Access.class)).$bang$bang();
        }
        Access access = this.fromAccess(classLike.getAccess());
        if (!classLike.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Modifiers.class)).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classLike.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classLike.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        DefinitionType definitionType = this.fromDefinitionType(classLike.getDefinitionType());
        if (!classLike.hasSelfType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expectedMsg$1("self type")).$bang$bang();
        }
        Lazy selfType = SafeLazyProxy$.MODULE$.strict((Object)this.fromType(classLike.getSelfType()));
        if (!classLike.hasStructure()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Type.Structure.class)).$bang$bang();
        }
        Lazy structure = SafeLazyProxy$.MODULE$.strict((Object)this.fromStructure(classLike.getStructure()));
        String[] savedAnnotations = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)classLike.getSavedAnnotationsList()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        Type[] childrenOfSealedClass = (Type[])this.EfficientTraverse(classLike.getChildrenOfSealedClassList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        boolean topLevel = classLike.getTopLevel();
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(classLike.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLike.of((String)name, (Access)access, (Modifiers)modifiers, (Annotation[])annotations, (DefinitionType)definitionType, (Lazy)selfType, (Lazy)structure, (String[])savedAnnotations, (Type[])childrenOfSealedClass, (boolean)topLevel, (TypeParameter[])typeParameters);
    }

    public UseScope fromUseScope(Schema.UseScope useScope, int id) {
        UseScope useScope2;
        Schema.UseScope useScope3 = useScope;
        if (Schema.UseScope.DEFAULT.equals(useScope3)) {
            useScope2 = UseScope.Default;
        } else if (Schema.UseScope.IMPLICIT.equals(useScope3)) {
            useScope2 = UseScope.Implicit;
        } else if (Schema.UseScope.PATMAT.equals(useScope3)) {
            useScope2 = UseScope.PatMatTarget;
        } else {
            if (Schema.UseScope.UNRECOGNIZED.equals(useScope3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedUseScope(id)).$bang$bang();
            }
            throw new MatchError((Object)useScope3);
        }
        return useScope2;
    }

    public AnalyzedClass fromAnalyzedClass(boolean shouldStoreApis, Schema.AnalyzedClass analyzedClass) {
        ProtobufDefaults$EmptyLazyCompanions$ protobufDefaults$EmptyLazyCompanions$;
        long compilationTs = analyzedClass.getCompilationTimestamp();
        String name = analyzedClass.getName().intern();
        if (!shouldStoreApis) {
            protobufDefaults$EmptyLazyCompanions$ = ProtobufDefaults$EmptyLazyCompanions$.MODULE$;
        } else {
            if (!analyzedClass.hasApi()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedCompanionsInAnalyzedClass()).$bang$bang();
            }
            protobufDefaults$EmptyLazyCompanions$ = SafeLazyProxy$.MODULE$.strict((Object)this.fromCompanions$1(analyzedClass.getApi()));
        }
        ProtobufDefaults$EmptyLazyCompanions$ api = protobufDefaults$EmptyLazyCompanions$;
        int apiHash = analyzedClass.getApiHash();
        Schema.Version version = this.currentVersion;
        Schema.Version version2 = Schema.Version.V1;
        int extraHash = !(version != null ? !version.equals(version2) : version2 != null) ? 0 : analyzedClass.getExtraHash();
        NameHash[] nameHashes = (NameHash[])this.EfficientTraverse(analyzedClass.getNameHashesList()).toZincArray((Function1 & Serializable & scala.Serializable)nameHash -> this.fromNameHash$1((Schema.NameHash)nameHash), ClassTag$.MODULE$.apply(NameHash.class));
        boolean hasMacro = analyzedClass.getHasMacro();
        String provenance = analyzedClass.getProvenance().intern();
        return AnalyzedClass.of((long)compilationTs, (String)name, (Lazy)api, (int)apiHash, (NameHash[])nameHashes, (boolean)hasMacro, (int)extraHash, (String)provenance);
    }

    private final Function1<String, String> stringId() {
        return this.stringId;
    }

    private final Function1<String, VirtualFileRef> stringToSource() {
        return this.stringToSource;
    }

    private final Function1<String, VirtualFileRef> stringToLibrary() {
        return this.stringToLibrary;
    }

    private final Function1<String, VirtualFileRef> stringToProd() {
        return this.stringToProd;
    }

    public Relations fromRelations(Schema.Relations relations) {
        Relation srcProd = ProtobufReaders.fromMap$1(relations.getSrcProdMap(), this.stringToSource(), this.stringToProd());
        Relation libraryDep = ProtobufReaders.fromMap$1(relations.getLibraryDepMap(), this.stringToSource(), this.stringToLibrary());
        Relation libraryClassName = ProtobufReaders.fromMap$1(relations.getLibraryClassNameMap(), this.stringToLibrary(), this.stringId());
        if (!relations.hasMemberRef()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("member refs")).$bang$bang();
        }
        Relations.ClassDependencies memberRef = this.fromClassDependencies$1(relations.getMemberRef());
        if (!relations.hasInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("inheritance")).$bang$bang();
        }
        Relations.ClassDependencies inheritance = this.fromClassDependencies$1(relations.getInheritance());
        if (!relations.hasLocalInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("local inheritance")).$bang$bang();
        }
        Relations.ClassDependencies localInheritance = this.fromClassDependencies$1(relations.getLocalInheritance());
        Relation classes = ProtobufReaders.fromMap$1(relations.getClassesMap(), this.stringToSource(), this.stringId());
        Relation productClassName = ProtobufReaders.fromMap$1(relations.getProductClassNameMap(), this.stringId(), this.stringId());
        Relation names = this.fromUsedNamesMap$1(relations.getNamesMap());
        InternalDependencies internal = new InternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.internal())})));
        ExternalDependencies external = new ExternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.external())})));
        return Relations$.MODULE$.make(srcProd, libraryDep, libraryClassName, internal, external, classes, names, productClassName);
    }

    public APIs fromApis(boolean shouldStoreApis, Schema.APIs apis) {
        scala.collection.immutable.Map internal = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getInternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, v));
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map external = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getExternalMap()).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, v));
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
        return APIs$.MODULE$.apply(internal, external);
    }

    public Tuple2<APIs, Schema.Version> fromApisFile(Schema.APIsFile apisFile, boolean shouldStoreApis) {
        if (!apisFile.hasApis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedApisInApisFile()).$bang$bang();
        }
        APIs apis = this.fromApis(shouldStoreApis, apisFile.getApis());
        Schema.Version version = apisFile.getVersion();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)apis), (Object)version);
    }

    public Analysis fromAnalysis(Schema.Analysis analysis) {
        if (!analysis.hasStamps()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Stamps.class)).$bang$bang();
        }
        Stamps stamps = this.fromStamps(analysis.getStamps());
        if (!analysis.hasRelations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Relations.class)).$bang$bang();
        }
        Relations relations = this.fromRelations(analysis.getRelations());
        if (!analysis.hasSourceInfos()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.SourceInfos.class)).$bang$bang();
        }
        SourceInfos sourceInfos = this.fromSourceInfos(analysis.getSourceInfos());
        if (!analysis.hasCompilations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Compilations.class)).$bang$bang();
        }
        Compilations compilations = this.fromCompilations(analysis.getCompilations());
        Stamps x$1 = stamps;
        Relations x$2 = relations;
        SourceInfos x$3 = sourceInfos;
        Compilations x$4 = compilations;
        APIs x$5 = Analysis$.MODULE$.Empty().copy$default$2();
        return Analysis$.MODULE$.Empty().copy(x$1, x$5, x$2, x$3, x$4);
    }

    public Tuple3<Analysis, MiniSetup, Schema.Version> fromAnalysisFile(Schema.AnalysisFile analysisFile) {
        Schema.Version version = analysisFile.getVersion();
        if (!analysisFile.hasAnalysis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(49).append("The analysis file from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        Analysis analysis = this.fromAnalysis(analysisFile.getAnalysis());
        if (!analysisFile.hasMiniSetup()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(46).append("The mini setup from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        MiniSetup miniSetup = this.fromMiniSetup(analysisFile.getMiniSetup());
        return new Tuple3((Object)analysis, (Object)miniSetup, (Object)version);
    }

    private final scala.collection.immutable.Map fromBinarySchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapBinaryFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapBinaryStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromSourceSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapSourceFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapSourceStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final scala.collection.immutable.Map fromProductSchemaMap$1(Map stamps) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapProductFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapProductStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    private final PathComponent fromPathComponent$1(Schema.Path.PathComponent pathComponent) {
        Id id;
        Schema.Path.PathComponent.ComponentCase componentCase = pathComponent.getComponentCase();
        if (Schema.Path.PathComponent.ComponentCase.ID.equals(componentCase)) {
            Schema.Id c = pathComponent.getId();
            id = Id.of((String)c.getId());
        } else if (Schema.Path.PathComponent.ComponentCase.SUPER.equals(componentCase)) {
            Schema.Super c = pathComponent.getSuper();
            if (!c.hasQualifier()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSuper()).$bang$bang();
            }
            Path q = this.fromPath(c.getQualifier());
            id = Super.of((Path)q);
        } else if (Schema.Path.PathComponent.ComponentCase.THIS.equals(componentCase)) {
            id = ProtobufDefaults$ReadersConstants$.MODULE$.This();
        } else {
            if (Schema.Path.PathComponent.ComponentCase.COMPONENT_NOT_SET.equals(componentCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expected(Schema.Path.PathComponent.ComponentCase.class, Schema.Path.PathComponent.class)).$bang$bang();
            }
            throw new MatchError((Object)componentCase);
        }
        return id;
    }

    private static final AnnotationArgument fromAnnotationArgument$1(Schema.AnnotationArgument argument) {
        String name = argument.getName().intern();
        String value = argument.getValue();
        return AnnotationArgument.of((String)name, (String)value);
    }

    private static final Lazy lazy$1(Object value) {
        return SafeLazyProxy$.MODULE$.strict(value);
    }

    private static final ParameterRef fromParameterRef$1(Schema.Type.ParameterRef tpe) {
        return ParameterRef.of((String)tpe.getId());
    }

    private final Parameterized fromParameterized$1(Schema.Type.Parameterized tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Parameterized.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Type[] typeArguments = (Type[])this.EfficientTraverse(tpe.getTypeArgumentsList()).toZincArray((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        return Parameterized.of((Type)baseType, (Type[])typeArguments);
    }

    private final Polymorphic fromPolymorphic$1(Schema.Type.Polymorphic tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Polymorphic.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(tpe.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Polymorphic.of((Type)baseType, (TypeParameter[])typeParameters);
    }

    private final Constant fromConstant$1(Schema.Type.Constant tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Constant.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        String value = tpe.getValue();
        return Constant.of((Type)baseType, (String)value);
    }

    private final Existential fromExistential$1(Schema.Type.Existential tpe) {
        None$ b = tpe.hasBaseType() ? new Some((Object)tpe.getBaseType()) : None$.MODULE$;
        Type baseType = (Type)this.OptionReader((Option)b).read((Function1 & Serializable & scala.Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Existential.class));
        TypeParameter[] clause = (TypeParameter[])this.EfficientTraverse(tpe.getClauseList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Existential.of((Type)baseType, (TypeParameter[])clause);
    }

    private final Singleton fromSingleton$1(Schema.Type.Singleton tpe) {
        if (!tpe.hasPath()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSingleton()).$bang$bang();
        }
        Path path = this.fromPath(tpe.getPath());
        return Singleton.of((Path)path);
    }

    private final Projection fromProjection$1(Schema.Type.Projection tpe) {
        String id = tpe.getId();
        if (!tpe.hasPrefix()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPrefixInProjection()).$bang$bang();
        }
        Type prefix = this.fromType(tpe.getPrefix());
        return Projection.of((Type)prefix, (String)id);
    }

    private final Annotated fromAnnotated$1(Schema.Type.Annotated tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Annotated.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(tpe.getAnnotationsList()).toZincArray((Function1 & Serializable & scala.Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        return Annotated.of((Type)baseType, (Annotation[])annotations);
    }

    private static final Qualifier fromQualifier$1(Schema.Qualifier qualifier) {
        IdQualifier idQualifier;
        Schema.Qualifier.TypeCase typeCase = qualifier.getTypeCase();
        if (Schema.Qualifier.TypeCase.IDQUALIFIER.equals(typeCase)) {
            Schema.IdQualifier q = qualifier.getIdQualifier();
            idQualifier = IdQualifier.of((String)q.getValue());
        } else if (Schema.Qualifier.TypeCase.THISQUALIFIER.equals(typeCase)) {
            idQualifier = ProtobufDefaults$ReadersConstants$.MODULE$.ThisQualifier();
        } else if (Schema.Qualifier.TypeCase.UNQUALIFIED.equals(typeCase)) {
            idQualifier = ProtobufDefaults$ReadersConstants$.MODULE$.Unqualified();
        } else {
            if (Schema.Qualifier.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyQualifier()).$bang$bang();
            }
            throw new MatchError((Object)typeCase);
        }
        return idQualifier;
    }

    private final Qualifier readQualifier$1(Option qualifier2) {
        return (Qualifier)this.OptionReader(qualifier2).read((Function1 & Serializable & scala.Serializable)qualifier -> ProtobufReaders.fromQualifier$1(qualifier), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedQualifierInAccess());
    }

    private static final ParameterModifier fromParameterModifier$1(Schema.ParameterModifier modifier) {
        ParameterModifier parameterModifier;
        Schema.ParameterModifier parameterModifier2 = modifier;
        if (Schema.ParameterModifier.PLAIN.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.Plain;
        } else if (Schema.ParameterModifier.BYNAME.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.ByName;
        } else if (Schema.ParameterModifier.REPEATED.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.Repeated;
        } else {
            if (Schema.ParameterModifier.UNRECOGNIZED.equals(parameterModifier2)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedParamModifier()).$bang$bang();
            }
            throw new MatchError((Object)parameterModifier2);
        }
        return parameterModifier;
    }

    private final MethodParameter fromMethodParameter$1(Schema.MethodParameter methodParameter) {
        String name = methodParameter.getName().intern();
        boolean hasDefault = methodParameter.getHasDefault();
        if (!methodParameter.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.MethodParameter.class)).$bang$bang();
        }
        Type type = this.fromType(methodParameter.getType());
        ParameterModifier modifier = ProtobufReaders.fromParameterModifier$1(methodParameter.getModifier());
        return MethodParameter.of((String)name, (Type)type, (boolean)hasDefault, (ParameterModifier)modifier);
    }

    private final ParameterList fromParameterList$1(Schema.ParameterList parameterList) {
        boolean isImplicit = parameterList.getIsImplicit();
        MethodParameter[] parameters = (MethodParameter[])this.EfficientTraverse(parameterList.getParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)methodParameter -> this.fromMethodParameter$1((Schema.MethodParameter)methodParameter), ClassTag$.MODULE$.apply(MethodParameter.class));
        return ParameterList.of((MethodParameter[])parameters, (boolean)isImplicit);
    }

    private final ClassLikeDef fromClassLikeDef$1(Schema.ClassDefinition.ClassLikeDef defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        DefinitionType definitionType = this.fromDefinitionType(defDef.getDefinitionType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLikeDef.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (DefinitionType)definitionType);
    }

    private final Def fromDefDef$1(Schema.ClassDefinition.Def defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!defDef.hasReturnType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedReturnTypeInDef()).$bang$bang();
        }
        Type returnType = this.fromType(defDef.getReturnType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        ParameterList[] valueParameters = (ParameterList[])this.EfficientTraverse(defDef.getValueParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)parameterList -> this.fromParameterList$1((Schema.ParameterList)parameterList), ClassTag$.MODULE$.apply(ParameterList.class));
        return Def.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (ParameterList[])valueParameters, (Type)returnType);
    }

    private final Val fromValDef$1(Schema.ClassDefinition.Val valDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!valDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Val.class)).$bang$bang();
        }
        Type tpe = this.fromType(valDef.getType());
        return Val.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final Var fromVarDef$1(Schema.ClassDefinition.Var varDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!varDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Var.class)).$bang$bang();
        }
        Type tpe = this.fromType(varDef.getType());
        return Var.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final TypeAlias fromTypeAlias$1(Schema.ClassDefinition.TypeAlias typeAlias, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!typeAlias.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.TypeAlias.class)).$bang$bang();
        }
        Type tpe = this.fromType(typeAlias.getType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeAlias.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeAlias.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (Type)tpe);
    }

    private final TypeDeclaration fromTypeDeclaration$1(Schema.ClassDefinition.TypeDeclaration decl, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!decl.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeDeclaration()).$bang$bang();
        }
        Type lowerBound = this.fromType(decl.getLowerBound());
        if (!decl.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeDeclaration()).$bang$bang();
        }
        Type upperBound = this.fromType(decl.getUpperBound());
        TypeParameter[] typeParams = (TypeParameter[])this.EfficientTraverse(decl.getTypeParametersList()).toZincArray((Function1 & Serializable & scala.Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeDeclaration.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParams, (Type)lowerBound, (Type)upperBound);
    }

    private static final Variance fromVariance$1(Schema.Variance variance) {
        Variance variance2;
        Schema.Variance variance3 = variance;
        if (Schema.Variance.INVARIANT.equals(variance3)) {
            variance2 = Variance.Invariant;
        } else if (Schema.Variance.COVARIANT.equals(variance3)) {
            variance2 = Variance.Covariant;
        } else if (Schema.Variance.CONTRAVARIANT.equals(variance3)) {
            variance2 = Variance.Contravariant;
        } else {
            if (Schema.Variance.UNRECOGNIZED.equals(variance3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedVariance()).$bang$bang();
            }
            throw new MatchError((Object)variance3);
        }
        return variance2;
    }

    private static final String expectedMsg$1(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.ClassLike.class);
    }

    private static final String expected$1(Class clazz) {
        return ProtobufReaders.expectedMsg$1(clazz.getName());
    }

    private static final String expected$2(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Companions.class);
    }

    private final Companions fromCompanions$1(Schema.Companions companions) {
        if (!companions.hasClassApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("class api")).$bang$bang();
        }
        ClassLike classApi = this.fromClassLike(companions.getClassApi());
        if (!companions.hasObjectApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("object api")).$bang$bang();
        }
        ClassLike objectApi = this.fromClassLike(companions.getObjectApi());
        return Companions.of((ClassLike)classApi, (ClassLike)objectApi);
    }

    private final NameHash fromNameHash$1(Schema.NameHash nameHash) {
        String name = nameHash.getName().intern();
        int hash = nameHash.getHash();
        UseScope scope = this.fromUseScope(nameHash.getScope(), nameHash.getScopeValue());
        return NameHash.of((String)name, (UseScope)scope, (int)hash);
    }

    public static final /* synthetic */ boolean $anonfun$fromRelations$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$fromRelations$2(Function1 fk$1, RelationBuilder builder$1, Function1 fv$1, Tuple2 x$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String kString = (String)tuple2._1();
            Schema.Values vs = (Schema.Values)tuple2._2();
            if (!vs.getValuesList().isEmpty()) {
                Object k = fk$1.apply((Object)kString);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)vs.getValuesList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)vString -> {
                    builder$1.update(k, fv$1.apply((Object)vString));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final Relation fromMap$1(Map map, Function1 fk, Function1 fv) {
        RelationBuilder builder = new RelationBuilder();
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProtobufReaders.$anonfun$fromRelations$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ProtobufReaders.$anonfun$fromRelations$2(fk, builder, fv, x$3);
            return BoxedUnit.UNIT;
        });
        return builder.result();
    }

    private final Relations.ClassDependencies fromClassDependencies$1(Schema.ClassDependencies classDependencies) {
        Relation internal = ProtobufReaders.fromMap$1(classDependencies.getInternalMap(), this.stringId(), this.stringId());
        Relation external = ProtobufReaders.fromMap$1(classDependencies.getExternalMap(), this.stringId(), this.stringId());
        return new Relations.ClassDependencies(internal, external);
    }

    private final UsedName fromUsedName$1(Schema.UsedName usedName) {
        String name = usedName.getName().intern();
        EnumSet<UseScope> useScopes = EnumSet.noneOf(UseScope.class);
        int len = usedName.getScopesCount();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), len - 1).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> useScopes.add(this.fromUseScope(usedName.getScopes(i), usedName.getScopesValue(i))));
        return UsedName$.MODULE$.make(name, useScopes);
    }

    public static final /* synthetic */ boolean $anonfun$fromRelations$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$fromRelations$6(ProtobufReaders $this, RelationBuilder builder$2, Tuple2 x$4) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            Schema.UsedNames used = (Schema.UsedNames)tuple2._2();
            Buffer usedNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(used.getUsedNamesList()).asScala();
            if (!usedNames.isEmpty()) {
                usedNames.foreach((Function1 & Serializable & scala.Serializable)schemaUsedName -> {
                    builder$2.update((Object)k, (Object)$this.fromUsedName$1(schemaUsedName));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final Relation fromUsedNamesMap$1(Map map) {
        RelationBuilder builder = new RelationBuilder();
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ProtobufReaders.$anonfun$fromRelations$5(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ProtobufReaders.$anonfun$fromRelations$6(this, builder, x$4);
            return BoxedUnit.UNIT;
        });
        return builder.result();
    }

    private static final String expected$3(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Relations.class);
    }

    private static final String expected$4(Class clazz) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(clazz, Schema.Analysis.class);
    }

    public ProtobufReaders(ReadMapper mapper, Schema.Version currentVersion) {
        this.mapper = mapper;
        this.currentVersion = currentVersion;
        this.stringId = (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x);
        this.stringToSource = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapSourceFile(this.fromPathStringV((String)path));
        this.stringToLibrary = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapBinaryFile(this.fromPathStringV((String)path));
        this.stringToProd = (Function1 & Serializable & scala.Serializable)path -> $this.mapper.mapProductFile(this.fromPathStringV((String)path));
    }

    public class EfficientTraverse<T> {
        private final List<T> seq;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R[] toZincArray(Function1<T, R> f, ClassTag<R> evidence$1) {
            return this.seq.stream().map(x -> f.apply(x)).toArray(x$2 -> (Object[])evidence$1.newArray(x$2));
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$EfficientTraverse$$$outer() {
            return this.$outer;
        }

        public EfficientTraverse(ProtobufReaders $outer, List<T> seq) {
            this.seq = seq;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class OptionReader<T> {
        private final Option<T> option;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R read(Function1<T, R> from, Function0<String> errorMessage) {
            return (R)this.option.fold((Function0 & Serializable & scala.Serializable)() -> ProtobufDefaults$Feedback$.MODULE$.StringToException((String)errorMessage.apply()).$bang$bang(), from);
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$OptionReader$$$outer() {
            return this.$outer;
        }

        public OptionReader(ProtobufReaders $outer, Option<T> option) {
            this.option = option;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

