/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.consistent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.consistent.ConsistentAnalysisFormat;
import sbt.internal.inc.consistent.ConsistentFileAnalysisStore$;
import sbt.internal.inc.consistent.Deserializer;
import sbt.internal.inc.consistent.ParallelGzipOutputStream;
import sbt.internal.inc.consistent.Serializer;
import sbt.internal.inc.consistent.SerializerFactory;
import sbt.io.IO$;
import sbt.io.Using$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0005\u0005%t!B\f\u0019\u0011\u0003\tc!B\u0012\u0019\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0003q\u0003bB*\u0002#\u0003%\t\u0001\u0016\u0005\b?\u0006\t\n\u0011\"\u0001a\u0011\u0015\u0011\u0017\u0001\"\u0001d\u0011\u0015\u0011\u0017\u0001\"\u0001f\u0011\u0015\u0011\u0017\u0001\"\u0001i\u0011\u001di\u0017!%A\u0005\u0002\u00014AA\\\u0001\u0007_\"A\u0001H\u0003B\u0001B\u0003%\u0011\b\u0003\u0005x\u0015\t\u0005\t\u0015!\u0003y\u0011!Y(B!A!\u0002\u0013a\b\u0002C(\u000b\u0005\u0003\u0005\u000b\u0011\u0002)\t\r-RA\u0011AA\u0012\u0011\u001d\t\tD\u0003C\u0001\u0003gAq!!\u0012\u000b\t\u0003\t9\u0005C\u0004\u0002V)!\t!a\u0016\b\u0013\u0005e\u0013!!A\t\n\u0005mc\u0001\u00038\u0002\u0003\u0003EI!!\u0018\t\r-\"B\u0011AA0\u0011%\t\t\u0007FI\u0001\n\u0003\t\u0019'A\u000eD_:\u001c\u0018n\u001d;f]R4\u0015\u000e\\3B]\u0006d\u0017p]5t'R|'/\u001a\u0006\u00033i\t!bY8og&\u001cH/\u001a8u\u0015\tYB$A\u0002j]\u000eT!!\b\u0010\u0002\u0011%tG/\u001a:oC2T\u0011aH\u0001\u0004g\n$8\u0001\u0001\t\u0003E\u0005i\u0011\u0001\u0007\u0002\u001c\u0007>t7/[:uK:$h)\u001b7f\u0003:\fG._:jgN#xN]3\u0014\u0005\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002C\u0005!A/\u001a=u)\u0015ys'Q%O!\t\u0001T'D\u00012\u0015\t\u00114'A\u0004d_6\u0004\u0018\u000e\\3\u000b\u0003Q\nQ\u0001_:ci&L!AN\u0019\u0003\u001b\u0005s\u0017\r\\=tSN\u001cFo\u001c:f\u0011\u0015A4\u00011\u0001:\u0003\u00111\u0017\u000e\\3\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AA5p\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\t\u0019KG.\u001a\u0005\u0006\u0005\u000e\u0001\raQ\u0001\b[\u0006\u0004\b/\u001a:t!\t!u)D\u0001F\u0015\t1\u0015'\u0001\u0005b]\u0006d\u0017p]5t\u0013\tAUI\u0001\tSK\u0006$wK]5uK6\u000b\u0007\u000f]3sg\"9!j\u0001I\u0001\u0002\u0004Y\u0015\u0001\u0004:faJ|G-^2jE2,\u0007C\u0001\u0014M\u0013\tiuEA\u0004C_>dW-\u00198\t\u000f=\u001b\u0001\u0013!a\u0001!\u0006Y\u0001/\u0019:bY2,G.[:n!\t1\u0013+\u0003\u0002SO\t\u0019\u0011J\u001c;\u0002\u001dQ,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\tQK\u000b\u0002L-.\nq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u00039\u001e\n!\"\u00198o_R\fG/[8o\u0013\tq\u0016LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0002^3yi\u0012\"WMZ1vYR$C'F\u0001bU\t\u0001f+\u0001\u0004cS:\f'/\u001f\u000b\u0003_\u0011DQ\u0001\u000f\u0004A\u0002e\"2a\f4h\u0011\u0015At\u00011\u0001:\u0011\u0015\u0011u\u00011\u0001D)\u0015y\u0013N[6m\u0011\u0015A\u0004\u00021\u0001:\u0011\u0015\u0011\u0005\u00021\u0001D\u0011\u0015Q\u0005\u00021\u0001L\u0011\u001dy\u0005\u0002%AA\u0002A\u000b\u0001CY5oCJLH\u0005Z3gCVdG\u000f\n\u001b\u0003\r\u0005\u001bFo\u001c:f+\u0015\u0001\u00181AA\f'\rQ\u0011o\f\t\u0003eVl\u0011a\u001d\u0006\u0003iv\nA\u0001\\1oO&\u0011ao\u001d\u0002\u0007\u001f\nTWm\u0019;\u0002\r\u0019|'/\\1u!\t\u0011\u00130\u0003\u0002{1\tA2i\u001c8tSN$XM\u001c;B]\u0006d\u0017p]5t\r>\u0014X.\u0019;\u0002\u0005M4\u0007#\u0002\u0012~\u007f\u0006U\u0011B\u0001@\u0019\u0005E\u0019VM]5bY&TXM\u001d$bGR|'/\u001f\t\u0005\u0003\u0003\t\u0019\u0001\u0004\u0001\u0005\u000f\u0005\u0015!B1\u0001\u0002\b\t\t1+\u0005\u0003\u0002\n\u0005=\u0001c\u0001\u0014\u0002\f%\u0019\u0011QB\u0014\u0003\u000f9{G\u000f[5oOB\u0019!%!\u0005\n\u0007\u0005M\u0001D\u0001\u0006TKJL\u0017\r\\5{KJ\u0004B!!\u0001\u0002\u0018\u00119\u0011\u0011\u0004\u0006C\u0002\u0005m!!\u0001#\u0012\t\u0005%\u0011Q\u0004\t\u0004E\u0005}\u0011bAA\u00111\taA)Z:fe&\fG.\u001b>feRQ\u0011QEA\u0015\u0003W\ti#a\f\u0011\r\u0005\u001d\"b`A\u000b\u001b\u0005\t\u0001\"\u0002\u001d\u0010\u0001\u0004I\u0004\"B<\u0010\u0001\u0004A\b\"B>\u0010\u0001\u0004a\bbB(\u0010!\u0003\u0005\r\u0001U\u0001\u0004g\u0016$H\u0003BA\u001b\u0003w\u00012AJA\u001c\u0013\r\tId\n\u0002\u0005+:LG\u000fC\u0004\u0002>A\u0001\r!a\u0010\u0002!\u0005t\u0017\r\\=tSN\u001cuN\u001c;f]R\u001c\bc\u0001\u0019\u0002B%\u0019\u00111I\u0019\u0003!\u0005s\u0017\r\\=tSN\u001cuN\u001c;f]R\u001c\u0018aA4fiR\u0011\u0011\u0011\n\t\u0007\u0003\u0017\n\t&a\u0010\u000e\u0005\u00055#bAA({\u0005!Q\u000f^5m\u0013\u0011\t\u0019&!\u0014\u0003\u0011=\u0003H/[8oC2\f\u0011\"\u001e8tC\u001a,w)\u001a;\u0015\u0005\u0005}\u0012AB!Ti>\u0014X\rE\u0002\u0002(Q\u0019\"\u0001F\u0013\u0015\u0005\u0005m\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'F\u0003a\u0003K\n9\u0007B\u0004\u0002\u0006Y\u0011\r!a\u0002\u0005\u000f\u0005eaC1\u0001\u0002\u001c\u0001")
public final class ConsistentFileAnalysisStore {
    public static int binary$default$4() {
        return ConsistentFileAnalysisStore$.MODULE$.binary$default$4();
    }

    public static AnalysisStore binary(File file, ReadWriteMappers mappers, boolean reproducible, int parallelism) {
        return ConsistentFileAnalysisStore$.MODULE$.binary(file, mappers, reproducible, parallelism);
    }

    public static AnalysisStore binary(File file, ReadWriteMappers mappers) {
        return ConsistentFileAnalysisStore$.MODULE$.binary(file, mappers);
    }

    public static AnalysisStore binary(File file) {
        return ConsistentFileAnalysisStore$.MODULE$.binary(file);
    }

    public static int text$default$4() {
        return ConsistentFileAnalysisStore$.MODULE$.text$default$4();
    }

    public static boolean text$default$3() {
        return ConsistentFileAnalysisStore$.MODULE$.text$default$3();
    }

    public static AnalysisStore text(File file, ReadWriteMappers mappers, boolean reproducible, int parallelism) {
        return ConsistentFileAnalysisStore$.MODULE$.text(file, mappers, reproducible, parallelism);
    }

    private static final class AStore<S extends Serializer, D extends Deserializer>
    implements AnalysisStore {
        private final File file;
        private final ConsistentAnalysisFormat format;
        private final SerializerFactory<S, D> sf;
        private final int parallelism;

        public void clearCache() {
            super.clearCache();
        }

        public void set(AnalysisContents analysisContents) {
            CompileAnalysis analysis = analysisContents.getAnalysis();
            MiniSetup setup = analysisContents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            try (FileOutputStream fout = new FileOutputStream(tmpAnalysisFile);){
                ParallelGzipOutputStream gout = new ParallelGzipOutputStream(fout, this.parallelism);
                S ser = this.sf.serializerFor(gout);
                this.format.write((Serializer)ser, analysis, setup);
                gout.close();
            }
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public Optional<AnalysisContents> get() {
            return JavaInterfaceUtil$.MODULE$.EnrichOption(Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> this.unsafeGet())).toOptional();
        }

        public AnalysisContents unsafeGet() {
            return (AnalysisContents)Using$.MODULE$.gzipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable)in -> {
                Object deser = $this.sf.deserializerFor((InputStream)in);
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = $this.format.read((Deserializer)deser);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis = (CompileAnalysis)tuple2._1();
                MiniSetup setup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)setup);
                CompileAnalysis analysis2 = (CompileAnalysis)tuple22._1();
                MiniSetup setup2 = (MiniSetup)tuple22._2();
                return AnalysisContents.create((CompileAnalysis)analysis2, (MiniSetup)setup2);
            });
        }

        public AStore(File file, ConsistentAnalysisFormat format, SerializerFactory<S, D> sf, int parallelism) {
            this.file = file;
            this.format = format;
            this.sf = sf;
            this.parallelism = parallelism;
        }
    }
}

