/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.CompanionsStore;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.binary.BinaryAnalysisFormat;
import sbt.internal.inc.text.TextAnalysisFormat;
import sbt.internal.shaded.com.google.protobuf.CodedInputStream;
import sbt.internal.shaded.com.google.protobuf.CodedOutputStream;
import sbt.io.IO$;
import sbt.io.Using$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import xsbti.api.Companions;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0005\u0005Mx!B\u00181\u0011\u00039d!B\u001d1\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%i\u0001\u0012\u0005\u0007\u0011\u0006\u0001\u000bQB#\t\u000f%\u000b!\u0019!C\u0007\u0015\"11+\u0001Q\u0001\u000e-Cq\u0001V\u0001C\u0002\u00135!\n\u0003\u0004V\u0003\u0001\u0006ia\u0013\u0005\b-\u0006\u0011\r\u0011\"\u0004X\u0011\u0019q\u0016\u0001)A\u00071\")q,\u0001C\u0001A\")q,\u0001C\u0001W\")q,\u0001C\u0001k\")!0\u0001C\u0001w\")!0\u0001C\u0001}\"1!0\u0001C\u0001\u0003\u0007AaA_\u0001\u0005\u0002\u0005UaABA\u000f\u0003\u0019\ty\u0002\u0003\u0005~%\t\u0005\t\u0015!\u0003Y\u0011%\t9C\u0005B\u0001B\u0003%q\u000e\u0003\u0005z%\t\u0005\t\u0015!\u0003Y\u0011\u0019\t%\u0003\"\u0001\u0002*!I\u0011\u0011\u0002\nC\u0002\u00135\u0011Q\u0007\u0005\t\u0003\u0003\u0012\u0002\u0015!\u0004\u00028!I\u00111\t\nC\u0002\u00135\u0011Q\t\u0005\t\u0003\u001b\u0012\u0002\u0015!\u0004\u0002H!9\u0011q\n\n\u0005B\u0005E\u0003bBA3%\u0011\u0005\u0013q\r\u0005\b\u0003S\u0012B\u0011IA6\r\u0019\t9(\u0001\u0004\u0002z!AQP\bB\u0001B\u0003%\u0001\f\u0003\u0006\u0002\ny\u0011\t\u0011)A\u0005\u0003\u0017A\u0001\"\u001f\u0010\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0007\u0003z!\t!a\u001f\t\u0013\u0005\u0015eD1A\u0005\u0002\u0005\u001d\u0005\u0002CAj=\u0001\u0006I!!#\t\u000f\u0005%d\u0004\"\u0001\u0002V\"9\u0011q\n\u0010\u0005\u0002\u0005E\u0003bBA3=\u0011\u0005\u0011q\r\u0005\b\u00037\fA\u0011BAo\r\u0019\tY)\u0001\u0004\u0002\u000e\"AQ0\u000bB\u0001B\u0003%\u0001\f\u0003\u0006\u0002\n%\u0012\t\u0011)A\u0005\u0003\u0017Aa!Q\u0015\u0005\u0002\u0005U\u0005bBA(S\u0011\u0005\u00111\u0014\u0005\b\u0003\u001fLC\u0011AAi\u0003E1\u0015\u000e\\3B]\u0006d\u0017p]5t'R|'/\u001a\u0006\u0003cI\n1!\u001b8d\u0015\t\u0019D'\u0001\u0005j]R,'O\\1m\u0015\u0005)\u0014aA:ci\u000e\u0001\u0001C\u0001\u001d\u0002\u001b\u0005\u0001$!\u0005$jY\u0016\fe.\u00197zg&\u001c8\u000b^8sKN\u0011\u0011a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0014\u0001\u0004\"j]\u0016CH/\u001a8tS>tW#A#\u0010\u0003\u0019\u000b\u0013aR\u0001\u0004E&t\u0017!\u0004\"j]\u0016CH/\u001a8tS>t\u0007%\u0001\tb]\u0006d\u0017p]5t\r&dWMT1nKV\t1\n\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006!A.\u00198h\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\rM#(/\u001b8h\u0003E\tg.\u00197zg&\u001ch)\u001b7f\u001d\u0006lW\rI\u0001\u0013G>l\u0007/\u00198j_:\u001ch)\u001b7f\u001d\u0006lW-A\nd_6\u0004\u0018M\\5p]N4\u0015\u000e\\3OC6,\u0007%A\u0007eK\u001a\fW\u000f\u001c;U[B$\u0015N]\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111lT\u0001\u0003S>L!!\u0018.\u0003\t\u0019KG.Z\u0001\u000fI\u00164\u0017-\u001e7u)6\u0004H)\u001b:!\u0003\u0019\u0011\u0017N\\1ssR\u0011\u0011-\u001b\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fqaY8na&dWMC\u0001g\u0003\u0015A8O\u0019;j\u0013\tA7MA\u0007B]\u0006d\u0017p]5t'R|'/\u001a\u0005\u0006U.\u0001\r\u0001W\u0001\rC:\fG._:jg\u001aKG.\u001a\u000b\u0004C2l\u0007\"\u00026\r\u0001\u0004A\u0006\"\u00028\r\u0001\u0004y\u0017aB7baB,'o\u001d\t\u0003aNl\u0011!\u001d\u0006\u0003e\u000e\f\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003iF\u0014\u0001CU3bI^\u0013\u0018\u000e^3NCB\u0004XM]:\u0015\t\u00054x\u000f\u001f\u0005\u0006U6\u0001\r\u0001\u0017\u0005\u0006]6\u0001\ra\u001c\u0005\u0006s6\u0001\r\u0001W\u0001\u0007i6\u0004H)\u001b:\u0002\tQ,\u0007\u0010\u001e\u000b\u0003CrDQ! \bA\u0002a\u000bAAZ5mKR!\u0011m`A\u0001\u0011\u0015ix\u00021\u0001Y\u0011\u0015qw\u00021\u0001p)\u0015\t\u0017QAA\u0004\u0011\u0015i\b\u00031\u0001Y\u0011\u001d\tI\u0001\u0005a\u0001\u0003\u0017\taAZ8s[\u0006$\b\u0003BA\u0007\u0003#i!!a\u0004\u000b\u0005i\u0004\u0014\u0002BA\n\u0003\u001f\u0011!\u0003V3yi\u0006s\u0017\r\\=tSN4uN]7biR9\u0011-a\u0006\u0002\u001a\u0005m\u0001\"B?\u0012\u0001\u0004A\u0006bBA\u0005#\u0001\u0007\u00111\u0002\u0005\u0006sF\u0001\r\u0001\u0017\u0002\u0010\u0005&t\u0017M]=GS2,7\u000b^8sKN!!#!\tb!\ra\u00151E\u0005\u0004\u0003Ki%AB(cU\u0016\u001cG/\u0001\tsK\u0006$wK]5uK6\u000b\u0007\u000f]3sgRA\u00111FA\u0018\u0003c\t\u0019\u0004E\u0002\u0002.Ii\u0011!\u0001\u0005\u0006{Z\u0001\r\u0001\u0017\u0005\u0007\u0003O1\u0002\u0019A8\t\u000be4\u0002\u0019\u0001-\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003{i!!a\u000f\u000b\u0005}\u0003\u0014\u0002BA \u0003w\u0011ACQ5oCJL\u0018I\\1msNL7OR8s[\u0006$\u0018a\u00024pe6\fG\u000fI\u0001\n)6\u0004XI\u001c3j]\u001e,\"!a\u0012\u0010\u0005\u0005%\u0013EAA&\u0003\u0011qC/\u001c9\u0002\u0015Qk\u0007/\u00128eS:<\u0007%A\u0002hKR$\"!a\u0015\u0011\r\u0005U\u00131LA0\u001b\t\t9FC\u0002\u0002Z=\u000bA!\u001e;jY&!\u0011QLA,\u0005!y\u0005\u000f^5p]\u0006d\u0007c\u00012\u0002b%\u0019\u00111M2\u0003!\u0005s\u0017\r\\=tSN\u001cuN\u001c;f]R\u001c\u0018!C;og\u00064WmR3u)\t\ty&A\u0002tKR$B!!\u001c\u0002tA\u0019A(a\u001c\n\u0007\u0005ETH\u0001\u0003V]&$\bbBA;;\u0001\u0007\u0011qL\u0001\tG>tG/\u001a8ug\n\u0011b)\u001b7f\u0005\u0006\u001cX\rZ*u_J,\u0017*\u001c9m'\u0011q\u0012\u0011E1\u0015\u0011\u0005u\u0014qPAA\u0003\u0007\u00032!!\f\u001f\u0011\u0015i(\u00051\u0001Y\u0011\u001d\tIA\ta\u0001\u0003\u0017AQ!\u001f\u0012A\u0002a\u000bqbY8na\u0006t\u0017n\u001c8t'R|'/Z\u000b\u0003\u0003\u0013\u00032!!\f*\u0005m1\u0015\u000e\\3CCN,GmQ8na\u0006t\u0017n\u001c8t\u001b\u0006\u00048\u000b^8sKN!\u0011fOAH!\rA\u0014\u0011S\u0005\u0004\u0003'\u0003$aD\"p[B\fg.[8ogN#xN]3\u0015\r\u0005%\u0015qSAM\u0011\u0015iH\u00061\u0001Y\u0011\u001d\tI\u0001\fa\u0001\u0003\u0017!\"!!(\u0011\u000bq\ny*a)\n\u0007\u0005\u0005VH\u0001\u0004PaRLwN\u001c\t\by\u0005\u0015\u0016\u0011VAU\u0013\r\t9+\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0011\u0005-\u0016\u0011XA`\u0003\u0007tA!!,\u00026B\u0019\u0011qV\u001f\u000e\u0005\u0005E&bAAZm\u00051AH]8pizJ1!a.>\u0003\u0019\u0001&/\u001a3fM&!\u00111XA_\u0005\ri\u0015\r\u001d\u0006\u0004\u0003ok\u0004\u0003BAV\u0003\u0003L1AUA_!\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAeK\u0006\u0019\u0011\r]5\n\t\u00055\u0017q\u0019\u0002\u000b\u0007>l\u0007/\u00198j_:\u001c\u0018aC4fiVs7-Y;hQR$\"!a)\u0002!\r|W\u000e]1oS>t7o\u0015;pe\u0016\u0004C\u0003BA7\u0003/Dq!!7&\u0001\u0004\ty&\u0001\tb]\u0006d\u0017p]5t\u0007>tG/\u001a8ug\u0006YAn\\8lkB,e\u000e\u001e:z)\u0019\ti'a8\u0002p\"9\u0011\u0011\u001d\u0015A\u0002\u0005\r\u0018AA5o!\u0011\t)/a;\u000e\u0005\u0005\u001d(\u0002BAu\u0003/\n1A_5q\u0013\u0011\ti/a:\u0003\u001diK\u0007/\u00138qkR\u001cFO]3b[\"9\u0011\u0011\u001f\u0015A\u0002\u0005}\u0016\u0001\u00028b[\u0016\u0004")
public final class FileAnalysisStore {
    public static AnalysisStore text(File file, TextAnalysisFormat format, File tmpDir) {
        return FileAnalysisStore$.MODULE$.text(file, format, tmpDir);
    }

    public static AnalysisStore text(File file, TextAnalysisFormat format) {
        return FileAnalysisStore$.MODULE$.text(file, format);
    }

    public static AnalysisStore text(File file, ReadWriteMappers mappers) {
        return FileAnalysisStore$.MODULE$.text(file, mappers);
    }

    public static AnalysisStore text(File file) {
        return FileAnalysisStore$.MODULE$.text(file);
    }

    public static AnalysisStore binary(File analysisFile, ReadWriteMappers mappers, File tmpDir) {
        return FileAnalysisStore$.MODULE$.binary(analysisFile, mappers, tmpDir);
    }

    public static AnalysisStore binary(File analysisFile, ReadWriteMappers mappers) {
        return FileAnalysisStore$.MODULE$.binary(analysisFile, mappers);
    }

    public static AnalysisStore binary(File analysisFile) {
        return FileAnalysisStore$.MODULE$.binary(analysisFile);
    }

    private static final class BinaryFileStore
    implements AnalysisStore {
        private final File file;
        private final File tmpDir;
        private final BinaryAnalysisFormat format;

        private final BinaryAnalysisFormat format() {
            return this.format;
        }

        private final String TmpEnding() {
            return ".tmp";
        }

        public Optional<AnalysisContents> get() {
            Option nestedRead = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> (Option)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream($this.file), (Function1 & Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                CodedInputStream reader = CodedInputStream.newInstance((InputStream)inputStream);
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = this.format().read(reader);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis2 = (CompileAnalysis)tuple2._1();
                MiniSetup miniSetup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis2, (Object)miniSetup);
                CompileAnalysis analysis3 = (CompileAnalysis)tuple22._1();
                MiniSetup miniSetup2 = (MiniSetup)tuple22._2();
                Option analysisWithAPIs = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                    FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                    return this.format().readAPIs(reader, analysis3, miniSetup2.storeApis());
                });
                return analysisWithAPIs.map((Function1 & Serializable)analysis -> AnalysisContents.create((CompileAnalysis)analysis, (MiniSetup)miniSetup2));
            }));
            return JavaInterfaceUtil$.MODULE$.EnrichOption(nestedRead.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())).toOptional();
        }

        public AnalysisContents unsafeGet() {
            return this.get().get();
        }

        public void set(AnalysisContents contents) {
            CompileAnalysis analysis = contents.getAnalysis();
            MiniSetup setup = contents.getMiniSetup();
            File tmpAnalysisFile = Files.createTempFile(this.tmpDir.toPath(), this.file.getName(), ".tmp", new FileAttribute[0]).toFile();
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            FileOutputStream outputStream2 = new FileOutputStream(tmpAnalysisFile);
            Using$.MODULE$.zipOutputStream().apply((Object)outputStream2, (Function1 & Serializable)outputStream -> {
                BinaryFileStore.$anonfun$set$1(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public static final /* synthetic */ void $anonfun$set$1(BinaryFileStore $this, CompileAnalysis analysis$2, MiniSetup setup$1, ZipOutputStream outputStream) {
            CodedOutputStream protobufWriter = CodedOutputStream.newInstance((OutputStream)outputStream);
            outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
            $this.format().write(protobufWriter, analysis$2, setup$1);
            outputStream.closeEntry();
            outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
            $this.format().writeAPIs(protobufWriter, analysis$2, setup$1.storeApis());
            outputStream.closeEntry();
        }

        public BinaryFileStore(File file, ReadWriteMappers readWriteMappers, File tmpDir) {
            this.file = file;
            this.tmpDir = tmpDir;
            this.format = new BinaryAnalysisFormat(readWriteMappers);
        }
    }

    private static final class FileBasedCompanionsMapStore
    implements CompanionsStore {
        private final File file;
        private final TextAnalysisFormat format;

        public Option<Tuple2<Map<String, Companions>, Map<String, Companions>>> get() {
            return Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> this.getUncaught());
        }

        public Tuple2<Map<String, Companions>, Map<String, Companions>> getUncaught() {
            return (Tuple2)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                return $this.format.readCompanionMap(reader);
            });
        }

        public FileBasedCompanionsMapStore(File file, TextAnalysisFormat format) {
            this.file = file;
            this.format = format;
        }
    }

    private static final class FileBasedStoreImpl
    implements AnalysisStore {
        private final File file;
        private final TextAnalysisFormat format;
        private final File tmpDir;
        private final FileBasedCompanionsMapStore companionsStore;

        public FileBasedCompanionsMapStore companionsStore() {
            return this.companionsStore;
        }

        public void set(AnalysisContents analysisContents) {
            CompileAnalysis analysis = analysisContents.getAnalysis();
            MiniSetup setup = analysisContents.getMiniSetup();
            File tmpAnalysisFile = Files.createTempFile(this.tmpDir.toPath(), this.file.getName(), ".tmp", new FileAttribute[0]).toFile();
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            Using$.MODULE$.zipOutputStream().apply((Object)new FileOutputStream(tmpAnalysisFile), (Function1 & Serializable)outputStream -> {
                FileBasedStoreImpl.$anonfun$set$2(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public Optional<AnalysisContents> get() {
            return JavaInterfaceUtil$.MODULE$.EnrichOption(Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> this.unsafeGet())).toOptional();
        }

        public AnalysisContents unsafeGet() {
            return (AnalysisContents)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                BufferedReader writer = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = $this.format.read(writer, this.companionsStore());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis = (CompileAnalysis)tuple2._1();
                MiniSetup setup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)setup);
                CompileAnalysis analysis2 = (CompileAnalysis)tuple22._1();
                MiniSetup setup2 = (MiniSetup)tuple22._2();
                return AnalysisContents.create((CompileAnalysis)analysis2, (MiniSetup)setup2);
            });
        }

        public static final /* synthetic */ void $anonfun$set$2(FileBasedStoreImpl $this, CompileAnalysis analysis$3, MiniSetup setup$2, ZipOutputStream outputStream) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, IO$.MODULE$.utf8()));
            outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
            $this.format.write(writer, analysis$3, setup$2);
            outputStream.closeEntry();
            if (setup$2.storeApis()) {
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
                CompileAnalysis compileAnalysis = analysis$3;
                if (!(compileAnalysis instanceof Analysis)) {
                    throw new MatchError((Object)compileAnalysis);
                }
                Analysis analysis = (Analysis)compileAnalysis;
                $this.format.writeCompanionMap(writer, analysis.apis());
                outputStream.closeEntry();
                return;
            }
        }

        public FileBasedStoreImpl(File file, TextAnalysisFormat format, File tmpDir) {
            this.file = file;
            this.format = format;
            this.tmpDir = tmpDir;
            this.companionsStore = new FileBasedCompanionsMapStore(file, format);
        }
    }
}

