/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.Incremental$;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.MixedAnalyzingCompiler$;
import sbt.internal.inc.VirtualFileUtil$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.internal.util.ConsoleAppender$;
import sbt.io.DirectoryFilter$;
import sbt.io.IO$;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.FileConverter;
import xsbti.Reporter;
import xsbti.VirtualFile;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileProgress;
import xsbti.compile.DependencyChanges;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.IncToolOptions;
import xsbti.compile.JavaCompiler;
import xsbti.compile.MiniSetup;
import xsbti.compile.MultipleOutput;
import xsbti.compile.Output;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.SingleOutput;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001\u0002\u0015*\u0005AB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005s!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003E\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t5\u0002\u0011\t\u0011)A\u00057\")!\r\u0001C\u0001G\"1!\u000e\u0001Q\u0001\n-DQ!\u001e\u0001\u0005\u0002YDq!a\t\u0001\t\u0003\t)\u0003\u0003\u0004=\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003C\u0002A\u0011BA2\u0011!\tI\b\u0001Q\u0005\n\u0005m\u0004\u0002CAD\u0001\u0001&I!!#\t\u0011\u0005m\u0006\u0001)C\u0005\u0003{;q!a5*\u0011\u0003\t)N\u0002\u0004)S!\u0005\u0011q\u001b\u0005\u0007ER!\t!!7\t\u0011\u0005mG\u0003\"\u0001.\u0003;Dq!a<\u0015\t\u0003\t\t\u0010C\u0005\u0003,R\t\n\u0011\"\u0001\u0003.\"I!1\u0019\u000b\u0012\u0002\u0013\u0005!Q\u0019\u0005\n\u0005\u0013$\u0012\u0013!C\u0001\u0005\u000bD\u0011Ba3\u0015#\u0003%\tA!4\t\u0013\tEG#%A\u0005\u0002\tM\u0007B\u0002&\u0015\t\u0003\u00119\u000eC\u0004\u0004\u0002Q!\taa\u0001\t\u000f\r\u0005A\u0003\"\u0001\u0004\u0012!91Q\u0005\u000b\u0005\u0002\r\u001d\u0002bBB\u0016)\u0011\u00051Q\u0006\u0005\b\u0007k!B\u0011AB\u001c\u0011!\u00199\u0005\u0006Q\u0005\n\r%\u0003\u0002\u0003B\t)\u0001\u0006Iaa\u0014\t\u000f\r-D\u0003\"\u0003\u0004n!91q\u000f\u000b\u0005\u0002\re\u0004bBB<)\u0011\u000511\u0011\u0002\u0017\u001b&DX\rZ!oC2L(0\u001b8h\u0007>l\u0007/\u001b7fe*\u0011!fK\u0001\u0004S:\u001c'B\u0001\u0017.\u0003!Ig\u000e^3s]\u0006d'\"\u0001\u0018\u0002\u0007M\u0014Go\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g-\u0001\u0004tG\u0006d\u0017mY\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\bG>l\u0007/\u001b7f\u0015\u0005q\u0014!\u0002=tERL\u0017B\u0001!<\u00055\u00196-\u00197b\u0007>l\u0007/\u001b7fe\u000691oY1mC\u000e\u0004\u0013!\u00026bm\u0006\u001cW#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\tK\u0013B\u0001%G\u0005U\te.\u00197zu&twMS1wC\u000e{W\u000e]5mKJ\faA[1wC\u000e\u0004\u0013AB2p]\u001aLw-F\u0001M!\tie*D\u0001*\u0013\ty\u0015F\u0001\u000bD_6\u0004\u0018\u000e\\3D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u0003\rawnZ\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a+L\u0001\u0005kRLG.\u0003\u0002Y+\n1Aj\\4hKJ\fA\u0001\\8hA\u0005\u0001r.\u001e;qkRT\u0015M]\"p]R,g\u000e\u001e\t\u00039~s!!T/\n\u0005yK\u0013\u0001\u0003&beV#\u0018\u000e\\:\n\u0005\u0001\f'\u0001E(viB,HOS1s\u0007>tG/\u001a8u\u0015\tq\u0016&\u0001\u0004=S:LGO\u0010\u000b\u0007I\u00164w\r[5\u0011\u00055\u0003\u0001\"B\u001c\u000b\u0001\u0004I\u0004\"\u0002\"\u000b\u0001\u0004!\u0005\"\u0002&\u000b\u0001\u0004a\u0005\"B)\u000b\u0001\u0004\u0019\u0006\"\u0002.\u000b\u0001\u0004Y\u0016\u0001D1cg\u000ec\u0017m]:qCRD\u0007c\u00017pc6\tQN\u0003\u0002og\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Al'aA*fcB\u0011!o]\u0007\u0002{%\u0011A/\u0010\u0002\f-&\u0014H/^1m\r&dW-A\u0006d_6\u0004\u0018\u000e\\3KCZ\fGCB<{\u0003\u001f\tI\u0002\u0005\u00023q&\u0011\u0011p\r\u0002\u0005+:LG\u000fC\u0003|\u0019\u0001\u0007A0\u0001\u0005kCZ\f7K]2t!\u0011i\u00181B9\u000f\u0007y\f9AD\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rq&\u0001\u0004=e>|GOP\u0005\u0002i%\u0019\u0011\u0011B\u001a\u0002\u000fA\f7m[1hK&\u0019\u0001/!\u0004\u000b\u0007\u0005%1\u0007C\u0004\u0002\u00121\u0001\r!a\u0005\u0002\u0011\r\fG\u000e\u001c2bG.\u00042A]A\u000b\u0013\r\t9\"\u0010\u0002\u0011\u0003:\fG._:jg\u000e\u000bG\u000e\u001c2bG.Dq!a\u0007\r\u0001\u0004\ti\"\u0001\tdY\u0006\u001c8OZ5mK6\u000bg.Y4feB\u0019!(a\b\n\u0007\u0005\u00052H\u0001\tDY\u0006\u001c8OR5mK6\u000bg.Y4fe\u0006aQM\\:ve\u0016|U\u000f\u001e9viV\u0011\u0011q\u0005\t\u0006{\u0006-\u0011\u0011\u0006\t\u0005\u0003W\tI$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\u00111\u0017\u000e\\3\u000b\t\u0005M\u0012QG\u0001\u0004]&|'BAA\u001c\u0003\u0011Q\u0017M^1\n\t\u0005m\u0012Q\u0006\u0002\u0005!\u0006$\b\u000eF\u0005x\u0003\u007f\t\u0019&!\u0018\u0002`!9\u0011\u0011\t\bA\u0002\u0005\r\u0013aB5oG2,H-\u001a\t\u0006\u0003\u000b\ni%\u001d\b\u0005\u0003\u000f\nI\u0005\u0005\u0002\u0000g%\u0019\u00111J\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ty%!\u0015\u0003\u0007M+GOC\u0002\u0002LMBq!!\u0016\u000f\u0001\u0004\t9&A\u0004dQ\u0006tw-Z:\u0011\u0007i\nI&C\u0002\u0002\\m\u0012\u0011\u0003R3qK:$WM\\2z\u0007\"\fgnZ3t\u0011\u001d\t\tB\u0004a\u0001\u0003'Aq!a\u0007\u000f\u0001\u0004\ti\"A\nqkRT\u0015M^1d\u001fV$\b/\u001e;J]*\u000b'\u000fF\u0003x\u0003K\n)\bC\u0004\u0002h=\u0001\r!!\u001b\u0002\u0013=,H\u000f];u\u0015\u0006\u0014\b\u0003BA6\u0003cj!!!\u001c\u000b\t\u0005=\u0014QG\u0001\u0003S>LA!a\u001d\u0002n\t!a)\u001b7f\u0011\u001d\t9h\u0004a\u0001\u0003S\n\u0011b\\;uaV$H)\u001b:\u0002#=,H\u000f];u\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0003\u0002(\u0005u\u0004bBA@!\u0001\u0007\u0011\u0011Q\u0001\u0007_V$\b/\u001e;\u0011\u0007i\n\u0019)C\u0002\u0002\u0006n\u0012aaT;uaV$\u0018!\u0002;j[\u0016$W\u0003BAF\u0003'#b!!$\u00020\u0006eF\u0003BAH\u0003K\u0003B!!%\u0002\u00142\u0001AaBAK#\t\u0007\u0011q\u0013\u0002\u0002)F!\u0011\u0011TAP!\r\u0011\u00141T\u0005\u0004\u0003;\u001b$a\u0002(pi\"Lgn\u001a\t\u0004e\u0005\u0005\u0016bAARg\t\u0019\u0011I\\=\t\u0011\u0005\u001d\u0016\u0003\"a\u0001\u0003S\u000b\u0011\u0001\u001e\t\u0006e\u0005-\u0016qR\u0005\u0004\u0003[\u001b$\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005E\u0016\u00031\u0001\u00024\u0006)A.\u00192fYB!\u0011QIA[\u0013\u0011\t9,!\u0015\u0003\rM#(/\u001b8h\u0011\u0015\t\u0016\u00031\u0001T\u0003%awnZ%oaV$8\u000fF\u0005x\u0003\u007f\u000b\t-a3\u0002P\")\u0011K\u0005a\u0001'\"9\u00111\u0019\nA\u0002\u0005\u0015\u0017!\u00036bm\u0006\u001cu.\u001e8u!\r\u0011\u0014qY\u0005\u0004\u0003\u0013\u001c$aA%oi\"9\u0011Q\u001a\nA\u0002\u0005\u0015\u0017AC:dC2\f7i\\;oi\"9\u0011\u0011\u001b\nA\u0002\u0005\u001d\u0012AC8viB,H\u000fR5sg\u00061R*\u001b=fI\u0006s\u0017\r\\={S:<7i\\7qS2,'\u000f\u0005\u0002N)M\u0011A#\r\u000b\u0003\u0003+\f\u0001B[1wC>sG.\u001f\u000b\u0005\u0003?\f)\u000fE\u00023\u0003CL1!a94\u0005\u001d\u0011un\u001c7fC:Dq!a:\u0017\u0001\u0004\tI/A\u0001g!\r\u0011\u00181^\u0005\u0004\u0003[l$A\u0004,jeR,\u0018\r\u001c$jY\u0016\u0014VMZ\u0001\u000b[\u0006\\WmQ8oM&<G#\f'\u0002t\u0006U\u0018Q B\u0001\u0005\u0017\u0011yA!\u0007\u0003*\t=\"1\u0007B\u001f\u0005\u0013\u0012\u0019F!\u0018\u0003h\t-$Q\u000fB<\u0005s\u0012yHa#\u0003\u001c\")qg\u0006a\u0001s!1!i\u0006a\u0001\u0003o\u00042AOA}\u0013\r\tYp\u000f\u0002\r\u0015\u00064\u0018mQ8na&dWM\u001d\u0005\u0007\u0003\u007f<\u0002\u0019\u0001?\u0002\u000fM|WO]2fg\"9!1A\fA\u0002\t\u0015\u0011!C2p]Z,'\u000f^3s!\r\u0011(qA\u0005\u0004\u0005\u0013i$!\u0004$jY\u0016\u001cuN\u001c<feR,'\u000f\u0003\u0004\u0003\u000e]\u0001\r\u0001`\u0001\nG2\f7o\u001d9bi\"DqA!\u0005\u0018\u0001\u0004\u0011\u0019\"A\u0003dC\u000eDW\rE\u0002;\u0005+I1Aa\u0006<\u000519En\u001c2bYN\u001c\u0015m\u00195f\u0011%\u0011Yb\u0006I\u0001\u0002\u0004\u0011i\"\u0001\u0005qe><'/Z:t!\u0015\u0011$q\u0004B\u0012\u0013\r\u0011\tc\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007i\u0012)#C\u0002\u0003(m\u0012qbQ8na&dW\r\u0015:pOJ,7o\u001d\u0005\n\u0005W9\u0002\u0013!a\u0001\u0005[\tqa\u001c9uS>t7\u000fE\u0003~\u0003\u0017\t\u0019\fC\u0005\u00032]\u0001\n\u00111\u0001\u0003.\u0005a!.\u0019<bG>\u0003H/[8og\"9!QG\fA\u0002\t]\u0012\u0001\u00059sKZLw.^:B]\u0006d\u0017p]5t!\rQ$\u0011H\u0005\u0004\u0005wY$aD\"p[BLG.Z!oC2L8/[:\t\u000f\t}r\u00031\u0001\u0003B\u0005i\u0001O]3wS>,8oU3ukB\u0004RA\rB\u0010\u0005\u0007\u00022A\u000fB#\u0013\r\u00119e\u000f\u0002\n\u001b&t\u0017nU3ukBDqAa\u0013\u0018\u0001\u0004\u0011i%A\fqKJ\u001cE.Y:ta\u0006$\b.\u00128uefdun\\6vaB\u0019!Ha\u0014\n\u0007\tE3HA\fQKJ\u001cE.Y:ta\u0006$\b.\u00128uefdun\\6va\"9!QK\fA\u0002\t]\u0013\u0001\u0003:fa>\u0014H/\u001a:\u0011\u0007I\u0014I&C\u0002\u0003\\u\u0012\u0001BU3q_J$XM\u001d\u0005\n\u0005?:\u0002\u0013!a\u0001\u0005C\nAbY8na&dWm\u0014:eKJ\u00042A\u000fB2\u0013\r\u0011)g\u000f\u0002\r\u0007>l\u0007/\u001b7f\u001fJ$WM\u001d\u0005\n\u0005S:\u0002\u0013!a\u0001\u0003?\fAa]6ja\"9!QN\fA\u0002\t=\u0014AG5oGJ,W.\u001a8uC2\u001cu.\u001c9jY\u0016\u0014x\n\u001d;j_:\u001c\bc\u0001\u001e\u0003r%\u0019!1O\u001e\u0003\u0015%s7m\u00149uS>t7\u000fC\u0004\u0002\u0000]\u0001\r!!!\t\u000bi;\u0002\u0019A.\t\u000f\tmt\u00031\u0001\u0003~\u0005YQ-\u0019:ms>+H\u000f];u!\u0015\u0011$qDAA\u0011\u001d\u0011\ti\u0006a\u0001\u0005\u0007\u000b!#Z1sYf\fe.\u00197zg&\u001c8\u000b^8sKB)!Ga\b\u0003\u0006B\u0019!Ha\"\n\u0007\t%5HA\u0007B]\u0006d\u0017p]5t'R|'/\u001a\u0005\b\u0005\u001b;\u0002\u0019\u0001BH\u0003\u001d\u0019H/Y7qKJ\u0004BA!%\u0003\u00186\u0011!1\u0013\u0006\u0004\u0005+[\u0014\u0001C1oC2L8/[:\n\t\te%1\u0013\u0002\u000b%\u0016\fGm\u0015;b[B\u001c\bb\u0002BO/\u0001\u0007!qT\u0001\u0006Kb$(/\u0019\t\u0006{\n\u0005&QU\u0005\u0005\u0005G\u000biA\u0001\u0003MSN$\bc\u0002\u001a\u0003(\u0006M\u00161W\u0005\u0004\u0005S\u001b$A\u0002+va2,''\u0001\u000bnC.,7i\u001c8gS\u001e$C-\u001a4bk2$HeN\u000b\u0003\u0005_SCA!\b\u00032.\u0012!1\u0017\t\u0005\u0005k\u0013y,\u0004\u0002\u00038*!!\u0011\u0018B^\u0003%)hn\u00195fG.,GMC\u0002\u0003>N\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tMa.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bnC.,7i\u001c8gS\u001e$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005\u000fTCA!\f\u00032\u0006!R.Y6f\u0007>tg-[4%I\u00164\u0017-\u001e7uIe\nQ#\\1lK\u000e{gNZ5hI\u0011,g-Y;mi\u0012\nD'\u0006\u0002\u0003P*\"!\u0011\rBY\u0003Ui\u0017m[3D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%cU*\"A!6+\t\u0005}'\u0011\u0017\u000b&\u0019\ne'1\u001cBo\u0005?\u0014\u0019O!:\u0003h\n%(1\u001eBx\u0005c\u0014\u0019P!>\u0003x\ne(1 B\u007f\u0005\u007fDa!a@\u001e\u0001\u0004a\bb\u0002B\u0002;\u0001\u0007!Q\u0001\u0005\u0007\u0005\u001bi\u0002\u0019\u0001?\t\u000f\t\u0005X\u00041\u0001\u0003D\u0005)1/\u001a;va\"9!1D\u000fA\u0002\tu\u0001b\u0002B\u001b;\u0001\u0007!q\u0007\u0005\b\u0005\u007fi\u0002\u0019\u0001B!\u0011\u001d\u0011Y%\ba\u0001\u0005\u001bBaA!<\u001e\u0001\u0004I\u0014\u0001C2p[BLG.\u001a:\t\r\tk\u0002\u0019AA|\u0011\u001d\u0011)&\ba\u0001\u0005/BqA!\u001b\u001e\u0001\u0004\ty\u000eC\u0004\u0003\u0012u\u0001\rAa\u0005\t\u000f\t5T\u00041\u0001\u0003p!)!,\ba\u00017\"9!1P\u000fA\u0002\tu\u0004b\u0002BA;\u0001\u0007!1\u0011\u0005\b\u0005\u001bk\u0002\u0019\u0001BH\u0003a\u0019X-\u0019:dQ\u000ec\u0017m]:qCRD\u0017I\u001c3M_>\\W\u000f\u001d\u000b\u0005\u0007\u000b\u0019y\u0001\u0005\u00043\u0005Oc8q\u0001\t\be\r%\u00111WB\u0007\u0013\r\u0019Ya\r\u0002\n\rVt7\r^5p]F\u0002BA\rB\u0010c\")!J\ba\u0001\u0019Ra1QAB\n\u0007+\u00199b!\t\u0004$!9!1A\u0010A\u0002\t\u0015\u0001B\u0002B\u0007?\u0001\u0007A\u0010C\u0004\u0004\u001a}\u0001\raa\u0007\u0002\u001bM\u001c\u0017\r\\1d\u001fB$\u0018n\u001c8t!\u0015\u00114QDAZ\u0013\r\u0019yb\r\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005\u0017z\u0002\u0019\u0001B'\u0011\u0019\u0011io\ba\u0001s\u0005y1\r\\1tgB\u000bG\u000f\u001b'p_.,\b\u000f\u0006\u0003\u0004\b\r%\u0002\"\u0002&!\u0001\u0004a\u0015!B1qa2LH\u0003BB\u0018\u0007g!2\u0001ZB\u0019\u0011\u0015\t\u0016\u0005q\u0001T\u0011\u0015Q\u0015\u00051\u0001M\u0003E9\u0018\u000e\u001e5C_>$8\r\\1tgB\fG\u000f\u001b\u000b\by\u000ee21IB#\u0011\u001d\u0019YD\ta\u0001\u0007{\tA!\u0019:hgB\u0019Qja\u0010\n\u0007\r\u0005\u0013FA\tD_6\u0004\u0018\u000e\\3s\u0003J<W/\\3oiNDaA!\u0004#\u0001\u0004a\bb\u0002B\u0002E\u0001\u0007!QA\u0001\u0016Kb\u0004H.[2ji\n{w\u000e^\"mCN\u001c\b/\u0019;i)\u0015a81JB'\u0011\u001d\u0011Yc\ta\u0001\u0005[AqAa\u0001$\u0001\u0004\u0011)\u0001\u0005\u0005\u0004R\r]\u0013\u0011FB.\u001b\t\u0019\u0019FC\u0002\u0004V5\fq!\\;uC\ndW-\u0003\u0003\u0004Z\rM#a\u0002%bg\"l\u0015\r\u001d\t\u0007\u0007;\u001a9G!\"\u000e\u0005\r}#\u0002BB1\u0007G\n1A]3g\u0015\u0011\u0019)'!\u000e\u0002\t1\fgnZ\u0005\u0005\u0007S\u001ayFA\u0005SK\u001a,'/\u001a8dK\u0006Y1\u000f^1uS\u000e\u001c\u0015m\u00195f)\u0019\u0011)ia\u001c\u0004r!9\u0011qF\u0013A\u0002\u0005%\u0002\u0002CB:K\u0011\u0005\ra!\u001e\u0002\u000f\t\f7m[5oOB)!'a+\u0003\u0006\u0006\t2\u000f^1uS\u000e\u001c\u0015m\u00195fIN#xN]3\u0015\r\t\u001551PB@\u0011\u001d\u0019iH\na\u0001\u0003S\tA\"\u00198bYf\u001c\u0018n\u001d$jY\u0016Dqa!!'\u0001\u0004\ty.A\bvg\u0016$V\r\u001f;B]\u0006d\u0017p]5t)A\u0011)i!\"\u0004\b\u000e%5QRBL\u00077\u001bY\u000bC\u0004\u0004~\u001d\u0002\r!!\u000b\t\u000f\r\u0005u\u00051\u0001\u0002`\"911R\u0014A\u0002\u0005}\u0017!D;tK\u000e{gn]5ti\u0016tG\u000fC\u0004\u0004\u0010\u001e\u0002\ra!%\u0002\u000f5\f\u0007\u000f]3sgB!!\u0011SBJ\u0013\u0011\u0019)Ja%\u0003!I+\u0017\rZ,sSR,W*\u00199qKJ\u001c\bbBBMO\u0001\u0007\u0011q\\\u0001\u0005g>\u0014H\u000fC\u0004\u0004\u001e\u001e\u0002\raa(\u0002\u0005\u0015\u001c\u0007\u0003BBQ\u0007Ok!aa)\u000b\u0007\r\u00156'\u0001\u0006d_:\u001cWO\u001d:f]RLAa!+\u0004$\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0007[;\u0003\u0019AAc\u0003-\u0001\u0018M]1mY\u0016d\u0017n]7")
public final class MixedAnalyzingCompiler {
    private final ScalaCompiler scalac;
    private final AnalyzingJavaCompiler javac;
    private final CompileConfiguration config;
    private final Logger log;
    private final JarUtils.OutputJarContent outputJarContent;
    private final Seq<VirtualFile> absClasspath;

    public static AnalysisStore staticCachedStore(Path path, boolean bl, boolean bl2, ReadWriteMappers readWriteMappers, boolean bl3, ExecutionContext executionContext, int n) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(path, bl, bl2, readWriteMappers, bl3, executionContext, n);
    }

    public static AnalysisStore staticCachedStore(Path path, boolean bl) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(path, bl);
    }

    public static Seq<VirtualFile> withBootclasspath(CompilerArguments compilerArguments, Seq<VirtualFile> seq, FileConverter fileConverter) {
        return MixedAnalyzingCompiler$.MODULE$.withBootclasspath(compilerArguments, seq, fileConverter);
    }

    public static MixedAnalyzingCompiler apply(CompileConfiguration compileConfiguration, Logger logger) {
        return MixedAnalyzingCompiler$.MODULE$.apply(compileConfiguration, logger);
    }

    public static Function1<String, Option<VirtualFile>> classPathLookup(CompileConfiguration compileConfiguration) {
        return MixedAnalyzingCompiler$.MODULE$.classPathLookup(compileConfiguration);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(FileConverter fileConverter, Seq<VirtualFile> seq, String[] stringArray, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler scalaCompiler) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(fileConverter, seq, stringArray, perClasspathEntryLookup, scalaCompiler);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(CompileConfiguration compileConfiguration) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(compileConfiguration);
    }

    public static boolean makeConfig$default$15() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$15();
    }

    public static CompileOrder makeConfig$default$14() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$14();
    }

    public static Seq<String> makeConfig$default$9() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$9();
    }

    public static Seq<String> makeConfig$default$8() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$8();
    }

    public static Option<CompileProgress> makeConfig$default$7() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$7();
    }

    public static CompileConfiguration makeConfig(ScalaCompiler scalaCompiler, JavaCompiler javaCompiler, Seq<VirtualFile> seq, FileConverter fileConverter, Seq<VirtualFile> seq2, GlobalsCache globalsCache, Option<CompileProgress> option, Seq<String> seq3, Seq<String> seq4, CompileAnalysis compileAnalysis, Option<MiniSetup> option2, PerClasspathEntryLookup perClasspathEntryLookup, Reporter reporter, CompileOrder compileOrder, boolean bl, IncOptions incOptions, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> option3, Option<AnalysisStore> option4, ReadStamps readStamps, List<Tuple2<String, String>> list) {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig(scalaCompiler, javaCompiler, seq, fileConverter, seq2, globalsCache, option, seq3, seq4, compileAnalysis, option2, perClasspathEntryLookup, reporter, compileOrder, bl, incOptions, output, outputJarContent, option3, option4, readStamps, list);
    }

    public ScalaCompiler scalac() {
        return this.scalac;
    }

    public AnalyzingJavaCompiler javac() {
        return this.javac;
    }

    public CompileConfiguration config() {
        return this.config;
    }

    public Logger log() {
        return this.log;
    }

    public void compileJava(Seq<VirtualFile> javaSrcs, AnalysisCallback callback, ClassFileManager classfileManager) {
        this.ensureOutput();
        if (javaSrcs.nonEmpty()) {
            this.timed("Java compilation + analysis", this.log(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Output output = this.config().currentSetup().output();
                IncToolOptions incToolOptions = IncToolOptions.of(Optional.of(classfileManager), (boolean)this.config().incOptions().useCustomizedFileManager());
                String[] joptions = this.config().currentSetup().options().javacOptions();
                Option option = JarUtils$.MODULE$.getOutputJar(output);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Path outputJar = (Path)some.value();
                    if (!this.javac().supportsDirectToJar()) {
                        Path outputDir = JarUtils$.MODULE$.javacTempOutput(outputJar);
                        Files.createDirectories(outputDir, new FileAttribute[0]);
                        this.javac().compile(javaSrcs, (Seq<VirtualFile>)((Seq)new .colon.colon((Object)this.toVirtualFile$1(outputJar), (List)Nil$.MODULE$)), this.config().converter(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])joptions), CompileOutput$.MODULE$.apply(outputDir), (Option<Path>)new Some((Object)outputJar), callback, incToolOptions, this.config().reporter(), (xsbti.Logger)this.log(), this.config().progress());
                        this.putJavacOutputInJar(outputJar.toFile(), outputDir.toFile());
                        return;
                    }
                }
                JarUtils$.MODULE$.withPreviousJar(output, (Function1 & Serializable & scala.Serializable)extraClasspath -> {
                    MixedAnalyzingCompiler.$anonfun$compileJava$2(this, javaSrcs, joptions, output, callback, incToolOptions, extraClasspath);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    public Seq<Path> ensureOutput() {
        Output output = this.config().currentSetup().output();
        Seq<Path> outputDirs = this.outputDirectories(output);
        outputDirs.foreach((Function1 & Serializable & scala.Serializable)d -> {
            Path dir = ((Object)d).toString().endsWith(".jar") ? d.getParent() : d;
            return Files.createDirectories(dir, new FileAttribute[0]);
        });
        return outputDirs;
    }

    public void compile(Set<VirtualFile> include, DependencyChanges changes, AnalysisCallback callback, ClassFileManager classfileManager) {
        Output output = this.config().currentSetup().output();
        Seq<Path> outputDirs = this.ensureOutput();
        Seq incSrc = (Seq)this.config().sources().filter(include);
        Tuple2 tuple2 = incSrc.partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MixedAnalyzingCompiler$.MODULE$.javaOnly(f)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq javaSrcs = (Seq)tuple2._1();
        Seq scalaSrcs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)javaSrcs, (Object)scalaSrcs);
        Seq javaSrcs2 = (Seq)tuple22._1();
        Seq scalaSrcs2 = (Seq)tuple22._2();
        this.logInputs(this.log(), javaSrcs2.size(), scalaSrcs2.size(), outputDirs);
        boolean pickleJava = Incremental$.MODULE$.isPickleJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.config().currentSetup().options().scalacOptions()));
        if (this.config().incOptions().pipelining()) {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            if (scalaSrcs2.nonEmpty()) {
                this.log().debug((Function0 & Serializable & scala.Serializable)() -> "done compiling Scala sources");
                return;
            }
            return;
        }
        CompileOrder compileOrder = this.config().currentSetup().order();
        CompileOrder compileOrder2 = CompileOrder.JavaThenScala;
        if (!(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null)) {
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
        } else {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
        }
        if (javaSrcs2.size() + scalaSrcs2.size() > 0) {
            if (ConsoleAppender$.MODULE$.showProgress()) {
                this.log().debug((Function0 & Serializable & scala.Serializable)() -> "done compiling");
                return;
            }
            this.log().info((Function0 & Serializable & scala.Serializable)() -> "done compiling");
            return;
        }
    }

    private void putJavacOutputInJar(File outputJar, File outputDir) {
        Seq compiledClasses = (Seq)syntax$.MODULE$.singleFileFinder(outputDir).$times$times(DirectoryFilter$.MODULE$.unary_$minus()).get().flatMap((Function1 & Serializable & scala.Serializable)classFile -> {
            Option option = IO$.MODULE$.relativize(outputDir, classFile);
            if (option instanceof Some) {
                Some some = (Some)option;
                String relPath = (String)some.value();
                return new .colon.colon((Object)new Tuple2(classFile, (Object)relPath), (List)Nil$.MODULE$);
            }
            return Nil$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
        if (compiledClasses.nonEmpty()) {
            JarUtils$.MODULE$.includeInJar(outputJar, compiledClasses);
            this.outputJarContent.addClasses(((TraversableOnce)compiledClasses.map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._2(), Seq$.MODULE$.canBuildFrom())).toSet());
        }
        IO$.MODULE$.delete(outputDir);
    }

    private Seq<Path> outputDirectories(Output output) {
        Output output2 = output;
        if (output2 instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output2;
            return new .colon.colon((Object)singleOutput.getOutputDirectoryAsPath(), (List)Nil$.MODULE$);
        }
        if (output2 instanceof MultipleOutput) {
            MultipleOutput multipleOutput = (MultipleOutput)output2;
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])multipleOutput.getOutputGroups())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getOutputDirectoryAsPath(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new MatchError((Object)output2);
    }

    private <T> T timed(String label, Logger log, Function0<T> t) {
        long start = System.nanoTime();
        Object result = t.apply();
        long elapsed = System.nanoTime() - start;
        log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append(label).append(" took ").append((double)elapsed / 1.0E9).append(" s").toString());
        return (T)result;
    }

    private void logInputs(Logger log, int javaCount, int scalaCount, Seq<Path> outputDirs) {
        Option scalaMsg = Analysis$.MODULE$.counted("Scala source", "", "s", scalaCount);
        Option javaMsg = Analysis$.MODULE$.counted("Java source", "", "s", javaCount);
        Iterable combined = (Iterable)Option$.MODULE$.option2Iterable(scalaMsg).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(javaMsg), Iterable$.MODULE$.canBuildFrom());
        if (combined.nonEmpty()) {
            String targets = ((TraversableOnce)outputDirs.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            log.info((Function0 & Serializable & scala.Serializable)() -> combined.mkString("compiling ", " and ", new StringBuilder(8).append(" to ").append(targets).append(" ...").toString()));
            return;
        }
    }

    private final VirtualFile toVirtualFile$1(Path p) {
        return this.config().converter().toVirtualFile(p.toAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$compileJava$2(MixedAnalyzingCompiler $this, Seq javaSrcs$1, String[] joptions$1, Output output$1, AnalysisCallback callback$1, IncToolOptions incToolOptions$1, Seq extraClasspath) {
        $this.javac().compile((Seq<VirtualFile>)javaSrcs$1, (Seq<VirtualFile>)((Seq)extraClasspath.map((Function1 & Serializable & scala.Serializable)p -> $this.toVirtualFile$1((Path)p), Seq$.MODULE$.canBuildFrom())), $this.config().converter(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])joptions$1), output$1, (Option<Path>)None$.MODULE$, callback$1, incToolOptions$1, $this.config().reporter(), (xsbti.Logger)$this.log(), $this.config().progress());
    }

    public static final /* synthetic */ void $anonfun$compile$4(MixedAnalyzingCompiler $this, Seq incSrc$1, Seq scalaSrcs$1, boolean pickleJava$1, DependencyChanges changes$1, String[] scalacOpts$1, Output output$2, AnalysisCallback callback$2, Seq extraClasspath) {
        Vector vector;
        CompileOrder compileOrder = $this.config().currentSetup().order();
        CompileOrder compileOrder2 = CompileOrder.Mixed;
        Seq sources = !(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null) ? incSrc$1 : scalaSrcs$1;
        Vector cp0 = (Vector)((Vector)extraClasspath.toVector().map((Function1 & Serializable & scala.Serializable)x -> $this.config().converter().toVirtualFile(x.toAbsolutePath()), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)$this.absClasspath.toVector(), Vector$.MODULE$.canBuildFrom());
        if (scalaSrcs$1.isEmpty() && pickleJava$1) {
            Vector libraryJars = (Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.scalac().scalaInstance().libraryJars())).toVector().map((Function1 & Serializable & scala.Serializable)x -> $this.config().converter().toVirtualFile(x.toPath()), Vector$.MODULE$.canBuildFrom());
            vector = (Vector)((SeqLike)cp0.$plus$plus((GenTraversableOnce)libraryJars, Vector$.MODULE$.canBuildFrom())).distinct();
        } else {
            vector = cp0;
        }
        Vector cp = vector;
        $this.timed("Scala compilation", $this.log(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.config().compiler().compile((VirtualFile[])sources.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (VirtualFile[])cp.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), $this.config().converter(), changes$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scalacOpts$1)).toArray(ClassTag$.MODULE$.apply(String.class)), output$2, callback$2, $this.config().reporter(), JavaInterfaceUtil$.MODULE$.EnrichOption($this.config().progress()).toOptional(), (xsbti.Logger)$this.log()));
    }

    private final void compileScala$1(Seq scalaSrcs$1, boolean pickleJava$1, AnalysisCallback callback$2, Output output$2, Seq incSrc$1, DependencyChanges changes$1) {
        if (scalaSrcs$1.nonEmpty() || pickleJava$1) {
            String[] stringArray;
            Some some;
            Tuple2 tuple2;
            Option pickleJarPair = JavaInterfaceUtil$.MODULE$.EnrichOptional(callback$2.getPickleJarPair()).toOption().map((Function1 & Serializable & scala.Serializable)t2 -> new Tuple2(t2.get1(), t2.get2()));
            Option option = pickleJarPair;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Path originalJar = (Path)tuple2._1();
                Path updatesJar = (Path)tuple2._2();
                String path = ((Object)originalJar).toString();
                String fwdSlashPath = path.replace('\\', '/');
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().currentSetup().options().scalacOptions())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    String string;
                    block3: {
                        block2: {
                            String string2 = string = x0$1;
                            String string3 = path;
                            if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                            String string4 = string;
                            String string5 = fwdSlashPath;
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
                        }
                        return ((Object)updatesJar).toString();
                    }
                    return string;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            } else {
                stringArray = this.config().currentSetup().options().scalacOptions();
            }
            String[] scalacOpts = stringArray;
            JarUtils$.MODULE$.withPreviousJar(output$2, (Function1 & Serializable & scala.Serializable)extraClasspath -> {
                MixedAnalyzingCompiler.$anonfun$compile$4(this, incSrc$1, scalaSrcs$1, pickleJava$1, changes$1, scalacOpts, output$2, callback$2, extraClasspath);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void compileJava0$1(Seq javaSrcs$2, AnalysisCallback callback$2, ClassFileManager classfileManager$2) {
        this.compileJava((Seq<VirtualFile>)javaSrcs$2, callback$2, classfileManager$2);
    }

    public MixedAnalyzingCompiler(ScalaCompiler scalac, AnalyzingJavaCompiler javac, CompileConfiguration config, Logger log, JarUtils.OutputJarContent outputJarContent) {
        this.scalac = scalac;
        this.javac = javac;
        this.config = config;
        this.log = log;
        this.outputJarContent = outputJarContent;
        this.absClasspath = (Seq)config.classpath().map((Function1 & Serializable & scala.Serializable)x$1 -> VirtualFileUtil$.MODULE$.toAbsolute(x$1), Seq$.MODULE$.canBuildFrom());
    }
}

