/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.Incremental$;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.MixedAnalyzingCompiler$;
import sbt.internal.inc.VirtualFileUtil$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.internal.util.ConsoleAppender$;
import sbt.io.DirectoryFilter$;
import sbt.io.IO$;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.FileConverter;
import xsbti.Reporter;
import xsbti.VirtualFile;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileProgress;
import xsbti.compile.DependencyChanges;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.IncToolOptions;
import xsbti.compile.JavaCompiler;
import xsbti.compile.MiniSetup;
import xsbti.compile.MultipleOutput;
import xsbti.compile.Output;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.SingleOutput;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0001\r\u0005f\u0001\u0002\u0015*\u0005AB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005s!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003E\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t5\u0002\u0011\t\u0011)A\u00057\")!\r\u0001C\u0001G\"1!\u000e\u0001Q\u0001\n-DQ!\u001e\u0001\u0005\u0002YDq!a\t\u0001\t\u0003\t)\u0003\u0003\u0004=\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003C\u0002A\u0011BA2\u0011!\tI\b\u0001Q\u0005\n\u0005m\u0004\u0002CAE\u0001\u0001&I!a#\t\u0011\u0005u\u0006\u0001)C\u0005\u0003\u007f;q!!6*\u0011\u0003\t9N\u0002\u0004)S!\u0005\u0011\u0011\u001c\u0005\u0007ER!\t!a7\t\u0011\u0005uG\u0003\"\u0001.\u0003?Dq!!=\u0015\t\u0003\t\u0019\u0010C\u0005\u0003.R\t\n\u0011\"\u0001\u00030\"I!Q\u0019\u000b\u0012\u0002\u0013\u0005!q\u0019\u0005\n\u0005\u0017$\u0012\u0013!C\u0001\u0005\u000fD\u0011B!4\u0015#\u0003%\tAa4\t\u0013\tMG#%A\u0005\u0002\tU\u0007B\u0002&\u0015\t\u0003\u0011I\u000eC\u0004\u0004\u0004Q!\ta!\u0002\t\u000f\r\rA\u0003\"\u0001\u0004\u0014!91q\u0005\u000b\u0005\u0002\r%\u0002bBB\u0017)\u0011\u00051q\u0006\u0005\b\u0007o!B\u0011AB\u001d\u0011!\u0019I\u0005\u0006Q\u0005\n\r-\u0003\u0002\u0003B\n)\u0001\u0006Ia!\u0015\t\u000f\r5D\u0003\"\u0003\u0004p!91\u0011\u0010\u000b\u0005\u0002\rm\u0004bBB=)\u0011\u00051Q\u0011\u0002\u0017\u001b&DX\rZ!oC2L(0\u001b8h\u0007>l\u0007/\u001b7fe*\u0011!fK\u0001\u0004S:\u001c'B\u0001\u0017.\u0003!Ig\u000e^3s]\u0006d'\"\u0001\u0018\u0002\u0007M\u0014Go\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g-\u0001\u0004tG\u0006d\u0017mY\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\bG>l\u0007/\u001b7f\u0015\u0005q\u0014!\u0002=tERL\u0017B\u0001!<\u00055\u00196-\u00197b\u0007>l\u0007/\u001b7fe\u000691oY1mC\u000e\u0004\u0013!\u00026bm\u0006\u001cW#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\tK\u0013B\u0001%G\u0005U\te.\u00197zu&twMS1wC\u000e{W\u000e]5mKJ\faA[1wC\u000e\u0004\u0013AB2p]\u001aLw-F\u0001M!\tie*D\u0001*\u0013\ty\u0015F\u0001\u000bD_6\u0004\u0018\u000e\\3D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u0003\rawnZ\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a+L\u0001\u0005kRLG.\u0003\u0002Y+\n1Aj\\4hKJ\fA\u0001\\8hA\u0005\u0001r.\u001e;qkRT\u0015M]\"p]R,g\u000e\u001e\t\u00039~s!!T/\n\u0005yK\u0013\u0001\u0003&beV#\u0018\u000e\\:\n\u0005\u0001\f'\u0001E(viB,HOS1s\u0007>tG/\u001a8u\u0015\tq\u0016&\u0001\u0004=S:LGO\u0010\u000b\u0007I\u00164w\r[5\u0011\u00055\u0003\u0001\"B\u001c\u000b\u0001\u0004I\u0004\"\u0002\"\u000b\u0001\u0004!\u0005\"\u0002&\u000b\u0001\u0004a\u0005\"B)\u000b\u0001\u0004\u0019\u0006\"\u0002.\u000b\u0001\u0004Y\u0016\u0001D1cg\u000ec\u0017m]:qCRD\u0007c\u00017pc6\tQN\u0003\u0002og\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Al'aA*fcB\u0011!o]\u0007\u0002{%\u0011A/\u0010\u0002\f-&\u0014H/^1m\r&dW-A\u0006d_6\u0004\u0018\u000e\\3KCZ\fGCB<{\u0003\u001f\tI\u0002\u0005\u00023q&\u0011\u0011p\r\u0002\u0005+:LG\u000fC\u0003|\u0019\u0001\u0007A0\u0001\u0005kCZ\f7K]2t!\u0011i\u00181B9\u000f\u0007y\f9AD\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rq&\u0001\u0004=e>|GOP\u0005\u0002i%\u0019\u0011\u0011B\u001a\u0002\u000fA\f7m[1hK&\u0019\u0001/!\u0004\u000b\u0007\u0005%1\u0007C\u0004\u0002\u00121\u0001\r!a\u0005\u0002\u0011\r\fG\u000e\u001c2bG.\u00042A]A\u000b\u0013\r\t9\"\u0010\u0002\u0011\u0003:\fG._:jg\u000e\u000bG\u000e\u001c2bG.Dq!a\u0007\r\u0001\u0004\ti\"\u0001\tdY\u0006\u001c8OZ5mK6\u000bg.Y4feB\u0019!(a\b\n\u0007\u0005\u00052H\u0001\tDY\u0006\u001c8OR5mK6\u000bg.Y4fe\u0006aQM\\:ve\u0016|U\u000f\u001e9viV\u0011\u0011q\u0005\t\u0005Y>\fI\u0003\u0005\u0003\u0002,\u0005eRBAA\u0017\u0015\u0011\ty#!\r\u0002\t\u0019LG.\u001a\u0006\u0005\u0003g\t)$A\u0002oS>T!!a\u000e\u0002\t)\fg/Y\u0005\u0005\u0003w\tiC\u0001\u0003QCRDG#C<\u0002@\u0005M\u0013QLA0\u0011\u001d\t\tE\u0004a\u0001\u0003\u0007\nq!\u001b8dYV$W\rE\u0003\u0002F\u00055\u0013O\u0004\u0003\u0002H\u0005%\u0003CA@4\u0013\r\tYeM\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0013\u0011\u000b\u0002\u0004'\u0016$(bAA&g!9\u0011Q\u000b\bA\u0002\u0005]\u0013aB2iC:<Wm\u001d\t\u0004u\u0005e\u0013bAA.w\t\tB)\u001a9f]\u0012,gnY=DQ\u0006tw-Z:\t\u000f\u0005Ea\u00021\u0001\u0002\u0014!9\u00111\u0004\bA\u0002\u0005u\u0011a\u00059vi*\u000bg/Y2PkR\u0004X\u000f^%o\u0015\u0006\u0014H#B<\u0002f\u0005U\u0004bBA4\u001f\u0001\u0007\u0011\u0011N\u0001\n_V$\b/\u001e;KCJ\u0004B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n)$\u0001\u0002j_&!\u00111OA7\u0005\u00111\u0015\u000e\\3\t\u000f\u0005]t\u00021\u0001\u0002j\u0005Iq.\u001e;qkR$\u0015N]\u0001\u0012_V$\b/\u001e;ESJ,7\r^8sS\u0016\u001cH\u0003BA?\u0003\u007f\u0002R!`A\u0006\u0003SAq!!!\u0011\u0001\u0004\t\u0019)\u0001\u0004pkR\u0004X\u000f\u001e\t\u0004u\u0005\u0015\u0015bAADw\t1q*\u001e;qkR\fQ\u0001^5nK\u0012,B!!$\u0002\u0016R1\u0011qRAY\u0003w#B!!%\u0002(B!\u00111SAK\u0019\u0001!q!a&\u0012\u0005\u0004\tIJA\u0001U#\u0011\tY*!)\u0011\u0007I\ni*C\u0002\u0002 N\u0012qAT8uQ&tw\rE\u00023\u0003GK1!!*4\u0005\r\te.\u001f\u0005\t\u0003S\u000bB\u00111\u0001\u0002,\u0006\tA\u000fE\u00033\u0003[\u000b\t*C\u0002\u00020N\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0003g\u000b\u0002\u0019AA[\u0003\u0015a\u0017MY3m!\u0011\t)%a.\n\t\u0005e\u0016\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\t\u000bE\u000b\u0002\u0019A*\u0002\u00131|w-\u00138qkR\u001cH#C<\u0002B\u0006\r\u0017QZAi\u0011\u0015\t&\u00031\u0001T\u0011\u001d\t)M\u0005a\u0001\u0003\u000f\f\u0011B[1wC\u000e{WO\u001c;\u0011\u0007I\nI-C\u0002\u0002LN\u00121!\u00138u\u0011\u001d\tyM\u0005a\u0001\u0003\u000f\f!b]2bY\u0006\u001cu.\u001e8u\u0011\u001d\t\u0019N\u0005a\u0001\u0003{\n!b\\;uaV$H)\u001b:t\u0003Yi\u0015\u000e_3e\u0003:\fG.\u001f>j]\u001e\u001cu.\u001c9jY\u0016\u0014\bCA'\u0015'\t!\u0012\u0007\u0006\u0002\u0002X\u0006A!.\u0019<b\u001f:d\u0017\u0010\u0006\u0003\u0002b\u0006\u001d\bc\u0001\u001a\u0002d&\u0019\u0011Q]\u001a\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u001e\fA\u0002\u0005-\u0018!\u00014\u0011\u0007I\fi/C\u0002\u0002pv\u0012aBV5siV\fGNR5mKJ+g-\u0001\u0006nC.,7i\u001c8gS\u001e$R\u0006TA{\u0003o\fyPa\u0001\u0003\u000e\tE!1\u0004B\u0016\u0005c\u0011)Da\u0010\u0003L\tU#q\fB5\u0005[\u00129H!\u001f\u0003|\t\u0005%Q\u0012BO\u0011\u00159t\u00031\u0001:\u0011\u0019\u0011u\u00031\u0001\u0002zB\u0019!(a?\n\u0007\u0005u8H\u0001\u0007KCZ\f7i\\7qS2,'\u000f\u0003\u0004\u0003\u0002]\u0001\r\u0001`\u0001\bg>,(oY3t\u0011\u001d\u0011)a\u0006a\u0001\u0005\u000f\t\u0011bY8om\u0016\u0014H/\u001a:\u0011\u0007I\u0014I!C\u0002\u0003\fu\u0012QBR5mK\u000e{gN^3si\u0016\u0014\bB\u0002B\b/\u0001\u0007A0A\u0005dY\u0006\u001c8\u000f]1uQ\"9!1C\fA\u0002\tU\u0011!B2bG\",\u0007c\u0001\u001e\u0003\u0018%\u0019!\u0011D\u001e\u0003\u0019\u001dcwNY1mg\u000e\u000b7\r[3\t\u0013\tuq\u0003%AA\u0002\t}\u0011\u0001\u00039s_\u001e\u0014Xm]:\u0011\u000bI\u0012\tC!\n\n\u0007\t\r2G\u0001\u0004PaRLwN\u001c\t\u0004u\t\u001d\u0012b\u0001B\u0015w\ty1i\\7qS2,\u0007K]8he\u0016\u001c8\u000fC\u0005\u0003.]\u0001\n\u00111\u0001\u00030\u00059q\u000e\u001d;j_:\u001c\b#B?\u0002\f\u0005U\u0006\"\u0003B\u001a/A\u0005\t\u0019\u0001B\u0018\u00031Q\u0017M^1d\u001fB$\u0018n\u001c8t\u0011\u001d\u00119d\u0006a\u0001\u0005s\t\u0001\u0003\u001d:fm&|Wo]!oC2L8/[:\u0011\u0007i\u0012Y$C\u0002\u0003>m\u0012qbQ8na&dW-\u00118bYf\u001c\u0018n\u001d\u0005\b\u0005\u0003:\u0002\u0019\u0001B\"\u00035\u0001(/\u001a<j_V\u001c8+\u001a;vaB)!G!\t\u0003FA\u0019!Ha\u0012\n\u0007\t%3HA\u0005NS:L7+\u001a;va\"9!QJ\fA\u0002\t=\u0013a\u00069fe\u000ec\u0017m]:qCRDWI\u001c;ss2{wn[;q!\rQ$\u0011K\u0005\u0004\u0005'Z$a\u0006)fe\u000ec\u0017m]:qCRDWI\u001c;ss2{wn[;q\u0011\u001d\u00119f\u0006a\u0001\u00053\n\u0001B]3q_J$XM\u001d\t\u0004e\nm\u0013b\u0001B/{\tA!+\u001a9peR,'\u000fC\u0005\u0003b]\u0001\n\u00111\u0001\u0003d\u0005a1m\\7qS2,wJ\u001d3feB\u0019!H!\u001a\n\u0007\t\u001d4H\u0001\u0007D_6\u0004\u0018\u000e\\3Pe\u0012,'\u000fC\u0005\u0003l]\u0001\n\u00111\u0001\u0002b\u0006!1o[5q\u0011\u001d\u0011yg\u0006a\u0001\u0005c\n!$\u001b8de\u0016lWM\u001c;bY\u000e{W\u000e]5mKJ|\u0005\u000f^5p]N\u00042A\u000fB:\u0013\r\u0011)h\u000f\u0002\u000b\u0013:\u001cw\n\u001d;j_:\u001c\bbBAA/\u0001\u0007\u00111\u0011\u0005\u00065^\u0001\ra\u0017\u0005\b\u0005{:\u0002\u0019\u0001B@\u0003-)\u0017M\u001d7z\u001fV$\b/\u001e;\u0011\u000bI\u0012\t#a!\t\u000f\t\ru\u00031\u0001\u0003\u0006\u0006\u0011R-\u0019:ms\u0006s\u0017\r\\=tSN\u001cFo\u001c:f!\u0015\u0011$\u0011\u0005BD!\rQ$\u0011R\u0005\u0004\u0005\u0017[$!D!oC2L8/[:Ti>\u0014X\rC\u0004\u0003\u0010^\u0001\rA!%\u0002\u000fM$\u0018-\u001c9feB!!1\u0013BM\u001b\t\u0011)JC\u0002\u0003\u0018n\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u00057\u0013)J\u0001\u0006SK\u0006$7\u000b^1naNDqAa(\u0018\u0001\u0004\u0011\t+A\u0003fqR\u0014\u0018\rE\u0003~\u0005G\u00139+\u0003\u0003\u0003&\u00065!\u0001\u0002'jgR\u0004rA\rBU\u0003k\u000b),C\u0002\u0003,N\u0012a\u0001V;qY\u0016\u0014\u0014\u0001F7bW\u0016\u001cuN\u001c4jO\u0012\"WMZ1vYR$s'\u0006\u0002\u00032*\"!q\u0004BZW\t\u0011)\f\u0005\u0003\u00038\n\u0005WB\u0001B]\u0015\u0011\u0011YL!0\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B`g\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r'\u0011\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F7bW\u0016\u001cuN\u001c4jO\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003J*\"!q\u0006BZ\u0003Qi\u0017m[3D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%s\u0005)R.Y6f\u0007>tg-[4%I\u00164\u0017-\u001e7uIE\"TC\u0001BiU\u0011\u0011\u0019Ga-\u0002+5\f7.Z\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00132kU\u0011!q\u001b\u0016\u0005\u0003C\u0014\u0019\fF\u0013M\u00057\u0014iNa8\u0003b\n\u0015(q\u001dBu\u0005W\u0014iO!=\u0003t\nU(q\u001fB}\u0005w\u0014iPa@\u0004\u0002!1!\u0011A\u000fA\u0002qDqA!\u0002\u001e\u0001\u0004\u00119\u0001\u0003\u0004\u0003\u0010u\u0001\r\u0001 \u0005\b\u0005Gl\u0002\u0019\u0001B#\u0003\u0015\u0019X\r^;q\u0011\u001d\u0011i\"\ba\u0001\u0005?AqAa\u000e\u001e\u0001\u0004\u0011I\u0004C\u0004\u0003Bu\u0001\rAa\u0011\t\u000f\t5S\u00041\u0001\u0003P!1!q^\u000fA\u0002e\n\u0001bY8na&dWM\u001d\u0005\u0007\u0005v\u0001\r!!?\t\u000f\t]S\u00041\u0001\u0003Z!9!1N\u000fA\u0002\u0005\u0005\bb\u0002B\n;\u0001\u0007!Q\u0003\u0005\b\u0005_j\u0002\u0019\u0001B9\u0011\u0015QV\u00041\u0001\\\u0011\u001d\u0011i(\ba\u0001\u0005\u007fBqAa!\u001e\u0001\u0004\u0011)\tC\u0004\u0003\u0010v\u0001\rA!%\u00021M,\u0017M]2i\u00072\f7o\u001d9bi\"\fe\u000e\u001a'p_.,\b\u000f\u0006\u0003\u0004\b\rE\u0001C\u0002\u001a\u0003*r\u001cI\u0001E\u00043\u0007\u0017\t)la\u0004\n\u0007\r51GA\u0005Gk:\u001cG/[8ocA!!G!\tr\u0011\u0015Qe\u00041\u0001M)1\u00199a!\u0006\u0004\u0018\re11EB\u0013\u0011\u001d\u0011)a\ba\u0001\u0005\u000fAaAa\u0004 \u0001\u0004a\bbBB\u000e?\u0001\u00071QD\u0001\u000eg\u000e\fG.Y2PaRLwN\\:\u0011\u000bI\u001ay\"!.\n\u0007\r\u00052GA\u0003BeJ\f\u0017\u0010C\u0004\u0003N}\u0001\rAa\u0014\t\r\t=x\u00041\u0001:\u0003=\u0019G.Y:t!\u0006$\b\u000eT8pWV\u0004H\u0003BB\u0005\u0007WAQA\u0013\u0011A\u00021\u000bQ!\u00199qYf$Ba!\r\u00046Q\u0019Ama\r\t\u000bE\u000b\u00039A*\t\u000b)\u000b\u0003\u0019\u0001'\u0002#]LG\u000f\u001b\"p_R\u001cG.Y:ta\u0006$\b\u000eF\u0004}\u0007w\u0019)ea\u0012\t\u000f\ru\"\u00051\u0001\u0004@\u0005!\u0011M]4t!\ri5\u0011I\u0005\u0004\u0007\u0007J#!E\"p[BLG.\u001a:Be\u001e,X.\u001a8ug\"1!q\u0002\u0012A\u0002qDqA!\u0002#\u0001\u0004\u00119!A\u000bfqBd\u0017nY5u\u0005>|Go\u00117bgN\u0004\u0018\r\u001e5\u0015\u000bq\u001ciea\u0014\t\u000f\t52\u00051\u0001\u00030!9!QA\u0012A\u0002\t\u001d\u0001\u0003CB*\u00073\nIc!\u0018\u000e\u0005\rU#bAB,[\u00069Q.\u001e;bE2,\u0017\u0002BB.\u0007+\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0004\u0004`\r%$qQ\u0007\u0003\u0007CRAaa\u0019\u0004f\u0005\u0019!/\u001a4\u000b\t\r\u001d\u0014QG\u0001\u0005Y\u0006tw-\u0003\u0003\u0004l\r\u0005$!\u0003*fM\u0016\u0014XM\\2f\u0003-\u0019H/\u0019;jG\u000e\u000b7\r[3\u0015\r\t\u001d5\u0011OB:\u0011\u001d\ty#\na\u0001\u0003SA\u0001b!\u001e&\t\u0003\u00071qO\u0001\bE\u0006\u001c7.\u001b8h!\u0015\u0011\u0014Q\u0016BD\u0003E\u0019H/\u0019;jG\u000e\u000b7\r[3e'R|'/\u001a\u000b\u0007\u0005\u000f\u001bih!!\t\u000f\r}d\u00051\u0001\u0002*\u0005a\u0011M\\1msNL7OR5mK\"911\u0011\u0014A\u0002\u0005\u0005\u0018aD;tKR+\u0007\u0010^!oC2L8/[:\u0015\u001d\t\u001d5qQBE\u0007\u0017\u001byi!'\u0004\u001e\"91qP\u0014A\u0002\u0005%\u0002bBBBO\u0001\u0007\u0011\u0011\u001d\u0005\b\u0007\u001b;\u0003\u0019AAq\u00035)8/Z\"p]NL7\u000f^3oi\"91\u0011S\u0014A\u0002\rM\u0015aB7baB,'o\u001d\t\u0005\u0005'\u001b)*\u0003\u0003\u0004\u0018\nU%\u0001\u0005*fC\u0012<&/\u001b;f\u001b\u0006\u0004\b/\u001a:t\u0011\u001d\u0019Yj\na\u0001\u0003C\fAa]8si\"91qT\u0014A\u0002\u0005\u001d\u0017a\u00039be\u0006dG.\u001a7jg6\u0004")
public final class MixedAnalyzingCompiler {
    private final ScalaCompiler scalac;
    private final AnalyzingJavaCompiler javac;
    private final CompileConfiguration config;
    private final Logger log;
    private final JarUtils.OutputJarContent outputJarContent;
    private final Seq<VirtualFile> absClasspath;

    public static AnalysisStore staticCachedStore(Path path, boolean bl, boolean bl2, ReadWriteMappers readWriteMappers, boolean bl3, int n) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(path, bl, bl2, readWriteMappers, bl3, n);
    }

    public static AnalysisStore staticCachedStore(Path path, boolean bl) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(path, bl);
    }

    public static Seq<VirtualFile> withBootclasspath(CompilerArguments compilerArguments, Seq<VirtualFile> seq, FileConverter fileConverter) {
        return MixedAnalyzingCompiler$.MODULE$.withBootclasspath(compilerArguments, seq, fileConverter);
    }

    public static MixedAnalyzingCompiler apply(CompileConfiguration compileConfiguration, Logger logger) {
        return MixedAnalyzingCompiler$.MODULE$.apply(compileConfiguration, logger);
    }

    public static Function1<String, Option<VirtualFile>> classPathLookup(CompileConfiguration compileConfiguration) {
        return MixedAnalyzingCompiler$.MODULE$.classPathLookup(compileConfiguration);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(FileConverter fileConverter, Seq<VirtualFile> seq, String[] stringArray, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler scalaCompiler) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(fileConverter, seq, stringArray, perClasspathEntryLookup, scalaCompiler);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(CompileConfiguration compileConfiguration) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(compileConfiguration);
    }

    public static boolean makeConfig$default$15() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$15();
    }

    public static CompileOrder makeConfig$default$14() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$14();
    }

    public static Seq<String> makeConfig$default$9() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$9();
    }

    public static Seq<String> makeConfig$default$8() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$8();
    }

    public static Option<CompileProgress> makeConfig$default$7() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$7();
    }

    public static CompileConfiguration makeConfig(ScalaCompiler scalaCompiler, JavaCompiler javaCompiler, Seq<VirtualFile> seq, FileConverter fileConverter, Seq<VirtualFile> seq2, GlobalsCache globalsCache, Option<CompileProgress> option, Seq<String> seq3, Seq<String> seq4, CompileAnalysis compileAnalysis, Option<MiniSetup> option2, PerClasspathEntryLookup perClasspathEntryLookup, Reporter reporter, CompileOrder compileOrder, boolean bl, IncOptions incOptions, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> option3, Option<AnalysisStore> option4, ReadStamps readStamps, List<Tuple2<String, String>> list) {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig(scalaCompiler, javaCompiler, seq, fileConverter, seq2, globalsCache, option, seq3, seq4, compileAnalysis, option2, perClasspathEntryLookup, reporter, compileOrder, bl, incOptions, output, outputJarContent, option3, option4, readStamps, list);
    }

    public ScalaCompiler scalac() {
        return this.scalac;
    }

    public AnalyzingJavaCompiler javac() {
        return this.javac;
    }

    public CompileConfiguration config() {
        return this.config;
    }

    public Logger log() {
        return this.log;
    }

    public void compileJava(Seq<VirtualFile> javaSrcs, AnalysisCallback callback, ClassFileManager classfileManager) {
        this.ensureOutput();
        if (javaSrcs.nonEmpty()) {
            this.timed("Java compilation + analysis", this.log(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Output output = this.config().currentSetup().output();
                IncToolOptions incToolOptions = IncToolOptions.of(Optional.of(classfileManager), (boolean)this.config().incOptions().useCustomizedFileManager());
                String[] joptions = this.config().currentSetup().options().javacOptions();
                Option outputJarOpt = JarUtils$.MODULE$.getOutputJar(output);
                Option option = outputJarOpt;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Path outputJar = (Path)some.value();
                    if (!this.javac().supportsDirectToJar()) {
                        Path outputDir = JarUtils$.MODULE$.javacTempOutput(outputJar);
                        Files.createDirectories(outputDir, new FileAttribute[0]);
                        this.javac().compile(javaSrcs, (Seq<VirtualFile>)((Seq)new .colon.colon((Object)this.toVirtualFile$1(outputJar), (List)Nil$.MODULE$)), this.config().converter(), (Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joptions)).toIndexedSeq(), CompileOutput$.MODULE$.apply(outputDir), (Option<Path>)outputJarOpt, callback, incToolOptions, this.config().reporter(), (xsbti.Logger)this.log(), this.config().progress());
                        this.putJavacOutputInJar(outputJar.toFile(), outputDir.toFile());
                        return;
                    }
                }
                JarUtils$.MODULE$.withPreviousJar(output, (Function1 & Serializable & scala.Serializable)extraClasspath -> {
                    MixedAnalyzingCompiler.$anonfun$compileJava$2(this, javaSrcs, joptions, output, outputJarOpt, callback, incToolOptions, extraClasspath);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    public Seq<Path> ensureOutput() {
        Output output = this.config().currentSetup().output();
        Option option = JarUtils$.MODULE$.getOutputJar(output);
        if (option instanceof Some) {
            Some some = (Some)option;
            Path jar = (Path)some.value();
            Files.createDirectories(jar.getParent(), new FileAttribute[0]);
            return (Seq)new .colon.colon((Object)jar, (List)Nil$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            Seq<Path> dirs = this.outputDirectories(output);
            dirs.foreach((Function1 & Serializable & scala.Serializable)x$2 -> Files.createDirectories(x$2, new FileAttribute[0]));
            return dirs;
        }
        throw new MatchError((Object)option);
    }

    public void compile(Set<VirtualFile> include, DependencyChanges changes, AnalysisCallback callback, ClassFileManager classfileManager) {
        Output output = this.config().currentSetup().output();
        Seq<Path> outputDirs = this.ensureOutput();
        Seq incSrc = (Seq)this.config().sources().filter(include);
        Tuple2 tuple2 = incSrc.partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MixedAnalyzingCompiler$.MODULE$.javaOnly(f)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq javaSrcs = (Seq)tuple2._1();
        Seq scalaSrcs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)javaSrcs, (Object)scalaSrcs);
        Seq javaSrcs2 = (Seq)tuple22._1();
        Seq scalaSrcs2 = (Seq)tuple22._2();
        this.logInputs(this.log(), javaSrcs2.size(), scalaSrcs2.size(), outputDirs);
        boolean pickleJava = Incremental$.MODULE$.isPickleJava((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().currentSetup().options().scalacOptions())).toIndexedSeq());
        if (this.config().incOptions().pipelining()) {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            if (scalaSrcs2.nonEmpty()) {
                this.log().debug((Function0 & Serializable & scala.Serializable)() -> "done compiling Scala sources");
                return;
            }
            return;
        }
        CompileOrder compileOrder = this.config().currentSetup().order();
        CompileOrder compileOrder2 = CompileOrder.JavaThenScala;
        if (!(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null)) {
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
        } else {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
        }
        if (javaSrcs2.size() + scalaSrcs2.size() > 0) {
            if (ConsoleAppender$.MODULE$.showProgress()) {
                this.log().debug((Function0 & Serializable & scala.Serializable)() -> "done compiling");
                return;
            }
            this.log().info((Function0 & Serializable & scala.Serializable)() -> "done compiling");
            return;
        }
    }

    private void putJavacOutputInJar(File outputJar, File outputDir) {
        Seq compiledClasses = (Seq)syntax$.MODULE$.singleFileFinder(outputDir).$times$times(DirectoryFilter$.MODULE$.unary_$minus()).get().flatMap((Function1 & Serializable & scala.Serializable)classFile -> {
            Option option = IO$.MODULE$.relativize(outputDir, classFile);
            if (option instanceof Some) {
                Some some = (Some)option;
                String relPath = (String)some.value();
                return new .colon.colon((Object)new Tuple2(classFile, (Object)relPath), (List)Nil$.MODULE$);
            }
            return Nil$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
        if (compiledClasses.nonEmpty()) {
            JarUtils$.MODULE$.includeInJar(outputJar, compiledClasses);
            this.outputJarContent.addClasses(((TraversableOnce)compiledClasses.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._2(), Seq$.MODULE$.canBuildFrom())).toSet());
        }
        IO$.MODULE$.delete(outputDir);
    }

    private Seq<Path> outputDirectories(Output output) {
        Output output2 = output;
        if (output2 instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output2;
            return new .colon.colon((Object)singleOutput.getOutputDirectoryAsPath(), (List)Nil$.MODULE$);
        }
        if (output2 instanceof MultipleOutput) {
            MultipleOutput multipleOutput = (MultipleOutput)output2;
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])multipleOutput.getOutputGroups())).toIndexedSeq().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getOutputDirectoryAsPath(), IndexedSeq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)output2);
    }

    private <T> T timed(String label, Logger log, Function0<T> t) {
        long start = System.nanoTime();
        Object result = t.apply();
        long elapsed = System.nanoTime() - start;
        log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append(label).append(" took ").append((double)elapsed / 1.0E9).append(" s").toString());
        return (T)result;
    }

    private void logInputs(Logger log, int javaCount, int scalaCount, Seq<Path> outputDirs) {
        Option scalaMsg = Analysis$.MODULE$.counted("Scala source", "", "s", scalaCount);
        Option javaMsg = Analysis$.MODULE$.counted("Java source", "", "s", javaCount);
        Iterable combined = (Iterable)Option$.MODULE$.option2Iterable(scalaMsg).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(javaMsg), Iterable$.MODULE$.canBuildFrom());
        if (combined.nonEmpty()) {
            String targets = ((TraversableOnce)outputDirs.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            log.info((Function0 & Serializable & scala.Serializable)() -> combined.mkString("compiling ", " and ", new StringBuilder(8).append(" to ").append(targets).append(" ...").toString()));
            return;
        }
    }

    private final VirtualFile toVirtualFile$1(Path p) {
        return this.config().converter().toVirtualFile(p.toAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$compileJava$2(MixedAnalyzingCompiler $this, Seq javaSrcs$1, String[] joptions$1, Output output$1, Option outputJarOpt$1, AnalysisCallback callback$1, IncToolOptions incToolOptions$1, Seq extraClasspath) {
        $this.javac().compile((Seq<VirtualFile>)javaSrcs$1, (Seq<VirtualFile>)((Seq)extraClasspath.map((Function1 & Serializable & scala.Serializable)p -> $this.toVirtualFile$1((Path)p), Seq$.MODULE$.canBuildFrom())), $this.config().converter(), (Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joptions$1)).toIndexedSeq(), output$1, (Option<Path>)outputJarOpt$1, callback$1, incToolOptions$1, $this.config().reporter(), (xsbti.Logger)$this.log(), $this.config().progress());
    }

    public static final /* synthetic */ void $anonfun$compile$4(MixedAnalyzingCompiler $this, Seq incSrc$1, Seq scalaSrcs$1, boolean pickleJava$1, DependencyChanges changes$1, String[] scalacOpts$1, Output output$2, AnalysisCallback callback$2, Seq extraClasspath) {
        Vector vector;
        CompileOrder compileOrder = $this.config().currentSetup().order();
        CompileOrder compileOrder2 = CompileOrder.Mixed;
        Seq sources = !(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null) ? incSrc$1 : scalaSrcs$1;
        Vector cp0 = (Vector)((Vector)extraClasspath.toVector().map((Function1 & Serializable & scala.Serializable)x -> $this.config().converter().toVirtualFile(x.toAbsolutePath()), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)$this.absClasspath.toVector(), Vector$.MODULE$.canBuildFrom());
        if (scalaSrcs$1.isEmpty() && pickleJava$1) {
            Vector libraryJars = (Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.scalac().scalaInstance().libraryJars())).toVector().map((Function1 & Serializable & scala.Serializable)x -> $this.config().converter().toVirtualFile(x.toPath()), Vector$.MODULE$.canBuildFrom());
            vector = (Vector)((SeqLike)cp0.$plus$plus((GenTraversableOnce)libraryJars, Vector$.MODULE$.canBuildFrom())).distinct();
        } else {
            vector = cp0;
        }
        Vector cp = vector;
        $this.timed("Scala compilation", $this.log(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.config().compiler().compile((VirtualFile[])sources.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (VirtualFile[])cp.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), $this.config().converter(), changes$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scalacOpts$1)).toArray(ClassTag$.MODULE$.apply(String.class)), output$2, callback$2, $this.config().reporter(), JavaInterfaceUtil$.MODULE$.EnrichOption($this.config().progress()).toOptional(), (xsbti.Logger)$this.log()));
    }

    private final void compileScala$1(Seq scalaSrcs$1, boolean pickleJava$1, AnalysisCallback callback$2, Output output$2, Seq incSrc$1, DependencyChanges changes$1) {
        if (scalaSrcs$1.nonEmpty() || pickleJava$1) {
            String[] stringArray;
            Some some;
            Tuple2 tuple2;
            Option pickleJarPair = JavaInterfaceUtil$.MODULE$.EnrichOptional(callback$2.getPickleJarPair()).toOption().map((Function1 & Serializable & scala.Serializable)t2 -> new Tuple2(t2.get1(), t2.get2()));
            Option option = pickleJarPair;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Path originalJar = (Path)tuple2._1();
                Path updatesJar = (Path)tuple2._2();
                String path = ((Object)originalJar).toString();
                String fwdSlashPath = path.replace('\\', '/');
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().currentSetup().options().scalacOptions())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    String string;
                    block3: {
                        block2: {
                            String string2 = string = x0$1;
                            String string3 = path;
                            if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                            String string4 = string;
                            String string5 = fwdSlashPath;
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
                        }
                        return ((Object)updatesJar).toString();
                    }
                    return string;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            } else {
                stringArray = this.config().currentSetup().options().scalacOptions();
            }
            String[] scalacOpts = stringArray;
            JarUtils$.MODULE$.withPreviousJar(output$2, (Function1 & Serializable & scala.Serializable)extraClasspath -> {
                MixedAnalyzingCompiler.$anonfun$compile$4(this, incSrc$1, scalaSrcs$1, pickleJava$1, changes$1, scalacOpts, output$2, callback$2, extraClasspath);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void compileJava0$1(Seq javaSrcs$2, AnalysisCallback callback$2, ClassFileManager classfileManager$2) {
        this.compileJava((Seq<VirtualFile>)javaSrcs$2, callback$2, classfileManager$2);
    }

    public MixedAnalyzingCompiler(ScalaCompiler scalac, AnalyzingJavaCompiler javac, CompileConfiguration config, Logger log, JarUtils.OutputJarContent outputJarContent) {
        this.scalac = scalac;
        this.javac = javac;
        this.config = config;
        this.log = log;
        this.outputJarContent = outputJarContent;
        this.absClasspath = (Seq)config.classpath().map((Function1 & Serializable & scala.Serializable)x$1 -> VirtualFileUtil$.MODULE$.toAbsolute(x$1), Seq$.MODULE$.canBuildFrom());
    }
}

