/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.Serializable;
import java.util.Optional;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.ExternalLookup;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.Lookup;
import sbt.internal.inc.MixedAnalyzingCompiler$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.api.AnalyzedClass;
import xsbti.compile.Changes;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.ExternalHooks;
import xsbti.compile.FileHash;
import xsbti.compile.MiniSetup;

public class LookupImpl
implements ExternalLookup,
Lookup {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(LookupImpl.class.getDeclaredField("externalLookup$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(LookupImpl.class.getDeclaredField("previousClasspathHash$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LookupImpl.class.getDeclaredField("analyses$lzy1"));
    private final CompileConfiguration compileConfiguration;
    private final Option<MiniSetup> previousSetup;
    private Vector<VirtualFile> classpath;
    private final Vector<FileHash> classpathHash;
    private volatile Object analyses$lzy1;
    private volatile Object previousClasspathHash$lzy1;
    private final Function1<String, Option<VirtualFile>> entry;
    private volatile Object externalLookup$lzy1;

    public LookupImpl(CompileConfiguration compileConfiguration, Option<MiniSetup> previousSetup) {
        this.compileConfiguration = compileConfiguration;
        this.previousSetup = previousSetup;
        this.classpath = compileConfiguration.classpath().toVector();
        this.classpathHash = Predef$.MODULE$.wrapRefArray((Object[])compileConfiguration.currentSetup().options().classpathHash()).toVector();
        this.entry = MixedAnalyzingCompiler$.MODULE$.classPathLookup(compileConfiguration);
    }

    public Vector<Analysis> analyses() {
        Object object = this.analyses$lzy1;
        if (object instanceof Vector) {
            return (Vector)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Vector)this.analyses$lzyINIT1();
    }

    private Object analyses$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.analyses$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Vector vector = null;
                    try {
                        vector = (Vector)this.classpath.flatMap((Function1 & Serializable)entry -> JavaInterfaceUtil$.MODULE$.EnrichOptional(this.compileConfiguration.perClasspathEntryLookup().analysis(entry)).toOption().map((Function1 & Serializable)x$1 -> {
                            CompileAnalysis compileAnalysis = x$1;
                            if (compileAnalysis instanceof Analysis) {
                                Analysis a = (Analysis)compileAnalysis;
                                return a;
                            }
                            throw new MatchError((Object)compileAnalysis);
                        }));
                        object2 = vector == null ? LazyVals.NullValue$.MODULE$ : vector;
                        this.classpath = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.analyses$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return vector;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Vector<FileHash> previousClasspathHash() {
        Object object = this.previousClasspathHash$lzy1;
        if (object instanceof Vector) {
            return (Vector)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Vector)this.previousClasspathHash$lzyINIT1();
    }

    private Object previousClasspathHash$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.previousClasspathHash$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Vector vector = null;
                    try {
                        Vector vector2;
                        Option<MiniSetup> option = this.previousSetup;
                        if (option instanceof Some) {
                            MiniSetup x = (MiniSetup)((Some)option).value();
                            vector2 = Predef$.MODULE$.wrapRefArray((Object[])x.options().classpathHash()).toVector();
                        } else {
                            vector2 = vector = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
                        }
                        object2 = vector == null ? LazyVals.NullValue$.MODULE$ : vector;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.previousClasspathHash$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.previousClasspathHash$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return vector;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<Vector<FileHash>> changedClasspathHash() {
        Vector<FileHash> vector = this.classpathHash;
        Vector<FileHash> vector2 = this.previousClasspathHash();
        if (!(vector != null ? !vector.equals(vector2) : vector2 != null)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.classpathHash);
    }

    public Option<CompileAnalysis> lookupAnalysis(String binaryClassName) {
        return this.analyses().find((Function1 & Serializable)_$1 -> _$1.relations().productClassName()._2s().contains((Object)binaryClassName));
    }

    public Option<VirtualFileRef> lookupOnClasspath(String binaryClassName) {
        return ((Option)this.entry.apply((Object)binaryClassName)).map((Function1 & Serializable)_$2 -> this.compileConfiguration.converter().toVirtualFile((VirtualFileRef)_$2));
    }

    public Option<ExternalLookup> externalLookup() {
        Object object = this.externalLookup$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.externalLookup$lzyINIT1();
    }

    private Object externalLookup$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.externalLookup$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = Option$.MODULE$.apply((Object)this.compileConfiguration.incOptions().externalHooks()).flatMap((Function1 & Serializable)ext -> JavaInterfaceUtil$.MODULE$.EnrichOptional(ext.getExternalLookup()).toOption()).collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(ExternalHooks.Lookup x) {
                                ExternalHooks.Lookup lookup = x;
                                if (lookup instanceof ExternalLookup) {
                                    ExternalLookup externalLookup = (ExternalLookup)lookup;
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(ExternalHooks.Lookup x, Function1 function1) {
                                ExternalHooks.Lookup lookup = x;
                                if (lookup instanceof ExternalLookup) {
                                    ExternalLookup externalLookup = (ExternalLookup)lookup;
                                    return externalLookup;
                                }
                                return function1.apply((Object)x);
                            }
                        });
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.externalLookup$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<AnalyzedClass> lookupAnalyzedClass(String binaryClassName, Option<VirtualFileRef> file) {
        Option<ExternalLookup> option = this.externalLookup();
        if (option instanceof Some) {
            AnalyzedClass api;
            ExternalLookup externalLookup = (ExternalLookup)((Some)option).value();
            Option option2 = externalLookup.lookupAnalyzedClass(binaryClassName, file);
            if (option2 instanceof Some && (api = (AnalyzedClass)((Some)option2).value()).provenance().isEmpty()) {
                return Lookup.lookupAnalyzedClass$((Lookup)this, (String)binaryClassName, file);
            }
            Option x = option2;
            return x;
        }
        return Lookup.lookupAnalyzedClass$((Lookup)this, (String)binaryClassName, file);
    }

    public Option<Changes<VirtualFileRef>> changedSources(CompileAnalysis previousAnalysis) {
        return this.externalLookup().flatMap((Function1 & Serializable)_$3 -> _$3.changedSources(previousAnalysis));
    }

    public Option<Set<VirtualFileRef>> changedBinaries(CompileAnalysis previousAnalysis) {
        return this.externalLookup().flatMap((Function1 & Serializable)_$4 -> _$4.changedBinaries(previousAnalysis));
    }

    public Option<Set<VirtualFileRef>> removedProducts(CompileAnalysis previousAnalysis) {
        return this.externalLookup().flatMap((Function1 & Serializable)_$5 -> _$5.removedProducts(previousAnalysis));
    }

    public boolean shouldDoIncrementalCompilation(Set<String> changedClasses, CompileAnalysis analysis) {
        return this.externalLookup().forall((Function1 & Serializable)_$6 -> _$6.shouldDoIncrementalCompilation(changedClasses, analysis));
    }

    public boolean shouldDoEarlyOutput(CompileAnalysis analysis) {
        Option<ExternalLookup> option = this.externalLookup();
        if (option instanceof Some) {
            ExternalLookup externalLookup = (ExternalLookup)((Some)option).value();
            return externalLookup.shouldDoEarlyOutput(analysis);
        }
        if (None$.MODULE$.equals(option)) {
            return ExternalLookup.shouldDoEarlyOutput$((ExternalLookup)this, (CompileAnalysis)analysis);
        }
        throw new MatchError(option);
    }

    public Optional<FileHash[]> hashClasspath(VirtualFile[] classpath) {
        return (Optional)this.externalLookup().map((Function1 & Serializable)_$7 -> _$7.hashClasspath(classpath)).getOrElse(LookupImpl::hashClasspath$$anonfun$2);
    }

    private static final Optional hashClasspath$$anonfun$2() {
        return Optional.empty();
    }
}

