/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.Incremental$;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.MixedAnalyzingCompiler$;
import sbt.internal.inc.VirtualFileUtil$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.internal.util.ConsoleAppender$;
import sbt.io.DirectoryFilter$;
import sbt.io.IO$;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import xsbti.AnalysisCallback;
import xsbti.FileConverter;
import xsbti.Reporter;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileProgress;
import xsbti.compile.DependencyChanges;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.IncToolOptions;
import xsbti.compile.JavaCompiler;
import xsbti.compile.MiniSetup;
import xsbti.compile.MultipleOutput;
import xsbti.compile.Output;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.SingleOutput;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.ReadWriteMappers;

public final class MixedAnalyzingCompiler {
    private final ScalaCompiler scalac;
    private final AnalyzingJavaCompiler javac;
    private final CompileConfiguration config;
    private final Logger log;
    private final JarUtils.OutputJarContent outputJarContent;
    private final Seq<VirtualFile> absClasspath;

    public static MixedAnalyzingCompiler apply(CompileConfiguration compileConfiguration, Logger logger) {
        return MixedAnalyzingCompiler$.MODULE$.apply(compileConfiguration, logger);
    }

    public static Function1<String, Option<VirtualFile>> classPathLookup(CompileConfiguration compileConfiguration) {
        return MixedAnalyzingCompiler$.MODULE$.classPathLookup(compileConfiguration);
    }

    public static boolean javaOnly(VirtualFileRef virtualFileRef) {
        return MixedAnalyzingCompiler$.MODULE$.javaOnly(virtualFileRef);
    }

    public static CompileConfiguration makeConfig(ScalaCompiler scalaCompiler, JavaCompiler javaCompiler, Seq<VirtualFile> seq, FileConverter fileConverter, Seq<VirtualFile> seq2, GlobalsCache globalsCache, Option<CompileProgress> option, Seq<String> seq3, Seq<String> seq4, CompileAnalysis compileAnalysis, Option<MiniSetup> option2, PerClasspathEntryLookup perClasspathEntryLookup, Reporter reporter, CompileOrder compileOrder, boolean bl, IncOptions incOptions, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> option3, Option<AnalysisStore> option4, ReadStamps readStamps, List<Tuple2<String, String>> list) {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig(scalaCompiler, javaCompiler, seq, fileConverter, seq2, globalsCache, option, seq3, seq4, compileAnalysis, option2, perClasspathEntryLookup, reporter, compileOrder, bl, incOptions, output, outputJarContent, option3, option4, readStamps, list);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(CompileConfiguration compileConfiguration) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(compileConfiguration);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(FileConverter fileConverter, Seq<VirtualFile> seq, String[] stringArray, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler scalaCompiler) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(fileConverter, seq, stringArray, perClasspathEntryLookup, scalaCompiler);
    }

    public static AnalysisStore staticCachedStore(Path path, boolean bl) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(path, bl);
    }

    public static AnalysisStore staticCachedStore(Path path, boolean bl, boolean bl2, ReadWriteMappers readWriteMappers, boolean bl3, int n) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(path, bl, bl2, readWriteMappers, bl3, n);
    }

    public static Seq<VirtualFile> withBootclasspath(CompilerArguments compilerArguments, Seq<VirtualFile> seq, FileConverter fileConverter) {
        return MixedAnalyzingCompiler$.MODULE$.withBootclasspath(compilerArguments, seq, fileConverter);
    }

    public static Option<CompileProgress> makeConfig$default$7() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$7();
    }

    public static Seq<String> makeConfig$default$8() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$8();
    }

    public static Seq<String> makeConfig$default$9() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$9();
    }

    public static CompileOrder makeConfig$default$14() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$14();
    }

    public static boolean makeConfig$default$15() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$15();
    }

    public MixedAnalyzingCompiler(ScalaCompiler scalac, AnalyzingJavaCompiler javac, CompileConfiguration config, Logger log, JarUtils.OutputJarContent outputJarContent) {
        this.scalac = scalac;
        this.javac = javac;
        this.config = config;
        this.log = log;
        this.outputJarContent = outputJarContent;
        this.absClasspath = (Seq)config.classpath().map((Function1 & Serializable)_$1 -> VirtualFileUtil$.MODULE$.toAbsolute(_$1));
    }

    public ScalaCompiler scalac() {
        return this.scalac;
    }

    public AnalyzingJavaCompiler javac() {
        return this.javac;
    }

    public CompileConfiguration config() {
        return this.config;
    }

    public Logger log() {
        return this.log;
    }

    public void compileJava(Seq<VirtualFile> javaSrcs, AnalysisCallback callback, ClassFileManager classfileManager) {
        this.ensureOutput();
        if (javaSrcs.nonEmpty()) {
            this.timed("Java compilation + analysis", this.log(), (Function0 & Serializable)() -> {
                this.compileJava$$anonfun$1(classfileManager, javaSrcs, callback);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Seq<Path> ensureOutput() {
        Output output = this.config().currentSetup().output();
        Option option = JarUtils$.MODULE$.getOutputJar(output);
        if (option instanceof Some) {
            Path jar = (Path)((Some)option).value();
            Files.createDirectories(jar.getParent(), new FileAttribute[0]);
            return (Seq)((SeqOps)new .colon.colon((Object)jar, (List)Nil$.MODULE$));
        }
        if (None$.MODULE$.equals(option)) {
            Seq<Path> dirs = this.outputDirectories(output);
            dirs.foreach((Function1 & Serializable)_$2 -> Files.createDirectories(_$2, new FileAttribute[0]));
            return dirs;
        }
        throw new MatchError((Object)option);
    }

    public void compile(Set<VirtualFile> include, DependencyChanges changes, AnalysisCallback callback, ClassFileManager classfileManager) {
        Output output = this.config().currentSetup().output();
        Seq<Path> outputDirs = this.ensureOutput();
        Seq incSrc = (Seq)this.config().sources().filter(include);
        Tuple2 tuple2 = incSrc.partition((Function1 & Serializable)f -> MixedAnalyzingCompiler$.MODULE$.javaOnly((VirtualFileRef)f));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq javaSrcs = (Seq)tuple2._1();
        Seq scalaSrcs = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)javaSrcs, (Object)scalaSrcs);
        Seq javaSrcs2 = (Seq)tuple22._1();
        Seq scalaSrcs2 = (Seq)tuple22._2();
        this.logInputs(this.log(), javaSrcs2.size(), scalaSrcs2.size(), outputDirs);
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.config().currentSetup().options().scalacOptions());
        boolean pickleJava = Incremental$.MODULE$.isPickleJava((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object));
        if (this.config().incOptions().pipelining()) {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            if (scalaSrcs2.nonEmpty()) {
                this.log().debug(MixedAnalyzingCompiler::compile$$anonfun$1);
                return;
            }
            return;
        }
        CompileOrder compileOrder = this.config().currentSetup().order();
        CompileOrder compileOrder2 = CompileOrder.JavaThenScala;
        if (!(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null)) {
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
        } else {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
        }
        if (javaSrcs2.size() + scalaSrcs2.size() > 0) {
            if (ConsoleAppender$.MODULE$.showProgress()) {
                this.log().debug(MixedAnalyzingCompiler::compile$$anonfun$2);
                return;
            }
            this.log().info(MixedAnalyzingCompiler::compile$$anonfun$3);
            return;
        }
    }

    private void putJavacOutputInJar(File outputJar, File outputDir) {
        Seq compiledClasses = (Seq)syntax$.MODULE$.singleFileFinder(outputDir).$times$times(DirectoryFilter$.MODULE$.unary_$minus()).get().flatMap((Function1 & Serializable)classFile -> {
            Option option = IO$.MODULE$.relativize(outputDir, classFile);
            if (option instanceof Some) {
                String relPath = (String)((Some)option).value();
                return (List)new .colon.colon((Object)Tuple2$.MODULE$.apply(classFile, (Object)relPath), (List)Nil$.MODULE$);
            }
            return package$.MODULE$.Nil();
        });
        if (compiledClasses.nonEmpty()) {
            JarUtils$.MODULE$.includeInJar(outputJar, compiledClasses);
            this.outputJarContent.addClasses(((IterableOnceOps)compiledClasses.map((Function1 & Serializable)_$3 -> (String)_$3._2())).toSet());
        }
        IO$.MODULE$.delete(outputDir);
    }

    private Seq<Path> outputDirectories(Output output) {
        Output output2 = output;
        if (output2 instanceof SingleOutput) {
            SingleOutput single = (SingleOutput)output2;
            return (Seq)new .colon.colon((Object)single.getOutputDirectoryAsPath(), (List)Nil$.MODULE$);
        }
        if (output2 instanceof MultipleOutput) {
            MultipleOutput mult = (MultipleOutput)output2;
            Object object = Predef$.MODULE$.refArrayOps((Object[])mult.getOutputGroups());
            return (Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object).map((Function1 & Serializable)_$4 -> _$4.getOutputDirectoryAsPath());
        }
        throw new MatchError((Object)output2);
    }

    private <T> T timed(String label, Logger log, Function0<T> t) {
        long start = System.nanoTime();
        Object result = t.apply();
        long elapsed = System.nanoTime() - start;
        log.debug(() -> MixedAnalyzingCompiler.timed$$anonfun$1(label, elapsed));
        return (T)result;
    }

    private void logInputs(Logger log, int javaCount, int scalaCount, Seq<Path> outputDirs) {
        Option scalaMsg = Analysis$.MODULE$.counted("Scala source", "", "s", scalaCount);
        Option javaMsg = Analysis$.MODULE$.counted("Java source", "", "s", javaCount);
        Iterable combined = (Iterable)Option$.MODULE$.option2Iterable(scalaMsg).$plus$plus((IterableOnce)javaMsg);
        if (combined.nonEmpty()) {
            String targets = ((IterableOnceOps)outputDirs.map((Function1 & Serializable)_$5 -> _$5.toAbsolutePath())).mkString(",");
            log.info(() -> MixedAnalyzingCompiler.logInputs$$anonfun$1(combined, targets));
            return;
        }
    }

    private final VirtualFile toVirtualFile$1(Path p) {
        return this.config().converter().toVirtualFile(p.toAbsolutePath());
    }

    private final /* synthetic */ void compileJava$$anonfun$1$$anonfun$1(Seq javaSrcs$2, String[] joptions$1, Output output$1, Option outputJarOpt$1, AnalysisCallback callback$2, IncToolOptions incToolOptions$1, Seq extraClasspath) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])joptions$1);
        this.javac().compile((Seq<VirtualFile>)javaSrcs$2, (Seq<VirtualFile>)((Seq)extraClasspath.map((Function1 & Serializable)p -> this.toVirtualFile$1((Path)p))), this.config().converter(), (Seq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension(object), output$1, (Option<Path>)outputJarOpt$1, callback$2, incToolOptions$1, this.config().reporter(), (xsbti.Logger)this.log(), this.config().progress());
    }

    private final void compileJava$$anonfun$1(ClassFileManager classfileManager$1, Seq javaSrcs$1, AnalysisCallback callback$1) {
        Output output = this.config().currentSetup().output();
        IncToolOptions incToolOptions = IncToolOptions.of(Optional.of(classfileManager$1), (boolean)this.config().incOptions().useCustomizedFileManager());
        Object[] joptions = this.config().currentSetup().options().javacOptions();
        Option outputJarOpt = JarUtils$.MODULE$.getOutputJar(output);
        Option option = outputJarOpt;
        if (option instanceof Some) {
            Path outputJar = (Path)((Some)option).value();
            if (!this.javac().supportsDirectToJar()) {
                Path outputDir = JarUtils$.MODULE$.javacTempOutput(outputJar);
                Files.createDirectories(outputDir, new FileAttribute[0]);
                Object object = Predef$.MODULE$.refArrayOps(joptions);
                this.javac().compile((Seq<VirtualFile>)javaSrcs$1, (Seq<VirtualFile>)((Seq)((SeqOps)new .colon.colon((Object)this.toVirtualFile$1(outputJar), (List)Nil$.MODULE$))), this.config().converter(), (Seq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension(object), CompileOutput$.MODULE$.apply(outputDir), (Option<Path>)outputJarOpt, callback$1, incToolOptions, this.config().reporter(), (xsbti.Logger)this.log(), this.config().progress());
                this.putJavacOutputInJar(outputJar.toFile(), outputDir.toFile());
                return;
            }
        }
        JarUtils$.MODULE$.withPreviousJar(output, (Function1)((JProcedure1 & Serializable)arg_0 -> this.compileJava$$anonfun$1$$anonfun$1(javaSrcs$1, (String[])joptions, output, outputJarOpt, callback$1, incToolOptions, arg_0)));
    }

    private final void compileScala$1$$anonfun$1$$anonfun$1(Seq sources$1, Vector cp$1, DependencyChanges changes$3, String[] scalacOpts$2, Output output$4, AnalysisCallback callback$5) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])scalacOpts$2);
        this.config().compiler().compile((VirtualFile[])sources$1.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (VirtualFile[])cp$1.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), this.config().converter(), changes$3, (String[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(String.class)), output$4, callback$5, this.config().reporter(), JavaInterfaceUtil$.MODULE$.EnrichOption(this.config().progress()).toOptional(), (xsbti.Logger)this.log());
    }

    private final void compileScala$1(Seq scalaSrcs$1, boolean pickleJava$1, AnalysisCallback callback$3, Output output$2, Seq incSrc$1, DependencyChanges changes$1) {
        if (scalaSrcs$1.nonEmpty() || pickleJava$1) {
            String[] stringArray;
            Tuple2 tuple2;
            Option pickleJarPair = JavaInterfaceUtil$.MODULE$.EnrichOptional(callback$3.getPickleJarPair()).toOption().map((Function1 & Serializable)t2 -> Tuple2$.MODULE$.apply(t2.get1(), t2.get2()));
            Option option = pickleJarPair;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Path originalJar = (Path)tuple2._1();
                Path updatesJar = (Path)tuple2._2();
                String path = originalJar.toString();
                String fwdSlashPath = path.replace('\\', '/');
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.config().currentSetup().options().scalacOptions());
                stringArray = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                    String string;
                    block3: {
                        block2: {
                            String s;
                            String string2 = s = (string = x$1);
                            String string3 = path;
                            if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                            String string4 = s;
                            String string5 = fwdSlashPath;
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
                        }
                        return updatesJar.toString();
                    }
                    String s = string;
                    return s;
                }, ClassTag$.MODULE$.apply(String.class));
            } else {
                stringArray = this.config().currentSetup().options().scalacOptions();
            }
            String[] scalacOpts = stringArray;
            JarUtils$.MODULE$.withPreviousJar(output$2, (Function1)(JProcedure1 & Serializable)extraClasspath -> {
                Vector vector;
                CompileOrder compileOrder = this.config().currentSetup().order();
                CompileOrder compileOrder2 = CompileOrder.Mixed;
                Seq sources = !(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null) ? incSrc$1 : scalaSrcs$1;
                Vector cp0 = (Vector)((IterableOps)extraClasspath.toVector().map((Function1 & Serializable)x -> this.config().converter().toVirtualFile(x.toAbsolutePath()))).$plus$plus((IterableOnce)this.absClasspath.toVector());
                if (scalaSrcs$1.isEmpty() && pickleJava$1) {
                    Vector libraryJars = (Vector)Predef$.MODULE$.wrapRefArray((Object[])this.scalac().scalaInstance().libraryJars()).toVector().map((Function1 & Serializable)x -> this.config().converter().toVirtualFile(x.toPath()));
                    vector = (Vector)((SeqOps)cp0.$plus$plus((IterableOnce)libraryJars)).distinct();
                } else {
                    vector = cp0;
                }
                Vector cp = vector;
                this.timed("Scala compilation", this.log(), (Function0 & Serializable)() -> {
                    this.compileScala$1$$anonfun$1$$anonfun$1(sources, cp, changes$1, scalacOpts, output$2, callback$3);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    private final void compileJava0$1(Seq javaSrcs$3, AnalysisCallback callback$6, ClassFileManager classfileManager$2) {
        this.compileJava((Seq<VirtualFile>)javaSrcs$3, callback$6, classfileManager$2);
    }

    private static final String compile$$anonfun$1() {
        return "done compiling Scala sources";
    }

    private static final String compile$$anonfun$2() {
        return "done compiling";
    }

    private static final String compile$$anonfun$3() {
        return "done compiling";
    }

    private static final String timed$$anonfun$1(String label$1, long elapsed$1) {
        return new StringBuilder(8).append(label$1).append(" took ").append((double)elapsed$1 / 1.0E9).append(" s").toString();
    }

    private static final String logInputs$$anonfun$1(Iterable combined$1, String targets$1) {
        return combined$1.mkString("compiling ", " and ", new StringBuilder(8).append(" to ").append(targets$1).append(" ...").toString());
    }
}

