/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.Optional;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.CompilerArguments$;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.Locate$;
import sbt.internal.inc.MixedAnalyzingCompiler;
import sbt.internal.inc.PlainVirtualFile$;
import sbt.internal.inc.VirtualFileUtil$;
import sbt.internal.inc.caching.ClasspathCache$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.io.IO$;
import sbt.util.InterfaceUtil$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import xsbti.FileConverter;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileProgress;
import xsbti.compile.ExternalHooks;
import xsbti.compile.FileHash;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.JavaCompiler;
import xsbti.compile.MiniOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.analysis.ReadStamps;

public final class MixedAnalyzingCompiler$
implements Serializable {
    private static final HashMap<Path, Reference<AnalysisStore>> cache;
    public static final MixedAnalyzingCompiler$ MODULE$;

    private MixedAnalyzingCompiler$() {
    }

    static {
        MODULE$ = new MixedAnalyzingCompiler$();
        cache = new HashMap();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MixedAnalyzingCompiler$.class);
    }

    public boolean javaOnly(VirtualFileRef f) {
        return f.id().endsWith(".java");
    }

    public CompileConfiguration makeConfig(ScalaCompiler scalac, JavaCompiler javac, Seq<VirtualFile> sources, FileConverter converter, Seq<VirtualFile> classpath, GlobalsCache cache, Option<CompileProgress> progress, Seq<String> options, Seq<String> javacOptions, CompileAnalysis previousAnalysis, Option<MiniSetup> previousSetup, PerClasspathEntryLookup perClasspathEntryLookup, Reporter reporter, CompileOrder compileOrder, boolean skip, IncOptions incrementalCompilerOptions, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<AnalysisStore> earlyAnalysisStore, ReadStamps stamper, List<Tuple2<String, String>> extra) {
        Optional computed;
        Optional lookup = incrementalCompilerOptions.externalHooks().getExternalLookup();
        FileHash[] classpathHash = lookup.isPresent() ? ((computed = ((ExternalHooks.Lookup)lookup.get()).hashClasspath((VirtualFile[])classpath.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)))).isPresent() ? (FileHash[])computed.get() : this.doHash$1(converter, classpath)) : this.doHash$1(converter, classpath);
        MiniSetup compileSetup = MiniSetup.of((Output)output, (MiniOptions)MiniOptions.of((FileHash[])classpathHash, (String[])((String[])options.toArray(ClassTag$.MODULE$.apply(String.class))), (String[])((String[])javacOptions.toArray(ClassTag$.MODULE$.apply(String.class)))), (String)scalac.scalaInstance().actualVersion(), (CompileOrder)compileOrder, (boolean)incrementalCompilerOptions.storeApis(), (T2[])((T2[])extra.map((Function1 & Serializable)x -> InterfaceUtil$.MODULE$.t2(x)).toArray(ClassTag$.MODULE$.apply(T2.class))));
        return this.config(sources, converter, classpath, compileSetup, progress, previousAnalysis, previousSetup, perClasspathEntryLookup, scalac, javac, reporter, skip, cache, incrementalCompilerOptions, outputJarContent, earlyOutput, earlyAnalysisStore, stamper);
    }

    public Option<CompileProgress> makeConfig$default$7() {
        return None$.MODULE$;
    }

    public Seq<String> makeConfig$default$8() {
        return package$.MODULE$.Nil();
    }

    public Seq<String> makeConfig$default$9() {
        return package$.MODULE$.Nil();
    }

    public CompileOrder makeConfig$default$14() {
        return CompileOrder.Mixed;
    }

    public boolean makeConfig$default$15() {
        return false;
    }

    public CompileConfiguration config(Seq<VirtualFile> sources, FileConverter converter, Seq<VirtualFile> classpath, MiniSetup setup, Option<CompileProgress> progress, CompileAnalysis previousAnalysis, Option<MiniSetup> previousSetup, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler compiler, JavaCompiler javac, Reporter reporter, boolean skip, GlobalsCache cache, IncOptions incrementalCompilerOptions, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<AnalysisStore> earlyAnalysisStore, ReadStamps stamper) {
        return new CompileConfiguration(sources, converter, classpath, previousAnalysis, previousSetup, setup, progress, perClasspathEntryLookup, reporter, compiler, javac, cache, incrementalCompilerOptions, outputJarContent, earlyOutput, earlyAnalysisStore, stamper);
    }

    public Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(CompileConfiguration config) {
        return this.searchClasspathAndLookup(config.converter(), config.classpath(), config.currentSetup().options().scalacOptions(), config.perClasspathEntryLookup(), config.compiler());
    }

    public Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(FileConverter converter, Seq<VirtualFile> classpath, String[] scalacOptions, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler compiler) {
        Seq absClasspath = (Seq)classpath.map((Function1 & Serializable)_$5 -> VirtualFileUtil$.MODULE$.toAbsolute(_$5));
        CompilerArguments cArgs = new CompilerArguments(compiler.scalaInstance(), compiler.classpathOptions());
        Seq searchClasspath = (Seq)this.explicitBootClasspath((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)scalacOptions), converter).$plus$plus(this.withBootclasspath(cArgs, (Seq<VirtualFile>)absClasspath, converter));
        return Tuple2$.MODULE$.apply((Object)searchClasspath, (Object)Locate$.MODULE$.entry(searchClasspath, perClasspathEntryLookup));
    }

    public Function1<String, Option<VirtualFile>> classPathLookup(CompileConfiguration config) {
        return (Function1)this.searchClasspathAndLookup(config)._2();
    }

    public MixedAnalyzingCompiler apply(CompileConfiguration config, Logger log) {
        Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> tuple2 = this.searchClasspathAndLookup(config);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq searchClasspath = (Seq)tuple2._1();
        Function1 entry = (Function1)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)searchClasspath, (Object)entry);
        Seq searchClasspath2 = (Seq)tuple22._1();
        Function1 entry2 = (Function1)tuple22._2();
        return new MixedAnalyzingCompiler(config.compiler(), new AnalyzingJavaCompiler(config.javac(), config.classpath(), config.compiler().scalaInstance(), config.compiler().classpathOptions(), (Function1<String, Option<VirtualFile>>)entry2, (Seq<VirtualFile>)searchClasspath2), config, log, config.outputJarContent());
    }

    public Seq<VirtualFile> withBootclasspath(CompilerArguments args, Seq<VirtualFile> classpath, FileConverter converter) {
        Seq cp = (Seq)classpath.map((Function1 & Serializable)x$0 -> converter.toPath(x$0));
        return (Seq)((IterableOps)((IterableOps)args.bootClasspathFor(cp).map((Function1 & Serializable)_$6 -> converter.toVirtualFile(_$6))).$plus$plus((IterableOnce)args.extClasspath().map((Function1 & Serializable)_$7 -> PlainVirtualFile$.MODULE$.apply(_$7)))).$plus$plus((IterableOnce)args.finishClasspath(cp).map((Function1 & Serializable)_$8 -> converter.toVirtualFile(_$8)));
    }

    private Seq<VirtualFile> explicitBootClasspath(Seq<String> options, FileConverter converter) {
        return ((IterableOps)((IterableOps)options.dropWhile((Function1 & Serializable)_$9 -> {
            String string = _$9;
            String string2 = CompilerArguments$.MODULE$.BootClasspathOption();
            return string == null ? string2 != null : !string.equals(string2);
        })).slice(1, 2)).headOption().toList().flatMap((Function1 & Serializable)s -> IO$.MODULE$.parseClasspath(s)).map((Function1 & Serializable)_$10 -> _$10.toPath()).map((Function1 & Serializable)_$11 -> converter.toVirtualFile(_$11));
    }

    private AnalysisStore staticCache(Path file, Function0<AnalysisStore> backing) {
        AnalysisStore analysisStore;
        MixedAnalyzingCompiler$ mixedAnalyzingCompiler$ = this;
        synchronized (mixedAnalyzingCompiler$) {
            analysisStore = (AnalysisStore)cache.get((Object)file).flatMap((Function1 & Serializable)ref -> Option$.MODULE$.apply(ref.get())).getOrElse(() -> this.staticCache$$anonfun$2(file, backing));
        }
        return analysisStore;
    }

    public AnalysisStore staticCachedStore(Path analysisFile, boolean useTextAnalysis) {
        AnalysisStore fileStore = useTextAnalysis ? FileAnalysisStore$.MODULE$.text(analysisFile.toFile()) : FileAnalysisStore$.MODULE$.binary(analysisFile.toFile());
        AnalysisStore cachedStore = AnalysisStore.getCachedStore((AnalysisStore)fileStore);
        return this.staticCache(analysisFile, (Function0<AnalysisStore>)((Function0 & Serializable)() -> this.staticCachedStore$$anonfun$1(cachedStore)));
    }

    private final FileHash[] doHash$1(FileConverter converter$1, Seq classpath$1) {
        return ClasspathCache$.MODULE$.hashClasspath((Seq<Path>)((Seq)classpath$1.map((Function1 & Serializable)x$0 -> converter$1.toPath(x$0))));
    }

    private final AnalysisStore staticCache$$anonfun$2(Path file$1, Function0 backing$1) {
        AnalysisStore b = (AnalysisStore)backing$1.apply();
        cache.put((Object)file$1, new SoftReference<AnalysisStore>(b));
        return b;
    }

    private final AnalysisStore staticCachedStore$$anonfun$1(AnalysisStore cachedStore$1) {
        return AnalysisStore.getThreadSafeStore((AnalysisStore)cachedStore$1);
    }
}

