/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.javac;

import java.io.Serializable;
import java.net.URLClassLoader;
import java.nio.file.Path;
import sbt.internal.inc.ClassToAPI$;
import sbt.internal.inc.CompileFailed;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.VirtualFileUtil$;
import sbt.internal.inc.classfile.JavaAnalyze$;
import sbt.internal.inc.classpath.ClasspathUtil$;
import sbt.internal.inc.javac.ClassFinder;
import sbt.internal.inc.javac.Classes;
import sbt.internal.inc.javac.DirectoryClassFinder;
import sbt.internal.inc.javac.JarClassFinder;
import sbt.internal.inc.javac.JavaCompiler$;
import sbt.util.InterfaceUtil$;
import sbt.util.Logger;
import sbt.util.Logger$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import xsbti.AnalysisCallback;
import xsbti.FileConverter;
import xsbti.Reporter;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.CompileProgress;
import xsbti.compile.IncToolOptions;
import xsbti.compile.JavaCompiler;
import xsbti.compile.MultipleOutput;
import xsbti.compile.Output;
import xsbti.compile.OutputGroup;
import xsbti.compile.ScalaInstance;
import xsbti.compile.SingleOutput;

public final class AnalyzingJavaCompiler
implements JavaCompiler {
    private final JavaCompiler javac;
    private final Seq classpath;
    private final ScalaInstance scalaInstance;
    private final ClasspathOptions classpathOptions;
    private final Function1 classLookup;
    private final Seq searchClasspath;

    public AnalyzingJavaCompiler(JavaCompiler javac, Seq<VirtualFile> classpath, ScalaInstance scalaInstance, ClasspathOptions classpathOptions, Function1<String, Option<VirtualFile>> classLookup, Seq<VirtualFile> searchClasspath) {
        this.javac = javac;
        this.classpath = classpath;
        this.scalaInstance = scalaInstance;
        this.classpathOptions = classpathOptions;
        this.classLookup = classLookup;
        this.searchClasspath = searchClasspath;
    }

    public JavaCompiler javac() {
        return this.javac;
    }

    public Seq<VirtualFile> classpath() {
        return this.classpath;
    }

    public ScalaInstance scalaInstance() {
        return this.scalaInstance;
    }

    public ClasspathOptions classpathOptions() {
        return this.classpathOptions;
    }

    public Function1<String, Option<VirtualFile>> classLookup() {
        return this.classLookup;
    }

    public Seq<VirtualFile> searchClasspath() {
        return this.searchClasspath;
    }

    public boolean supportsDirectToJar() {
        return this.javac().supportsDirectToJar();
    }

    public void compile(Seq<VirtualFile> sources, Seq<VirtualFile> extraClasspath, FileConverter converter, Seq<String> options, Output output, Option<Path> finalJarOutput, AnalysisCallback callback, IncToolOptions incToolOptions, Reporter reporter, xsbti.Logger log, Option<CompileProgress> progressOpt) {
        Map sourceDirs = (Map)Map$.MODULE$.empty();
        if (sources.nonEmpty()) {
            scala.collection.immutable.Map map;
            Seq absClasspath = (Seq)((IterableOps)extraClasspath.$plus$plus(this.classpath())).map((Function1 & Serializable)vf -> VirtualFileUtil$.MODULE$.toAbsolute(vf));
            Output output2 = output;
            if (output2 instanceof SingleOutput) {
                SingleOutput single = (SingleOutput)output2;
                Object[] objectArray = new Tuple2[1];
                Option option = (Option)Predef$.MODULE$.ArrowAssoc((Object)Option$.MODULE$.apply((Object)single.getOutputDirectoryAsPath()));
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option, sources);
                map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            } else if (output2 instanceof MultipleOutput) {
                MultipleOutput multi = (MultipleOutput)output2;
                map = sources.groupBy((Function1 & Serializable)src -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])multi.getOutputGroups());
                    return ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)out -> {
                        VirtualFileRef sourceDir = (VirtualFileRef)sourceDirs.getOrElseUpdate((Object)out.getSourceDirectoryAsPath(), () -> AnalyzingJavaCompiler.$anonfun$3(converter, out));
                        return src.id().startsWith(sourceDir.id());
                    }).map((Function1 & Serializable)_$1 -> _$1.getOutputDirectoryAsPath());
                });
            } else {
                throw new MatchError((Object)output2);
            }
            scala.collection.immutable.Map chunks = map;
            chunks.get((Object)None$.MODULE$).foreach((Function1)(JProcedure1 & Serializable)srcs -> {
                String culpritPaths = ((IterableOnceOps)srcs.map((Function1 & Serializable)_$2 -> _$2.id())).mkString(", ");
                log.error(InterfaceUtil$.MODULE$.toSupplier(() -> AnalyzingJavaCompiler.compile$$anonfun$1$$anonfun$1(culpritPaths)));
            });
            Iterable memo = (Iterable)chunks.withFilter((Function1 & Serializable)x$1 -> {
                Option option;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
                    Path outputPath = (Path)((Some)option).value();
                    Seq srcs = (Seq)tuple2._2();
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Option option;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
                    Path outputPath = (Path)((Some)option).value();
                    Seq srcs = (Seq)tuple2._2();
                    ClassFinder classFinder = outputPath.toString().endsWith(".jar") ? new JarClassFinder(outputPath) : new DirectoryClassFinder(outputPath);
                    return Tuple3$.MODULE$.apply((Object)classFinder, classFinder.classes().pathsAndClose(), (Object)srcs);
                }
                throw new MatchError((Object)tuple2);
            });
            String somePhase = "<some phase>";
            String noPhase = "<no phase>";
            String javaCompilationPhase = "Java compilation";
            progressOpt.map((Function1 & Serializable)progress -> {
                progress.startUnit(javaCompilationPhase, "");
                return progress.advance(0, 2, somePhase, javaCompilationPhase);
            });
            this.timed(javaCompilationPhase, Logger$.MODULE$.xlog2Log(log), (Function0 & Serializable)() -> {
                this.compile$$anonfun$3(sources, converter, options, output, incToolOptions, reporter, log, absClasspath);
                return BoxedUnit.UNIT;
            });
            String javaAnalysisPhase = "Java analysis";
            progressOpt.map((Function1 & Serializable)progress -> {
                progress.startUnit(javaAnalysisPhase, "");
                return progress.advance(1, 2, javaCompilationPhase, javaAnalysisPhase);
            });
            ClassLoader loader = ClasspathUtil$.MODULE$.toLoader((Seq)Option$.MODULE$.option2Iterable(JavaInterfaceUtil$.MODULE$.EnrichOptional(output.getSingleOutputAsPath()).toOption()).toSeq().$plus$plus((IterableOnce)((IterableOps)extraClasspath.$plus$plus(this.searchClasspath())).map((Function1 & Serializable)x$0 -> converter.toPath(x$0))));
            this.timed(javaAnalysisPhase, Logger$.MODULE$.xlog2Log(log), (Function0 & Serializable)() -> {
                AnalyzingJavaCompiler.compile$$anonfun$5(output, finalJarOutput, callback, log, memo, loader);
                return BoxedUnit.UNIT;
            });
            ClassLoader classLoader = loader;
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader u = (URLClassLoader)classLoader;
                u.close();
            }
            progressOpt.foreach((Function1 & Serializable)progress -> progress.advance(2, 2, javaAnalysisPhase, noPhase));
            return;
        }
    }

    public boolean run(VirtualFile[] sources, String[] options, Output output, IncToolOptions incToolOptions, Reporter reporter, xsbti.Logger log) {
        return this.javac().run(sources, options, output, incToolOptions, reporter, log);
    }

    private <T> T timed(String label, Logger log, Function0<T> t) {
        long start = System.nanoTime();
        Object result = t.apply();
        long elapsed = System.nanoTime() - start;
        log.debug(() -> AnalyzingJavaCompiler.timed$$anonfun$1(label, elapsed));
        return (T)result;
    }

    private static final VirtualFile $anonfun$3(FileConverter converter$3, OutputGroup out$1) {
        return converter$3.toVirtualFile(out$1.getSourceDirectoryAsPath());
    }

    private static final String compile$$anonfun$1$$anonfun$1(String culpritPaths$1) {
        return new StringBuilder(32).append("No output directory mapped for: ").append(culpritPaths$1).toString();
    }

    private final void compile$$anonfun$3(Seq sources$1, FileConverter converter$4, Seq options$1, Output output$1, IncToolOptions incToolOptions$1, Reporter reporter$1, xsbti.Logger log$2, Seq absClasspath$1) {
        Seq args = JavaCompiler$.MODULE$.commandArguments(absClasspath$1, converter$4, options$1, this.scalaInstance(), this.classpathOptions());
        VirtualFile[] javaSources = (VirtualFile[])((IterableOnceOps)sources$1.sortBy((Function1 & Serializable)_$3 -> _$3.id(), (Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(VirtualFile.class));
        boolean success = this.javac().run(javaSources, (String[])args.toArray(ClassTag$.MODULE$.apply(String.class)), output$1, incToolOptions$1, reporter$1, log$2);
        if (!success) {
            String msg = "javac returned non-zero exit code";
            throw new CompileFailed((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)), msg, reporter$1.problems());
        }
    }

    private static final Set readAPI$1(AnalysisCallback callback$1, VirtualFileRef source, Seq classes) {
        Tuple3 tuple3 = ClassToAPI$.MODULE$.process(classes);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Seq apis = (Seq)tuple3._1();
        Seq mainClasses = (Seq)tuple3._2();
        Set inherits = (Set)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)apis, (Object)mainClasses, (Object)inherits);
        Seq apis2 = (Seq)tuple32._1();
        Seq mainClasses2 = (Seq)tuple32._2();
        Set inherits2 = (Set)tuple32._3();
        apis2.foreach((Function1)(JProcedure1 & Serializable)_$4 -> callback$1.api(source, _$4));
        mainClasses2.foreach((Function1)(JProcedure1 & Serializable)_$5 -> callback$1.mainClass(source, _$5));
        return (Set)inherits2.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Class from = (Class)tuple2._1();
                Class to = (Class)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)from.getName(), (Object)to.getName());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final void compile$$anonfun$5(Output output$2, Option finalJarOutput$1, AnalysisCallback callback$4, xsbti.Logger log$3, Iterable memo$1, ClassLoader loader$1) {
        memo$1.withFilter((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                ClassFinder classFinder = (ClassFinder)tuple3._1();
                Seq oldClasses = (Seq)tuple3._2();
                Seq srcs = (Seq)tuple3._3();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                ClassFinder classFinder = (ClassFinder)tuple3._1();
                Seq oldClasses = (Seq)tuple3._2();
                Seq srcs = (Seq)tuple3._3();
                try (Classes classes2 = classFinder.classes();){
                    Set newClasses = (Set)((SetOps)Predef$.MODULE$.Set().apply(classes2.paths())).$minus$minus((IterableOnce)oldClasses);
                    JavaAnalyze$.MODULE$.apply(newClasses.toSeq(), srcs, Logger$.MODULE$.xlog2Log(log$3), output$2, finalJarOutput$1, callback$4, loader$1, (Function2 & Serializable)(source, classes) -> AnalyzingJavaCompiler.readAPI$1(callback$4, source, classes));
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private static final String timed$$anonfun$1(String label$1, long elapsed$1) {
        return new StringBuilder(8).append(label$1).append(" took ").append((double)elapsed$1 / 1.0E9).append(" s").toString();
    }
}

