/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.japi;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.TArray;
import scala.concurrent.stm.TArray$;
import scala.concurrent.stm.TMap;
import scala.concurrent.stm.TMap$;
import scala.concurrent.stm.TSet;
import scala.concurrent.stm.TSet$;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$;
import scala.concurrent.stm.japi.STM;
import scala.concurrent.stm.japi.STMHelpers$;
import scala.concurrent.stm.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.NoManifest$;
import scala.runtime.BoxedUnit;

public final class STM$ {
    public static STM$ MODULE$;

    static {
        new STM$();
    }

    public <A> Ref.View<A> newRef(A initialValue) {
        return Ref$.MODULE$.apply(initialValue, NoManifest$.MODULE$).single();
    }

    public <A, B> TMap.View<A, B> newTMap() {
        return TMap$.MODULE$.empty().single();
    }

    public <A, B> Map<A, B> newMap() {
        return JavaConversions$.MODULE$.mutableMapAsJavaMap(this.newTMap());
    }

    public <A> TSet.View<A> newTSet() {
        return TSet$.MODULE$.empty().single();
    }

    public <A> Set<A> newSet() {
        return JavaConversions$.MODULE$.mutableSetAsJavaSet(this.newTSet());
    }

    public <A> TArray.View<A> newTArray(int length) {
        return TArray$.MODULE$.ofDim(length, ManifestFactory$.MODULE$.Object()).single();
    }

    public <A> List<A> newArrayAsList(int length) {
        return JavaConversions$.MODULE$.mutableSeqAsJavaList(this.newTArray(length));
    }

    public void atomic(Runnable runnable) {
        package$.MODULE$.atomic().apply((Function1 & java.io.Serializable & Serializable)txn -> {
            runnable.run();
            return BoxedUnit.UNIT;
        }, MaybeTxn$.MODULE$.unknown());
    }

    public <A> A atomic(Callable<A> callable) {
        return package$.MODULE$.atomic().apply(STMHelpers$.MODULE$.callableToAtomicBlock(callable), MaybeTxn$.MODULE$.unknown());
    }

    public void retry() {
        Option<InTxn> option = Txn$.MODULE$.findCurrent(MaybeTxn$.MODULE$.unknown());
        if (option instanceof Some) {
            Some some = (Some)option;
            InTxn txn = (InTxn)some.value();
            throw Txn$.MODULE$.retry(txn);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("retry outside atomic");
        }
        throw new MatchError(option);
    }

    public void retryFor(long timeoutMillis) {
        Option<InTxn> option = Txn$.MODULE$.findCurrent(MaybeTxn$.MODULE$.unknown());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("retry outside atomic");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        InTxn txn = (InTxn)some.value();
        Txn$.MODULE$.retryFor(timeoutMillis, Txn$.MODULE$.retryFor$default$2(), txn);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <A> void transform(Ref.View<A> ref, STM.Transformer<A> f) {
        ref.transform(STMHelpers$.MODULE$.transformerToFunction(f));
    }

    public <A> A getAndTransform(Ref.View<A> ref, STM.Transformer<A> f) {
        return ref.getAndTransform(STMHelpers$.MODULE$.transformerToFunction(f));
    }

    public <A> A transformAndGet(Ref.View<A> ref, STM.Transformer<A> f) {
        return ref.transformAndGet(STMHelpers$.MODULE$.transformerToFunction(f));
    }

    public void increment(Ref.View<Integer> ref, int delta) {
        ref.transform((Function1<Integer, Integer>)(Function1 & java.io.Serializable & Serializable)v -> Predef$.MODULE$.int2Integer(v + delta));
    }

    public void increment(Ref.View<Long> ref, long delta) {
        ref.transform((Function1<Long, Long>)(Function1 & java.io.Serializable & Serializable)v -> Predef$.MODULE$.long2Long(v + delta));
    }

    private InTxn activeTxn() {
        InTxn txn;
        Option<InTxn> option = Txn$.MODULE$.findCurrent(MaybeTxn$.MODULE$.unknown());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("not in a transaction");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        InTxn inTxn = txn = (InTxn)some.value();
        return inTxn;
    }

    public void afterCommit(Runnable task) {
        Txn$.MODULE$.afterCommit((Function1<Txn.Status, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)status -> {
            task.run();
            return BoxedUnit.UNIT;
        }, this.activeTxn());
    }

    public void afterRollback(Runnable task) {
        Txn$.MODULE$.afterRollback((Function1<Txn.Status, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)status -> {
            task.run();
            return BoxedUnit.UNIT;
        }, this.activeTxn());
    }

    public void afterCompletion(Runnable task) {
        Txn$.MODULE$.afterCompletion((Function1<Txn.Status, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)status -> {
            task.run();
            return BoxedUnit.UNIT;
        }, this.activeTxn());
    }

    private STM$() {
        MODULE$ = this;
    }
}

