/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.stm.NestingLevel;
import scala.concurrent.stm.Txn;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!B\u0001\u0003\u0001\u0011Q!\u0001D\"bY2\u0014\u0017mY6MSN$(BA\u0002\u0005\u0003\u0011\u00198.\u001a7\u000b\u0005\u00151\u0011aA:u[*\u0011q\u0001C\u0001\u000bG>t7-\u001e:sK:$(\"A\u0005\u0002\u000bM\u001c\u0017\r\\1\u0016\u0005-A2C\u0001\u0001\r!\tia\"D\u0001\t\u0013\ty\u0001B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\taE\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tA\u0003E\u0002\u0016\u0001Yi\u0011A\u0001\t\u0003/aa\u0001\u0001B\u0003\u001a\u0001\t\u0007!DA\u0001B#\tYb\u0004\u0005\u0002\u000e9%\u0011Q\u0004\u0003\u0002\b\u001d>$\b.\u001b8h!\tiq$\u0003\u0002!\u0011\t\u0019\u0011I\\=\t\u000f\t\u0002!\u0019!C\u0007G\u0005y\u0011J\\5uS\u0006d7)\u00199bG&$\u00180F\u0001%\u001f\u0005)SD\u0001\u0001\u0001\u0012\u00199\u0003\u0001)A\u0007I\u0005\u0001\u0012J\\5uS\u0006d7)\u00199bG&$\u0018\u0010\t\u0005\bS\u0001\u0011\r\u0011\"\u0004+\u0003Ai\u0015\r_#naRL8)\u00199bG&$\u00180F\u0001,\u001f\u0005aSD\u0001\u0011\u0001\u0011\u0019q\u0003\u0001)A\u0007W\u0005\tR*\u0019=F[B$\u0018pQ1qC\u000eLG/\u001f\u0011\t\u000fA\u0002\u0001\u0019!C\u0005c\u0005)ql]5{KV\t!\u0007\u0005\u0002\u000eg%\u0011A\u0007\u0003\u0002\u0004\u0013:$\bb\u0002\u001c\u0001\u0001\u0004%IaN\u0001\n?NL'0Z0%KF$\"\u0001O\u001e\u0011\u00055I\u0014B\u0001\u001e\t\u0005\u0011)f.\u001b;\t\u000fq*\u0014\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\t\ry\u0002\u0001\u0015)\u00033\u0003\u0019y6/\u001b>fA!9\u0001\t\u0001a\u0001\n\u0013\t\u0015!B0eCR\fW#\u0001\"\u0011\u00075\u0019U)\u0003\u0002E\u0011\t)\u0011I\u001d:bsB!QB\u0012\f9\u0013\t9\u0005BA\u0005Gk:\u001cG/[8oc!9\u0011\n\u0001a\u0001\n\u0013Q\u0015!C0eCR\fw\fJ3r)\tA4\nC\u0004=\u0011\u0006\u0005\t\u0019\u0001\"\t\r5\u0003\u0001\u0015)\u0003C\u0003\u0019yF-\u0019;bA!)q\n\u0001C\u0001!\u00069\u0011n]#naRLX#A)\u0011\u00055\u0011\u0016BA*\t\u0005\u001d\u0011un\u001c7fC:DQ!\u0016\u0001\u0005\u0002E\nAa]5{K\")q\u000b\u0001C\u00011\u0006A1/\u001b>f?\u0012*\u0017\u000f\u0006\u000293\")!L\u0016a\u0001e\u00059a.Z<TSj,\u0007\"\u0002/\u0001\t\u0013i\u0016AC2iC:<WmU5{KR\u0011\u0001H\u0018\u0005\u00065n\u0003\rA\r\u0005\u0006A\u0002!I!Y\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0002q!)1\r\u0001C\u0001I\u0006AA\u0005\u001d7vg\u0012*\u0017\u000f\u0006\u00029K\")aM\u0019a\u0001\u000b\u00069\u0001.\u00198eY\u0016\u0014\b\"\u00025\u0001\t\u0013\t\u0017\u0001B4s_^DQA\u001b\u0001\u0005\u0002-\fQ!\u00199qYf$\"!\u00127\t\u000b5L\u0007\u0019\u0001\u001a\u0002\u0003%DQa\u001c\u0001\u0005\u0002A\fAAZ5sKR\u0019\u0001(]<\t\u000bIt\u0007\u0019A:\u0002\u000b1,g/\u001a7\u0011\u0005Q,X\"\u0001\u0003\n\u0005Y$!\u0001\u0004(fgRLgn\u001a'fm\u0016d\u0007\"\u0002=o\u0001\u00041\u0012aA1sO\")q\u000e\u0001C\u0005uR!\u0001h\u001f?~\u0011\u0015\u0011\u0018\u00101\u0001t\u0011\u0015A\u0018\u00101\u0001\u0017\u0011\u0015i\u0017\u00101\u00013Q\tIx\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001C\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0005\u0003\u0007\u0011q\u0001^1jYJ,7\rC\u0004\u0002\u000e\u0001!I!a\u0004\u0002\u0015MDw.\u001e7e\r&\u0014X\rF\u0002R\u0003#AaA]A\u0006\u0001\u0004\u0019\bbBA\u000b\u0001\u0011\u0005\u0011qC\u0001\tiJ,hnY1uKR\u0019!)!\u0007\t\ri\u000b\u0019\u00021\u00013\u0001")
public class CallbackList<A> {
    private int _size = 0;
    private Function1<A, BoxedUnit>[] _data = new Function1[128];

    private final int InitialCapacity() {
        return 128;
    }

    private final int MaxEmptyCapacity() {
        return 8192;
    }

    private int _size() {
        return this._size;
    }

    private void _size_$eq(int x$1) {
        this._size = x$1;
    }

    private Function1<A, BoxedUnit>[] _data() {
        return this._data;
    }

    private void _data_$eq(Function1<A, BoxedUnit>[] x$1) {
        this._data = x$1;
    }

    public boolean isEmpty() {
        return this._size() == 0;
    }

    public int size() {
        return this._size();
    }

    public void size_$eq(int newSize) {
        block0: {
            if (newSize == this._size()) break block0;
            this.changeSize(newSize);
        }
    }

    private void changeSize(int newSize) {
        if (newSize < 0 || newSize > this._size()) {
            throw new IllegalArgumentException();
        }
        if (newSize == 0 && this._data().length > 8192) {
            this.reset();
        } else {
            Arrays.fill(this._data(), newSize, this._size(), null);
            this._size_$eq(newSize);
        }
    }

    private void reset() {
        this._data_$eq(new Function1[128]);
        this._size_$eq(0);
    }

    public void $plus$eq(Function1<A, BoxedUnit> handler) {
        if (this._size() == this._data().length) {
            this.grow();
        }
        this._data()[this._size()] = handler;
        this._size_$eq(this._size() + 1);
    }

    private void grow() {
        Function1[] a = new Function1[this._data().length * 2];
        System.arraycopy(this._data(), 0, a, 0, this._data().length);
        this._data_$eq(a);
    }

    public Function1<A, BoxedUnit> apply(int i) {
        return this._data()[i];
    }

    public void fire(NestingLevel level, A arg) {
        block0: {
            if (this._size() <= 0) break block0;
            this.fire(level, arg, 0);
        }
    }

    private void fire(NestingLevel level, A arg, int i) {
        while (i < this._size() && this.shouldFire(level)) {
            Object object;
            try {
                object = this._data()[i].apply(arg);
            }
            catch (Throwable x) {
                Txn.Status s = level.requestRollback(new Txn.UncaughtExceptionCause(x));
                Predef$.MODULE$.assert(s instanceof Txn.RolledBack);
                object = BoxedUnit.UNIT;
            }
            ++i;
        }
    }

    private boolean shouldFire(NestingLevel level) {
        return !(level.status() instanceof Txn.RolledBack);
    }

    /*
     * WARNING - void declaration
     */
    public Function1<A, BoxedUnit>[] truncate(int newSize) {
        Function1<A, BoxedUnit>[] function1Array;
        if (this._size() == newSize) {
            function1Array = null;
        } else {
            void var2_2;
            Function1[] z = new Function1[this._size() - newSize];
            System.arraycopy(this._data(), newSize, z, 0, z.length);
            this.size_$eq(newSize);
            function1Array = var2_2;
        }
        return function1Array;
    }
}

