/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import org.scalatest.PrintReporter$;
import org.scalatest.Report;
import org.scalatest.Reporter;
import org.scalatest.Reporter$class;
import org.scalatest.Resources$;
import org.scalatest.SpecReport;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;

public abstract class PrintReporter
implements Reporter,
ScalaObject {
    private int suitesAbortedCount;
    private int testsFailedCount;
    private int testsCompletedCount;
    private final PrintWriter pw;

    public PrintReporter(PrintWriter pw) {
        this.pw = pw;
        this.testsCompletedCount = 0;
        this.testsFailedCount = 0;
        this.suitesAbortedCount = 0;
        Reporter$class.$init$(this);
    }

    private void makeReport(Report report, String resourceName) {
        Some some;
        block15: {
            block14: {
                block10: {
                    Option<Throwable> option;
                    block13: {
                        block12: {
                            block11: {
                                Throwable throwable;
                                Some stringToPrintOption;
                                Object object;
                                Report report2 = report;
                                if (report2 == null || report2.equals(null)) {
                                    throw new NullPointerException("report is null");
                                }
                                Report report3 = report;
                                if (report3 instanceof SpecReport) {
                                    String string;
                                    SpecReport specReport;
                                    SpecReport specReport2 = specReport = (SpecReport)report3;
                                    String string2 = string = resourceName;
                                    String string3 = "testFailed";
                                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                        object = specReport2.includeInSpecOutput() ? new Some((Object)Resources$.MODULE$.apply("specTextAndNote", (Seq<Object>)new BoxedObjectArray(new Object[]{specReport2.formattedSpecText(), Resources$.MODULE$.apply("failedNote")}))) : None$.MODULE$;
                                    } else {
                                        String string4 = string;
                                        String string5 = "testIgnored";
                                        object = !(string4 != null ? !string4.equals(string5) : string5 != null) ? (specReport2.includeInSpecOutput() ? new Some((Object)Resources$.MODULE$.apply("specTextAndNote", (Seq<Object>)new BoxedObjectArray(new Object[]{specReport2.formattedSpecText(), Resources$.MODULE$.apply("ignoredNote")}))) : None$.MODULE$) : (specReport2.includeInSpecOutput() ? new Some((Object)specReport2.formattedSpecText()) : None$.MODULE$);
                                    }
                                } else {
                                    String resName = Predef$.MODULE$.stringWrapper(report.message().trim()).isEmpty() ? new StringBuilder().append((Object)resourceName).append((Object)"NoMessage").toString() : resourceName;
                                    object = new Some((Object)Resources$.MODULE$.apply(resName, (Seq<Object>)new BoxedObjectArray(new Object[]{report.name(), report.message()})));
                                }
                                some = stringToPrintOption = object;
                                if (!(some instanceof Some)) break block10;
                                this.pw.println((String)some.x());
                                option = report.throwable();
                                if (!(option instanceof Some)) break block11;
                                Some some2 = (Some)option;
                                Throwable t = throwable = (Throwable)some2.x();
                                Report report4 = report;
                                if (report4 instanceof SpecReport) {
                                    StringWriter sw = new StringWriter();
                                    t.printStackTrace(new PrintWriter(sw));
                                    String stackTrace = sw.toString();
                                    String indentedStackTrace = PrintReporter$.MODULE$.indentStackTrace(stackTrace, 1);
                                    this.pw.print(indentedStackTrace);
                                } else {
                                    t.printStackTrace(this.pw);
                                }
                                break block12;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Throwable> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block13;
                        }
                        this.pw.flush();
                        break block14;
                    }
                    throw new MatchError(option);
                }
                None$ none$ = None$.MODULE$;
                Some some3 = some;
                if (none$ != null ? !none$.equals(some3) : some3 != null) break block15;
            }
            return;
        }
        throw new MatchError((Object)some);
    }

    private void makeFinalReport(String resourceName) {
        this.printResourceStringWithInt(resourceName, this.testsCompletedCount());
        if (this.suitesAbortedCount() == 1) {
            this.printResourceString("oneSuiteAborted");
        } else if (this.suitesAbortedCount() > 1) {
            this.printResourceStringWithInt("multipleSuitesAborted", this.suitesAbortedCount());
        }
        if (this.testsFailedCount() == 1) {
            this.printResourceString("oneTestFailed");
        } else if (this.testsFailedCount() > 1) {
            this.printResourceStringWithInt("multipleTestsFailed", this.testsFailedCount());
        } else if (this.suitesAbortedCount() == 0) {
            this.printResourceString("allTestsPassed");
        }
        this.pw.flush();
    }

    private void printResourceString(String resourceName) {
        this.pw.println(Resources$.MODULE$.apply(resourceName));
        this.pw.flush();
    }

    private void printResourceStringWithInt(String resourceName, int testCount) {
        String stringToReport = Resources$.MODULE$.apply(resourceName, (Seq<Object>)new BoxedObjectArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)testCount)).toString()}));
        this.pw.println(stringToReport);
        this.pw.flush();
    }

    public void dispose() {
        this.pw.close();
    }

    public void runCompleted() {
        this.makeFinalReport("runCompleted");
    }

    public void runAborted(Report report) {
        this.makeReport(report, "runAborted");
    }

    public void runStopped() {
        this.makeFinalReport("runStopped");
    }

    public void suiteAborted(Report report) {
        this.suitesAbortedCount_$eq(this.suitesAbortedCount() + 1);
        this.makeReport(report, "suiteAborted");
    }

    public void suiteCompleted(Report report) {
        this.makeReport(report, "suiteCompleted");
    }

    public void suiteStarting(Report report) {
        this.makeReport(report, "suiteStarting");
    }

    public void infoProvided(Report report) {
        this.makeReport(report, "infoProvided");
    }

    public void testFailed(Report report) {
        this.makeReport(report, "testFailed");
        this.testsCompletedCount_$eq(this.testsCompletedCount() + 1);
        this.testsFailedCount_$eq(this.testsFailedCount() + 1);
    }

    public void testIgnored(Report report) {
        this.makeReport(report, "testIgnored");
    }

    public void testSucceeded(Report report) {
        this.makeReport(report, "testSucceeded");
        this.testsCompletedCount_$eq(this.testsCompletedCount() + 1);
    }

    public void testStarting(Report report) {
        this.makeReport(report, "testStarting");
    }

    public void runStarting(int testCount) {
        if (testCount < 0) {
            throw new IllegalArgumentException();
        }
        this.testsCompletedCount_$eq(0);
        this.testsFailedCount_$eq(0);
        this.suitesAbortedCount_$eq(0);
        this.printResourceStringWithInt("runStarting", testCount);
    }

    public PrintReporter(String filename) {
        this(new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File(filename)), PrintReporter$.MODULE$.BufferSize())));
    }

    public PrintReporter(OutputStream os) {
        this(new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(os, PrintReporter$.MODULE$.BufferSize()))));
    }

    private void suitesAbortedCount_$eq(int x$1) {
        this.suitesAbortedCount = x$1;
    }

    private int suitesAbortedCount() {
        return this.suitesAbortedCount;
    }

    private void testsFailedCount_$eq(int x$1) {
        this.testsFailedCount = x$1;
    }

    private int testsFailedCount() {
        return this.testsFailedCount;
    }

    private void testsCompletedCount_$eq(int x$1) {
        this.testsCompletedCount = x$1;
    }

    private int testsCompletedCount() {
        return this.testsCompletedCount;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

