/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.rmi.RemoteException;
import org.scalatest.Distributor;
import org.scalatest.Report;
import org.scalatest.Reporter;
import org.scalatest.Rerunnable;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Suite$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteRerunner
implements Rerunnable,
ScalaObject {
    private final String suiteClassName;

    public SuiteRerunner(String suiteClassName) {
        this.suiteClassName = suiteClassName;
        String string = suiteClassName;
        if (string == null || string.equals(null)) {
            throw new NullPointerException();
        }
    }

    @Override
    public void rerun(Reporter reporter, Stopper stopper, Set<String> includes, Set<String> excludes, Map<String, Object> properties, Option<Distributor> distributor, ClassLoader loader) {
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            int expectedTestCount = suite.expectedTestCount(includes, excludes);
            None$ rerunnable = Suite$.MODULE$.checkForPublicNoArgConstructor(suite.getClass()) ? new Some((Object)new SuiteRerunner(suite.getClass().getName())) : None$.MODULE$;
            reporter.runStarting(expectedTestCount);
            try {
                String rawString = Resources$.MODULE$.apply("suiteExecutionStarting");
                reporter.suiteStarting(new Report(suite.suiteName(), rawString, (Option<Throwable>)None$.MODULE$, (Option<Rerunnable>)rerunnable));
                suite.execute((Option<String>)None$.MODULE$, reporter, stopper, includes, excludes, properties, distributor);
                String rawString2 = Resources$.MODULE$.apply("suiteCompletedNormally");
                reporter.suiteCompleted(new Report(suite.suiteName(), rawString2, (Option<Throwable>)None$.MODULE$, (Option<Rerunnable>)rerunnable));
            }
            catch (RuntimeException runtimeException) {
                String rawString = Resources$.MODULE$.apply("executeException");
                reporter.suiteAborted(new Report(suite.suiteName(), rawString, (Option<Throwable>)new Some((Object)runtimeException), (Option<Rerunnable>)rerunnable));
            }
            if (stopper.stopRequested()) {
                reporter.runStopped();
            } else {
                reporter.runCompleted();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report report = new Report("org.scalatest.tools.Runner", Resources$.MODULE$.apply("cannotLoadSuite"), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (InstantiationException instantiationException) {
            Report report = new Report("org.scalatest.tools.Runner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option<Throwable>)new Some((Object)instantiationException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (IllegalAccessException illegalAccessException) {
            Report report = new Report("org.scalatest.tools.Runner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (SecurityException securityException) {
            Report report = new Report("org.scalatest.tools.Runner", Resources$.MODULE$.apply("securityWhenReruning"), (Option<Throwable>)new Some((Object)securityException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Report report = new Report("org.scalatest.tools.Runner", Resources$.MODULE$.apply("cannotLoadClass"), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (Throwable throwable) {
            Report report = new Report("org.scalatest.tools.Runner", Resources$.MODULE$.apply("bigProblems"), (Option<Throwable>)new Some((Object)throwable), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

