/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.rmi.RemoteException;
import org.scalatest.Distributor;
import org.scalatest.Report;
import org.scalatest.Reporter;
import org.scalatest.Rerunnable;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRerunner
implements Rerunnable,
ScalaObject {
    private final String testName;
    private final String suiteClassName;

    public TestRerunner(String suiteClassName, String testName) {
        String string;
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        String string2 = suiteClassName;
        if (string2 == null || string2.equals(null) || (string = testName) == null || string.equals(null)) {
            throw new NullPointerException();
        }
    }

    @Override
    public void rerun(Reporter reporter, Stopper stopper, Set<String> includes, Set<String> excludes, Map<String, Object> properties, Option<Distributor> distributor, ClassLoader loader) {
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            reporter.runStarting(1);
            suite.execute((Option<String>)new Some((Object)this.testName), reporter, stopper, includes, excludes, properties, distributor);
            reporter.runCompleted();
        }
        catch (Throwable throwable) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("bigProblems"), (Option<Throwable>)new Some((Object)throwable), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotLoadClass"), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (SecurityException securityException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("securityWhenReruning"), (Option<Throwable>)new Some((Object)securityException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotFindMethod"), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (IllegalAccessException illegalAccessException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (InstantiationException instantiationException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option<Throwable>)new Some((Object)instantiationException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotLoadSuite"), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Rerunnable>)None$.MODULE$);
            reporter.runAborted(report);
        }
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

