/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import scala.ScalaObject;

public class ColorBar
extends JPanel
implements ScalaObject {
    private Image offscreenImage;
    private Color barColor;
    private int value = 0;
    private int max = 0;
    private final Color SENSIBLE_GRAY;
    private final Color DEEP_RED;
    private final Color HANDSOME_GREEN = new Color(85, 238, 102);

    public ColorBar() {
        this.DEEP_RED = new Color(238, 85, 102);
        this.SENSIBLE_GRAY = new Color(238, 238, 238);
        this.barColor = this.HANDSOME_GREEN();
        this.setBackground(this.SENSIBLE_GRAY());
    }

    public void paint(Graphics g) {
        int extent;
        int n;
        Dimension dim = this.getSize();
        Image image = this.offscreenImage();
        if (image == null || image.equals(null)) {
            this.offscreenImage_$eq(this.createImage(dim.width, dim.height));
        } else {
            int offWidth = this.offscreenImage().getWidth(null);
            int offHeight = this.offscreenImage().getHeight(null);
            if (offWidth != dim.width || offHeight != dim.height) {
                this.offscreenImage_$eq(this.createImage(dim.width, dim.height));
            }
        }
        Graphics og = this.offscreenImage().getGraphics();
        og.setColor(this.SENSIBLE_GRAY());
        og.fillRect(0, 0, dim.width, dim.height);
        int localVal = this.value();
        int localMax = this.max();
        if (localVal >= localMax) {
            n = dim.width + 1;
        } else if (localVal != 0) {
            float floatExtent = (float)dim.width * (float)localVal / (float)localMax;
            n = (int)floatExtent;
        } else {
            n = extent = 0;
        }
        if (this.max() != 0) {
            og.setColor(this.barColor());
            og.fillRect(0, 0, extent, dim.height + 1);
        }
        g.drawImage(this.offscreenImage(), 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        this.max_$eq(max);
        if (this.value() > max) {
            this.value_$eq(max);
        }
        this.repaint();
    }

    public void setValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        this.value_$eq(value);
        if (value > this.max()) {
            this.max_$eq(value);
        }
        this.repaint();
    }

    public void setGray() {
        this.barColor_$eq(this.SENSIBLE_GRAY());
        this.repaint();
    }

    public void setRed() {
        this.barColor_$eq(this.DEEP_RED());
        this.repaint();
    }

    public void setGreen() {
        this.barColor_$eq(this.HANDSOME_GREEN());
        this.repaint();
    }

    private void offscreenImage_$eq(Image x$1) {
        this.offscreenImage = x$1;
    }

    private Image offscreenImage() {
        return this.offscreenImage;
    }

    private void barColor_$eq(Color x$1) {
        this.barColor = x$1;
    }

    private Color barColor() {
        return this.barColor;
    }

    private void value_$eq(int x$1) {
        this.value = x$1;
    }

    private int value() {
        return this.value;
    }

    private void max_$eq(int x$1) {
        this.max = x$1;
    }

    private int max() {
        return this.max;
    }

    private Color SENSIBLE_GRAY() {
        return this.SENSIBLE_GRAY;
    }

    private Color DEEP_RED() {
        return this.DEEP_RED;
    }

    private Color HANDSOME_GREEN() {
        return this.HANDSOME_GREEN;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

