/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.rmi.RemoteException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.scalatest.DispatchReporter;
import org.scalatest.Distributor;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.tools.SuiteRunner;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentDistributor
implements Distributor,
ScalaObject {
    private final LinkedBlockingQueue futureQueue;
    private final ExecutorService execSvc;
    private final Map propertiesMap;
    private final Set excludes;
    private final Set includes;
    private final Stopper stopper;
    private final DispatchReporter dispatchReporter;

    public ConcurrentDistributor(DispatchReporter dispatchReporter, Stopper stopper, Set<String> includes, Set<String> excludes, Map<String, Object> propertiesMap) {
        this.dispatchReporter = dispatchReporter;
        this.stopper = stopper;
        this.includes = includes;
        this.excludes = excludes;
        this.propertiesMap = propertiesMap;
        this.execSvc = Executors.newCachedThreadPool();
        this.futureQueue = new LinkedBlockingQueue();
    }

    public void waitUntilDone() {
        while (true) {
            if (BoxesRunTime.equals(this.futureQueue().peek(), null)) {
                return;
            }
            ((Future)this.futureQueue().poll()).get();
        }
    }

    public None$ poll() {
        return None$.MODULE$;
    }

    @Override
    public void put(Suite suite) {
        SuiteRunner suiteRunner = new SuiteRunner(suite, this.dispatchReporter, this.stopper, (Set<String>)this.includes, (Set<String>)this.excludes, (Map<String, Object>)this.propertiesMap, (Option<Distributor>)new Some((Object)this));
        Future<?> future = this.execSvc().submit(suiteRunner);
        this.futureQueue().put(future);
    }

    private LinkedBlockingQueue futureQueue() {
        return this.futureQueue;
    }

    private ExecutorService execSvc() {
        return this.execSvc;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

