/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import java.rmi.RemoteException;
import java.util.regex.Pattern;
import org.specs.Specification;
import org.specs.io.ConsoleOutput$class;
import org.specs.io.Output$class;
import org.specs.log.Log$class;
import org.specs.runner.ClassRunner$;
import org.specs.runner.OutputReporter;
import org.specs.runner.OutputReporter$class;
import org.specs.runner.Reporter;
import org.specs.runner.Reporter$class;
import org.specs.runner.SpecsFilter;
import org.specs.runner.SpecsFilter$class;
import org.specs.specification.Example;
import org.specs.specification.Examples;
import org.specs.specification.Sus;
import org.specs.util.Classes;
import org.specs.util.Classes$class;
import org.specs.util.Property;
import org.specs.util.SimpleTimer;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Iterable;
import scala.List;
import scala.List$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.StringBuilder;
import scala.Tuple5;
import scala.reflect.Manifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxedObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRunner
implements Classes,
OutputReporter,
ScalaObject {
    public volatile int bitmap$0;
    private final Pattern exampleFilter;
    private final Pattern susFilter;
    private final List filteredSpecs;
    private int level;
    private final int Error;
    private final int Warning;
    private final int Info;
    private final int Debug;
    private String[] org$specs$runner$Reporter$$specArgs;
    private final Property planOnly;
    private final Property colorize;
    private final Property finalStatisticsOnly;
    private final Property statistics;
    private final Property failedAndErrorsOnly;
    private final Property stacktrace;
    private final Property org$specs$runner$Reporter$$userConfiguration;
    private List<Specification> specs;
    private final SimpleTimer timer;

    public ClassRunner() {
        Output$class.$init$(this);
        ConsoleOutput$class.$init$(this);
        Classes$class.$init$(this);
        SpecsFilter$class.$init$(this);
        Log$class.$init$(this);
        Reporter$class.$init$(this);
        OutputReporter$class.$init$(this);
        this.timer = new SimpleTimer();
    }

    private String fullClassName(String packageName, String className) {
        return packageName.trim().isEmpty() ? className.trim() : new StringBuilder().append((Object)packageName.trim()).append((Object)".").append((Object)className.trim()).toString();
    }

    public Option<Specification> createSpecification(String packageName, String className) {
        return this.createObject(this.fullClassName(packageName, className), true, new BoxedObjectArray((Object[])this.args()).contains((Object)"-v"), Manifest$.MODULE$.classType(Specification.class));
    }

    public List<Specification> getSpecifications() {
        String packageNames = (String)this.argValue(this.args(), (List<String>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"-p", "--packages"}))).getOrElse((Function0)new $anonfun$1(this));
        List specificationPackageNames = new BoxedObjectArray((Object[])packageNames.split(",")).toList();
        String classNames = (String)this.argValue(this.args(), (List<String>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"-k", "--classes"}))).getOrElse((Function0)new $anonfun$2(this));
        List specificationNames$1 = new BoxedObjectArray((Object[])classNames.split(",")).toList();
        List specificationClasses = specificationPackageNames.flatMap((Function1)new $anonfun$3(this, specificationNames$1));
        return specificationClasses.flatMap((Function1)new $anonfun$getSpecifications$1(this));
    }

    @Override
    public void displayOptionsDescription() {
        Reporter$class.displayOptionsDescription(this);
        this.println("-k, --classes                   comma-separated list of specification class names instead");
        this.println("-p, --packages                  comma-separated list of specification package names to append to class names");
    }

    @Override
    public void displayOptions() {
        Reporter$class.displayOptions(this);
        this.println("    [-k|--classes]");
        this.println("    [-p|--packages]");
    }

    @Override
    public void displayUsage() {
        this.println("usage java <classpath> run [className|-k classNames]");
    }

    @Override
    public void main(String[] arguments) {
        if (arguments.length == 0) {
            this.println("The first argument should be at least the specification class name");
        } else {
            Reporter$class.main(this, arguments);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Specification> specs() {
        if ((this.bitmap$0 & 1) != 0) return this.specs;
        ClassRunner classRunner = this;
        synchronized (classRunner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.specs = this.getSpecifications();
                this.bitmap$0 |= 1;
            }
            return this.specs;
        }
    }

    @Override
    public SimpleTimer timer() {
        return this.timer;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    @Override
    public void printStackTrace(Throwable x$1) {
        Output$class.printStackTrace(this, x$1);
    }

    @Override
    public void flush() {
        ConsoleOutput$class.flush(this);
    }

    public void printf(String x$1, Seq x$2) {
        ConsoleOutput$class.printf(this, x$1, x$2);
    }

    @Override
    public void println(Object x$1) {
        ConsoleOutput$class.println(this, x$1);
    }

    public String getClassName(Object x$1) {
        return Classes$class.getClassName(this, x$1);
    }

    public String className(Class x$1) {
        return Classes$class.className((Classes)this, x$1);
    }

    @Override
    public String className(String x$1) {
        return Classes$class.className((Classes)this, x$1);
    }

    public String getOuterClassName(Class x$1) {
        return Classes$class.getOuterClassName(this, x$1);
    }

    public Option tryToCreateObject(String x$1, Manifest x$2) {
        return Classes$class.tryToCreateObject(this, x$1, x$2);
    }

    public Option tryToCreateObject(String x$1, boolean x$2, boolean x$3, Manifest x$4) {
        return Classes$class.tryToCreateObject(this, x$1, x$2, x$3, x$4);
    }

    public Class loadClassOf(String x$1) {
        return Classes$class.loadClassOf(this, x$1);
    }

    public Option loadClass(String x$1) {
        return Classes$class.loadClass(this, x$1);
    }

    public Object createInstanceFor(Class x$1, Manifest x$2) {
        return Classes$class.createInstanceFor(this, x$1, x$2);
    }

    public Option createInstanceOf(Option x$1, Manifest x$2) {
        return Classes$class.createInstanceOf(this, x$1, x$2);
    }

    public Option createObject(String x$1, boolean x$2, boolean x$3, Manifest x$4) {
        return Classes$class.createObject(this, x$1, x$2, x$3, x$4);
    }

    public Option createObject(String x$1, boolean x$2, Manifest x$3) {
        return Classes$class.createObject(this, x$1, x$2, x$3);
    }

    public Option createObject(String x$1, Manifest x$2) {
        return Classes$class.createObject(this, x$1, x$2);
    }

    public Either create(String x$1, Manifest x$2) {
        return Classes$class.create(this, x$1, x$2);
    }

    @Override
    public String examplePattern() {
        return SpecsFilter$class.examplePattern(this);
    }

    @Override
    public String susPattern() {
        return SpecsFilter$class.susPattern(this);
    }

    public Option filterExample(Example x$1) {
        return SpecsFilter$class.filterExample(this, x$1);
    }

    public Option filter(Sus x$1) {
        return SpecsFilter$class.filter((SpecsFilter)this, x$1);
    }

    public Option filter(Specification x$1) {
        return SpecsFilter$class.filter((SpecsFilter)this, x$1);
    }

    public List filter(Seq x$1) {
        return SpecsFilter$class.filter((SpecsFilter)this, x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Pattern exampleFilter() {
        if ((this.bitmap$0 & 0x40) != 0) return this.exampleFilter;
        ClassRunner classRunner = this;
        synchronized (classRunner) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.exampleFilter = SpecsFilter$class.exampleFilter(this);
                this.bitmap$0 |= 0x40;
            }
            return this.exampleFilter;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Pattern susFilter() {
        if ((this.bitmap$0 & 0x10) != 0) return this.susFilter;
        ClassRunner classRunner = this;
        synchronized (classRunner) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.susFilter = SpecsFilter$class.susFilter(this);
                this.bitmap$0 |= 0x10;
            }
            return this.susFilter;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List filteredSpecs() {
        if ((this.bitmap$0 & 4) != 0) return this.filteredSpecs;
        ClassRunner classRunner = this;
        synchronized (classRunner) {
            if ((this.bitmap$0 & 4) == 0) {
                this.filteredSpecs = SpecsFilter$class.filteredSpecs(this);
                this.bitmap$0 |= 4;
            }
            return this.filteredSpecs;
        }
    }

    public void error(Function0 x$1) {
        Log$class.error(this, x$1);
    }

    public void warning(Function0 x$1) {
        Log$class.warning(this, x$1);
    }

    public void info(Function0 x$1) {
        Log$class.info(this, x$1);
    }

    public void debug(Function0 x$1) {
        Log$class.debug(this, x$1);
    }

    @Override
    public void Error_$eq(int x$1) {
        this.Error = x$1;
    }

    @Override
    public void Warning_$eq(int x$1) {
        this.Warning = x$1;
    }

    @Override
    public void Info_$eq(int x$1) {
        this.Info = x$1;
    }

    @Override
    public void Debug_$eq(int x$1) {
        this.Debug = x$1;
    }

    @Override
    public void level_$eq(int x$1) {
        this.level = x$1;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public int Error() {
        return this.Error;
    }

    @Override
    public int Warning() {
        return this.Warning;
    }

    @Override
    public int Info() {
        return this.Info;
    }

    @Override
    public int Debug() {
        return this.Debug;
    }

    public List $colon$colon(Reporter x$1) {
        return Reporter$class.$colon$colon(this, x$1);
    }

    public Option argValue(String[] x$1, List x$2) {
        return Reporter$class.argValue(this, x$1, x$2);
    }

    public void setTags(Seq x$1) {
        Reporter$class.setTags(this, x$1);
    }

    @Override
    public Reporter reportSpecs() {
        return Reporter$class.reportSpecs(this);
    }

    @Override
    public String exampleFilterPattern() {
        return Reporter$class.exampleFilterPattern(this);
    }

    @Override
    public String susFilterPattern() {
        return Reporter$class.susFilterPattern(this);
    }

    @Override
    public void displayHelp() {
        Reporter$class.displayHelp(this);
    }

    @Override
    public void exit(int x$1) {
        Reporter$class.exit(this, x$1);
    }

    @Override
    public void args_$eq(String[] x$1) {
        Reporter$class.args_$eq(this, x$1);
    }

    @Override
    public String[] args() {
        return Reporter$class.args(this);
    }

    @Override
    public Object runConfiguration() {
        return Reporter$class.runConfiguration(this);
    }

    @Override
    public Reporter setOptionsFromConfig() {
        return Reporter$class.setOptionsFromConfig(this);
    }

    @Override
    public Reporter resetOptions() {
        return Reporter$class.resetOptions(this);
    }

    @Override
    public Reporter setPlanOnly() {
        return Reporter$class.setPlanOnly(this);
    }

    @Override
    public Reporter setColorize() {
        return Reporter$class.setColorize(this);
    }

    @Override
    public Reporter setFinalStatisticsOnly() {
        return Reporter$class.setFinalStatisticsOnly(this);
    }

    @Override
    public Reporter setNoStatistics() {
        return Reporter$class.setNoStatistics(this);
    }

    @Override
    public Reporter setFailedAndErrorsOnly() {
        return Reporter$class.setFailedAndErrorsOnly(this);
    }

    @Override
    public Reporter setNoStacktrace() {
        return Reporter$class.setNoStacktrace(this);
    }

    public Reporter setConfiguration(Option x$1) {
        return Reporter$class.setConfiguration(this, x$1);
    }

    @Override
    public void planOnly_$eq(Property x$1) {
        this.planOnly = x$1;
    }

    @Override
    public void colorize_$eq(Property x$1) {
        this.colorize = x$1;
    }

    @Override
    public void finalStatisticsOnly_$eq(Property x$1) {
        this.finalStatisticsOnly = x$1;
    }

    @Override
    public void statistics_$eq(Property x$1) {
        this.statistics = x$1;
    }

    @Override
    public void failedAndErrorsOnly_$eq(Property x$1) {
        this.failedAndErrorsOnly = x$1;
    }

    @Override
    public void stacktrace_$eq(Property x$1) {
        this.stacktrace = x$1;
    }

    @Override
    public void org$specs$runner$Reporter$$userConfiguration_$eq(Property x$1) {
        this.org$specs$runner$Reporter$$userConfiguration = x$1;
    }

    @Override
    public final void org$specs$runner$Reporter$$specArgs_$eq(String[] x$1) {
        this.org$specs$runner$Reporter$$specArgs = x$1;
    }

    @Override
    public final String[] org$specs$runner$Reporter$$specArgs() {
        return this.org$specs$runner$Reporter$$specArgs;
    }

    public Property planOnly() {
        return this.planOnly;
    }

    public Property colorize() {
        return this.colorize;
    }

    public Property finalStatisticsOnly() {
        return this.finalStatisticsOnly;
    }

    public Property statistics() {
        return this.statistics;
    }

    public Property failedAndErrorsOnly() {
        return this.failedAndErrorsOnly;
    }

    public Property stacktrace() {
        return this.stacktrace;
    }

    @Override
    public final Property org$specs$runner$Reporter$$userConfiguration() {
        return this.org$specs$runner$Reporter$$userConfiguration;
    }

    @Override
    public void reportExample(Examples x$1, String x$2) {
        OutputReporter$class.reportExample(this, x$1, x$2);
    }

    public void reportExamples(Iterable x$1, String x$2) {
        OutputReporter$class.reportExamples(this, x$1, x$2);
    }

    public void printStats(Tuple5 x$1, String x$2) {
        OutputReporter$class.printStats((OutputReporter)this, x$1, x$2);
    }

    @Override
    public void printStats(Sus x$1, String x$2) {
        OutputReporter$class.printStats((OutputReporter)this, x$1, x$2);
    }

    @Override
    public void printSus(Sus x$1, String x$2) {
        OutputReporter$class.printSus(this, x$1, x$2);
    }

    @Override
    public void reportSus(Sus x$1, String x$2) {
        OutputReporter$class.reportSus(this, x$1, x$2);
    }

    public void reportSystems(Iterable x$1, String x$2) {
        OutputReporter$class.reportSystems(this, x$1, x$2);
    }

    public Tuple5 stats(Example x$1) {
        return OutputReporter$class.stats((OutputReporter)this, x$1);
    }

    public Tuple5 stats(Sus x$1) {
        return OutputReporter$class.stats((OutputReporter)this, x$1);
    }

    public Tuple5 stats(Specification x$1) {
        return OutputReporter$class.stats((OutputReporter)this, x$1);
    }

    public OutputReporter.AddableTuple toAddableTuple(Tuple5 x$1) {
        return OutputReporter$class.toAddableTuple(this, x$1);
    }

    @Override
    public OutputReporter reportSpec(Specification x$1, String x$2) {
        return OutputReporter$class.reportSpec(this, x$1, x$2);
    }

    public OutputReporter report(Seq x$1, String x$2) {
        return OutputReporter$class.report(this, x$1, x$2);
    }

    public OutputReporter report(Seq x$1) {
        return OutputReporter$class.report(this, x$1);
    }

    @Override
    public String infoColored(String x$1) {
        return OutputReporter$class.infoColored(this, x$1);
    }

    @Override
    public String skipColored(String x$1) {
        return OutputReporter$class.skipColored(this, x$1);
    }

    @Override
    public String successColored(String x$1) {
        return OutputReporter$class.successColored(this, x$1);
    }

    @Override
    public String failureColored(String x$1) {
        return OutputReporter$class.failureColored(this, x$1);
    }

    @Override
    public final OutputReporter org$specs$runner$OutputReporter$$super$report(Seq x$1) {
        return (OutputReporter)Reporter$class.report(this, x$1);
    }
}

