/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import java.rmi.RemoteException;
import java.util.regex.Pattern;
import org.specs.Specification;
import org.specs.io.ConsoleOutput$class;
import org.specs.io.Output$class;
import org.specs.log.Log$class;
import org.specs.runner.Notifier;
import org.specs.runner.NotifierRunner$;
import org.specs.runner.NotifierRunner$totalSpecification$2$;
import org.specs.runner.Reporter;
import org.specs.runner.Reporter$class;
import org.specs.runner.SpecsFilter;
import org.specs.runner.SpecsFilter$class;
import org.specs.specification.Example;
import org.specs.specification.Examples;
import org.specs.specification.Sus;
import org.specs.util.Property;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifierRunner
implements Reporter,
ScalaObject {
    public volatile int bitmap$0;
    private final Pattern exampleFilter;
    private final Pattern susFilter;
    private final List filteredSpecs;
    private int level;
    private final int Error;
    private final int Warning;
    private final int Info;
    private final int Debug;
    private String[] org$specs$runner$Reporter$$specArgs;
    private final Property planOnly;
    private final Property colorize;
    private final Property finalStatisticsOnly;
    private final Property statistics;
    private final Property failedAndErrorsOnly;
    private final Property stacktrace;
    private final Property org$specs$runner$Reporter$$userConfiguration;
    private final Notifier[] notifiers;
    private final Specification[] specs;

    public NotifierRunner(Specification[] specs, Notifier[] notifiers) {
        this.specs = specs;
        this.notifiers = notifiers;
        SpecsFilter$class.$init$(this);
        Output$class.$init$(this);
        ConsoleOutput$class.$init$(this);
        Log$class.$init$(this);
        Reporter$class.$init$(this);
    }

    private final NotifierRunner$totalSpecification$2$ totalSpecification$1(ObjectRef objectRef) {
        if ((NotifierRunner$totalSpecification$2$)objectRef.elem == null) {
            objectRef.elem = new NotifierRunner$totalSpecification$2$(this);
        }
        return (NotifierRunner$totalSpecification$2$)objectRef.elem;
    }

    public NotifierRunner reportExample(Examples example$1, boolean planOnly$2) {
        new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportExample$1(this, example$1));
        if (!planOnly$2 && example$1.isOk()) {
            new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportExample$2(this, example$1));
        } else if (planOnly$2 || example$1.failures().isEmpty()) {
            if (planOnly$2 || example$1.errors().isEmpty()) {
                if (!planOnly$2 && !example$1.skipped().isEmpty()) {
                    new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportExample$5(this, example$1));
                }
            } else {
                new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportExample$4(this, example$1));
            }
        } else {
            new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportExample$3(this, example$1));
        }
        if (!planOnly$2) {
            example$1.examples().foreach((Function1)new $anonfun$reportExample$6(this, planOnly$2));
        }
        new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportExample$7(this, example$1));
        return this;
    }

    public NotifierRunner reportSystem(Sus system$1, boolean planOnly$3) {
        new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportSystem$1(this, system$1));
        if (planOnly$3 || system$1.ownFailures().isEmpty()) {
            if (planOnly$3 || system$1.ownErrors().isEmpty()) {
                if (!planOnly$3 && !system$1.ownSkipped().isEmpty()) {
                    new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportSystem$4(this, system$1));
                }
            } else {
                new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportSystem$3(this, system$1));
            }
        } else {
            new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportSystem$2(this, system$1));
        }
        system$1.examples().foreach((Function1)new $anonfun$reportSystem$5(this, planOnly$3));
        new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportSystem$6(this, system$1));
        return this;
    }

    public NotifierRunner reportASpecification(Specification spec$1, boolean planOnly$1) {
        new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportASpecification$1(this, spec$1));
        spec$1.subSpecifications().foreach((Function1)new $anonfun$reportASpecification$2(this, planOnly$1));
        spec$1.systems().foreach((Function1)new $anonfun$reportASpecification$3(this, planOnly$1));
        new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$reportASpecification$4(this, spec$1));
        return this;
    }

    @Override
    public NotifierRunner report(Seq<Specification> specs) {
        Specification specification;
        Reporter$class.report(this, specs);
        Seq filteredSpecs = specs.flatMap((Function1)new $anonfun$1(this));
        if (filteredSpecs.size() == 1) {
            specification = (Specification)filteredSpecs.apply((Object)BoxesRunTime.boxToInteger((int)0));
        } else {
            ObjectRef totalSpecification$module$1 = new ObjectRef(null);
            specification = this.totalSpecification$1(totalSpecification$module$1);
        }
        Specification specToRun$1 = specification;
        new BoxedObjectArray((Object[])this.notifiers()).foreach((Function1)new $anonfun$report$1(this, specToRun$1));
        return this.reportASpecification(specToRun$1, BoxesRunTime.unboxToBoolean((Object)specToRun$1.planOnly().apply()));
    }

    public NotifierRunner(Specification s2, Notifier n2) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new Specification[]{s2})), Specification.class);
        Specification[] specificationArray = (Specification[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Specification.class) : object);
        Object object2 = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new Notifier[]{n2})), Notifier.class);
        this(specificationArray, (Notifier[])(object2 instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object2, Notifier.class) : object2));
    }

    public Notifier[] notifiers() {
        return this.notifiers;
    }

    public Specification[] specs() {
        return this.specs;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    @Override
    public String examplePattern() {
        return SpecsFilter$class.examplePattern(this);
    }

    @Override
    public String susPattern() {
        return SpecsFilter$class.susPattern(this);
    }

    public Option filterExample(Example x$1) {
        return SpecsFilter$class.filterExample(this, x$1);
    }

    public Option filter(Sus x$1) {
        return SpecsFilter$class.filter((SpecsFilter)this, x$1);
    }

    public Option filter(Specification x$1) {
        return SpecsFilter$class.filter((SpecsFilter)this, x$1);
    }

    public List filter(Seq x$1) {
        return SpecsFilter$class.filter((SpecsFilter)this, x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Pattern exampleFilter() {
        if ((this.bitmap$0 & 0x10) != 0) return this.exampleFilter;
        NotifierRunner notifierRunner = this;
        synchronized (notifierRunner) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.exampleFilter = SpecsFilter$class.exampleFilter(this);
                this.bitmap$0 |= 0x10;
            }
            return this.exampleFilter;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Pattern susFilter() {
        if ((this.bitmap$0 & 4) != 0) return this.susFilter;
        NotifierRunner notifierRunner = this;
        synchronized (notifierRunner) {
            if ((this.bitmap$0 & 4) == 0) {
                this.susFilter = SpecsFilter$class.susFilter(this);
                this.bitmap$0 |= 4;
            }
            return this.susFilter;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List filteredSpecs() {
        if ((this.bitmap$0 & 1) != 0) return this.filteredSpecs;
        NotifierRunner notifierRunner = this;
        synchronized (notifierRunner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.filteredSpecs = SpecsFilter$class.filteredSpecs(this);
                this.bitmap$0 |= 1;
            }
            return this.filteredSpecs;
        }
    }

    @Override
    public void printStackTrace(Throwable x$1) {
        Output$class.printStackTrace(this, x$1);
    }

    @Override
    public void flush() {
        ConsoleOutput$class.flush(this);
    }

    public void printf(String x$1, Seq x$2) {
        ConsoleOutput$class.printf(this, x$1, x$2);
    }

    @Override
    public void println(Object x$1) {
        ConsoleOutput$class.println(this, x$1);
    }

    public void error(Function0 x$1) {
        Log$class.error(this, x$1);
    }

    public void warning(Function0 x$1) {
        Log$class.warning(this, x$1);
    }

    public void info(Function0 x$1) {
        Log$class.info(this, x$1);
    }

    public void debug(Function0 x$1) {
        Log$class.debug(this, x$1);
    }

    @Override
    public void Error_$eq(int x$1) {
        this.Error = x$1;
    }

    @Override
    public void Warning_$eq(int x$1) {
        this.Warning = x$1;
    }

    @Override
    public void Info_$eq(int x$1) {
        this.Info = x$1;
    }

    @Override
    public void Debug_$eq(int x$1) {
        this.Debug = x$1;
    }

    @Override
    public void level_$eq(int x$1) {
        this.level = x$1;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public int Error() {
        return this.Error;
    }

    @Override
    public int Warning() {
        return this.Warning;
    }

    @Override
    public int Info() {
        return this.Info;
    }

    @Override
    public int Debug() {
        return this.Debug;
    }

    public List $colon$colon(Reporter x$1) {
        return Reporter$class.$colon$colon(this, x$1);
    }

    public Option argValue(String[] x$1, List x$2) {
        return Reporter$class.argValue(this, x$1, x$2);
    }

    public void setTags(Seq x$1) {
        Reporter$class.setTags(this, x$1);
    }

    @Override
    public Reporter reportSpecs() {
        return Reporter$class.reportSpecs(this);
    }

    @Override
    public String exampleFilterPattern() {
        return Reporter$class.exampleFilterPattern(this);
    }

    @Override
    public String susFilterPattern() {
        return Reporter$class.susFilterPattern(this);
    }

    @Override
    public void displayOptionsDescription() {
        Reporter$class.displayOptionsDescription(this);
    }

    @Override
    public void displayOptions() {
        Reporter$class.displayOptions(this);
    }

    @Override
    public void displayUsage() {
        Reporter$class.displayUsage(this);
    }

    @Override
    public void displayHelp() {
        Reporter$class.displayHelp(this);
    }

    @Override
    public void exit(int x$1) {
        Reporter$class.exit(this, x$1);
    }

    @Override
    public void main(String[] x$1) {
        Reporter$class.main(this, x$1);
    }

    @Override
    public void args_$eq(String[] x$1) {
        Reporter$class.args_$eq(this, x$1);
    }

    @Override
    public String[] args() {
        return Reporter$class.args(this);
    }

    @Override
    public Object runConfiguration() {
        return Reporter$class.runConfiguration(this);
    }

    @Override
    public Reporter setOptionsFromConfig() {
        return Reporter$class.setOptionsFromConfig(this);
    }

    @Override
    public Reporter resetOptions() {
        return Reporter$class.resetOptions(this);
    }

    @Override
    public Reporter setPlanOnly() {
        return Reporter$class.setPlanOnly(this);
    }

    @Override
    public Reporter setColorize() {
        return Reporter$class.setColorize(this);
    }

    @Override
    public Reporter setFinalStatisticsOnly() {
        return Reporter$class.setFinalStatisticsOnly(this);
    }

    @Override
    public Reporter setNoStatistics() {
        return Reporter$class.setNoStatistics(this);
    }

    @Override
    public Reporter setFailedAndErrorsOnly() {
        return Reporter$class.setFailedAndErrorsOnly(this);
    }

    @Override
    public Reporter setNoStacktrace() {
        return Reporter$class.setNoStacktrace(this);
    }

    public Reporter setConfiguration(Option x$1) {
        return Reporter$class.setConfiguration(this, x$1);
    }

    @Override
    public void planOnly_$eq(Property x$1) {
        this.planOnly = x$1;
    }

    @Override
    public void colorize_$eq(Property x$1) {
        this.colorize = x$1;
    }

    @Override
    public void finalStatisticsOnly_$eq(Property x$1) {
        this.finalStatisticsOnly = x$1;
    }

    @Override
    public void statistics_$eq(Property x$1) {
        this.statistics = x$1;
    }

    @Override
    public void failedAndErrorsOnly_$eq(Property x$1) {
        this.failedAndErrorsOnly = x$1;
    }

    @Override
    public void stacktrace_$eq(Property x$1) {
        this.stacktrace = x$1;
    }

    @Override
    public void org$specs$runner$Reporter$$userConfiguration_$eq(Property x$1) {
        this.org$specs$runner$Reporter$$userConfiguration = x$1;
    }

    @Override
    public final void org$specs$runner$Reporter$$specArgs_$eq(String[] x$1) {
        this.org$specs$runner$Reporter$$specArgs = x$1;
    }

    @Override
    public final String[] org$specs$runner$Reporter$$specArgs() {
        return this.org$specs$runner$Reporter$$specArgs;
    }

    public Property planOnly() {
        return this.planOnly;
    }

    public Property colorize() {
        return this.colorize;
    }

    public Property finalStatisticsOnly() {
        return this.finalStatisticsOnly;
    }

    public Property statistics() {
        return this.statistics;
    }

    public Property failedAndErrorsOnly() {
        return this.failedAndErrorsOnly;
    }

    public Property stacktrace() {
        return this.stacktrace;
    }

    @Override
    public final Property org$specs$runner$Reporter$$userConfiguration() {
        return this.org$specs$runner$Reporter$$userConfiguration;
    }
}

