/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import java.rmi.RemoteException;
import org.scalatools.testing.Event;
import org.scalatools.testing.EventHandler;
import org.scalatools.testing.Logger;
import org.specs.runner.AnsiColors$;
import org.specs.runner.HandlerEvents;
import org.specs.runner.HandlerEvents$class;
import org.specs.runner.Notifier;
import org.specs.runner.TestInterfaceNotifier$;
import org.specs.runner.TestLoggers;
import org.specs.runner.TestLoggers$class;
import org.specs.util.Configuration;
import org.specs.util.DefaultConfiguration;
import org.specs.util.ExtendedThrowable$;
import scala.Function1;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.runtime.BoxedObjectArray;

public class TestInterfaceNotifier
implements Notifier,
HandlerEvents,
TestLoggers,
ScalaObject {
    private String padding;
    private final Configuration configuration;
    private final Logger[] loggers;
    private final EventHandler handler;

    public TestInterfaceNotifier(EventHandler handler, Logger[] loggers, Configuration configuration) {
        this.handler = handler;
        this.loggers = loggers;
        this.configuration = configuration;
        HandlerEvents$class.$init$(this);
        TestLoggers$class.$init$(this);
    }

    public void systemCompleted(String systemName) {
        this.decrementPadding();
    }

    public void systemSkipped(String testName) {
        this.logStatus(testName, AnsiColors$.MODULE$.yellow(), "o");
        this.handler.handle((Event)this.skipped(testName));
    }

    public void systemError(String testName, Throwable e2) {
        this.logStatus(testName, AnsiColors$.MODULE$.red(), "x");
        this.logStatus(e2.getMessage(), AnsiColors$.MODULE$.red(), "  ");
        this.handler.handle((Event)this.error(testName, e2));
    }

    public void systemFailed(String testName, Throwable e2) {
        this.logStatus(testName, AnsiColors$.MODULE$.red(), "x");
        this.logStatus(e2.getMessage(), AnsiColors$.MODULE$.red(), "  ");
        this.handler.handle((Event)this.failure(testName, e2));
    }

    public void systemSucceeded(String testName) {
        this.logStatus(testName, AnsiColors$.MODULE$.green(), "+");
        this.handler.handle((Event)this.succeeded(testName));
    }

    public void systemStarting(String systemName) {
        this.logInfo(systemName, AnsiColors$.MODULE$.blue());
    }

    public void exampleSkipped(String testName) {
        this.logStatus(testName, AnsiColors$.MODULE$.yellow(), "o");
        this.handler.handle((Event)this.skipped(testName));
    }

    public void exampleError(String testName, Throwable e2) {
        this.logStatus(testName, AnsiColors$.MODULE$.red(), "x");
        this.logStatus(new StringBuilder().append((Object)e2.getMessage()).append((Object)" (").append((Object)ExtendedThrowable$.MODULE$.toExtendedThrowable(e2).location()).append((Object)")").toString(), AnsiColors$.MODULE$.red(), " ");
        if (this.configuration.stacktrace()) {
            new BoxedObjectArray((Object[])e2.getStackTrace()).foreach((Function1)new $anonfun$exampleError$1(this));
        }
        this.handler.handle((Event)this.error(testName, e2));
    }

    public void exampleFailed(String testName, Throwable e2) {
        this.logStatus(testName, AnsiColors$.MODULE$.red(), "x");
        this.logStatus(new StringBuilder().append((Object)e2.getMessage()).append((Object)" (").append((Object)ExtendedThrowable$.MODULE$.toExtendedThrowable(e2).location()).append((Object)")").toString(), AnsiColors$.MODULE$.red(), " ");
        this.handler.handle((Event)this.failure(testName, e2));
    }

    public void exampleSucceeded(String testName) {
        this.logStatus(testName, AnsiColors$.MODULE$.green(), "+");
        this.handler.handle((Event)this.succeeded(testName));
    }

    public void exampleCompleted(String exampleName) {
        this.decrementPadding();
    }

    public void exampleStarting(String exampleName) {
        this.incrementPadding();
    }

    public void runStarting(int examplesCount) {
    }

    public TestInterfaceNotifier(EventHandler handler, Logger[] loggers) {
        this(handler, loggers, new DefaultConfiguration());
    }

    public Logger[] loggers() {
        return this.loggers;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    public HandlerEvents.NamedEvent skipped(String x$1) {
        return HandlerEvents$class.skipped(this, x$1);
    }

    public HandlerEvents.NamedEvent error(String x$1, Throwable x$2) {
        return HandlerEvents$class.error(this, x$1, x$2);
    }

    public HandlerEvents.NamedEvent failure(String x$1, Throwable x$2) {
        return HandlerEvents$class.failure(this, x$1, x$2);
    }

    public HandlerEvents.NamedEvent succeeded(String x$1) {
        return HandlerEvents$class.succeeded(this, x$1);
    }

    public void decrementPadding() {
        TestLoggers$class.decrementPadding(this);
    }

    public void incrementPadding() {
        TestLoggers$class.incrementPadding(this);
    }

    public void logStatus(String x$1, String x$2, String x$3) {
        TestLoggers$class.logStatus(this, x$1, x$2, x$3);
    }

    public void logInfo(String x$1, String x$2) {
        TestLoggers$class.logInfo(this, x$1, x$2);
    }

    public void logError(String x$1) {
        TestLoggers$class.logError(this, x$1);
    }

    public void padding_$eq(String x$1) {
        this.padding = x$1;
    }

    public String padding() {
        return this.padding;
    }
}

