/*
 * Decompiled with CFR 0.152.
 */
package org.scalacheck.time;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.Gen$Choose$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface JavaTimeArbitrary {
    public static void $init$(JavaTimeArbitrary $this) {
    }

    public static Duration org$scalacheck$time$JavaTimeArbitrary$$minJavaDuration$(JavaTimeArbitrary $this) {
        return $this.org$scalacheck$time$JavaTimeArbitrary$$minJavaDuration();
    }

    default public Duration org$scalacheck$time$JavaTimeArbitrary$$minJavaDuration() {
        return Duration.ofSeconds(Long.MIN_VALUE);
    }

    public static Duration org$scalacheck$time$JavaTimeArbitrary$$maxJavaDuration$(JavaTimeArbitrary $this) {
        return $this.org$scalacheck$time$JavaTimeArbitrary$$maxJavaDuration();
    }

    default public Duration org$scalacheck$time$JavaTimeArbitrary$$maxJavaDuration() {
        return Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    }

    public static Arbitrary arbJavaDuration$(JavaTimeArbitrary $this) {
        return $this.arbJavaDuration();
    }

    default public Arbitrary<Duration> arbJavaDuration() {
        return Arbitrary$.MODULE$.apply(this::arbJavaDuration$$anonfun$1);
    }

    public static Arbitrary arbInstant$(JavaTimeArbitrary $this) {
        return $this.arbInstant();
    }

    default public Arbitrary<Instant> arbInstant() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbInstant$$anonfun$1);
    }

    public static Arbitrary arbYear$(JavaTimeArbitrary $this) {
        return $this.arbYear();
    }

    default public Arbitrary<Year> arbYear() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbYear$$anonfun$1);
    }

    public static Arbitrary arbLocalDate$(JavaTimeArbitrary $this) {
        return $this.arbLocalDate();
    }

    default public Arbitrary<LocalDate> arbLocalDate() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbLocalDate$$anonfun$1);
    }

    public static Arbitrary arbLocalTime$(JavaTimeArbitrary $this) {
        return $this.arbLocalTime();
    }

    default public Arbitrary<LocalTime> arbLocalTime() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbLocalTime$$anonfun$1);
    }

    public static Arbitrary arbLocalDateTime$(JavaTimeArbitrary $this) {
        return $this.arbLocalDateTime();
    }

    default public Arbitrary<LocalDateTime> arbLocalDateTime() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbLocalDateTime$$anonfun$1);
    }

    public static Arbitrary arbMonthDay$(JavaTimeArbitrary $this) {
        return $this.arbMonthDay();
    }

    default public Arbitrary<MonthDay> arbMonthDay() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbMonthDay$$anonfun$1);
    }

    public static Arbitrary arbZoneOffset$(JavaTimeArbitrary $this) {
        return $this.arbZoneOffset();
    }

    default public Arbitrary<ZoneOffset> arbZoneOffset() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbZoneOffset$$anonfun$1);
    }

    public static Set org$scalacheck$time$JavaTimeArbitrary$$availableZoneIds$(JavaTimeArbitrary $this) {
        return $this.org$scalacheck$time$JavaTimeArbitrary$$availableZoneIds();
    }

    default public Set<ZoneId> org$scalacheck$time$JavaTimeArbitrary$$availableZoneIds() {
        return (Set)Predef$.MODULE$.wrapRefArray(ZoneId.getAvailableZoneIds().toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))).toSet().map((Function1 & Serializable)value -> ZoneId.of(value));
    }

    public static Arbitrary arbZoneId$(JavaTimeArbitrary $this) {
        return $this.arbZoneId();
    }

    default public Arbitrary<ZoneId> arbZoneId() {
        return Arbitrary$.MODULE$.apply(this::arbZoneId$$anonfun$1);
    }

    public static Arbitrary arbOffsetTime$(JavaTimeArbitrary $this) {
        return $this.arbOffsetTime();
    }

    default public Arbitrary<OffsetTime> arbOffsetTime() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbOffsetTime$$anonfun$1);
    }

    public static Arbitrary arbOffsetDateTime$(JavaTimeArbitrary $this) {
        return $this.arbOffsetDateTime();
    }

    default public Arbitrary<OffsetDateTime> arbOffsetDateTime() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbOffsetDateTime$$anonfun$1);
    }

    public static Arbitrary arbPeriod$(JavaTimeArbitrary $this) {
        return $this.arbPeriod();
    }

    default public Arbitrary<Period> arbPeriod() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbPeriod$$anonfun$1);
    }

    public static Arbitrary arbYearMonth$(JavaTimeArbitrary $this) {
        return $this.arbYearMonth();
    }

    default public Arbitrary<YearMonth> arbYearMonth() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbYearMonth$$anonfun$1);
    }

    public static Arbitrary arbZonedDateTime$(JavaTimeArbitrary $this) {
        return $this.arbZonedDateTime();
    }

    default public Arbitrary<ZonedDateTime> arbZonedDateTime() {
        return Arbitrary$.MODULE$.apply(JavaTimeArbitrary::arbZonedDateTime$$anonfun$1);
    }

    private Gen arbJavaDuration$$anonfun$1() {
        return Gen$.MODULE$.choose(this.org$scalacheck$time$JavaTimeArbitrary$$minJavaDuration(), this.org$scalacheck$time$JavaTimeArbitrary$$maxJavaDuration(), Gen$Choose$.MODULE$.chooseJavaDuration());
    }

    private static Gen arbInstant$$anonfun$1() {
        return Gen$.MODULE$.choose(Instant.MIN, Instant.MAX, Gen$Choose$.MODULE$.chooseInstant());
    }

    private static Gen arbYear$$anonfun$1() {
        return Gen$.MODULE$.choose(Year.of(-999999999), Year.of(-999999999), Gen$Choose$.MODULE$.chooseYear());
    }

    private static Gen arbLocalDate$$anonfun$1() {
        return Gen$.MODULE$.choose(LocalDate.MIN, LocalDate.MAX, Gen$Choose$.MODULE$.chooseLocalDate());
    }

    private static Gen arbLocalTime$$anonfun$1() {
        return Gen$.MODULE$.choose(LocalTime.MIN, LocalTime.MAX, Gen$Choose$.MODULE$.chooseLocalTime());
    }

    private static Gen arbLocalDateTime$$anonfun$1() {
        return Gen$.MODULE$.choose(LocalDateTime.MIN, LocalDateTime.MAX, Gen$Choose$.MODULE$.chooseLocalDateTime());
    }

    private static Gen arbMonthDay$$anonfun$1() {
        return Gen$.MODULE$.choose(MonthDay.of(Month.JANUARY, 1), MonthDay.of(Month.DECEMBER, 31), Gen$Choose$.MODULE$.chooseMonthDay());
    }

    private static Gen arbZoneOffset$$anonfun$1() {
        return Gen$.MODULE$.oneOf(Gen$.MODULE$.oneOf(ZoneOffset.MAX, ZoneOffset.MIN, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ZoneOffset[]{ZoneOffset.UTC})), Gen$.MODULE$.choose(ZoneOffset.MAX, ZoneOffset.MIN, Gen$Choose$.MODULE$.chooseZoneOffset()), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gen[0]));
    }

    private Gen arbZoneId$$anonfun$1() {
        return Gen$.MODULE$.oneOf(Gen$.MODULE$.oneOf(this.org$scalacheck$time$JavaTimeArbitrary$$availableZoneIds()), this.arbZoneOffset().arbitrary(), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gen[0]));
    }

    private static Gen arbOffsetTime$$anonfun$1() {
        return Gen$.MODULE$.choose(OffsetTime.MIN, OffsetTime.MAX, Gen$Choose$.MODULE$.chooseOffsetTime());
    }

    private static Gen arbOffsetDateTime$$anonfun$1() {
        return Gen$.MODULE$.choose(OffsetDateTime.MIN, OffsetDateTime.MAX, Gen$Choose$.MODULE$.chooseOffsetDateTime());
    }

    private static /* synthetic */ Period arbPeriod$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(int years$2, int months$1, int days) {
        return Period.of(years$2, months$1, days);
    }

    private static /* synthetic */ Gen arbPeriod$$anonfun$4$$anonfun$3$$anonfun$3(int years$1, int months) {
        return Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbInt()).map((Function1 & Serializable)days -> JavaTimeArbitrary.arbPeriod$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(years$1, months, BoxesRunTime.unboxToInt((Object)days)));
    }

    private static /* synthetic */ Gen arbPeriod$$anonfun$6$$anonfun$5(int years) {
        return Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbInt()).flatMap((Function1 & Serializable)months -> JavaTimeArbitrary.arbPeriod$$anonfun$4$$anonfun$3$$anonfun$3(years, BoxesRunTime.unboxToInt((Object)months)));
    }

    private static Gen arbPeriod$$anonfun$1() {
        return Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbInt()).flatMap((Function1 & Serializable)years -> JavaTimeArbitrary.arbPeriod$$anonfun$6$$anonfun$5(BoxesRunTime.unboxToInt((Object)years)));
    }

    private static Gen arbYearMonth$$anonfun$1() {
        return Gen$.MODULE$.choose(YearMonth.of(-999999999, Month.JANUARY), YearMonth.of(999999999, Month.DECEMBER), Gen$Choose$.MODULE$.chooseYearMonth());
    }

    private static Gen arbZonedDateTime$$anonfun$1() {
        return Gen$.MODULE$.choose(ZonedDateTime.of(LocalDateTime.MIN, ZoneOffset.MAX), ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.MIN), Gen$Choose$.MODULE$.chooseZonedDateTime());
    }
}

