/*
 * Decompiled with CFR 0.152.
 */
package scalafx.collections;

import java.io.Serializable;
import javafx.collections.ArrayChangeListener;
import scala.Function0;
import scala.Function2;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scalafx.beans.Observable;
import scalafx.collections.ObservableArray$Change$;
import scalafx.event.subscriptions.Subscription;

public abstract class ObservableArray<V, T extends ObservableArray<V, T, D>, D extends javafx.collections.ObservableArray<D>>
implements Builder<V, T>,
Observable {
    private final javafx.collections.ObservableArray delegate;

    public ObservableArray(D delegate, ClassTag<V> evidence$1) {
        this.delegate = delegate;
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
    }

    @Override
    public D delegate() {
        return (D)this.delegate;
    }

    public void trimToSize() {
        this.delegate().trimToSize();
    }

    public void ensureCapacity(int capacity) {
        this.delegate().ensureCapacity(capacity);
    }

    public abstract void copyTo(int var1, Object var2, int var3, int var4);

    public abstract void copyTo(int var1, T var2, int var3, int var4);

    public abstract V get(int var1);

    public abstract void addAll(T var1);

    public abstract void addAll(Seq<V> var1);

    public abstract void addAll(Object var1, int var2, int var3);

    public abstract void addAll(T var1, int var2, int var3);

    public abstract void setAll(Seq<V> var1);

    public abstract void setAll(T var1);

    public abstract void setAll(Object var1, int var2, int var3);

    public abstract void setAll(T var1, int var2, int var3);

    public abstract void set(int var1, V var2);

    public abstract void set(int var1, Object var2, int var3, int var4);

    public abstract void set(int var1, T var2, int var3, int var4);

    public Object toArray() {
        return this.toArray(null);
    }

    public abstract Object toArray(Object var1);

    public abstract Object toArray(int var1, Object var2, int var3);

    public V apply(int idx) {
        return this.get(idx);
    }

    public void update(int idx, V value) {
        this.set(idx, value);
    }

    public int size() {
        return this.delegate().size();
    }

    public int length() {
        return this.size();
    }

    public T $plus$plus$eq(Object src) {
        this.addAll((Seq<V>)ScalaRunTime$.MODULE$.genericWrapArray(src));
        return (T)this;
    }

    public T $plus$plus$eq(T src) {
        this.addAll(src);
        return (T)this;
    }

    public void clear() {
        this.delegate().clear();
    }

    public T result() {
        return (T)this;
    }

    public ObservableArray addOne(V elem) {
        this.addAll((Seq<V>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{elem}));
        return this;
    }

    public boolean isEmpty() {
        return !this.nonEmpty();
    }

    public boolean nonEmpty() {
        return this.delegate().size() > 0;
    }

    public Subscription onChange(Function2<T, Change, BoxedUnit> op) {
        ArrayChangeListener listener = new ArrayChangeListener<D>(op, this){
            private final Function2 op$1;
            private final /* synthetic */ ObservableArray $outer;
            {
                this.op$1 = op$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onChanged(javafx.collections.ObservableArray array, boolean sizeChanged, int start, int end) {
                this.op$1.apply((Object)this.$outer, (Object)ObservableArray$Change$.MODULE$.apply(sizeChanged, start, end));
            }
        };
        this.delegate().addListener(listener);
        return new Subscription(listener, this){
            private final ArrayChangeListener listener$1;
            private final /* synthetic */ ObservableArray $outer;
            {
                this.listener$1 = listener$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void cancel() {
                this.$outer.delegate().removeListener(this.listener$1);
            }
        };
    }

    public Subscription onChange(Function0<BoxedUnit> op) {
        ArrayChangeListener listener = new ArrayChangeListener<D>(op){
            private final Function0 op$2;
            {
                this.op$2 = op$4;
            }

            public void onChanged(javafx.collections.ObservableArray array, boolean sizeChanged, int start, int end) {
                this.op$2.apply$mcV$sp();
            }
        };
        this.delegate().addListener(listener);
        return new Subscription(listener, this){
            private final ArrayChangeListener listener$2;
            private final /* synthetic */ ObservableArray $outer;
            {
                this.listener$2 = listener$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void cancel() {
                this.$outer.delegate().removeListener(this.listener$2);
            }
        };
    }

    public static class Change
    implements Product,
    Serializable {
        private final boolean sizeChanged;
        private final int start;
        private final int end;

        public static Change apply(boolean bl, int n, int n2) {
            return ObservableArray$Change$.MODULE$.apply(bl, n, n2);
        }

        public static Change fromProduct(Product product) {
            return ObservableArray$Change$.MODULE$.fromProduct(product);
        }

        public static Change unapply(Change change) {
            return ObservableArray$Change$.MODULE$.unapply(change);
        }

        public Change(boolean sizeChanged, int start, int end) {
            this.sizeChanged = sizeChanged;
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.sizeChanged() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.start());
            n = Statics.mix((int)n, (int)this.end());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Change)) return false;
            Change change = (Change)object;
            if (this.sizeChanged() != change.sizeChanged()) return false;
            if (this.start() != change.start()) return false;
            if (this.end() != change.end()) return false;
            if (!change.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Change;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Change";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "sizeChanged";
                }
                case 1: {
                    return "start";
                }
                case 2: {
                    return "end";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean sizeChanged() {
            return this.sizeChanged;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public Change copy(boolean sizeChanged, int start, int end) {
            return new Change(sizeChanged, start, end);
        }

        public boolean copy$default$1() {
            return this.sizeChanged();
        }

        public int copy$default$2() {
            return this.start();
        }

        public int copy$default$3() {
            return this.end();
        }

        public boolean _1() {
            return this.sizeChanged();
        }

        public int _2() {
            return this.start();
        }

        public int _3() {
            return this.end();
        }
    }
}

