/*
 * Copyright (c) 2011-2025, ScalaFX Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the ScalaFX Project nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE SCALAFX PROJECT OR ITS CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package scalafx.beans.binding

import javafx.beans.binding as jfxbb
import javafx.collections as jfxc
import scalafx.beans.value.ObservableValue
import scalafx.collections.CollectionIncludes.observableList2ObservableBuffer
import scalafx.collections.ObservableBuffer

import scala.language.implicitConversions

object BufferBinding {

  /**
   * Converts a ScalaFX BufferBinding to its JavaFX counterpart LisBinding.
   *
   * @param v ScalaFX BufferBinding
   * @return JavaFX ListBinding
   */
  implicit def sfxBufferBinding2jfx[E <: Any](v: BufferBinding[E]): jfxbb.ListBinding[E] =
    if (v != null) v.delegate else null
}

/**
 * Wraps a $JFX $URL0 ListBinding]].
 *
 * @define TC          BufferBinding
 * @define URL0        [[https://docs.oracle.com/javase/8/javafx/api/javafx/beans/binding/ListBinding.html
 * @define JFX         JavaFX
 * @define ORIGINALDOC Original Documentation]].
 */
class BufferBinding[E <: Any](override val delegate: jfxbb.ListBinding[E])
    extends BufferExpression(delegate)
    with ObservableValue[ObservableBuffer[E], jfxc.ObservableList[E]] {

  override def value: ObservableBuffer[E] = delegate.get
}
