/*
 * Copyright (c) 2011-2025, ScalaFX Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the ScalaFX Project nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE SCALAFX PROJECT OR ITS CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package scalafx.scene

import javafx.scene as jfxs
import scalafx.Includes.*
import scalafx.delegate.SFXDelegate
import scalafx.geometry.Rectangle2D
import scalafx.scene.paint.Paint
import scalafx.scene.transform.Transform

import scala.language.implicitConversions

object SnapshotParameters {
  implicit def sfxSnapshotParameters2jfx(sp: SnapshotParameters): jfxs.SnapshotParameters =
    if (sp != null) sp.delegate else null
}

/**
 * Wraps [[http://docs.oracle.com/javase/8/javafx/api/javafx/scene/SnapshotParameters.html]]
 *
 * @since 2.2
 */
class SnapshotParameters(override val delegate: jfxs.SnapshotParameters = new jfxs.SnapshotParameters)
    extends SFXDelegate[jfxs.SnapshotParameters] {

  /**
   * The current camera.
   */
  def camera: Camera = delegate.getCamera

  def camera_=(c: Camera): Unit = {
    delegate.setCamera(c)
  }

  /**
   * The current depthBuffer flag.
   */
  def depthBuffer: Boolean = delegate.isDepthBuffer

  def depthBuffer_=(db: Boolean): Unit = {
    delegate.setDepthBuffer(db)
  }

  /**
   * The current fill.
   */
  def fill: Paint = delegate.getFill

  def fill_=(p: Paint): Unit = {
    delegate.setFill(p)
  }

  /**
   * The current transform.
   */
  def transform: Transform = delegate.getTransform

  def transform_=(t: Transform): Unit = {
    delegate.setTransform(t)
  }

  /**
   * The current viewport.
   */
  def viewport: Rectangle2D = delegate.getViewport

  def viewport_=(v: Rectangle2D): Unit = {
    delegate.setViewport(v)
  }

}
