/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scalaj.http.HttpConstants$;
import scalaj.http.HttpRequest;
import scalaj.http.Token;

public final class OAuth$ {
    public static final OAuth$ MODULE$;
    private final String MAC;

    static {
        new OAuth$();
    }

    public String MAC() {
        return this.MAC;
    }

    public HttpRequest sign(HttpRequest req, Token consumer, Option<Token> token, Option<String> verifier) {
        return req.option((Function1<HttpURLConnection, BoxedUnit>)new Serializable(req, consumer, token, verifier){
            public static final long serialVersionUID = 0L;
            private final HttpRequest req$1;
            private final Token consumer$1;
            private final Option token$1;
            private final Option verifier$1;

            public final void apply(HttpURLConnection conn) {
                Seq baseParams = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"oauth_timestamp", (Object)((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() / 1000L))).toString()), new Tuple2((Object)"oauth_nonce", (Object)((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString())}));
                Tuple2<Seq<Tuple2<String, String>>, String> tuple2 = OAuth$.MODULE$.getSig((Seq<Tuple2<String, String>>)baseParams, this.req$1, this.consumer$1, (Option<Token>)this.token$1, (Option<String>)this.verifier$1);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Seq oauthParams = (Seq)tuple2._1();
                    String signature = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)oauthParams, (Object)signature);
                    Seq oauthParams2 = (Seq)tuple23._1();
                    String signature2 = (String)tuple23._2();
                    oauthParams2 = (Seq)oauthParams2.$plus$colon((Object)new Tuple2((Object)"oauth_signature", (Object)signature2), Seq$.MODULE$.canBuildFrom());
                    conn.setRequestProperty("Authorization", new StringBuilder().append((Object)"OAuth ").append((Object)((TraversableOnce)oauthParams2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, String> p) {
                            return new StringBuilder().append((Object)((String)p._1())).append((Object)"=\"").append((Object)OAuth$.MODULE$.percentEncode((String)p._2())).append((Object)"\"").toString();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.req$1 = req$1;
                this.consumer$1 = consumer$1;
                this.token$1 = token$1;
                this.verifier$1 = verifier$1;
            }
        });
    }

    public Tuple2<Seq<Tuple2<String, String>>, String> getSig(Seq<Tuple2<String, String>> baseParams, HttpRequest req, Token consumer, Option<Token> token, Option<String> verifier) {
        Tuple2 tuple2 = new Tuple2((Object)"oauth_version", (Object)"1.0");
        Tuple2 tuple22 = new Tuple2((Object)"oauth_consumer_key", (Object)consumer.key());
        Tuple2 tuple23 = new Tuple2((Object)"oauth_signature_method", (Object)"HMAC-SHA1");
        ObjectRef oauthParams = ObjectRef.create((Object)((Seq)((SeqLike)((SeqLike)baseParams.$plus$colon((Object)tuple23, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)tuple22, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom())));
        token.foreach((Function1)new Serializable(oauthParams){
            public static final long serialVersionUID = 0L;
            private final ObjectRef oauthParams$1;

            public final void apply(Token t) {
                this.oauthParams$1.elem = (Seq)((Seq)this.oauthParams$1.elem).$plus$colon((Object)new Tuple2((Object)"oauth_token", (Object)t.key()), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.oauthParams$1 = oauthParams$1;
            }
        });
        verifier.foreach((Function1)new Serializable(oauthParams){
            public static final long serialVersionUID = 0L;
            private final ObjectRef oauthParams$1;

            public final void apply(String v) {
                this.oauthParams$1.elem = (Seq)((Seq)this.oauthParams$1.elem).$plus$colon((Object)new Tuple2((Object)"oauth_verifier", (Object)v), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.oauthParams$1 = oauthParams$1;
            }
        });
        String baseString = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{req.method().toUpperCase(), this.normalizeUrl(new URL(req.url())), this.normalizeParams((Seq<Tuple2<String, String>>)((Seq)req.params().$plus$plus((GenTraversableOnce)((Seq)oauthParams.elem), Seq$.MODULE$.canBuildFrom())))}))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return OAuth$.MODULE$.percentEncode(s);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("&");
        String keyString = new StringBuilder().append((Object)this.percentEncode(consumer.secret())).append((Object)"&").append(token.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Token t) {
                return OAuth$.MODULE$.percentEncode(t.secret());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(HttpConstants$.MODULE$.utf8()), this.MAC());
        Mac mac = Mac.getInstance(this.MAC());
        mac.init(key);
        byte[] text = baseString.getBytes(HttpConstants$.MODULE$.utf8());
        return new Tuple2((Object)((Seq)oauthParams.elem), (Object)HttpConstants$.MODULE$.base64(mac.doFinal(text)));
    }

    private String normalizeParams(Seq<Tuple2<String, String>> params) {
        return ((TraversableOnce)this.percentEncode(params).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5, String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).$less((Object)x$6);
            }
        })).mkString("&");
    }

    private String normalizeUrl(URL url) {
        String path;
        int index;
        boolean dropPort;
        URI uri = new URI(url.toString());
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return new StringBuilder().append((Object)scheme).append((Object)"://").append((Object)authority).append((Object)path).toString();
    }

    public Seq<String> percentEncode(Seq<Tuple2<String, String>> params) {
        return (Seq)params.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> p) {
                return new StringBuilder().append((Object)OAuth$.MODULE$.percentEncode((String)p._1())).append((Object)"=").append((Object)OAuth$.MODULE$.percentEncode((String)p._2())).toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String percentEncode(String s) {
        return s == null ? "" : HttpConstants$.MODULE$.urlEncode(s, HttpConstants$.MODULE$.utf8()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private OAuth$() {
        MODULE$ = this;
        this.MAC = "HmacSHA1";
    }
}

