/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scalaj.http.Base64;
import scalaj.http.HttpOptions$;
import scalaj.http.Token;

public final class HttpConstants$ {
    public static HttpConstants$ MODULE$;
    private final Regex CharsetRegex;
    private final Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode;
    private final String utf8;

    static {
        new HttpConstants$();
    }

    public Regex CharsetRegex() {
        return this.CharsetRegex;
    }

    public Seq<Function1<HttpURLConnection, BoxedUnit>> defaultOptions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{HttpOptions$.MODULE$.connTimeout(1000), HttpOptions$.MODULE$.readTimeout(5000), HttpOptions$.MODULE$.followRedirects(false)}));
    }

    public Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode() {
        return this.setFixedLengthStreamingMode;
    }

    public String urlEncode(String name, String charset) {
        return URLEncoder.encode(name, charset);
    }

    public String urlDecode(String name, String charset) {
        return URLDecoder.decode(name, charset);
    }

    public String base64(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public String base64(String in) {
        return this.base64(in.getBytes(this.utf8()));
    }

    public String toQs(Seq<Tuple2<String, String>> params, String charset) {
        return ((TraversableOnce)params.map((Function1 & java.io.Serializable & Serializable)p -> this.urlEncode((String)p._1(), charset) + "=" + this.urlEncode((String)p._2(), charset), Seq$.MODULE$.canBuildFrom())).mkString("&");
    }

    public String appendQs(String url, Seq<Tuple2<String, String>> params, String charset) {
        return url + (params.isEmpty() ? "" : (url.contains("?") ? "&" : "?") + this.toQs(params, charset));
    }

    public String readString(InputStream is) {
        return this.readString(is, this.utf8());
    }

    public String readString(InputStream is, String charset) {
        String string;
        if (is == null) {
            string = "";
        } else {
            InputStreamReader in = new InputStreamReader(is, charset);
            StringBuilder bos = new StringBuilder();
            char[] ba = new char[4096];
            this.readOnce$2(in, bos, ba);
            string = bos.toString();
        }
        return string;
    }

    public byte[] readBytes(InputStream in) {
        byte[] byArray;
        if (in == null) {
            byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] ba = new byte[4096];
            this.readOnce$3(in, bos, ba);
            byArray = bos.toByteArray();
        }
        return byArray;
    }

    public Seq<Tuple2<String, String>> readParams(InputStream in, String charset) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.readString(in, charset).split("&"))).flatMap((Function1 & java.io.Serializable & Serializable)x$22 -> {
            Iterable iterable;
            String[] stringArray = x$22.split("=");
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String k = (String)((SeqLike)option.get()).apply(0);
                String v = (String)((SeqLike)option.get()).apply(1);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)this.urlDecode(k, charset), (Object)this.urlDecode(v, charset))));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toList();
    }

    public String readParams$default$2() {
        return this.utf8();
    }

    public Map<String, String> readParamMap(InputStream in, String charset) {
        return (Map)Predef$.MODULE$.Map().apply(this.readParams(in, charset));
    }

    public String readParamMap$default$2() {
        return this.utf8();
    }

    public Token readToken(InputStream in) {
        Map<String, String> params = this.readParamMap(in, this.readParamMap$default$2());
        return new Token((String)params.apply((Object)"oauth_token"), (String)params.apply((Object)"oauth_token_secret"));
    }

    public Proxy proxy(String host, int port, Proxy.Type proxyType) {
        return new Proxy(proxyType, new InetSocketAddress(host, port));
    }

    public Proxy.Type proxy$default$3() {
        return Proxy.Type.HTTP;
    }

    public String utf8() {
        return this.utf8;
    }

    private static final Tuple2 liftedTree1$1(Class connClass$1) {
        Tuple2 tuple2;
        try {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Long.TYPE));
        }
        catch (NoSuchMethodException e) {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Integer.TYPE));
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$setFixedLengthStreamingMode$1(boolean isLong$1, Method theMethod$1, HttpURLConnection conn, long length) {
        if (isLong$1) {
            theMethod$1.invoke((Object)conn, Predef$.MODULE$.long2Long(length));
        } else {
            if (length > Integer.MAX_VALUE) {
                throw new RuntimeException("Failing attempt to upload file greater than 2GB on java version < 1.7");
            }
            theMethod$1.invoke((Object)conn, Predef$.MODULE$.int2Integer((int)length));
        }
    }

    private final void readOnce$2(InputStreamReader in$2, StringBuilder bos$1, char[] ba$1) {
        int len;
        do {
            Object object = (len = in$2.read(ba$1)) > 0 ? bos$1.appendAll(ba$1, 0, len) : BoxedUnit.UNIT;
        } while (len >= 0);
    }

    private final void readOnce$3(InputStream in$1, ByteArrayOutputStream bos$2, byte[] ba$2) {
        int len;
        do {
            if ((len = in$1.read(ba$2)) <= 0) continue;
            bos$2.write(ba$2, 0, len);
        } while (len >= 0);
    }

    private HttpConstants$() {
        MODULE$ = this;
        this.CharsetRegex = new Regex("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Class<HttpURLConnection> connClass = HttpURLConnection.class;
        Tuple2 tuple2 = HttpConstants$.liftedTree1$1(connClass);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean isLong = tuple2._1$mcZ$sp();
        Method theMethod = (Method)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isLong), (Object)theMethod);
        Tuple2 tuple23 = tuple22;
        boolean isLong2 = tuple23._1$mcZ$sp();
        Method theMethod2 = (Method)tuple23._2();
        this.setFixedLengthStreamingMode = (Function2 & java.io.Serializable & Serializable)(conn, length) -> {
            HttpConstants$.$anonfun$setFixedLengthStreamingMode$1(isLong2, theMethod2, conn, BoxesRunTime.unboxToLong((Object)length));
            return BoxedUnit.UNIT;
        };
        this.utf8 = "UTF-8";
    }
}

