/*
 * Decompiled with CFR 0.152.
 */
package org.scalameta.ascii.layout.drawing;

import java.io.Serializable;
import org.scalameta.ascii.common.Region;
import org.scalameta.ascii.layout.drawing.Drawing;
import org.scalameta.ascii.layout.drawing.EdgeDrawingElement;
import org.scalameta.ascii.layout.drawing.EdgeSegment;
import org.scalameta.ascii.layout.drawing.EdgeSegmentInfo;
import org.scalameta.ascii.util.QuadTree;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\f\u0019\u0001\rB\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006]\u0001!\ta\f\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u0019\u0001\u0005\u0001)A\u0005i!9\u0011\t\u0001b\u0001\n\u0013\u0019\u0004B\u0002\"\u0001A\u0003%A\u0007C\u0004D\u0001\t\u0007I\u0011\u0002#\t\rE\u0003\u0001\u0015!\u0003F\u0011\u001d\u0011\u0006A1A\u0005\n\u0011Caa\u0015\u0001!\u0002\u0013)\u0005\"\u0002+\u0001\t\u0003)\u0006\"\u00020\u0001\t\u0003y\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00025\u0001\t\u0003I\u0007\"B6\u0001\t\u0003a\u0007\"\u00028\u0001\t\u0003y\u0007\"B9\u0001\t\u0003\u0011\b\"B<\u0001\t\u0003A\b\"B9\u0001\t\u0013Q\b\"B<\u0001\t\u0013i\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\u0006\u0001!\t%a\u0002\u0003\u0017\u0015#w-\u001a+sC\u000e\\WM\u001d\u0006\u00033i\tq\u0001\u001a:bo&twM\u0003\u0002\u001c9\u00051A.Y=pkRT!!\b\u0010\u0002\u000b\u0005\u001c8-[5\u000b\u0005}\u0001\u0013!C:dC2\fW.\u001a;b\u0015\u0005\t\u0013aA8sO\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111\u0006L\u0007\u00021%\u0011Q\u0006\u0007\u0002\b\tJ\fw/\u001b8h\u0003\u0019a\u0014N\\5u}Q\u0011\u0001'\r\t\u0003W\u0001AQ!\u0007\u0002A\u0002)\n!\u0003[8sSj|g\u000e^1m#V\fG\r\u0016:fKV\tA\u0007E\u00026qij\u0011A\u000e\u0006\u0003oq\tA!\u001e;jY&\u0011\u0011H\u000e\u0002\t#V\fG\r\u0016:fKB\u00111HP\u0007\u0002y)\u0011Q\bH\u0001\u0007G>lWn\u001c8\n\u0005}b$A\u0002*fO&|g.A\ni_JL'p\u001c8uC2\fV/\u00193Ue\u0016,\u0007%\u0001\twKJ$\u0018nY1m#V\fG\r\u0016:fK\u0006\tb/\u001a:uS\u000e\fG.U;bIR\u0013X-\u001a\u0011\u0002\u001bY,'\u000f^3y%\u0016<\u0017n\u001c8t+\u0005)\u0005c\u0001$Ou9\u0011q\t\u0014\b\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\n\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u000553\u0013a\u00029bG.\fw-Z\u0005\u0003\u001fB\u0013A\u0001T5ti*\u0011QJJ\u0001\u000fm\u0016\u0014H/\u001a=SK\u001eLwN\\:!\u00031\t'O]8x%\u0016<\u0017n\u001c8t\u00035\t'O]8x%\u0016<\u0017n\u001c8tA\u0005y\u0011\r\u001a3FI\u001e,7+Z4nK:$8\u000f\u0006\u0002W3B\u0011QeV\u0005\u00031\u001a\u0012A!\u00168ji\")!l\u0003a\u00017\u0006Y1/Z4nK:$\u0018J\u001c4p!\tYC,\u0003\u0002^1\tyQ\tZ4f'\u0016<W.\u001a8u\u0013:4w.\u0001\nsK6|g/Z#eO\u0016\u001cVmZ7f]R\u001cHC\u0001,a\u0011\u0015QF\u00021\u0001\\\u0003Q\tG\r\u001a%pe&TxN\u001c;bYN+w-\\3oiR\u0011ak\u0019\u0005\u0006I6\u0001\r!Z\u0001\fK\u0012<WmU3h[\u0016tG\u000f\u0005\u0002,M&\u0011q\r\u0007\u0002\f\u000b\u0012<WmU3h[\u0016tG/\u0001\nbI\u00124VM\u001d;jG\u0006d7+Z4nK:$HC\u0001,k\u0011\u0015!g\u00021\u0001f\u0003]\u0011X-\\8wK\"{'/\u001b>p]R\fGnU3h[\u0016tG\u000f\u0006\u0002W[\")Am\u0004a\u0001K\u0006)\"/Z7pm\u00164VM\u001d;jG\u0006d7+Z4nK:$HC\u0001,q\u0011\u0015!\u0007\u00031\u0001f\u0003I\u0019w\u000e\u001c7jI\u0016\u001c\bj\u001c:ju>tG/\u00197\u0015\u0005M4\bCA\u0013u\u0013\t)hEA\u0004C_>dW-\u00198\t\u000b\u0011\f\u0002\u0019A3\u0002!\r|G\u000e\\5eKN4VM\u001d;jG\u0006dGCA:z\u0011\u0015!'\u00031\u0001f)\t\u00198\u0010C\u0003}'\u0001\u0007!(\u0001\u0004sK\u001eLwN\u001c\u000b\u0003gzDQ\u0001 \u000bA\u0002i\nAbY8mY&$Wm],ji\"$2a]A\u0002\u0011\u0015QV\u00031\u0001\\\u0003!!xn\u0015;sS:<GCAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001\\1oO*\u0011\u00111C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u00055!AB*ue&tw\r")
public class EdgeTracker {
    private final QuadTree<Region> horizontalQuadTree;
    private final QuadTree<Region> verticalQuadTree;
    private final List<Region> vertexRegions;
    private final List<Region> arrowRegions;

    private QuadTree<Region> horizontalQuadTree() {
        return this.horizontalQuadTree;
    }

    private QuadTree<Region> verticalQuadTree() {
        return this.verticalQuadTree;
    }

    private List<Region> vertexRegions() {
        return this.vertexRegions;
    }

    private List<Region> arrowRegions() {
        return this.arrowRegions;
    }

    public void addEdgeSegments(EdgeSegmentInfo segmentInfo) {
        this.verticalQuadTree().add(segmentInfo.segment1().region());
        this.horizontalQuadTree().add(segmentInfo.segment2().region());
        this.verticalQuadTree().add(segmentInfo.segment3().region());
    }

    public void removeEdgeSegments(EdgeSegmentInfo segmentInfo) {
        this.verticalQuadTree().remove(segmentInfo.segment1().region());
        this.horizontalQuadTree().remove(segmentInfo.segment2().region());
        this.verticalQuadTree().remove(segmentInfo.segment3().region());
    }

    public void addHorizontalSegment(EdgeSegment edgeSegment) {
        this.horizontalQuadTree().add(edgeSegment.region());
    }

    public void addVerticalSegment(EdgeSegment edgeSegment) {
        this.verticalQuadTree().add(edgeSegment.region());
    }

    public void removeHorizontalSegment(EdgeSegment edgeSegment) {
        this.horizontalQuadTree().remove(edgeSegment.region());
    }

    public void removeVerticalSegment(EdgeSegment edgeSegment) {
        this.verticalQuadTree().remove(edgeSegment.region());
    }

    public boolean collidesHorizontal(EdgeSegment edgeSegment) {
        return this.collidesHorizontal(edgeSegment.region());
    }

    public boolean collidesVertical(EdgeSegment edgeSegment) {
        return this.collidesVertical(edgeSegment.region());
    }

    private boolean collidesHorizontal(Region region) {
        return this.horizontalQuadTree().collides(region);
    }

    private boolean collidesVertical(Region region) {
        return this.verticalQuadTree().collides(region);
    }

    public boolean collidesWith(EdgeSegmentInfo segmentInfo) {
        return this.collidesVertical(segmentInfo.segment1().region()) || this.collidesHorizontal(segmentInfo.segment2().region()) || this.collidesVertical(segmentInfo.segment3().region()) || this.collidesVertical(segmentInfo.segment2().region()) && this.collidesHorizontal(segmentInfo.segment3().region());
    }

    public String toString() {
        return new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this.horizontalQuadTree()), "\n------------------------------------------------------------\n")).append(this.verticalQuadTree()).toString();
    }

    public static final /* synthetic */ void $anonfun$new$1(EdgeTracker $this, Region t) {
        $this.horizontalQuadTree().add(t);
    }

    public static final /* synthetic */ void $anonfun$new$2(EdgeTracker $this, Region t) {
        $this.horizontalQuadTree().add(t);
    }

    public static final /* synthetic */ void $anonfun$new$3(EdgeTracker $this, Region t) {
        $this.verticalQuadTree().add(t);
    }

    public static final /* synthetic */ void $anonfun$new$5(EdgeTracker $this, EdgeSegment segment) {
        if (segment.direction().isHorizontal()) {
            $this.horizontalQuadTree().add(segment.region());
        } else {
            $this.verticalQuadTree().add(segment.region());
        }
    }

    public static final /* synthetic */ void $anonfun$new$4(EdgeTracker $this, EdgeDrawingElement edge) {
        edge.segments().foreach((Function1 & Serializable)segment -> {
            EdgeTracker.$anonfun$new$5($this, segment);
            return BoxedUnit.UNIT;
        });
    }

    public EdgeTracker(Drawing drawing) {
        this.horizontalQuadTree = new QuadTree(drawing.dimension());
        this.verticalQuadTree = new QuadTree(drawing.dimension());
        this.vertexRegions = drawing.vertexElements().map((Function1 & Serializable)x$1 -> x$1.region());
        this.arrowRegions = drawing.edgeElements().map((Function1 & Serializable)edgeElement -> edgeElement.hasArrow1() ? edgeElement.startPoint().region() : edgeElement.finishPoint().region());
        this.arrowRegions().foreach((Function1 & Serializable)t -> {
            EdgeTracker.$anonfun$new$1(this, t);
            return BoxedUnit.UNIT;
        });
        this.vertexRegions().foreach((Function1 & Serializable)t -> {
            EdgeTracker.$anonfun$new$2(this, t);
            return BoxedUnit.UNIT;
        });
        this.vertexRegions().foreach((Function1 & Serializable)t -> {
            EdgeTracker.$anonfun$new$3(this, t);
            return BoxedUnit.UNIT;
        });
        drawing.edgeElements().foreach((Function1 & Serializable)edge -> {
            EdgeTracker.$anonfun$new$4(this, edge);
            return BoxedUnit.UNIT;
        });
    }
}

