/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.meta.internal.io.InputStreamIO;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.io.ListFiles;
import scala.meta.internal.io.OutputStreamIO;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class PlatformFileIO$ {
    public static PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    public byte[] readAllBytes(URI uri) {
        byte[] byArray;
        try (InputStream is = uri.toURL().openStream();){
            byArray = InputStreamIO$.MODULE$.readBytes(is);
        }
        return byArray;
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return Files.readAllBytes(path.toNIO());
    }

    public <A> A read(AbsolutePath path, InputStreamIO<A> isio) {
        A a;
        try (InputStream stream = Files.newInputStream(path.toNIO(), new OpenOption[0]);){
            a = isio.read(stream);
        }
        return a;
    }

    public <A> void write(AbsolutePath path, A msg, Seq<OpenOption> openOptions, OutputStreamIO<A> osio) {
        Files.createDirectories(path.toNIO().getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path.toNIO(), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class)));){
            osio.write(msg, os);
        }
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return new String(Files.readAllBytes(path.toNIO()), charset);
    }

    public ListFiles listFiles(AbsolutePath path2) {
        return new ListFiles(path2, (List<RelativePath>)((List)((List)Option$.MODULE$.apply((Object)path2.toFile().list()).toList().flatten((Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).map((Function1 & java.io.Serializable & Serializable)path -> RelativePath$.MODULE$.apply((String)path), List$.MODULE$.canBuildFrom())));
    }

    public boolean isFile(AbsolutePath path) {
        return Files.isRegularFile(path.toNIO(), new LinkOption[0]);
    }

    public boolean isDirectory(AbsolutePath path) {
        return Files.isDirectory(path.toNIO(), new LinkOption[0]);
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root) {
        Builder relativeFiles = List$.MODULE$.newBuilder();
        Iterator iter = Files.walk(root.toNIO(), new FileVisitOption[0]).iterator();
        while (iter.hasNext()) {
            Path path = (Path)iter.next();
            Object object = Files.isRegularFile(path, new LinkOption[0]) ? relativeFiles.$plus$eq((Object)RelativePath$.MODULE$.apply(root.toNIO().relativize(path))) : BoxedUnit.UNIT;
        }
        return new ListFiles(root, (List<RelativePath>)((List)relativeFiles.result()));
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile, boolean create) {
        FileSystem fs = this.newJarFileSystem(jarFile, create);
        return AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public boolean jarRootPath$default$2() {
        return false;
    }

    public <T> T withJarFileSystem(AbsolutePath path, boolean create, boolean close, Function1<AbsolutePath, T> f) {
        FileSystem fs = this.newJarFileSystem(path, create);
        AbsolutePath root = AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        if (create || close) {
            Object object;
            try {
                object = f.apply((Object)root);
            }
            finally {
                fs.close();
            }
            return (T)object;
        }
        return (T)f.apply((Object)root);
    }

    public <T> boolean withJarFileSystem$default$3() {
        return false;
    }

    public FileSystem newJarFileSystem(AbsolutePath path, boolean create) {
        Object object = create && !Files.exists(path.toNIO().getParent(), new LinkOption[0]) ? Files.createDirectories(path.toNIO().getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
        HashMap<String, String> map = new HashMap<String, String>();
        Object object2 = create ? map.put("create", "true") : BoxedUnit.UNIT;
        URI uri = URI.create(new StringBuilder(4).append("jar:").append(path.toNIO().toUri().toString()).toString());
        return this.newFileSystem(uri, map);
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> map) {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystems.newFileSystem(uri, map);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        return fileSystem;
    }

    public Map<String, ?> newFileSystem$default$2() {
        return new HashMap();
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

