/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;

final class OutputCapture {
    private final PrintStream originalOut = System.out;
    private final PrintStream originalScalaOut = OutputCapture.getScalaOut();
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final PrintStream prBuffer = new PrintStream(this.buffer, true);
    private final boolean scalaOutSet;

    private OutputCapture() {
        System.out.flush();
        System.setOut(this.prBuffer);
        this.scalaOutSet = OutputCapture.setScalaOut(this.prBuffer);
    }

    static OutputCapture start() {
        return new OutputCapture();
    }

    void stop() {
        System.out.flush();
        System.setOut(this.originalOut);
        if (this.scalaOutSet) {
            OutputCapture.setScalaOut(this.originalScalaOut);
        }
    }

    void replay() throws IOException {
        System.out.write(this.buffer.toByteArray());
        System.out.flush();
    }

    private static PrintStream getScalaOut() {
        try {
            Class<?> clazz = Class.forName("scala.Console");
            Method method = clazz.getMethod("out", new Class[0]);
            return (PrintStream)method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static boolean setScalaOut(PrintStream printStream) {
        try {
            Class<?> clazz = Class.forName("scala.Console");
            Method method = clazz.getMethod("setOut", PrintStream.class);
            method.invoke(null, printStream);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

