/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import munit.internal.junitinterface.CustomRunners;
import munit.internal.junitinterface.JUnitComputer;
import munit.internal.junitinterface.JUnitTask;
import munit.internal.junitinterface.RunSettings;
import munit.internal.junitinterface.RunStatistics;
import munit.internal.junitinterface.Settings;
import org.junit.runner.notification.RunListener;
import sbt.testing.Runner;
import sbt.testing.Task;
import sbt.testing.TaskDef;

final class JUnitRunner
implements Runner {
    private final String[] args;
    private final String[] remoteArgs;
    private final RunSettings settings;
    private volatile boolean used = false;
    final ClassLoader testClassLoader;
    final RunListener runListener;
    final RunStatistics runStatistics;
    final CustomRunners customRunners;

    JUnitRunner(String[] stringArray, String[] stringArray2, ClassLoader classLoader, CustomRunners customRunners) {
        this.args = stringArray;
        this.remoteArgs = stringArray2;
        this.testClassLoader = classLoader;
        this.customRunners = customRunners;
        Settings settings = Settings.defaults();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = true;
        boolean bl7 = false;
        boolean bl8 = settings.trimStackTraces();
        RunSettings.Summary summary = RunSettings.Summary.SBT;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        String string = "";
        String string2 = "org.junit.runners.Suite";
        String string3 = null;
        for (String string4 : stringArray) {
            if ("-v".equals(string4) || "--verbose".equals(string4)) {
                bl7 = true;
                continue;
            }
            if (string4.startsWith("--summary=")) {
                summary = RunSettings.Summary.values()[Integer.parseInt(string4.substring(10))];
                continue;
            }
            if ("-n".equals(string4)) {
                bl = true;
                continue;
            }
            if ("-s".equals(string4)) {
                bl2 = true;
                continue;
            }
            if ("-a".equals(string4)) {
                bl3 = true;
                continue;
            }
            if ("-c".equals(string4)) {
                bl4 = false;
                continue;
            }
            if ("+l".equals(string4)) {
                bl5 = true;
                continue;
            }
            if ("+b".equals(string4)) {
                bl6 = true;
                continue;
            }
            if ("-b".equals(string4)) {
                bl6 = false;
                continue;
            }
            if ("--logger=sbt".equals(string4)) {
                bl5 = true;
                continue;
            }
            if ("--logger=buffered".equals(string4)) {
                bl6 = true;
                continue;
            }
            if ("-l".equals(string4)) {
                bl5 = false;
                continue;
            }
            if ("-F".equals(string4)) {
                bl8 = false;
                continue;
            }
            if ("+F".equals(string4)) {
                bl8 = true;
                continue;
            }
            if (string4.startsWith("--tests=")) {
                string = string4.substring(8);
                continue;
            }
            if (string4.startsWith("--ignore-runners=")) {
                string2 = string4.substring(17);
                continue;
            }
            if (string4.startsWith("--run-listener=")) {
                string3 = string4.substring(15);
                continue;
            }
            if (string4.startsWith("--include-categories=")) {
                hashSet.addAll(Arrays.asList(string4.substring(21).split(",")));
                continue;
            }
            if (string4.startsWith("--exclude-categories=")) {
                hashSet2.addAll(Arrays.asList(string4.substring(21).split(",")));
                continue;
            }
            if (string4.startsWith("--include-tags=")) {
                hashSet3.addAll(Arrays.asList(string4.substring("--include-tags=".length()).split(",")));
                continue;
            }
            if (string4.startsWith("--exclude-tags=")) {
                hashSet4.addAll(Arrays.asList(string4.substring("--exclude-tags=".length()).split(",")));
                continue;
            }
            if (string4.startsWith("-D") && string4.contains("=")) {
                int n = string4.indexOf(61);
                hashMap.put(string4.substring(2, n), string4.substring(n + 1));
                continue;
            }
            if (string4.startsWith("-") || string4.startsWith("+")) continue;
            arrayList.add(string4);
        }
        for (String string4 : stringArray) {
            if ("+n".equals(string4)) {
                bl = false;
                continue;
            }
            if ("+s".equals(string4)) {
                bl2 = false;
                continue;
            }
            if ("+a".equals(string4)) {
                bl3 = false;
                continue;
            }
            if ("+c".equals(string4)) {
                bl4 = true;
                continue;
            }
            if (!"+l".equals(string4)) continue;
            bl5 = true;
        }
        this.settings = new RunSettings(!bl, bl2, bl7, bl5, bl6, bl8, summary, bl3, string2, bl4, hashMap, arrayList, hashSet, hashSet2, hashSet3, hashSet4, string);
        this.runListener = this.createRunListener(string3);
        this.runStatistics = new RunStatistics(this.settings);
    }

    public Task[] tasks(TaskDef[] taskDefArray) {
        this.used = true;
        JUnitComputer jUnitComputer = new JUnitComputer(this.testClassLoader, this.customRunners, this.settings);
        int n = taskDefArray.length;
        ArrayList<JUnitTask> arrayList = new ArrayList<JUnitTask>(taskDefArray.length);
        for (int i = 0; i < n; ++i) {
            TaskDef taskDef = taskDefArray[i];
            if (!this.shouldRun(jUnitComputer, taskDef)) continue;
            arrayList.add(new JUnitTask(this, this.settings, taskDef, jUnitComputer));
        }
        return arrayList.toArray(new Task[0]);
    }

    private boolean shouldRun(JUnitComputer jUnitComputer, TaskDef taskDef) {
        try {
            Class<?> clazz = this.testClassLoader.loadClass(taskDef.fullyQualifiedName());
            return !jUnitComputer.customRunner(clazz).isPresent() || this.customRunners.matchesFingerprint(taskDef.fingerprint());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private RunListener createRunListener(String string) {
        if (string != null) {
            try {
                return (RunListener)this.testClassLoader.loadClass(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public String done() {
        if (!this.used) {
            return "";
        }
        String string = this.runStatistics.createSummary();
        if (string.isEmpty()) {
            return string;
        }
        System.out.println(string);
        return " ";
    }

    public String[] remoteArgs() {
        return this.remoteArgs;
    }

    public String[] args() {
        return this.args;
    }
}

