/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import munit.internal.junitinterface.CustomFingerprint;
import sbt.testing.Fingerprint;
import sbt.testing.SubclassFingerprint;

public class CustomRunners {
    final List<CustomFingerprint> runners;
    final Set<String> superclasses;

    public CustomRunners(List<CustomFingerprint> list) {
        this.runners = list;
        this.superclasses = new HashSet<String>();
        list.forEach(customFingerprint -> this.superclasses.add(customFingerprint.suite));
    }

    public boolean isEmpty() {
        return this.runners.isEmpty();
    }

    public Map<String, String> all() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.runners.forEach(customFingerprint -> hashMap.put(customFingerprint.suite, customFingerprint.runner));
        return hashMap;
    }

    public boolean matchesFingerprint(Fingerprint fingerprint) {
        if (fingerprint instanceof SubclassFingerprint) {
            SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
            return this.superclasses.contains(subclassFingerprint.superclassName());
        }
        return false;
    }

    public static CustomRunners of(CustomFingerprint ... customFingerprintArray) {
        return new CustomRunners(Arrays.asList(customFingerprintArray));
    }
}

