/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import mdoc.internal.cli.InternalInput;
import mdoc.internal.cli.Settings;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.package$;
import scala.util.Try$;

public interface CliEnrichments {
    public static XtensionInputMdoc XtensionInputMdoc$(CliEnrichments $this, Input input) {
        return $this.XtensionInputMdoc(input);
    }

    default public XtensionInputMdoc XtensionInputMdoc(Input input) {
        return new XtensionInputMdoc(this, input);
    }

    public static XtensionPrintStream XtensionPrintStream$(CliEnrichments $this, PrintStream sb) {
        return $this.XtensionPrintStream(sb);
    }

    default public XtensionPrintStream XtensionPrintStream(PrintStream sb) {
        return new XtensionPrintStream(this, sb);
    }

    public static XtensionPositionMdoc XtensionPositionMdoc$(CliEnrichments $this, Position pos) {
        return $this.XtensionPositionMdoc(pos);
    }

    default public XtensionPositionMdoc XtensionPositionMdoc(Position pos) {
        return new XtensionPositionMdoc(this, pos);
    }

    public static XtensionThrowable XtensionThrowable$(CliEnrichments $this, Throwable e) {
        return $this.XtensionThrowable(e);
    }

    default public XtensionThrowable XtensionThrowable(Throwable e) {
        return new XtensionThrowable(this, e);
    }

    public static XtensionAbsolutePathLink XtensionAbsolutePathLink$(CliEnrichments $this, AbsolutePath path) {
        return $this.XtensionAbsolutePathLink(path);
    }

    default public XtensionAbsolutePathLink XtensionAbsolutePathLink(AbsolutePath path) {
        return new XtensionAbsolutePathLink(this, path);
    }

    public static String mdoc$internal$cli$CliEnrichments$XtensionInputMdoc$$_$filename$$anonfun$2(Input.VirtualFile v$2) {
        return v$2.path();
    }

    public class XtensionAbsolutePathLink {
        private final AbsolutePath path;
        private final /* synthetic */ CliEnrichments $outer;

        public XtensionAbsolutePathLink(CliEnrichments $outer, AbsolutePath path) {
            this.path = path;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String filename() {
            return this.path.toNIO().getFileName().toString();
        }

        public String extension() {
            return PathIO$.MODULE$.extension(this.path.toNIO());
        }

        public String readText() {
            return FileIO$.MODULE$.slurp(this.path, StandardCharsets.UTF_8);
        }

        public void copyTo(AbsolutePath out) {
            Files.createDirectories(this.path.toNIO().getParent(), new FileAttribute[0]);
            Files.copy(this.path.toNIO(), out.toNIO(), StandardCopyOption.REPLACE_EXISTING);
        }

        public void write(String text) {
            Files.createDirectories(this.path.toNIO().getParent(), new FileAttribute[0]);
            Files.write(this.path.toNIO(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        public String toRelativeLinkFrom(AbsolutePath other, String prefix) {
            return new StringBuilder(0).append(prefix).append(this.path.toRelative(this.$outer.XtensionAbsolutePathLink(other).parent()).toURI(false).toString()).toString();
        }

        public AbsolutePath parent() {
            return AbsolutePath$.MODULE$.apply(this.path.toNIO().getParent(), AbsolutePath$.MODULE$.workingDirectory());
        }

        public final /* synthetic */ CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionAbsolutePathLink$$$outer() {
            return this.$outer;
        }
    }

    public class XtensionInputMdoc {
        private final Input input;
        private final /* synthetic */ CliEnrichments $outer;

        public XtensionInputMdoc(CliEnrichments $outer, Input input) {
            this.input = input;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String filename() {
            Input input = this.input;
            if (input instanceof Input.Slice) {
                Input.Slice s = (Input.Slice)input;
                return this.$outer.XtensionInputMdoc(s.input()).filename();
            }
            if (input instanceof Input.File) {
                Input.File f = (Input.File)input;
                return this.$outer.XtensionAbsolutePathLink(f.path()).filename();
            }
            if (input instanceof Input.VirtualFile) {
                Input.VirtualFile v = (Input.VirtualFile)input;
                return (String)Try$.MODULE$.apply(() -> this.filename$$anonfun$1(v)).getOrElse(() -> CliEnrichments.mdoc$internal$cli$CliEnrichments$XtensionInputMdoc$$_$filename$$anonfun$2(v));
            }
            return this.$outer.XtensionInputMdoc(this.input).syntax();
        }

        public String syntax() {
            Input input = this.input;
            Input.None$ none$ = package$.MODULE$.Input().None();
            Input input2 = input;
            if (!(none$ != null ? !none$.equals(input2) : input2 != null)) {
                return "<none>";
            }
            if (input instanceof Input.File) {
                AbsolutePath path = ((Input.File)input).path();
                return path.toString();
            }
            if (input instanceof Input.VirtualFile) {
                String path = ((Input.VirtualFile)input).path();
                return path;
            }
            return "<input>";
        }

        public RelativePath relativeFilename(AbsolutePath sourceroot) {
            Input input = this.input;
            if (input instanceof Input.Slice) {
                Input.Slice s = (Input.Slice)input;
                return this.$outer.XtensionInputMdoc(s.input()).relativeFilename(sourceroot);
            }
            return AbsolutePath$.MODULE$.apply(this.$outer.XtensionInputMdoc(this.input).syntax(), AbsolutePath$.MODULE$.workingDirectory()).toRelative(sourceroot);
        }

        public String toFilename(Settings settings) {
            if (settings.reportRelativePaths()) {
                return Paths.get(this.$outer.XtensionInputMdoc(this.input).filename(), new String[0]).getFileName().toString();
            }
            return this.filename();
        }

        public Position.Range toPosition() {
            return package$.MODULE$.Position().Range().apply(this.input, 0, this.input.chars().length);
        }

        public Position toOffset(int line, int column) {
            return package$.MODULE$.Position().Range().apply(this.input, line, column, line, column);
        }

        public final /* synthetic */ CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionInputMdoc$$$outer() {
            return this.$outer;
        }

        private final String filename$$anonfun$1(Input.VirtualFile v$1) {
            return this.$outer.XtensionAbsolutePathLink(AbsolutePath$.MODULE$.apply(Paths.get(v$1.path(), new String[0]), AbsolutePath$.MODULE$.workingDirectory())).filename();
        }
    }

    public class XtensionPositionMdoc
    extends InternalInput {
        private final Position pos;
        private final /* synthetic */ CliEnrichments $outer;

        public XtensionPositionMdoc(CliEnrichments $outer, Position pos) {
            this.pos = pos;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(pos.input());
        }

        public String lineContent() {
            Input input = this.pos.input();
            int start = this.lineToOffset(this.pos.startLine());
            boolean notEof = start < input.chars().length;
            int end = notEof ? this.lineToOffset(this.pos.startLine() + 1) : start;
            return StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(new String(input.chars(), start, end - start)));
        }

        public String lineCaret() {
            return new StringBuilder(1).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), this.pos.startColumn())).append("^").toString();
        }

        public Position addStart(int offset) {
            Position position = this.pos;
            if (position instanceof Position.Range) {
                Position.Range range = (Position.Range)position;
                Input i = range.input();
                int start = range.start();
                int end = range.end();
                return package$.MODULE$.Position().Range().apply(i, start + offset, end);
            }
            return this.pos;
        }

        public Position toUnslicedPosition() {
            Input input = this.pos.input();
            if (input instanceof Input.Slice) {
                Input.Slice slice = (Input.Slice)input;
                Input underlying = slice.input();
                int a = slice.start();
                return this.$outer.XtensionPositionMdoc((Position)package$.MODULE$.Position().Range().apply(underlying, a + this.pos.start(), a + this.pos.end())).toUnslicedPosition();
            }
            return this.pos;
        }

        public final /* synthetic */ CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionPositionMdoc$$$outer() {
            return this.$outer;
        }
    }

    public class XtensionPrintStream {
        private final PrintStream sb;
        private final /* synthetic */ CliEnrichments $outer;

        public XtensionPrintStream(CliEnrichments $outer, PrintStream sb) {
            this.sb = sb;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public void appendMultiline(String string) {
            this.appendMultiline(string, string.length());
        }

        public void appendMultiline(String string, int N) {
            for (int i = 0; i < N; ++i) {
                PrintStream printStream;
                char c = string.charAt(i);
                if ('\n' == c) {
                    printStream = this.sb.append("\n// ");
                    continue;
                }
                char ch = c;
                printStream = this.sb.append(ch);
            }
        }

        public final /* synthetic */ CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionPrintStream$$$outer() {
            return this.$outer;
        }
    }

    public class XtensionThrowable {
        private final Throwable e;
        private final /* synthetic */ CliEnrichments $outer;

        public XtensionThrowable(CliEnrichments $outer, Throwable e) {
            this.e = e;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String message() {
            if (this.e.getMessage() != null) {
                return this.e.getMessage();
            }
            if (this.e.getCause() != null) {
                return this.$outer.XtensionThrowable(this.e.getCause()).message();
            }
            return "null";
        }

        public final /* synthetic */ CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionThrowable$$$outer() {
            return this.$outer;
        }
    }
}

