/*
 * Decompiled with CFR 0.152.
 */
package mdoc.parser;

import java.io.Serializable;
import mdoc.parser.CodeFence;
import mdoc.parser.CodeFence$;
import mdoc.parser.MarkdownPart;
import mdoc.parser.MarkdownPart$;
import mdoc.parser.MarkdownPart$State$;
import mdoc.parser.MarkdownPart$State$CodeFence$;
import mdoc.parser.MarkdownPart$State$Text$;
import mdoc.parser.MarkdownPart$syntax$;
import mdoc.parser.MarkdownPart$syntax$StringBuilderOps$;
import mdoc.parser.ParserSettings;
import mdoc.parser.Text;
import mdoc.parser.Text$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.function.JProcedure1;

public abstract class MarkdownPart {
    private int posBeg = 0;
    private int posEnd = -1;

    public static int ordinal(MarkdownPart markdownPart) {
        return MarkdownPart$.MODULE$.ordinal(markdownPart);
    }

    public static List<MarkdownPart> parse(String string, ParserSettings parserSettings) {
        return MarkdownPart$.MODULE$.parse(string, parserSettings);
    }

    public int posBeg() {
        return this.posBeg;
    }

    public void posBeg_$eq(int x$1) {
        this.posBeg = x$1;
    }

    public int posEnd() {
        return this.posEnd;
    }

    public void posEnd_$eq(int x$1) {
        this.posEnd = x$1;
    }

    public final void renderToString(StringBuilder out) {
        MarkdownPart markdownPart = this;
        if (markdownPart instanceof Text) {
            String string;
            Text text = Text$.MODULE$.unapply((Text)markdownPart);
            String value = string = text._1();
            out.append(value);
            return;
        }
        if (markdownPart instanceof CodeFence) {
            CodeFence fence = (CodeFence)markdownPart;
            String indentation = fence.hasBlankTag() ? fence.tag().value() : StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), fence.indent());
            Option<String> option = fence.newPart();
            if (option instanceof Some) {
                String newPart = (String)((Some)option).value();
                MarkdownPart$syntax$StringBuilderOps$.MODULE$.appendLinesPrefixed$extension(MarkdownPart$syntax$.MODULE$.StringBuilderOps(out), indentation, newPart);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                fence.tag().renderToString(out);
                fence.openBackticks().renderToString(out);
                Option<String> option2 = fence.newInfo();
                if (None$.MODULE$.equals(option2)) {
                    fence.info().renderToString(out);
                } else if (option2 instanceof Some) {
                    String newInfo = (String)((Some)option2).value();
                    out.append(newInfo);
                    if (!newInfo.endsWith("\n")) {
                        out.append("\n");
                    }
                } else {
                    throw new MatchError(option2);
                }
                Option<String> option3 = fence.newBody();
                if (None$.MODULE$.equals(option3)) {
                    MarkdownPart$syntax$StringBuilderOps$.MODULE$.appendLinesPrefixed$extension(MarkdownPart$syntax$.MODULE$.StringBuilderOps(out), indentation, fence.body().value());
                } else if (option3 instanceof Some) {
                    String newBody = (String)((Some)option3).value();
                    MarkdownPart$syntax$StringBuilderOps$.MODULE$.appendLinesPrefixed$extension(MarkdownPart$syntax$.MODULE$.StringBuilderOps(out), indentation, newBody);
                } else {
                    throw new MatchError(option3);
                }
                MarkdownPart$syntax$StringBuilderOps$.MODULE$.appendLinesPrefixed$extension(MarkdownPart$syntax$.MODULE$.StringBuilderOps(out), indentation, fence.closeBackticks().value());
                return;
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)markdownPart);
    }

    public static class Parser {
        private final String text;
        private final ParserSettings settings;

        public Parser(String text, ParserSettings settings) {
            this.text = text;
            this.settings = settings;
        }

        private Text newText(int start, int end) {
            int adaptedEnd = package$.MODULE$.max(start, end);
            Text part = Text$.MODULE$.apply(this.text.substring(start, adaptedEnd));
            part.posBeg_$eq(start);
            part.posEnd_$eq(adaptedEnd);
            return part;
        }

        private CodeFence newCodeFence(State.CodeFence state, int backtickStart, int backtickEnd) {
            Text tag = this.newText(state.start(), state.start() + state.indent());
            Text open = this.newText(state.start(), state.start() + state.indent() + state.backticks().length()).dropLinePrefix(state.indent());
            Text info = this.newText(open.posEnd(), open.posEnd() + state.info().length());
            int adaptedBacktickStart = package$.MODULE$.max(0, backtickStart - 1);
            Text body = this.newText(info.posEnd(), adaptedBacktickStart).dropLinePrefix(state.indent());
            Text close = this.newText(adaptedBacktickStart, backtickEnd).dropLinePrefix(state.indent());
            CodeFence part = CodeFence$.MODULE$.apply(open, info, body, close, tag);
            part.posBeg_$eq(state.start());
            part.posEnd_$eq(backtickEnd);
            return part;
        }

        public List<MarkdownPart> acceptParts() {
            BoxedUnit boxedUnit;
            ObjectRef state = ObjectRef.create((Object)MarkdownPart$State$Text$.MODULE$);
            ListBuffer parts = ListBuffer$.MODULE$.empty();
            IntRef curr = IntRef.create((int)0);
            StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(this.text)).foreach((Function1)(JProcedure1 & Serializable)line -> {
                int n;
                BoxedUnit boxedUnit;
                int end = curr$1.elem + line.length();
                State state = (State)state$1.elem;
                if (MarkdownPart$State$Text$.MODULE$.equals(state)) {
                    int start = line.indexOf("```");
                    if (start == 0 || start > 0 && this.settings.allowCodeFenceIndented()) {
                        String fence = line.substring(start);
                        String backticks = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(fence), (Function1 & Serializable)_$1 -> this.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
                        String info = fence.substring(backticks.length());
                        State.CodeFence codeFence = MarkdownPart$State$CodeFence$.MODULE$.apply(curr$1.elem, backticks, info, start);
                        state$1.elem = codeFence;
                        codeFence = null;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = parts.$plus$eq((Object)this.newText(curr$1.elem, end));
                    }
                } else if (state instanceof State.CodeFence) {
                    State.CodeFence s = (State.CodeFence)state;
                    int start = line.indexOf(s.backticks());
                    if (start == s.indent() && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)ch -> this.acceptParts$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)))) {
                        parts.$plus$eq((Object)this.newCodeFence(s, curr$1.elem, end));
                        MarkdownPart$State$Text$ markdownPart$State$Text$ = MarkdownPart$State$Text$.MODULE$;
                        state$1.elem = markdownPart$State$Text$;
                        markdownPart$State$Text$ = null;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)state);
                }
                curr$1.elem = n = curr$1.elem + line.length();
            });
            State state2 = (State)state.elem;
            if (state2 instanceof State.CodeFence) {
                State.CodeFence s = (State.CodeFence)state2;
                boxedUnit = parts.$plus$eq((Object)this.newCodeFence(s, this.text.length(), this.text.length()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return parts.toList();
        }

        private final /* synthetic */ boolean $anonfun$1(char _$1) {
            return _$1 == '`';
        }

        private final /* synthetic */ boolean acceptParts$$anonfun$1$$anonfun$1(char ch) {
            return ch == '`' || RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(ch));
        }
    }

    public static abstract class State {
        public static int ordinal(State state) {
            return MarkdownPart$State$.MODULE$.ordinal(state);
        }
    }
}

